/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

class BlocksWithLocations
implements Writable {
    private BlockWithLocations[] blocks;

    BlocksWithLocations() {
    }

    BlocksWithLocations(BlockWithLocations[] blocks) {
        this.blocks = blocks;
    }

    BlockWithLocations[] getBlocks() {
        return this.blocks;
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt(out, this.blocks.length);
        for (int i = 0; i < this.blocks.length; ++i) {
            this.blocks[i].write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        int len = WritableUtils.readVInt(in);
        this.blocks = new BlockWithLocations[len];
        for (int i = 0; i < len; ++i) {
            this.blocks[i] = new BlockWithLocations();
            this.blocks[i].readFields(in);
        }
    }

    static class BlockWithLocations
    implements Writable {
        Block block;
        String[] datanodeIDs;

        public BlockWithLocations() {
            this.block = new Block();
            this.datanodeIDs = null;
        }

        public BlockWithLocations(Block b, String[] datanodes) {
            this.block = b;
            this.datanodeIDs = datanodes;
        }

        Block getBlock() {
            return this.block;
        }

        String[] getDatanodes() {
            return this.datanodeIDs;
        }

        public void readFields(DataInput in) throws IOException {
            this.block.readFields(in);
            int len = WritableUtils.readVInt(in);
            this.datanodeIDs = new String[len];
            for (int i = 0; i < len; ++i) {
                this.datanodeIDs[i] = Text.readString(in);
            }
        }

        public void write(DataOutput out) throws IOException {
            this.block.write(out);
            WritableUtils.writeVInt(out, this.datanodeIDs.length);
            for (String id : this.datanodeIDs) {
                Text.writeString(out, id);
            }
        }
    }
}

