/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dfs.ClientProtocol;
import org.apache.hadoop.dfs.DFSClient;
import org.apache.hadoop.dfs.JspHelper;
import org.apache.hadoop.dfs.NameNode;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.UnixUserGroupInformation;
import org.znerd.xmlenc.XMLOutputter;

abstract class DfsServlet
extends HttpServlet {
    static final Log LOG = LogFactory.getLog((String)DfsServlet.class.getCanonicalName());

    DfsServlet() {
    }

    protected UnixUserGroupInformation getUGI(HttpServletRequest request) {
        String ugi = request.getParameter("ugi");
        try {
            return new UnixUserGroupInformation(ugi.split(","));
        }
        catch (Exception e) {
            LOG.warn((Object)("Invalid ugi (= " + ugi + ")"));
            return JspHelper.webUGI;
        }
    }

    protected ClientProtocol createNameNodeProxy(UnixUserGroupInformation ugi) throws IOException {
        ServletContext context = this.getServletContext();
        NameNode nn = (NameNode)context.getAttribute("name.node");
        Configuration conf = new Configuration((Configuration)context.getAttribute("name.conf"));
        UnixUserGroupInformation.saveToConf(conf, "hadoop.job.ugi", ugi);
        return DFSClient.createNamenode(nn.getNameNodeAddress(), conf);
    }

    static void writeRemoteException(String path, RemoteException re, XMLOutputter doc) throws IOException {
        doc.startTag("RemoteException");
        doc.attribute("path", path);
        doc.attribute("class", re.getClassName());
        String msg = re.getLocalizedMessage();
        int i = msg.indexOf("\n");
        if (i >= 0) {
            msg = msg.substring(0, i);
        }
        doc.attribute("message", msg.substring(msg.indexOf(":") + 1).trim());
        doc.endTag();
    }
}

