/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.DataNode;
import org.apache.hadoop.dfs.DataStorage;
import org.apache.hadoop.dfs.DatanodeBlockInfo;
import org.apache.hadoop.dfs.FSConstants;
import org.apache.hadoop.dfs.FSDatasetInterface;
import org.apache.hadoop.dfs.datanode.metrics.FSDatasetMBean;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.fs.DU;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.metrics.util.MBeanUtil;
import org.apache.hadoop.util.DiskChecker;

class FSDataset
implements FSConstants,
FSDatasetInterface {
    public static final String METADATA_EXTENSION = ".meta";
    public static final short METADATA_VERSION = 1;
    FSVolumeSet volumes;
    private HashMap<Block, ActiveFile> ongoingCreates = new HashMap();
    private int maxBlocksPerDir = 0;
    private HashMap<Block, DatanodeBlockInfo> volumeMap = null;
    static Random random = new Random();
    long blockWriteTimeout = 3600000L;
    private ObjectName mbeanName;
    private Random rand = new Random();

    static File getMetaFile(File f) {
        return new File(f.getAbsolutePath() + METADATA_EXTENSION);
    }

    protected File getMetaFile(Block b) throws IOException {
        File blockFile = this.getBlockFile(b);
        return FSDataset.getMetaFile(blockFile);
    }

    public boolean metaFileExists(Block b) throws IOException {
        return this.getMetaFile(b).exists();
    }

    public long getMetaDataLength(Block b) throws IOException {
        File checksumFile = this.getMetaFile(b);
        return checksumFile.length();
    }

    public FSDatasetInterface.MetaDataInputStream getMetaDataInputStream(Block b) throws IOException {
        File checksumFile = this.getMetaFile(b);
        return new FSDatasetInterface.MetaDataInputStream(new FileInputStream(checksumFile), checksumFile.length());
    }

    public FSDataset(DataStorage storage, Configuration conf) throws IOException {
        this.maxBlocksPerDir = conf.getInt("dfs.datanode.numblocks", 64);
        FSVolume[] volArray = new FSVolume[storage.getNumStorageDirs()];
        for (int idx = 0; idx < storage.getNumStorageDirs(); ++idx) {
            volArray[idx] = new FSVolume(storage.getStorageDir(idx).getCurrentDir(), conf);
        }
        this.volumes = new FSVolumeSet(volArray);
        this.volumeMap = new HashMap();
        this.volumes.getVolumeMap(this.volumeMap);
        this.blockWriteTimeout = (long)Math.max(conf.getInt("dfs.datanode.block.write.timeout.sec", 3600), 1) * 1000L;
        this.registerMBean(storage.getStorageID());
    }

    public long getDfsUsed() throws IOException {
        return this.volumes.getDfsUsed();
    }

    public long getCapacity() throws IOException {
        return this.volumes.getCapacity();
    }

    public long getRemaining() throws IOException {
        return this.volumes.getRemaining();
    }

    public long getLength(Block b) throws IOException {
        File f = this.validateBlockFile(b);
        if (f == null) {
            throw new IOException("Block " + b + " is not valid.");
        }
        return f.length();
    }

    protected synchronized File getBlockFile(Block b) throws IOException {
        File f = this.validateBlockFile(b);
        if (f == null) {
            throw new IOException("Block " + b + " is not valid.");
        }
        return f;
    }

    public synchronized InputStream getBlockInputStream(Block b) throws IOException {
        return new FileInputStream(this.getBlockFile(b));
    }

    public synchronized InputStream getBlockInputStream(Block b, long seekOffset) throws IOException {
        File blockFile = this.getBlockFile(b);
        RandomAccessFile blockInFile = new RandomAccessFile(blockFile, "r");
        if (seekOffset > 0L) {
            blockInFile.seek(seekOffset);
        }
        return new FileInputStream(blockInFile.getFD());
    }

    FSDatasetInterface.BlockWriteStreams createBlockWriteStreams(File f) throws IOException {
        return new FSDatasetInterface.BlockWriteStreams(new FileOutputStream(new RandomAccessFile(f, "rw").getFD()), new FileOutputStream(new RandomAccessFile(FSDataset.getMetaFile(f), "rw").getFD()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean detachBlock(Block block, int numLinks) throws IOException {
        DatanodeBlockInfo info = null;
        FSDataset fSDataset = this;
        synchronized (fSDataset) {
            info = this.volumeMap.get(block);
        }
        return info.detachBlock(block, numLinks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSDatasetInterface.BlockWriteStreams writeToBlock(Block b, boolean isRecovery) throws IOException {
        if (this.isValidBlock(b)) {
            if (!isRecovery) {
                throw new IOException("Block " + b + " is valid, and cannot be written to.");
            }
            DataNode.LOG.info((Object)("Reopen Block " + b));
            return null;
        }
        long blockSize = b.getNumBytes();
        File f = null;
        List<Thread> threads = null;
        FSDataset fSDataset = this;
        synchronized (fSDataset) {
            ActiveFile activeFile = this.ongoingCreates.get(b);
            if (activeFile != null) {
                f = activeFile.file;
                threads = activeFile.threads;
                if (!isRecovery) {
                    if (System.currentTimeMillis() - f.lastModified() < this.blockWriteTimeout) {
                        throw new IOException("Block " + b + " has already been started (though not completed), and thus cannot be created.");
                    }
                    if (!f.delete()) {
                        throw new IOException("Can't write the block - unable to remove stale temp file " + f);
                    }
                    f = null;
                } else {
                    for (Thread thread : threads) {
                        thread.interrupt();
                    }
                }
                this.ongoingCreates.remove(b);
            }
            FSVolume v = null;
            if (!isRecovery) {
                v = this.volumes.getNextVolume(blockSize);
                f = this.createTmpFile(v, b);
                this.volumeMap.put(b, new DatanodeBlockInfo(v));
            }
            this.ongoingCreates.put(b, new ActiveFile(f, threads));
        }
        try {
            if (threads != null) {
                for (Thread thread : threads) {
                    thread.join();
                }
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Recovery waiting for thread interrupted.");
        }
        return this.createBlockWriteStreams(f);
    }

    public long getChannelPosition(Block b, FSDatasetInterface.BlockWriteStreams streams) throws IOException {
        FileOutputStream file = (FileOutputStream)streams.dataOut;
        return file.getChannel().position();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChannelPosition(Block b, FSDatasetInterface.BlockWriteStreams streams, long dataOffset, long ckOffset) throws IOException {
        long size = 0L;
        FSDataset fSDataset = this;
        synchronized (fSDataset) {
            FSVolume vol = this.volumeMap.get(b).getVolume();
            size = vol.getTmpFile(b).length();
        }
        if (size < dataOffset) {
            String msg = "Trying to change block file offset of block " + b + " to " + dataOffset + " but actual size of file is " + size;
            throw new IOException(msg);
        }
        FileOutputStream file = (FileOutputStream)streams.dataOut;
        file.getChannel().position(dataOffset);
        file = (FileOutputStream)streams.checksumOut;
        file.getChannel().position(ckOffset);
    }

    synchronized File createTmpFile(FSVolume vol, Block blk) throws IOException {
        if (vol == null && (vol = this.volumeMap.get(blk).getVolume()) == null) {
            throw new IOException("Could not find volume for block " + blk);
        }
        return vol.createTmpFile(blk);
    }

    public synchronized void finalizeBlock(Block b) throws IOException {
        File f = this.ongoingCreates.get((Object)b).file;
        if (f == null || !f.exists()) {
            throw new IOException("No temporary file " + f + " for block " + b);
        }
        FSVolume v = this.volumeMap.get(b).getVolume();
        if (v == null) {
            throw new IOException("No volume for temporary file " + f + " for block " + b);
        }
        File dest = null;
        dest = v.addBlock(b, f);
        this.volumeMap.put(b, new DatanodeBlockInfo(v, dest));
        this.ongoingCreates.remove(b);
    }

    public synchronized void unfinalizeBlock(Block b) throws IOException {
        this.ongoingCreates.remove(b);
        this.volumeMap.remove(b);
        DataNode.LOG.warn((Object)("Block " + b + " unfinalized and removed. "));
    }

    public Block[] getBlockReport() {
        TreeSet<Block> blockSet = new TreeSet<Block>();
        this.volumes.getBlockInfo(blockSet);
        Block[] blockTable = new Block[blockSet.size()];
        int i = 0;
        Iterator<Block> it = blockSet.iterator();
        while (it.hasNext()) {
            blockTable[i] = it.next();
            ++i;
        }
        return blockTable;
    }

    public boolean isValidBlock(Block b) {
        return this.validateBlockFile(b) != null;
    }

    File validateBlockFile(Block b) {
        File f = this.getFile(b);
        if (f != null && f.exists()) {
            return f;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(Block[] invalidBlks) throws IOException {
        boolean error = false;
        for (int i = 0; i < invalidBlks.length; ++i) {
            FSVolume v;
            File f = null;
            FSDataset fSDataset = this;
            synchronized (fSDataset) {
                f = this.getFile(invalidBlks[i]);
                DatanodeBlockInfo dinfo = this.volumeMap.get(invalidBlks[i]);
                if (dinfo == null) {
                    DataNode.LOG.warn((Object)("Unexpected error trying to delete block " + invalidBlks[i] + ". BlockInfo not found in volumeMap."));
                    error = true;
                    continue;
                }
                v = dinfo.getVolume();
                if (f == null) {
                    DataNode.LOG.warn((Object)("Unexpected error trying to delete block " + invalidBlks[i] + ". Block not found in blockMap." + (v == null ? " " : " Block found in volumeMap.")));
                    error = true;
                    continue;
                }
                if (v == null) {
                    DataNode.LOG.warn((Object)("Unexpected error trying to delete block " + invalidBlks[i] + ". No volume for this block." + " Block found in blockMap. " + f + "."));
                    error = true;
                    continue;
                }
                File parent = f.getParentFile();
                if (parent == null) {
                    DataNode.LOG.warn((Object)("Unexpected error trying to delete block " + invalidBlks[i] + ". Parent not found for file " + f + "."));
                    error = true;
                    continue;
                }
                v.clearPath(parent);
                this.volumeMap.remove(invalidBlks[i]);
            }
            File metaFile = FSDataset.getMetaFile(f);
            long blockSize = f.length() + metaFile.length();
            if (!f.delete() || !metaFile.delete() && metaFile.exists()) {
                DataNode.LOG.warn((Object)("Unexpected error trying to delete block " + invalidBlks[i] + " at file " + f));
                error = true;
                continue;
            }
            v.decDfsUsed(blockSize);
            DataNode.LOG.info((Object)("Deleting block " + invalidBlks[i] + " file " + f));
            if (!f.exists()) continue;
            DataNode.LOG.info((Object)("File " + f + " was deleted but still exists!"));
        }
        if (error) {
            throw new IOException("Error in deleting blocks.");
        }
    }

    synchronized File getFile(Block b) {
        DatanodeBlockInfo info = this.volumeMap.get(b);
        if (info != null) {
            return info.getFile();
        }
        return null;
    }

    public void checkDataDir() throws DiskChecker.DiskErrorException {
        this.volumes.checkDirs();
    }

    public String toString() {
        return "FSDataset{dirpath='" + this.volumes + "'}";
    }

    void registerMBean(String storageId) {
        String serverName = storageId.equals("") ? "DataNode-UndefinedStorageId" + this.rand.nextInt() : "DataNode-" + storageId;
        try {
            StandardMBean bean = new StandardMBean(this, FSDatasetMBean.class);
            this.mbeanName = MBeanUtil.registerMBean(serverName, "FSDatasetStatus", bean);
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
        }
        DataNode.LOG.info((Object)"Registered FSDatasetStatusMBean");
    }

    public void shutdown() {
        if (this.mbeanName != null) {
            MBeanUtil.unregisterMBean(this.mbeanName);
        }
    }

    public String getStorageInfo() {
        return this.toString();
    }

    @Deprecated
    public long getBlockSize(Block b) {
        return this.getFile(b).length();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ActiveFile {
        File file;
        List<Thread> threads = new ArrayList<Thread>(2);

        ActiveFile(File f, List<Thread> list) {
            this.file = f;
            if (list != null) {
                this.threads.addAll(list);
            }
            this.threads.add(Thread.currentThread());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FSVolumeSet {
        FSVolume[] volumes = null;
        int curVolume = 0;

        FSVolumeSet(FSVolume[] volumes) {
            this.volumes = volumes;
        }

        synchronized FSVolume getNextVolume(long blockSize) throws IOException {
            int startVolume = this.curVolume;
            do {
                FSVolume volume = this.volumes[this.curVolume];
                this.curVolume = (this.curVolume + 1) % this.volumes.length;
                if (volume.getAvailable() <= blockSize) continue;
                return volume;
            } while (this.curVolume != startVolume);
            throw new DiskChecker.DiskOutOfSpaceException("Insufficient space for an additional block");
        }

        long getDfsUsed() throws IOException {
            long dfsUsed = 0L;
            for (int idx = 0; idx < this.volumes.length; ++idx) {
                dfsUsed += this.volumes[idx].getDfsUsed();
            }
            return dfsUsed;
        }

        synchronized long getCapacity() throws IOException {
            long capacity = 0L;
            for (int idx = 0; idx < this.volumes.length; ++idx) {
                capacity += this.volumes[idx].getCapacity();
            }
            return capacity;
        }

        synchronized long getRemaining() throws IOException {
            long remaining = 0L;
            for (int idx = 0; idx < this.volumes.length; ++idx) {
                remaining += this.volumes[idx].getAvailable();
            }
            return remaining;
        }

        synchronized void getBlockInfo(TreeSet<Block> blockSet) {
            for (int idx = 0; idx < this.volumes.length; ++idx) {
                this.volumes[idx].getBlockInfo(blockSet);
            }
        }

        synchronized void getVolumeMap(HashMap<Block, DatanodeBlockInfo> volumeMap) {
            for (int idx = 0; idx < this.volumes.length; ++idx) {
                this.volumes[idx].getVolumeMap(volumeMap);
            }
        }

        synchronized void checkDirs() throws DiskChecker.DiskErrorException {
            for (int idx = 0; idx < this.volumes.length; ++idx) {
                this.volumes[idx].checkDirs();
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            for (int idx = 0; idx < this.volumes.length; ++idx) {
                sb.append(this.volumes[idx].toString());
                if (idx == this.volumes.length - 1) continue;
                sb.append(",");
            }
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FSVolume {
        static final double USABLE_DISK_PCT_DEFAULT = (double)0.98f;
        private FSDir dataDir;
        private File tmpDir;
        private File detachDir;
        private DF usage;
        private DU dfsUsage;
        private long reserved;
        private double usableDiskPct = 0.98f;

        FSVolume(File currentDir, Configuration conf) throws IOException {
            this.reserved = conf.getLong("dfs.datanode.du.reserved", 0L);
            this.usableDiskPct = conf.getFloat("dfs.datanode.du.pct", 0.98f);
            File parent = currentDir.getParentFile();
            this.detachDir = new File(parent, "detach");
            if (this.detachDir.exists()) {
                this.recoverDetachedBlocks(currentDir, this.detachDir);
            }
            this.dataDir = new FSDir(currentDir);
            this.tmpDir = new File(parent, "tmp");
            if (this.tmpDir.exists()) {
                FileUtil.fullyDelete(this.tmpDir);
            }
            if (!this.tmpDir.mkdirs() && !this.tmpDir.isDirectory()) {
                throw new IOException("Mkdirs failed to create " + this.tmpDir.toString());
            }
            if (!this.detachDir.mkdirs() && !this.detachDir.isDirectory()) {
                throw new IOException("Mkdirs failed to create " + this.detachDir.toString());
            }
            this.usage = new DF(parent, conf);
            this.dfsUsage = new DU(parent, conf);
        }

        void decDfsUsed(long value) {
            this.dfsUsage.decDfsUsed(value);
        }

        long getDfsUsed() throws IOException {
            return this.dfsUsage.getUsed();
        }

        long getCapacity() throws IOException {
            return this.usage.getCapacity();
        }

        long getAvailable() throws IOException {
            long available;
            long remaining = this.getCapacity() - this.getDfsUsed() - this.reserved;
            if (remaining > (available = this.usage.getAvailable())) {
                remaining = available;
            }
            return remaining > 0L ? (long)((double)remaining * this.usableDiskPct) : 0L;
        }

        String getMount() throws IOException {
            return this.usage.getMount();
        }

        File getDir() {
            return this.dataDir.dir;
        }

        File createTmpFile(Block b) throws IOException {
            File f = new File(this.tmpDir, b.getBlockName());
            return this.createTmpFile(b, f);
        }

        File getTmpFile(Block b) throws IOException {
            File f = new File(this.tmpDir, b.getBlockName());
            return f;
        }

        File createDetachFile(Block b, String filename) throws IOException {
            File f = new File(this.detachDir, filename);
            return this.createTmpFile(b, f);
        }

        private File createTmpFile(Block b, File f) throws IOException {
            if (f.exists()) {
                throw new IOException("Unexpected problem in creating temporary file for " + b + ".  File " + f + " should not be present, but is.");
            }
            if (!f.createNewFile()) {
                throw new IOException("Unexpected problem in creating temporary file for " + b + ".  File " + f + " should be creatable, but is already present.");
            }
            return f;
        }

        File addBlock(Block b, File f) throws IOException {
            File blockFile = this.dataDir.addBlock(b, f);
            File metaFile = FSDataset.getMetaFile(blockFile);
            this.dfsUsage.incDfsUsed(b.getNumBytes() + metaFile.length());
            return blockFile;
        }

        void checkDirs() throws DiskChecker.DiskErrorException {
            this.dataDir.checkDirTree();
            DiskChecker.checkDir(this.tmpDir);
        }

        void getBlockInfo(TreeSet<Block> blockSet) {
            this.dataDir.getBlockInfo(blockSet);
        }

        void getVolumeMap(HashMap<Block, DatanodeBlockInfo> volumeMap) {
            this.dataDir.getVolumeMap(volumeMap, this);
        }

        void clearPath(File f) {
            this.dataDir.clearPath(f);
        }

        public String toString() {
            return this.dataDir.dir.getAbsolutePath();
        }

        private void recoverDetachedBlocks(File dataDir, File dir) throws IOException {
            File[] contents = dir.listFiles();
            if (contents == null) {
                return;
            }
            for (int i = 0; i < contents.length; ++i) {
                if (!contents[i].isFile()) {
                    throw new IOException("Found " + contents[i] + " in " + dir + " but it is not a file.");
                }
                File blk = new File(dataDir, contents[i].getName());
                if (!blk.exists()) {
                    if (contents[i].renameTo(blk)) continue;
                    throw new IOException("Unable to recover detached file " + contents[i]);
                }
                if (contents[i].delete()) continue;
                throw new IOException("Unable to cleanup detached file " + contents[i]);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FSDir {
        File dir;
        int numBlocks = 0;
        FSDir[] children;
        int lastChildIdx = 0;

        public FSDir(File dir) throws IOException {
            this.dir = dir;
            this.children = null;
            if (!dir.exists()) {
                if (!dir.mkdirs()) {
                    throw new IOException("Mkdirs failed to create " + dir.toString());
                }
            } else {
                File[] files = dir.listFiles();
                int numChildren = 0;
                for (int idx = 0; idx < files.length; ++idx) {
                    if (files[idx].isDirectory()) {
                        ++numChildren;
                        continue;
                    }
                    if (!Block.isBlockFilename(files[idx])) continue;
                    ++this.numBlocks;
                }
                if (numChildren > 0) {
                    this.children = new FSDir[numChildren];
                    int curdir = 0;
                    for (int idx = 0; idx < files.length; ++idx) {
                        if (!files[idx].isDirectory()) continue;
                        this.children[curdir] = new FSDir(files[idx]);
                        ++curdir;
                    }
                }
            }
        }

        public File addBlock(Block b, File src) throws IOException {
            File file = this.addBlock(b, src, false, false);
            return file != null ? file : this.addBlock(b, src, true, true);
        }

        private File addBlock(Block b, File src, boolean createOk, boolean resetIdx) throws IOException {
            if (this.numBlocks < FSDataset.this.maxBlocksPerDir) {
                File dest = new File(this.dir, b.getBlockName());
                File metaData = FSDataset.getMetaFile(src);
                if (!metaData.renameTo(FSDataset.getMetaFile(dest)) || !src.renameTo(dest)) {
                    throw new IOException("could not move files for " + b + " from tmp to " + dest.getAbsolutePath());
                }
                ++this.numBlocks;
                return dest;
            }
            if (this.lastChildIdx < 0 && resetIdx) {
                this.lastChildIdx = random.nextInt(this.children.length);
            }
            if (this.lastChildIdx >= 0 && this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    int idx = (this.lastChildIdx + i) % this.children.length;
                    File file = this.children[idx].addBlock(b, src, false, resetIdx);
                    if (file == null) continue;
                    this.lastChildIdx = idx;
                    return file;
                }
                this.lastChildIdx = -1;
            }
            if (!createOk) {
                return null;
            }
            if (this.children == null || this.children.length == 0) {
                this.children = new FSDir[FSDataset.this.maxBlocksPerDir];
                for (int idx = 0; idx < FSDataset.this.maxBlocksPerDir; ++idx) {
                    this.children[idx] = new FSDir(new File(this.dir, "subdir" + idx));
                }
            }
            this.lastChildIdx = random.nextInt(this.children.length);
            return this.children[this.lastChildIdx].addBlock(b, src, true, false);
        }

        public void getBlockInfo(TreeSet<Block> blockSet) {
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i].getBlockInfo(blockSet);
                }
            }
            File[] blockFiles = this.dir.listFiles();
            for (int i = 0; i < blockFiles.length; ++i) {
                if (!Block.isBlockFilename(blockFiles[i])) continue;
                blockSet.add(new Block(blockFiles[i], blockFiles[i].length()));
            }
        }

        void getVolumeMap(HashMap<Block, DatanodeBlockInfo> volumeMap, FSVolume volume) {
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i].getVolumeMap(volumeMap, volume);
                }
            }
            File[] blockFiles = this.dir.listFiles();
            for (int i = 0; i < blockFiles.length; ++i) {
                if (!Block.isBlockFilename(blockFiles[i])) continue;
                volumeMap.put(new Block(blockFiles[i], blockFiles[i].length()), new DatanodeBlockInfo(volume, blockFiles[i]));
            }
        }

        public void checkDirTree() throws DiskChecker.DiskErrorException {
            DiskChecker.checkDir(this.dir);
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i].checkDirTree();
                }
            }
        }

        void clearPath(File f) {
            String[] dirNames;
            String root = this.dir.getAbsolutePath();
            String dir = f.getAbsolutePath();
            if (dir.startsWith(root) && this.clearPath(f, dirNames = dir.substring(root.length()).split(File.separator + "subdir"), 1)) {
                return;
            }
            this.clearPath(f, null, -1);
        }

        private boolean clearPath(File f, String[] dirNames, int idx) {
            if ((dirNames == null || idx == dirNames.length) && this.dir.compareTo(f) == 0) {
                --this.numBlocks;
                return true;
            }
            if (dirNames != null) {
                int childIdx;
                if (idx > dirNames.length - 1 || this.children == null) {
                    return false;
                }
                try {
                    childIdx = Integer.parseInt(dirNames[idx]);
                }
                catch (NumberFormatException ignored) {
                    return false;
                }
                return childIdx >= 0 && childIdx < this.children.length ? this.children[childIdx].clearPath(f, dirNames, idx + 1) : false;
            }
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    if (!this.children[i].clearPath(f, null, -1)) continue;
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return "FSDir{dir=" + this.dir + ", children=" + (this.children == null ? null : Arrays.asList(this.children)) + "}";
        }
    }
}

