/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.dfs.NameNode;
import org.apache.hadoop.dfs.TransferFsImage;
import org.apache.hadoop.util.StringUtils;

public class GetImageServlet
extends HttpServlet {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.dfs.FSNamesystem");

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Map pmap = request.getParameterMap();
        try {
            ServletContext context = this.getServletContext();
            NameNode nn = (NameNode)context.getAttribute("name.node");
            TransferFsImage ff = new TransferFsImage(pmap, request, response);
            if (ff.getImage()) {
                TransferFsImage.getFileServer((OutputStream)response.getOutputStream(), nn.getFsImageName());
            } else if (ff.getEdit()) {
                TransferFsImage.getFileServer((OutputStream)response.getOutputStream(), nn.getFsEditName());
            } else if (ff.putImage()) {
                nn.validateCheckpointUpload(ff.getToken());
                TransferFsImage.getFileClient(ff.getInfoServer(), "getimage=1", nn.getFsImageNameCheckpoint());
                nn.checkpointUploadDone();
            }
        }
        catch (Exception ie) {
            String errMsg = "GetImage failed. " + StringUtils.stringifyException(ie);
            response.sendError(410, errMsg);
            throw new IOException(errMsg);
        }
        finally {
            response.getOutputStream().close();
        }
    }
}

