/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.DatanodeInfo;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

class LocatedBlock
implements Writable {
    private Block b;
    private long offset;
    private DatanodeInfo[] locs;

    public LocatedBlock() {
        this(new Block(), new DatanodeInfo[0], 0L);
    }

    public LocatedBlock(Block b, DatanodeInfo[] locs) {
        this(b, locs, -1L);
    }

    public LocatedBlock(Block b, DatanodeInfo[] locs, long startOffset) {
        this.b = b;
        this.offset = startOffset;
        this.locs = locs == null ? new DatanodeInfo[0] : locs;
    }

    public Block getBlock() {
        return this.b;
    }

    DatanodeInfo[] getLocations() {
        return this.locs;
    }

    long getStartOffset() {
        return this.offset;
    }

    long getBlockSize() {
        return this.b.getNumBytes();
    }

    void setStartOffset(long value) {
        this.offset = value;
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.offset);
        this.b.write(out);
        out.writeInt(this.locs.length);
        for (int i = 0; i < this.locs.length; ++i) {
            this.locs[i].write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.offset = in.readLong();
        this.b = new Block();
        this.b.readFields(in);
        int count = in.readInt();
        this.locs = new DatanodeInfo[count];
        for (int i = 0; i < this.locs.length; ++i) {
            this.locs[i] = new DatanodeInfo();
            this.locs[i].readFields(in);
        }
    }

    static {
        WritableFactories.setFactory(LocatedBlock.class, new WritableFactory(){

            public Writable newInstance() {
                return new LocatedBlock();
            }
        });
    }
}

