/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dfs.NameNode;
import org.apache.hadoop.dfs.namenode.metrics.NameNodeStatistics;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.metrics.jvm.JvmMetrics;
import org.apache.hadoop.metrics.util.MetricsIntValue;
import org.apache.hadoop.metrics.util.MetricsTimeVaryingInt;
import org.apache.hadoop.metrics.util.MetricsTimeVaryingRate;

public class NameNodeMetrics
implements Updater {
    private static Log log = LogFactory.getLog(NameNodeMetrics.class);
    private final MetricsRecord metricsRecord;
    private NameNodeStatistics namenodeStats;
    public MetricsTimeVaryingInt numFilesCreated = new MetricsTimeVaryingInt("FilesCreated");
    public MetricsTimeVaryingInt numGetBlockLocations = new MetricsTimeVaryingInt("GetBlockLocations");
    public MetricsTimeVaryingInt numFilesRenamed = new MetricsTimeVaryingInt("FilesRenamed");
    public MetricsTimeVaryingInt numFilesListed = new MetricsTimeVaryingInt("FilesListed");
    public MetricsTimeVaryingRate transactions = new MetricsTimeVaryingRate("Transactions");
    public MetricsTimeVaryingRate syncs = new MetricsTimeVaryingRate("Syncs");
    public MetricsTimeVaryingRate blockReport = new MetricsTimeVaryingRate("blockReport");
    public MetricsIntValue safeModeTime = new MetricsIntValue("SafemodeTime");
    public MetricsIntValue fsImageLoadTime = new MetricsIntValue("fsImageLoadTime");

    NameNodeMetrics(Configuration conf, NameNode nameNode) {
        String sessionId = conf.get("session.id");
        JvmMetrics.init("NameNode", sessionId);
        this.namenodeStats = new NameNodeStatistics(this);
        MetricsContext metricsContext = MetricsUtil.getContext("dfs");
        this.metricsRecord = MetricsUtil.createRecord(metricsContext, "namenode");
        this.metricsRecord.setTag("sessionId", sessionId);
        metricsContext.registerUpdater(this);
        log.info((Object)("Initializing NameNodeMeterics using context object:" + metricsContext.getClass().getName()));
    }

    public void shutdown() {
        if (this.namenodeStats != null) {
            this.namenodeStats.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdates(MetricsContext unused) {
        NameNodeMetrics nameNodeMetrics = this;
        synchronized (nameNodeMetrics) {
            this.numFilesCreated.pushMetric(this.metricsRecord);
            this.numGetBlockLocations.pushMetric(this.metricsRecord);
            this.numFilesRenamed.pushMetric(this.metricsRecord);
            this.numFilesListed.pushMetric(this.metricsRecord);
            this.transactions.pushMetric(this.metricsRecord);
            this.syncs.pushMetric(this.metricsRecord);
            this.blockReport.pushMetric(this.metricsRecord);
            this.safeModeTime.pushMetric(this.metricsRecord);
            this.fsImageLoadTime.pushMetric(this.metricsRecord);
        }
        this.metricsRecord.update();
    }

    public void resetAllMinMax() {
        this.transactions.resetMinMax();
        this.syncs.resetMinMax();
        this.blockReport.resetMinMax();
    }
}

