/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.IOException;
import org.apache.hadoop.dfs.UpgradeObjectCollection;
import org.apache.hadoop.dfs.UpgradeStatusReport;
import org.apache.hadoop.dfs.Upgradeable;

abstract class UpgradeObject
implements Upgradeable {
    protected short status;

    UpgradeObject() {
    }

    public short getUpgradeStatus() {
        return this.status;
    }

    public String getDescription() {
        return "Upgrade object for " + (Object)((Object)this.getType()) + " layout version " + this.getVersion();
    }

    public UpgradeStatusReport getUpgradeStatusReport(boolean details) throws IOException {
        return new UpgradeStatusReport(this.getVersion(), this.getUpgradeStatus(), false);
    }

    public int compareTo(Upgradeable o) {
        if (this.getVersion() != o.getVersion()) {
            return this.getVersion() > o.getVersion() ? -1 : 1;
        }
        int res = this.getType().toString().compareTo(o.getType().toString());
        if (res != 0) {
            return res;
        }
        return this.getClass().getCanonicalName().compareTo(o.getClass().getCanonicalName());
    }

    public boolean equals(Object o) {
        if (!(o instanceof UpgradeObject)) {
            return false;
        }
        return this.compareTo((UpgradeObject)o) == 0;
    }

    public int hashCode() {
        return new UpgradeObjectCollection.UOSignature(this).hashCode();
    }
}

