/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.IOException;
import java.net.SocketTimeoutException;
import org.apache.hadoop.dfs.DataNode;
import org.apache.hadoop.dfs.FSConstants;
import org.apache.hadoop.dfs.NamespaceInfo;
import org.apache.hadoop.dfs.UpgradeCommand;
import org.apache.hadoop.dfs.UpgradeObject;
import org.apache.hadoop.util.StringUtils;

abstract class UpgradeObjectDatanode
extends UpgradeObject
implements Runnable {
    private DataNode dataNode = null;

    UpgradeObjectDatanode() {
    }

    public FSConstants.NodeType getType() {
        return FSConstants.NodeType.DATA_NODE;
    }

    protected DataNode getDatanode() {
        return this.dataNode;
    }

    void setDatanode(DataNode dataNode) {
        this.dataNode = dataNode;
    }

    abstract void doUpgrade() throws IOException;

    boolean preUpgradeAction(NamespaceInfo nsInfo) throws IOException {
        int nsUpgradeVersion = nsInfo.getDistributedUpgradeVersion();
        if (nsUpgradeVersion >= this.getVersion()) {
            return false;
        }
        String errorMsg = "\n   Data-node missed a distributed upgrade and will shutdown.\n   " + this.getDescription() + "." + " Name-node version = " + nsInfo.getLayoutVersion() + ".";
        DataNode.LOG.fatal((Object)errorMsg);
        try {
            this.dataNode.namenode.errorReport(this.dataNode.dnRegistration, 0, errorMsg);
        }
        catch (SocketTimeoutException e) {
            DataNode.LOG.info((Object)("Problem connecting to server: " + this.dataNode.getNameNodeAddr()));
        }
        throw new IOException(errorMsg);
    }

    public void run() {
        assert (this.dataNode != null) : "UpgradeObjectDatanode.dataNode is null";
        if (this.dataNode.shouldRun) {
            try {
                this.doUpgrade();
            }
            catch (Exception e) {
                DataNode.LOG.error((Object)StringUtils.stringifyException(e));
            }
        }
        if (this.getUpgradeStatus() < 100) {
            DataNode.LOG.info((Object)("\n   Distributed upgrade for DataNode version " + this.getVersion() + " to current LV " + -13 + " cannot be completed."));
        }
        try {
            this.dataNode.upgradeManager.completeUpgrade();
        }
        catch (IOException e) {
            DataNode.LOG.error((Object)StringUtils.stringifyException(e));
        }
    }

    public UpgradeCommand completeUpgrade() throws IOException {
        return new UpgradeCommand(100, this.getVersion(), 100);
    }
}

