/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

public class UpgradeStatusReport
implements Writable {
    protected int version;
    protected short upgradeStatus;
    protected boolean finalized;

    public UpgradeStatusReport() {
        this.version = 0;
        this.upgradeStatus = 0;
        this.finalized = false;
    }

    public UpgradeStatusReport(int version, short status, boolean isFinalized) {
        this.version = version;
        this.upgradeStatus = status;
        this.finalized = isFinalized;
    }

    public int getVersion() {
        return this.version;
    }

    public short getUpgradeStatus() {
        return this.upgradeStatus;
    }

    public boolean isFinalized() {
        return this.finalized;
    }

    public String getStatusText(boolean details) {
        return "Upgrade for version " + this.getVersion() + (this.upgradeStatus < 100 ? " is in progress. Status = " + this.upgradeStatus + "%" : " has been completed.\nUpgrade is " + (this.finalized ? "" : "not ") + "finalized.");
    }

    public String toString() {
        return this.getStatusText(false);
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.version);
        out.writeShort(this.upgradeStatus);
    }

    public void readFields(DataInput in) throws IOException {
        this.version = in.readInt();
        this.upgradeStatus = in.readShort();
    }

    static {
        WritableFactories.setFactory(UpgradeStatusReport.class, new WritableFactory(){

            public Writable newInstance() {
                return new UpgradeStatusReport();
            }
        });
    }
}

