/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs.datanode.metrics;

import java.util.Random;
import javax.management.ObjectName;
import org.apache.hadoop.dfs.datanode.metrics.DataNodeMetrics;
import org.apache.hadoop.dfs.datanode.metrics.DataNodeStatisticsMBean;
import org.apache.hadoop.metrics.util.MBeanUtil;

public class DataNodeStatistics
implements DataNodeStatisticsMBean {
    private DataNodeMetrics myMetrics;
    private ObjectName mbeanName;
    private Random rand = new Random();

    DataNodeStatistics(DataNodeMetrics dataNodeMetrics, String storageId) {
        this.myMetrics = dataNodeMetrics;
        String serverName = storageId.equals("") ? "DataNode-UndefinedStorageId" + this.rand.nextInt() : "DataNode-" + storageId;
        this.mbeanName = MBeanUtil.registerMBean(serverName, "DataNodeStatistics", this);
    }

    public void shutdown() {
        if (this.mbeanName != null) {
            MBeanUtil.unregisterMBean(this.mbeanName);
        }
    }

    public void resetAllMinMax() {
        this.myMetrics.resetAllMinMax();
    }

    public int getBlocksRead() {
        return this.myMetrics.blocksRead.getPreviousIntervalValue();
    }

    public int getBlocksRemoved() {
        return this.myMetrics.blocksRemoved.getPreviousIntervalValue();
    }

    public int getBlocksReplicated() {
        return this.myMetrics.blocksReplicated.getPreviousIntervalValue();
    }

    public int getBlocksWritten() {
        return this.myMetrics.blocksWritten.getPreviousIntervalValue();
    }

    public int getBytesRead() {
        return this.myMetrics.bytesRead.getPreviousIntervalValue();
    }

    public int getBlockVerificationFailures() {
        return this.myMetrics.blockVerificationFailures.getPreviousIntervalValue();
    }

    public int getBlocksVerified() {
        return this.myMetrics.blocksVerified.getPreviousIntervalValue();
    }

    public int getReadsFromLocalClient() {
        return this.myMetrics.readsFromLocalClient.getPreviousIntervalValue();
    }

    public int getReadsFromRemoteClient() {
        return this.myMetrics.readsFromRemoteClient.getPreviousIntervalValue();
    }

    public int getWritesFromLocalClient() {
        return this.myMetrics.writesFromLocalClient.getPreviousIntervalValue();
    }

    public int getWritesFromRemoteClient() {
        return this.myMetrics.writesFromRemoteClient.getPreviousIntervalValue();
    }

    public long getReadBlockOpAverageTime() {
        return this.myMetrics.readBlockOp.getPreviousIntervalAverageTime();
    }

    public long getReadBlockOpMaxTime() {
        return this.myMetrics.readBlockOp.getMaxTime();
    }

    public long getReadBlockOpMinTime() {
        return this.myMetrics.readBlockOp.getMinTime();
    }

    public int getReadBlockOpNum() {
        return this.myMetrics.readBlockOp.getPreviousIntervalNumOps();
    }

    public long getReadMetadataOpAverageTime() {
        return this.myMetrics.readMetadataOp.getPreviousIntervalAverageTime();
    }

    public long getReadMetadataOpMaxTime() {
        return this.myMetrics.readMetadataOp.getMaxTime();
    }

    public long getReadMetadataOpMinTime() {
        return this.myMetrics.readMetadataOp.getMinTime();
    }

    public int getReadMetadataOpNum() {
        return this.myMetrics.readMetadataOp.getPreviousIntervalNumOps();
    }

    public long getReplaceBlockOpAverageTime() {
        return this.myMetrics.replaceBlockOp.getPreviousIntervalAverageTime();
    }

    public long getReplaceBlockOpMaxTime() {
        return this.myMetrics.replaceBlockOp.getMaxTime();
    }

    public long getReplaceBlockOpMinTime() {
        return this.myMetrics.replaceBlockOp.getMinTime();
    }

    public int getReplaceBlockOpNum() {
        return this.myMetrics.replaceBlockOp.getPreviousIntervalNumOps();
    }

    public long getWriteBlockOpAverageTime() {
        return this.myMetrics.writeBlockOp.getPreviousIntervalAverageTime();
    }

    public long getWriteBlockOpMaxTime() {
        return this.myMetrics.writeBlockOp.getMaxTime();
    }

    public long getWriteBlockOpMinTime() {
        return this.myMetrics.writeBlockOp.getMinTime();
    }

    public int getWriteBlockOpNum() {
        return this.myMetrics.writeBlockOp.getPreviousIntervalNumOps();
    }

    public long getCopyBlockOpAverageTime() {
        return this.myMetrics.copyBlockOp.getPreviousIntervalAverageTime();
    }

    public long getCopyBlockOpMaxTime() {
        return this.myMetrics.copyBlockOp.getMaxTime();
    }

    public long getCopyBlockOpMinTime() {
        return this.myMetrics.copyBlockOp.getMinTime();
    }

    public int getCopyBlockOpNum() {
        return this.myMetrics.copyBlockOp.getPreviousIntervalNumOps();
    }

    public long getBlockReportsAverageTime() {
        return this.myMetrics.blockReports.getPreviousIntervalAverageTime();
    }

    public long getBlockReportsMaxTime() {
        return this.myMetrics.blockReports.getMaxTime();
    }

    public long getBlockReportsMinTime() {
        return this.myMetrics.blockReports.getMinTime();
    }

    public int getBlockReportsNum() {
        return this.myMetrics.blockReports.getPreviousIntervalNumOps();
    }

    public long getHeartbeatsAverageTime() {
        return this.myMetrics.heartbeats.getPreviousIntervalAverageTime();
    }

    public long getHeartbeatsMaxTime() {
        return this.myMetrics.heartbeats.getMaxTime();
    }

    public long getHeartbeatsMinTime() {
        return this.myMetrics.heartbeats.getMinTime();
    }

    public int getHeartbeatsNum() {
        return this.myMetrics.heartbeats.getPreviousIntervalNumOps();
    }
}

