/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

public class BlockLocation
implements Writable {
    private String[] hosts;
    private String[] names;
    private long offset;
    private long length;

    public BlockLocation() {
        this(new String[0], new String[0], 0L, 0L);
    }

    public BlockLocation(String[] names, String[] hosts, long offset, long length) {
        this.names = names == null ? new String[0] : names;
        this.hosts = hosts == null ? new String[0] : hosts;
        this.offset = offset;
        this.length = length;
    }

    public String[] getHosts() throws IOException {
        if (this.hosts == null || this.hosts.length == 0) {
            return new String[0];
        }
        return this.hosts;
    }

    public String[] getNames() throws IOException {
        if (this.names == null || this.names.length == 0) {
            return new String[0];
        }
        return this.names;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLength() {
        return this.length;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public void setHosts(String[] hosts) throws IOException {
        this.hosts = hosts == null ? new String[0] : hosts;
    }

    public void setNames(String[] names) throws IOException {
        this.names = names == null ? new String[0] : names;
    }

    public void write(DataOutput out) throws IOException {
        int i;
        out.writeLong(this.offset);
        out.writeLong(this.length);
        out.writeInt(this.names.length);
        for (i = 0; i < this.names.length; ++i) {
            Text name = new Text(this.names[i]);
            name.write(out);
        }
        out.writeInt(this.hosts.length);
        for (i = 0; i < this.hosts.length; ++i) {
            Text host = new Text(this.hosts[i]);
            host.write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.offset = in.readLong();
        this.length = in.readLong();
        int numNames = in.readInt();
        this.names = new String[numNames];
        for (int i = 0; i < numNames; ++i) {
            Text name = new Text();
            name.readFields(in);
            this.names[i] = name.toString();
        }
        int numHosts = in.readInt();
        for (int i = 0; i < numHosts; ++i) {
            Text host = new Text();
            host.readFields(in);
            this.hosts[i] = host.toString();
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.offset);
        result.append(',');
        result.append(this.length);
        for (String h : this.hosts) {
            result.append(',');
            result.append(h);
        }
        return result.toString();
    }

    static {
        WritableFactories.setFactory(BlockLocation.class, new WritableFactory(){

            public Writable newInstance() {
                return new BlockLocation();
            }
        });
    }
}

