/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

public class ContentSummary
implements Writable {
    private long length;
    private long fileCount;
    private long directoryCount;
    private static final String STRING_FORMAT = "%12d %12d %18d ";
    static String HEADER = String.format("%12d %12d %18d ".replace('d', 's'), "directories", "files", "bytes");

    public ContentSummary() {
    }

    public ContentSummary(long length, long fileCount, long directoryCount) {
        this.length = length;
        this.fileCount = fileCount;
        this.directoryCount = directoryCount;
    }

    public long getLength() {
        return this.length;
    }

    public long getDirectoryCount() {
        return this.directoryCount;
    }

    public long getFileCount() {
        return this.fileCount;
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.length);
        out.writeLong(this.fileCount);
        out.writeLong(this.directoryCount);
    }

    public void readFields(DataInput in) throws IOException {
        this.length = in.readLong();
        this.fileCount = in.readLong();
        this.directoryCount = in.readLong();
    }

    public String toString() {
        return String.format(STRING_FORMAT, this.directoryCount, this.fileCount, this.length);
    }
}

