/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Shell;

public class DU
extends Shell {
    private String dirPath;
    private long used;

    public DU(File path, long interval) throws IOException {
        super(interval);
        this.dirPath = path.getCanonicalPath();
    }

    public DU(File path, Configuration conf) throws IOException {
        this(path, conf.getLong("dfs.blockreport.intervalMsec", 3600000L));
    }

    public synchronized void decDfsUsed(long value) {
        this.used -= value;
    }

    public synchronized void incDfsUsed(long value) {
        this.used += value;
    }

    public synchronized long getUsed() throws IOException {
        this.run();
        return this.used;
    }

    public String getDirPath() {
        return this.dirPath;
    }

    public String toString() {
        return "du -sk " + this.dirPath + "\n" + this.used + "\t" + this.dirPath;
    }

    protected String[] getExecString() {
        return new String[]{"du", "-sk", this.dirPath};
    }

    protected void parseExecResult(BufferedReader lines) throws IOException {
        String line = lines.readLine();
        if (line == null) {
            throw new IOException("Expecting a line not the end of stream");
        }
        String[] tokens = line.split("\t");
        if (tokens.length == 0) {
            throw new IOException("Illegal du output");
        }
        this.used = Long.parseLong(tokens[0]) * 1024L;
    }

    public static void main(String[] args) throws Exception {
        String path = ".";
        if (args.length > 0) {
            path = args[0];
        }
        System.out.println(new DU(new File(path), new Configuration()).toString());
    }
}

