/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;

public class FilterFileSystem
extends FileSystem {
    protected FileSystem fs;

    public FilterFileSystem(FileSystem fs) {
        this.fs = fs;
    }

    public void initialize(URI name, Configuration conf) throws IOException {
        this.fs.initialize(name, conf);
    }

    public URI getUri() {
        return this.fs.getUri();
    }

    public String getName() {
        return this.fs.getName();
    }

    public Path makeQualified(Path path) {
        return this.fs.makeQualified(path);
    }

    protected void checkPath(Path path) {
        this.fs.checkPath(path);
    }

    public BlockLocation[] getFileBlockLocations(Path f, long start, long len) throws IOException {
        return this.fs.getFileBlockLocations(f, start, len);
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        return this.fs.open(f, bufferSize);
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.fs.create(f, permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    public boolean setReplication(Path src, short replication) throws IOException {
        return this.fs.setReplication(src, replication);
    }

    public boolean rename(Path src, Path dst) throws IOException {
        return this.fs.rename(src, dst);
    }

    @Deprecated
    public boolean delete(Path f) throws IOException {
        return this.delete(f, true);
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        return this.fs.delete(f, recursive);
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        return this.fs.listStatus(f);
    }

    public Path getHomeDirectory() {
        return this.fs.getHomeDirectory();
    }

    public void setWorkingDirectory(Path newDir) {
        this.fs.setWorkingDirectory(newDir);
    }

    public Path getWorkingDirectory() {
        return this.fs.getWorkingDirectory();
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        return this.fs.mkdirs(f, permission);
    }

    public void copyFromLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        this.fs.copyFromLocalFile(delSrc, src, dst);
    }

    public void copyToLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        this.fs.copyToLocalFile(delSrc, src, dst);
    }

    public Path startLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        return this.fs.startLocalOutput(fsOutputFile, tmpLocalFile);
    }

    public void completeLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        this.fs.completeLocalOutput(fsOutputFile, tmpLocalFile);
    }

    public long getDefaultBlockSize() {
        return this.fs.getDefaultBlockSize();
    }

    public short getDefaultReplication() {
        return this.fs.getDefaultReplication();
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        return this.fs.getFileStatus(f);
    }

    public Configuration getConf() {
        return this.fs.getConf();
    }

    public void close() throws IOException {
        super.close();
        this.fs.close();
    }

    public void setOwner(Path p, String username, String groupname) throws IOException {
        this.fs.setOwner(p, username, groupname);
    }

    public void setPermission(Path p, FsPermission permission) throws IOException {
        this.fs.setPermission(p, permission);
    }
}

