/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BufferedFSInputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSError;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;

public class RawLocalFileSystem
extends FileSystem {
    static final URI NAME = URI.create("file:///");
    private Path workingDir;
    TreeMap<File, FileInputStream> sharedLockDataSet = new TreeMap();
    TreeMap<File, FileOutputStream> nonsharedLockDataSet = new TreeMap();
    TreeMap<File, FileLock> lockObjSet = new TreeMap();

    public RawLocalFileSystem() {
        this.workingDir = new Path(System.getProperty("user.dir")).makeQualified(this);
    }

    public File pathToFile(Path path) {
        this.checkPath(path);
        if (!path.isAbsolute()) {
            path = new Path(this.getWorkingDirectory(), path);
        }
        return new File(path.toUri().getPath());
    }

    public String getName() {
        return "local";
    }

    public URI getUri() {
        return NAME;
    }

    public void initialize(URI uri, Configuration conf) {
        this.setConf(conf);
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        if (!this.exists(f)) {
            throw new FileNotFoundException(f.toString());
        }
        return new FSDataInputStream(new BufferedFSInputStream(new LocalFSFileInputStream(f), bufferSize));
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        if (this.exists(f) && !overwrite) {
            throw new IOException("File already exists:" + f);
        }
        Path parent = f.getParent();
        if (parent != null && !this.mkdirs(parent)) {
            throw new IOException("Mkdirs failed to create " + parent.toString());
        }
        return new FSDataOutputStream(new BufferedOutputStream(new LocalFSFileOutputStream(f), bufferSize), this.statistics);
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        FSDataOutputStream out = this.create(f, overwrite, bufferSize, replication, blockSize, progress);
        this.setPermission(f, permission);
        return out;
    }

    public boolean rename(Path src, Path dst) throws IOException {
        if (this.pathToFile(src).renameTo(this.pathToFile(dst))) {
            return true;
        }
        return FileUtil.copy(this, src, this, dst, true, this.getConf());
    }

    @Deprecated
    public boolean delete(Path p) throws IOException {
        return this.delete(p, true);
    }

    public boolean delete(Path p, boolean recursive) throws IOException {
        File f = this.pathToFile(p);
        if (f.isFile()) {
            return f.delete();
        }
        if (!recursive && f.isDirectory() && f.listFiles().length != 0) {
            throw new IOException("Directory " + f.toString() + " is not empty");
        }
        return FileUtil.fullyDelete(f);
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        File localf = this.pathToFile(f);
        if (!localf.exists()) {
            return null;
        }
        if (localf.isFile()) {
            return new FileStatus[]{new RawLocalFileStatus(localf, this.getDefaultBlockSize(), this)};
        }
        String[] names = localf.list();
        if (names == null) {
            return null;
        }
        FileStatus[] results = new FileStatus[names.length];
        for (int i = 0; i < names.length; ++i) {
            results[i] = this.getFileStatus(new Path(f, names[i]));
        }
        return results;
    }

    public boolean mkdirs(Path f) throws IOException {
        Path parent = f.getParent();
        File p2f = this.pathToFile(f);
        return !(parent != null && !this.mkdirs(parent) || !p2f.mkdir() && !p2f.isDirectory());
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        boolean b = this.mkdirs(f);
        this.setPermission(f, permission);
        return b;
    }

    public Path getHomeDirectory() {
        return new Path(System.getProperty("user.home")).makeQualified(this);
    }

    public void setWorkingDirectory(Path newDir) {
        this.workingDir = newDir;
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void lock(Path p, boolean shared) throws IOException {
        File f = this.pathToFile(p);
        f.createNewFile();
        if (shared) {
            FileInputStream lockData = new FileInputStream(f);
            FileLock lockObj = lockData.getChannel().lock(0L, Long.MAX_VALUE, shared);
            RawLocalFileSystem rawLocalFileSystem = this;
            synchronized (rawLocalFileSystem) {
                this.sharedLockDataSet.put(f, lockData);
                this.lockObjSet.put(f, lockObj);
            }
        }
        FileOutputStream lockData = new FileOutputStream(f);
        FileLock lockObj = lockData.getChannel().lock(0L, Long.MAX_VALUE, shared);
        RawLocalFileSystem rawLocalFileSystem = this;
        synchronized (rawLocalFileSystem) {
            this.nonsharedLockDataSet.put(f, lockData);
            this.lockObjSet.put(f, lockObj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void release(Path p) throws IOException {
        FileOutputStream nonsharedLockData;
        FileInputStream sharedLockData;
        FileLock lockObj;
        File f = this.pathToFile(p);
        RawLocalFileSystem rawLocalFileSystem = this;
        synchronized (rawLocalFileSystem) {
            lockObj = this.lockObjSet.remove(f);
            sharedLockData = this.sharedLockDataSet.remove(f);
            nonsharedLockData = this.nonsharedLockDataSet.remove(f);
        }
        if (lockObj == null) {
            throw new IOException("Given target not held as lock");
        }
        if (sharedLockData == null && nonsharedLockData == null) {
            throw new IOException("Given target not held as lock");
        }
        lockObj.release();
        if (sharedLockData != null) {
            sharedLockData.close();
        } else {
            nonsharedLockData.close();
        }
    }

    public void moveFromLocalFile(Path src, Path dst) throws IOException {
        this.rename(src, dst);
    }

    public Path startLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        return fsOutputFile;
    }

    public void completeLocalOutput(Path fsWorkingFile, Path tmpLocalFile) throws IOException {
    }

    public void close() throws IOException {
        super.close();
    }

    public String toString() {
        return "LocalFS";
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        File path = this.pathToFile(f);
        if (path.exists()) {
            return new RawLocalFileStatus(this.pathToFile(f), this.getDefaultBlockSize(), this);
        }
        throw new FileNotFoundException("File " + f + " does not exist.");
    }

    public void setOwner(Path p, String username, String groupname) throws IOException {
        if (username == null && groupname == null) {
            throw new IOException("username == null && groupname == null");
        }
        if (username == null) {
            RawLocalFileSystem.execCommand(this.pathToFile(p), "chgrp", groupname);
        } else {
            String s = username + (groupname == null ? "" : ":" + groupname);
            RawLocalFileSystem.execCommand(this.pathToFile(p), "chown", s);
        }
    }

    public void setPermission(Path p, FsPermission permission) throws IOException {
        RawLocalFileSystem.execCommand(this.pathToFile(p), "chmod", String.format("%04o", permission.toShort()));
    }

    private static String execCommand(File f, String ... cmd) throws IOException {
        String[] args = new String[cmd.length + 1];
        System.arraycopy(cmd, 0, args, 0, cmd.length);
        args[cmd.length] = f.getCanonicalPath();
        String output = Shell.execCommand(args);
        return output;
    }

    static class RawLocalFileStatus
    extends FileStatus {
        private boolean isPermissionLoaded() {
            return !super.getOwner().equals("");
        }

        RawLocalFileStatus(File f, long defaultBlockSize, FileSystem fs) {
            super(f.length(), f.isDirectory(), 1, defaultBlockSize, f.lastModified(), new Path(f.getPath()).makeQualified(fs));
        }

        public FsPermission getPermission() {
            if (!this.isPermissionLoaded()) {
                this.loadPermissionInfo();
            }
            return super.getPermission();
        }

        public String getOwner() {
            if (!this.isPermissionLoaded()) {
                this.loadPermissionInfo();
            }
            return super.getOwner();
        }

        public String getGroup() {
            if (!this.isPermissionLoaded()) {
                this.loadPermissionInfo();
            }
            return super.getGroup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadPermissionInfo() {
            block9: {
                IOException e = null;
                try {
                    StringTokenizer t = new StringTokenizer(RawLocalFileSystem.execCommand(new File(this.getPath().toUri()), Shell.getGET_PERMISSION_COMMAND()));
                    String permission = t.nextToken();
                    if (permission.length() > 10) {
                        permission = permission.substring(0, 10);
                    }
                    this.setPermission(FsPermission.valueOf(permission));
                    t.nextToken();
                    this.setOwner(t.nextToken());
                    this.setGroup(t.nextToken());
                }
                catch (Shell.ExitCodeException ioe) {
                    if (ioe.getExitCode() != 1) {
                        e = ioe;
                    }
                    this.setPermission(null);
                    this.setOwner(null);
                    this.setGroup(null);
                }
                catch (IOException ioe) {
                    e = ioe;
                }
                finally {
                    if (e == null) break block9;
                    throw new RuntimeException("Error while running command to get file permissions : " + StringUtils.stringifyException(e));
                }
            }
        }

        public void write(DataOutput out) throws IOException {
            if (!this.isPermissionLoaded()) {
                this.loadPermissionInfo();
            }
            super.write(out);
        }
    }

    class LocalFSFileOutputStream
    extends OutputStream {
        FileOutputStream fos;

        public LocalFSFileOutputStream(Path f) throws IOException {
            this.fos = new FileOutputStream(RawLocalFileSystem.this.pathToFile(f));
        }

        public void close() throws IOException {
            this.fos.close();
        }

        public void flush() throws IOException {
            this.fos.flush();
        }

        public void write(byte[] b, int off, int len) throws IOException {
            try {
                this.fos.write(b, off, len);
            }
            catch (IOException e) {
                throw new FSError(e);
            }
        }

        public void write(int b) throws IOException {
            try {
                this.fos.write(b);
            }
            catch (IOException e) {
                throw new FSError(e);
            }
        }
    }

    class LocalFSFileInputStream
    extends FSInputStream {
        FileInputStream fis;
        private long position;

        public LocalFSFileInputStream(Path f) throws IOException {
            this.fis = new TrackingFileInputStream(RawLocalFileSystem.this.pathToFile(f));
        }

        public void seek(long pos) throws IOException {
            this.fis.getChannel().position(pos);
            this.position = pos;
        }

        public long getPos() throws IOException {
            return this.position;
        }

        public boolean seekToNewSource(long targetPos) throws IOException {
            return false;
        }

        public int available() throws IOException {
            return this.fis.available();
        }

        public void close() throws IOException {
            this.fis.close();
        }

        public boolean markSupport() {
            return false;
        }

        public int read() throws IOException {
            try {
                int value = this.fis.read();
                if (value >= 0) {
                    ++this.position;
                }
                return value;
            }
            catch (IOException e) {
                throw new FSError(e);
            }
        }

        public int read(byte[] b, int off, int len) throws IOException {
            try {
                int value = this.fis.read(b, off, len);
                if (value > 0) {
                    this.position += (long)value;
                }
                return value;
            }
            catch (IOException e) {
                throw new FSError(e);
            }
        }

        public int read(long position, byte[] b, int off, int len) throws IOException {
            ByteBuffer bb = ByteBuffer.wrap(b, off, len);
            try {
                return this.fis.getChannel().read(bb, position);
            }
            catch (IOException e) {
                throw new FSError(e);
            }
        }

        public long skip(long n) throws IOException {
            long value = this.fis.skip(n);
            if (value > 0L) {
                this.position += value;
            }
            return value;
        }
    }

    class TrackingFileInputStream
    extends FileInputStream {
        public TrackingFileInputStream(File f) throws IOException {
            super(f);
        }

        public int read() throws IOException {
            int result = super.read();
            if (result != -1) {
                RawLocalFileSystem.this.statistics.incrementBytesRead(1L);
            }
            return result;
        }

        public int read(byte[] data) throws IOException {
            int result = super.read(data);
            if (result != -1) {
                RawLocalFileSystem.this.statistics.incrementBytesRead(result);
            }
            return result;
        }

        public int read(byte[] data, int offset, int length) throws IOException {
            int result = super.read(data, offset, length);
            if (result != -1) {
                RawLocalFileSystem.this.statistics.incrementBytesRead(result);
            }
            return result;
        }
    }
}

