/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.serializer;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WritableSerialization
extends Configured
implements Serialization<Writable> {
    @Override
    public boolean accept(Class<?> c) {
        return Writable.class.isAssignableFrom(c);
    }

    @Override
    public Deserializer<Writable> getDeserializer(Class<Writable> c) {
        return new WritableDeserializer(this.getConf(), c);
    }

    @Override
    public Serializer<Writable> getSerializer(Class<Writable> c) {
        return new WritableSerializer();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WritableSerializer
    implements Serializer<Writable> {
        private DataOutputStream dataOut;

        WritableSerializer() {
        }

        @Override
        public void open(OutputStream out) {
            this.dataOut = out instanceof DataOutputStream ? (DataOutputStream)out : new DataOutputStream(out);
        }

        @Override
        public void serialize(Writable w) throws IOException {
            w.write(this.dataOut);
        }

        @Override
        public void close() throws IOException {
            this.dataOut.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WritableDeserializer
    extends Configured
    implements Deserializer<Writable> {
        private Class<?> writableClass;
        private DataInputStream dataIn;

        public WritableDeserializer(Configuration conf, Class<?> c) {
            this.setConf(conf);
            this.writableClass = c;
        }

        @Override
        public void open(InputStream in) {
            this.dataIn = in instanceof DataInputStream ? (DataInputStream)in : new DataInputStream(in);
        }

        @Override
        public Writable deserialize(Writable w) throws IOException {
            Writable writable = w == null ? (Writable)ReflectionUtils.newInstance(this.writableClass, this.getConf()) : w;
            writable.readFields(this.dataIn);
            return writable;
        }

        @Override
        public void close() throws IOException {
            this.dataIn.close();
        }
    }
}

