/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.IOException;
import java.lang.reflect.Constructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteException
extends IOException {
    private String className;

    public RemoteException(String className, String msg) {
        super(msg);
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public IOException unwrapRemoteException(Class<?> ... lookupTypes) {
        if (lookupTypes == null) {
            return this;
        }
        for (Class<?> lookupClass : lookupTypes) {
            if (!lookupClass.getName().equals(this.getClassName())) continue;
            try {
                return this.instantiateException(lookupClass.asSubclass(IOException.class));
            }
            catch (Exception e) {
                return this;
            }
        }
        return this;
    }

    public IOException unwrapRemoteException() {
        try {
            Class<?> realClass = Class.forName(this.getClassName());
            return this.instantiateException(realClass.asSubclass(IOException.class));
        }
        catch (Exception exception) {
            return this;
        }
    }

    private IOException instantiateException(Class<? extends IOException> cls) throws Exception {
        Constructor<? extends IOException> cn = cls.getConstructor(String.class);
        cn.setAccessible(true);
        IOException ex = cn.newInstance(this.getMessage());
        ex.initCause(this);
        return ex;
    }
}

