/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Counters
implements Writable,
Iterable<Group> {
    private static final Log LOG = LogFactory.getLog(Counters.class);
    private Map<String, Group> counters = new HashMap<String, Group>();
    private Map<Enum, Counter> cache = new IdentityHashMap<Enum, Counter>();

    public synchronized Collection<String> getGroupNames() {
        return this.counters.keySet();
    }

    @Override
    public synchronized Iterator<Group> iterator() {
        return this.counters.values().iterator();
    }

    public synchronized Group getGroup(String groupName) {
        Group result = this.counters.get(groupName);
        if (result == null) {
            result = new Group(groupName);
            this.counters.put(groupName, result);
        }
        return result;
    }

    public synchronized Counter findCounter(Enum key) {
        Counter counter = this.cache.get(key);
        if (counter == null) {
            Group group = this.getGroup(key.getDeclaringClass().getName());
            counter = group.getCounter(key.ordinal(), key.toString());
            this.cache.put(key, counter);
        }
        return counter;
    }

    public synchronized Counter findCounter(String group, int id, String name) {
        return this.getGroup(group).getCounter(id, name);
    }

    public synchronized void incrCounter(Enum key, long amount) {
        this.findCounter(key).value += amount;
    }

    public synchronized long getCounter(Enum key) {
        return this.findCounter(key).value;
    }

    public synchronized void incrAllCounters(Counters other) {
        for (Group otherGroup : other) {
            Group group = this.getGroup(otherGroup.getName());
            for (int i = 0; i < otherGroup.subcounters.size(); ++i) {
                Counter otherCounter = (Counter)otherGroup.subcounters.get(i);
                if (otherCounter == null) continue;
                group.getCounter(i, otherCounter.displayName).value += otherCounter.value;
            }
        }
    }

    public static Counters sum(Counters a, Counters b) {
        Counters counters = new Counters();
        counters.incrAllCounters(a);
        counters.incrAllCounters(b);
        return counters;
    }

    public synchronized int size() {
        int result = 0;
        for (Group group : this) {
            result += group.size();
        }
        return result;
    }

    @Override
    public synchronized void write(DataOutput out) throws IOException {
        out.writeInt(this.counters.size());
        for (Group group : this.counters.values()) {
            Text.writeString(out, group.getName());
            group.write(out);
        }
    }

    @Override
    public synchronized void readFields(DataInput in) throws IOException {
        int numClasses = in.readInt();
        this.counters.clear();
        while (numClasses-- > 0) {
            String groupName = Text.readString(in);
            Group group = new Group(groupName);
            group.readFields(in);
            this.counters.put(groupName, group);
        }
    }

    public void log(Log log) {
        log.info((Object)("Counters: " + this.size()));
        for (Group group : this) {
            log.info((Object)("  " + group.getDisplayName()));
            for (Counter counter : group) {
                log.info((Object)("    " + counter.getDisplayName() + "=" + counter.getCounter()));
            }
        }
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder("Counters: " + this.size());
        for (Group group : this) {
            sb.append("\n\t" + group.getDisplayName());
            for (Counter counter : group) {
                sb.append("\n\t\t" + counter.getDisplayName() + "=" + counter.getCounter());
            }
        }
        return sb.toString();
    }

    public synchronized String makeCompactString() {
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        for (Group group : this) {
            for (Counter counter : group) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(',');
                }
                buffer.append(group.getDisplayName());
                buffer.append('.');
                buffer.append(counter.getDisplayName());
                buffer.append(':');
                buffer.append(counter.getCounter());
            }
        }
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Group
    implements Writable,
    Iterable<Counter> {
        private String groupName;
        private String displayName;
        private ArrayList<Counter> subcounters = new ArrayList();
        private ResourceBundle bundle = null;

        Group(String groupName) {
            try {
                this.bundle = Group.getResourceBundle(groupName);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            this.groupName = groupName;
            this.displayName = this.localize("CounterGroupName", groupName);
            LOG.debug((Object)("Creating group " + groupName + " with " + (this.bundle == null ? "nothing" : "bundle")));
        }

        private static ResourceBundle getResourceBundle(String enumClassName) {
            String bundleName = enumClassName.replace('$', '_');
            return ResourceBundle.getBundle(bundleName);
        }

        public String getName() {
            return this.groupName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public synchronized long getCounter(String counterName) {
            for (Counter counter : this.subcounters) {
                if (counter == null || !counter.displayName.equals(counterName)) continue;
                return counter.value;
            }
            return 0L;
        }

        public synchronized Counter getCounter(int id, String name) {
            Counter result = null;
            int size = this.subcounters.size();
            if (id < size) {
                result = this.subcounters.get(id);
            }
            if (result == null) {
                LOG.debug((Object)("Adding " + name + " at " + id));
                result = new Counter(this.localize(name + ".name", name), 0L);
                this.subcounters.ensureCapacity(id + 1);
                for (int i = size; i <= id; ++i) {
                    this.subcounters.add(null);
                }
                this.subcounters.set(id, result);
            }
            return result;
        }

        public synchronized int size() {
            int num = 0;
            for (Counter counter : this.subcounters) {
                if (counter == null) continue;
                ++num;
            }
            return num;
        }

        private String localize(String key, String defaultValue) {
            String result = defaultValue;
            if (this.bundle != null) {
                try {
                    result = this.bundle.getString(key);
                }
                catch (MissingResourceException mre) {
                    // empty catch block
                }
            }
            return result;
        }

        @Override
        public synchronized void write(DataOutput out) throws IOException {
            Text.writeString(out, this.displayName);
            WritableUtils.writeVInt(out, this.subcounters.size());
            for (Counter counter : this.subcounters) {
                if (counter == null) {
                    out.writeBoolean(false);
                    continue;
                }
                out.writeBoolean(true);
                counter.write(out);
            }
        }

        @Override
        public synchronized void readFields(DataInput in) throws IOException {
            this.displayName = Text.readString(in);
            this.subcounters.clear();
            int size = WritableUtils.readVInt(in);
            this.subcounters.ensureCapacity(size);
            for (int i = 0; i < size; ++i) {
                Counter counter = null;
                if (in.readBoolean()) {
                    counter = new Counter();
                    counter.readFields(in);
                }
                this.subcounters.add(counter);
            }
        }

        @Override
        public Iterator<Counter> iterator() {
            return new CounterIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class CounterIterator
        implements Iterator<Counter> {
            private int current = -1;

            CounterIterator() {
                this.getNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void getNext() {
                Group group = Group.this;
                synchronized (group) {
                    int len = Group.this.subcounters.size();
                    while (++this.current < len) {
                        if (Group.this.subcounters.get(this.current) == null) continue;
                        return;
                    }
                }
                this.current = Integer.MAX_VALUE;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                Group group = Group.this;
                synchronized (group) {
                    return this.current < Group.this.subcounters.size();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Counter next() {
                Group group = Group.this;
                synchronized (group) {
                    int result = this.current;
                    this.getNext();
                    return (Counter)Group.this.subcounters.get(result);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("NonNullIterator doesn't support remove");
            }
        }
    }

    public static class Counter
    implements Writable {
        private String displayName;
        private long value;

        Counter() {
            this.value = 0L;
        }

        Counter(String displayName, long value) {
            this.displayName = displayName;
            this.value = value;
        }

        public synchronized void readFields(DataInput in) throws IOException {
            this.displayName = Text.readString(in);
            this.value = WritableUtils.readVLong(in);
        }

        public synchronized void write(DataOutput out) throws IOException {
            Text.writeString(out, this.displayName);
            WritableUtils.writeVLong(out, this.value);
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public synchronized long getCounter() {
            return this.value;
        }

        public synchronized void increment(long incr) {
            this.value += incr;
        }
    }
}

