/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URL;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

public class JobProfile
implements Writable {
    String user;
    String jobid;
    String jobFile;
    String url;
    String name;

    public JobProfile() {
    }

    public JobProfile(String user, String jobid, String jobFile, String url, String name) {
        this.user = user;
        this.jobid = jobid;
        this.jobFile = jobFile;
        this.url = url;
        this.name = name;
    }

    public String getUser() {
        return this.user;
    }

    public String getJobId() {
        return this.jobid;
    }

    public String getJobFile() {
        return this.jobFile;
    }

    public URL getURL() {
        try {
            return new URL(this.url);
        }
        catch (IOException ie) {
            return null;
        }
    }

    public String getJobName() {
        return this.name;
    }

    public void write(DataOutput out) throws IOException {
        UTF8.writeString(out, this.jobid);
        UTF8.writeString(out, this.jobFile);
        UTF8.writeString(out, this.url);
        UTF8.writeString(out, this.user);
        UTF8.writeString(out, this.name);
    }

    public void readFields(DataInput in) throws IOException {
        this.jobid = UTF8.readString(in);
        this.jobFile = UTF8.readString(in);
        this.url = UTF8.readString(in);
        this.user = UTF8.readString(in);
        this.name = UTF8.readString(in);
    }

    static {
        WritableFactories.setFactory(JobProfile.class, new WritableFactory(){

            public Writable newInstance() {
                return new JobProfile();
            }
        });
    }
}

