/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiFileSplit
implements InputSplit {
    private Path[] paths;
    private long[] lengths;
    private long totLength;
    private JobConf job;

    MultiFileSplit() {
    }

    public MultiFileSplit(JobConf job, Path[] files, long[] lengths) {
        this.job = job;
        this.lengths = lengths;
        this.paths = files;
        this.totLength = 0L;
        for (long length : lengths) {
            this.totLength += length;
        }
    }

    @Override
    public long getLength() {
        return this.totLength;
    }

    public long[] getLengths() {
        return this.lengths;
    }

    public long getLength(int i) {
        return this.lengths[i];
    }

    public int getNumPaths() {
        return this.paths.length;
    }

    public Path getPath(int i) {
        return this.paths[i];
    }

    public Path[] getPaths() {
        return this.paths;
    }

    @Override
    public String[] getLocations() throws IOException {
        HashSet<String> hostSet = new HashSet<String>();
        for (Path file : this.paths) {
            BlockLocation[] blkLocations = FileSystem.get(this.job).getFileBlockLocations(file, 0L, FileSystem.get(this.job).getFileStatus(file).getLen());
            if (blkLocations == null || blkLocations.length <= 0) continue;
            this.addToSet(hostSet, blkLocations[0].getHosts());
        }
        return hostSet.toArray(new String[hostSet.size()]);
    }

    private void addToSet(Set<String> set, String[] array) {
        for (String s : array) {
            set.add(s);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.totLength = in.readLong();
        int arrLength = in.readInt();
        this.lengths = new long[arrLength];
        for (int i = 0; i < arrLength; ++i) {
            this.lengths[i] = in.readLong();
        }
        int filesLength = in.readInt();
        this.paths = new Path[filesLength];
        for (int i = 0; i < filesLength; ++i) {
            this.paths[i] = new Path(Text.readString(in));
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.totLength);
        out.writeInt(this.lengths.length);
        for (long length : this.lengths) {
            out.writeLong(length);
        }
        out.writeInt(this.paths.length);
        for (Path p : this.paths) {
            Text.writeString(out, p.toString());
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.paths.length; ++i) {
            sb.append(this.paths[i].toUri().getPath() + ":0+" + this.lengths[i]);
            if (i >= this.paths.length - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }
}

