/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.log.LogLevel;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.hadoop.util.ReflectionUtils;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.SocketListener;
import org.mortbay.http.SslListener;
import org.mortbay.http.handler.ResourceHandler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.WebApplicationContext;
import org.mortbay.util.MultiException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusHttpServer {
    private Server webServer = new Server();
    private SocketListener listener;
    private SslListener sslListener;
    private boolean findPort;
    private WebApplicationContext webAppContext;
    private static final Log LOG = LogFactory.getLog((String)StatusHttpServer.class.getName());

    public StatusHttpServer(String name, String bindAddress, int port, boolean findPort) throws IOException {
        this.findPort = findPort;
        this.listener = new SocketListener();
        this.listener.setPort(port);
        this.listener.setHost(bindAddress);
        this.webServer.addListener((HttpListener)this.listener);
        String logDir = System.getProperty("hadoop.log.dir");
        if (logDir != null) {
            HttpContext logContext = new HttpContext();
            logContext.setContextPath("/logs/*");
            logContext.setResourceBase(logDir);
            logContext.addHandler((HttpHandler)new ResourceHandler());
            this.webServer.addContext(logContext);
        }
        String appDir = StatusHttpServer.getWebAppsPath();
        HttpContext staticContext = new HttpContext();
        staticContext.setContextPath("/static/*");
        staticContext.setResourceBase(appDir + "/static");
        staticContext.addHandler((HttpHandler)new ResourceHandler());
        this.webServer.addContext(staticContext);
        this.webAppContext = this.webServer.addWebApplication("/", appDir + "/" + name);
        this.addServlet("stacks", "/stacks", StackServlet.class);
        this.addServlet("reducegraph", "/taskgraph", TaskGraphServlet.class);
        this.addServlet("logLevel", "/logLevel", LogLevel.Servlet.class);
    }

    public void setAttribute(String name, Object value) {
        this.webAppContext.setAttribute(name, value);
    }

    public <T extends HttpServlet> void addServlet(String name, String pathSpec, Class<T> servletClass) {
        WebApplicationContext context = this.webAppContext;
        try {
            if (name == null) {
                context.addServlet(pathSpec, servletClass.getName());
            } else {
                context.addServlet(name, pathSpec, servletClass.getName());
            }
        }
        catch (ClassNotFoundException ex) {
            throw StatusHttpServer.makeRuntimeException("Problem instantiating class", ex);
        }
        catch (InstantiationException ex) {
            throw StatusHttpServer.makeRuntimeException("Problem instantiating class", ex);
        }
        catch (IllegalAccessException ex) {
            throw StatusHttpServer.makeRuntimeException("Problem instantiating class", ex);
        }
    }

    private static RuntimeException makeRuntimeException(String msg, Throwable cause) {
        RuntimeException result = new RuntimeException(msg);
        if (cause != null) {
            result.initCause(cause);
        }
        return result;
    }

    public Object getAttribute(String name) {
        return this.webAppContext.getAttribute(name);
    }

    private static String getWebAppsPath() throws IOException {
        URL url = StatusHttpServer.class.getClassLoader().getResource("webapps");
        if (url == null) {
            throw new IOException("webapps not found in CLASSPATH");
        }
        return url.toString();
    }

    public int getPort() {
        return this.listener.getPort();
    }

    public void setThreads(int min, int max) {
        this.listener.setMinThreads(min);
        this.listener.setMaxThreads(max);
    }

    public void addSslListener(InetSocketAddress addr, String keystore, String storPass, String keyPass) throws IOException {
        if (this.sslListener != null || this.webServer.isStarted()) {
            throw new IOException("Failed to add ssl listener");
        }
        this.sslListener = new SslListener();
        this.sslListener.setHost(addr.getHostName());
        this.sslListener.setPort(addr.getPort());
        this.sslListener.setKeystore(keystore);
        this.sslListener.setPassword(storPass);
        this.sslListener.setKeyPassword(keyPass);
        this.webServer.addListener((HttpListener)this.sslListener);
    }

    public void start() throws IOException {
        try {
            while (true) {
                try {
                    this.webServer.start();
                }
                catch (MultiException ex) {
                    Exception sub;
                    boolean needNewPort = false;
                    if (ex.size() == 1 && (sub = ex.getException(0)) instanceof BindException) {
                        if (!this.findPort) {
                            throw sub;
                        }
                        needNewPort = true;
                    }
                    if (!needNewPort) {
                        throw ex;
                    }
                    this.listener.setPort(this.listener.getPort() + 1);
                    continue;
                }
                break;
            }
        }
        catch (IOException ie) {
            throw ie;
        }
        catch (Exception e) {
            IOException ie = new IOException("Problem starting http server");
            ie.initCause(e);
            throw ie;
        }
    }

    public void stop() throws InterruptedException {
        this.webServer.stop();
    }

    public static class TaskGraphServlet
    extends HttpServlet {
        private static final long serialVersionUID = -1365683739392460020L;
        public static final int width = 600;
        public static final int height = 200;
        public static final int ymargin = 20;
        public static final int xmargin = 80;
        private static final float oneThird = 0.33333334f;

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            int i;
            response.setContentType("image/svg+xml");
            JobTracker tracker = (JobTracker)this.getServletContext().getAttribute("job.tracker");
            String jobId = request.getParameter("jobid");
            if (jobId == null) {
                return;
            }
            String typeStr = request.getParameter("type");
            boolean isMap = false;
            if ("map".equalsIgnoreCase(typeStr)) {
                isMap = true;
            }
            PrintWriter out = response.getWriter();
            TaskReport[] reports = null;
            reports = isMap ? tracker.getMapTaskReports(jobId) : tracker.getReduceTaskReports(jobId);
            int numTasks = reports.length;
            if (numTasks <= 0) {
                return;
            }
            int tasksPerBar = (int)Math.ceil((double)numTasks / 600.0);
            int numBars = (int)Math.ceil((double)numTasks / (double)tasksPerBar);
            int w = Math.max(600, numBars);
            int barWidth = Math.min(10, w / numBars);
            int barsPerNotch = (int)Math.ceil(10.0 / (double)barWidth);
            int totalWidth = (w += numBars / barsPerNotch) + 160;
            out.print("<?xml version=\"1.0\" standalone=\"no\"?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \n\"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n<?xml-stylesheet type=\"text/css\" href=\"/static/hadoop.css\"?>\n\n<svg width=\"");
            out.print(totalWidth);
            out.print("\" height=\"");
            out.print(240);
            out.print("\" version=\"1.1\"\nxmlns=\"http://www.w3.org/2000/svg\">\n\n");
            this.printLine(out, 79, 79, 221, 19, "black");
            this.printLine(out, 79, w + 80 + 1, 221, 221, "black");
            this.printLine(out, w + 80 + 1, w + 80 + 1, 221, 19, "#CCCCCC");
            this.printLine(out, 79, w + 80 + 1, 19, 19, "#CCCCCC");
            String[] colors = new String[]{"#00DD00", "#E50000", "#AAAAFF"};
            int xNotchInterval = (int)Math.ceil((double)numTasks / 10.0);
            int xOffset = -1;
            int xNotchCount = 0;
            if (reports != null) {
                i = 0;
                int barCnt = 0;
                while (true) {
                    if (barCnt % barsPerNotch == 0) {
                        ++xOffset;
                    }
                    int x = barCnt * barWidth + 80 + xOffset;
                    if (i >= xNotchInterval * xNotchCount) {
                        this.printLine(out, x, x, 223, 218, "black");
                        this.printText(out, x, 235, String.valueOf(xNotchInterval * xNotchCount++), "middle");
                    }
                    if (i >= reports.length) break;
                    if (isMap) {
                        float progress = this.getMapAvarageProgress(tasksPerBar, i, reports);
                        int barHeight = (int)Math.ceil(200.0f * progress);
                        int y = 200 - barHeight + 20;
                        this.printRect(out, barWidth, barHeight, x, y, colors[2]);
                    } else {
                        float[] progresses = this.getReduceAvarageProgresses(tasksPerBar, i, reports);
                        int prevHeight = 0;
                        for (int j = 0; j < 3; ++j) {
                            int barHeight = (int)(66.0f * progresses[j]);
                            if (barHeight > 63) {
                                barHeight = 67;
                            }
                            int y = 200 - barHeight + 20 - prevHeight;
                            prevHeight += barHeight;
                            this.printRect(out, barWidth, barHeight, x, y, colors[j]);
                        }
                    }
                    i += tasksPerBar;
                    ++barCnt;
                }
            }
            for (i = 0; i <= 10; ++i) {
                this.printLine(out, 77, 82, 20 + i * 200 / 10, 20 + i * 200 / 10, "black");
                this.printText(out, 70, 24 + i * 200 / 10, String.valueOf(100 - i * 10), "end");
            }
            if (!isMap) {
                this.printRect(out, 14, 14, 80 + w + 4, 40, colors[0]);
                this.printText(out, 80 + w + 24, 50, "copy", "start");
                this.printRect(out, 14, 14, 80 + w + 4, 70, colors[1]);
                this.printText(out, 80 + w + 24, 80, "sort", "start");
                this.printRect(out, 14, 14, 80 + w + 4, 100, colors[2]);
                this.printText(out, 80 + w + 24, 110, "reduce", "start");
            }
            out.print("</svg>");
        }

        private float getMapAvarageProgress(int tasksPerBar, int index, TaskReport[] reports) {
            int k;
            float progress = 0.0f;
            for (k = 0; k < tasksPerBar && index + k < reports.length; ++k) {
                progress += reports[index + k].getProgress();
            }
            return progress /= (float)k;
        }

        private float[] getReduceAvarageProgresses(int tasksPerBar, int index, TaskReport[] reports) {
            int k;
            float[] progresses = new float[]{0.0f, 0.0f, 0.0f};
            for (k = 0; k < tasksPerBar && index + k < reports.length; ++k) {
                int j = 0;
                for (float progress = reports[index + k].getProgress(); progress > 0.0f; progress -= 0.33333334f) {
                    if (progress > 0.33333334f) {
                        int n = j;
                        progresses[n] = progresses[n] + 1.0f;
                    } else {
                        int n = j;
                        progresses[n] = progresses[n] + progress * 3.0f;
                    }
                    ++j;
                }
            }
            int j = 0;
            while (j < 3) {
                int n = j++;
                progresses[n] = progresses[n] / (float)k;
            }
            return progresses;
        }

        private void printRect(PrintWriter out, int width, int height, int x, int y, String color) throws IOException {
            if (height > 0) {
                out.print("<rect width=\"");
                out.print(width);
                out.print("\" height=\"");
                out.print(height);
                out.print("\" x=\"");
                out.print(x);
                out.print("\" y=\"");
                out.print(y);
                out.print("\" style=\"fill:");
                out.print(color);
                out.print("\"/>\n");
            }
        }

        private void printLine(PrintWriter out, int x1, int x2, int y1, int y2, String color) throws IOException {
            out.print("<line x1=\"");
            out.print(x1);
            out.print("\" x2=\"");
            out.print(x2);
            out.print("\" y1=\"");
            out.print(y1);
            out.print("\" y2=\"");
            out.print(y2);
            out.print("\" class=\"taskgraphline\" style=\"stroke:");
            out.print(color);
            out.print("\"/>\n");
        }

        private void printText(PrintWriter out, int x, int y, String text, String anchor) throws IOException {
            out.print("<text x=\"");
            out.print(String.valueOf(x));
            out.print("\" y=\"");
            out.print(String.valueOf(y));
            out.print("\" style=\"fill:black;font-family:sans-serif;text-anchor:");
            out.print(anchor);
            out.print("\">");
            out.print(text);
            out.print("</text>\n");
        }
    }

    public static class StackServlet
    extends HttpServlet {
        private static final long serialVersionUID = -6284183679759467039L;

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            ServletOutputStream outStream = response.getOutputStream();
            ReflectionUtils.printThreadInfo(new PrintWriter((OutputStream)outStream), "");
            outStream.close();
            ReflectionUtils.logThreadInfo(LOG, "jsp requested", 1L);
        }
    }
}

