/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FSError;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapOutputFile;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class TaskRunner
extends Thread {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.mapred.TaskRunner");
    volatile boolean killed = false;
    private Shell.ShellCommandExecutor shexec;
    private Task t;
    private TaskTracker tracker;
    protected JobConf conf;
    protected MapOutputFile mapOutputFile;

    public TaskRunner(Task t, TaskTracker tracker, JobConf conf) {
        this.t = t;
        this.tracker = tracker;
        this.conf = conf;
        this.mapOutputFile = new MapOutputFile(t.getJobId());
        this.mapOutputFile.setConf(conf);
    }

    public Task getTask() {
        return this.t;
    }

    public TaskTracker getTracker() {
        return this.tracker;
    }

    public boolean prepare() throws IOException {
        return true;
    }

    public void close() throws IOException {
    }

    private String stringifyPathArray(Path[] p) {
        if (p == null) {
            return null;
        }
        StringBuffer str = new StringBuffer(p[0].toString());
        for (int i = 1; i < p.length; ++i) {
            str.append(",");
            str.append(p[i].toString());
        }
        return str.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void run() {
        block73: {
            block68: {
                block72: {
                    block67: {
                        try {
                            try {
                                taskid = this.t.getTaskId();
                                lDirAlloc = new LocalDirAllocator("mapred.local.dir");
                                jobCacheDir = null;
                                if (this.conf.getJar() != null) {
                                    jobCacheDir = new File(new Path(this.conf.getJar()).getParent().toString());
                                }
                                workDir = new File(lDirAlloc.getLocalPathToRead(TaskTracker.getJobCacheSubdir() + "/" + this.t.getJobId() + "/" + this.t.getTaskId() + "/" + "work", this.conf).toString());
                                archives = DistributedCache.getCacheArchives(this.conf);
                                files = DistributedCache.getCacheFiles(this.conf);
                                if (archives != null || files != null) {
                                    if (archives != null) {
                                        archivesTimestamps = DistributedCache.getArchiveTimestamps(this.conf);
                                        p = new Path[archives.length];
                                        for (i = 0; i < archives.length; ++i) {
                                            fileSystem = FileSystem.get(archives[i], this.conf);
                                            fileStatus = fileSystem.getFileStatus(new Path(archives[i].getPath()));
                                            cacheId = DistributedCache.makeRelative(archives[i], this.conf);
                                            cachePath = TaskTracker.getCacheSubdir() + "/" + cacheId;
                                            localPath = lDirAlloc.ifExists(cachePath, this.conf) != false ? lDirAlloc.getLocalPathToRead(cachePath, this.conf) : lDirAlloc.getLocalPathForWrite(cachePath, fileStatus.getLen(), this.conf);
                                            baseDir = localPath.toString().replace(cacheId, "");
                                            p[i] = DistributedCache.getLocalCache(archives[i], this.conf, new Path(baseDir), fileStatus, true, Long.parseLong(archivesTimestamps[i]), new Path(workDir.getAbsolutePath()));
                                        }
                                        DistributedCache.setLocalArchives(this.conf, this.stringifyPathArray(p));
                                    }
                                    if (files != null) {
                                        fileTimestamps = DistributedCache.getFileTimestamps(this.conf);
                                        p = new Path[files.length];
                                        for (i = 0; i < files.length; ++i) {
                                            fileSystem = FileSystem.get(files[i], this.conf);
                                            fileStatus = fileSystem.getFileStatus(new Path(files[i].getPath()));
                                            cacheId = DistributedCache.makeRelative(files[i], this.conf);
                                            cachePath = TaskTracker.getCacheSubdir() + "/" + cacheId;
                                            localPath = lDirAlloc.ifExists(cachePath, this.conf) != false ? lDirAlloc.getLocalPathToRead(cachePath, this.conf) : lDirAlloc.getLocalPathForWrite(cachePath, fileStatus.getLen(), this.conf);
                                            baseDir = localPath.toString().replace(cacheId, "");
                                            p[i] = DistributedCache.getLocalCache(files[i], this.conf, new Path(baseDir), fileStatus, false, Long.parseLong(fileTimestamps[i]), new Path(workDir.getAbsolutePath()));
                                        }
                                        DistributedCache.setLocalFiles(this.conf, this.stringifyPathArray(p));
                                    }
                                    localTaskFile = new Path(this.t.getJobFile());
                                    localFs = FileSystem.getLocal(this.conf);
                                    localFs.delete(localTaskFile, true);
                                    out = localFs.create(localTaskFile);
                                    try {
                                        this.conf.write(out);
                                    }
                                    finally {
                                        out.close();
                                    }
                                }
                                try {
                                    DistributedCache.createAllSymlink(this.conf, jobCacheDir, workDir);
                                }
                                catch (IOException ie) {
                                    TaskRunner.LOG.warn((Object)StringUtils.stringifyException(ie));
                                }
                                if (!this.prepare()) {
                                    var35_30 = null;
                                    break block67;
                                }
                                sep = System.getProperty("path.separator");
                                classPath = new StringBuffer();
                                classPath.append(System.getProperty("java.class.path"));
                                classPath.append(sep);
                                if (!workDir.mkdirs() && !workDir.isDirectory()) {
                                    TaskRunner.LOG.fatal((Object)("Mkdirs failed to create " + workDir.toString()));
                                }
                                if ((jar = this.conf.getJar()) != null) {
                                    libs = new File(jobCacheDir, "lib").listFiles();
                                    if (libs != null) {
                                        for (i = 0; i < libs.length; ++i) {
                                            classPath.append(sep);
                                            classPath.append(libs[i]);
                                        }
                                    }
                                    classPath.append(sep);
                                    classPath.append(new File(jobCacheDir, "classes"));
                                    classPath.append(sep);
                                    classPath.append(jobCacheDir);
                                }
                                if ((archiveClasspaths = DistributedCache.getArchiveClassPaths(this.conf)) != null && archives != null && (localArchives = DistributedCache.getLocalCacheArchives(this.conf)) != null) {
                                    for (i = 0; i < archives.length; ++i) {
                                        for (j = 0; j < archiveClasspaths.length; ++j) {
                                            if (!archives[i].getPath().equals(archiveClasspaths[j].toString())) continue;
                                            classPath.append(sep);
                                            classPath.append(localArchives[i].toString());
                                        }
                                    }
                                }
                                if ((fileClasspaths = DistributedCache.getFileClassPaths(this.conf)) != null && files != null && (localFiles = DistributedCache.getLocalCacheFiles(this.conf)) != null) {
                                    for (i = 0; i < files.length; ++i) {
                                        for (j = 0; j < fileClasspaths.length; ++j) {
                                            if (!files[i].getPath().equals(fileClasspaths[j].toString())) continue;
                                            classPath.append(sep);
                                            classPath.append(localFiles[i].toString());
                                        }
                                    }
                                }
                                classPath.append(sep);
                                classPath.append(workDir);
                                vargs = new Vector<String>(8);
                                jvm = new File(new File(System.getProperty("java.home"), "bin"), "java");
                                vargs.add(jvm.toString());
                                javaOpts = this.conf.get("mapred.child.java.opts", "-Xmx200m");
                                javaOpts = TaskRunner.replaceAll(javaOpts, "@taskid@", taskid);
                                javaOptsSplit = javaOpts.split(" ");
                                libraryPath = System.getProperty("java.library.path");
                                libraryPath = libraryPath == null ? workDir.getAbsolutePath() : libraryPath + sep + workDir;
                                hasUserLDPath = false;
                                for (i = 0; i < javaOptsSplit.length; ++i) {
                                    if (!javaOptsSplit[i].startsWith("-Djava.library.path=")) continue;
                                    v0 = i;
                                    javaOptsSplit[v0] = javaOptsSplit[v0] + sep + libraryPath;
                                    hasUserLDPath = true;
                                    break;
                                }
                                if (!hasUserLDPath) {
                                    vargs.add("-Djava.library.path=" + libraryPath);
                                }
                                for (i = 0; i < javaOptsSplit.length; ++i) {
                                    vargs.add(javaOptsSplit[i]);
                                }
                                tmp = this.conf.get("mapred.child.tmp", "./tmp");
                                tmpDir = new Path(tmp);
                                if (!tmpDir.isAbsolute()) {
                                    tmpDir = new Path(workDir.toString(), tmp);
                                }
                                if (!(localFs = FileSystem.getLocal(this.conf)).mkdirs(tmpDir) && !localFs.getFileStatus(tmpDir).isDir()) {
                                    throw new IOException("Mkdirs failed to create " + tmpDir.toString());
                                }
                                vargs.add("-Djava.io.tmpdir=" + tmpDir.toString());
                                vargs.add("-classpath");
                                vargs.add(classPath.toString());
                                logSize = TaskLog.getTaskLogLength(this.conf);
                                vargs.add("-Dhadoop.log.dir=" + new File(System.getProperty("hadoop.log.dir")).getAbsolutePath());
                                vargs.add("-Dhadoop.root.logger=INFO,TLA");
                                vargs.add("-Dhadoop.tasklog.taskid=" + taskid);
                                vargs.add("-Dhadoop.tasklog.totalLogFileSize=" + logSize);
                                if (this.conf.getProfileEnabled() && this.conf.getProfileTaskRange(this.t.isMapTask()).isIncluded(this.t.getPartition())) {
                                    prof = TaskLog.getTaskLogFile(taskid, TaskLog.LogName.PROFILE);
                                    vargs.add(String.format(this.conf.getProfileParams(), new Object[]{prof.toString()}));
                                }
                                vargs.add(TaskTracker.Child.class.getName());
                                address = this.tracker.getTaskTrackerReportAddress();
                                vargs.add(address.getAddress().getHostAddress());
                                vargs.add(Integer.toString(address.getPort()));
                                vargs.add(taskid);
                                ulimitCmd = Shell.getUlimitMemoryCommand(this.conf);
                                setup = null;
                                if (ulimitCmd != null) {
                                    setup = new ArrayList<String>();
                                    for (String arg : ulimitCmd) {
                                        setup.add(arg);
                                    }
                                }
                                stdout = TaskLog.getTaskLogFile(taskid, TaskLog.LogName.STDOUT);
                                stderr = TaskLog.getTaskLogFile(taskid, TaskLog.LogName.STDERR);
                                stdout.getParentFile().mkdirs();
                                wrappedCommand = TaskLog.captureOutAndError(setup, vargs, stdout, stderr, logSize);
                                this.runChild(wrappedCommand, workDir, taskid);
                                break block68;
                            }
                            catch (FSError e) {
                                TaskRunner.LOG.fatal((Object)"FSError", (Throwable)e);
                                try {
                                    this.tracker.fsError(this.t.getTaskId(), e.getMessage());
                                }
                                catch (IOException ie) {
                                    TaskRunner.LOG.fatal((Object)(this.t.getTaskId() + " reporting FSError"), (Throwable)ie);
                                }
                                var35_32 = null;
                                try {
                                    archives = DistributedCache.getCacheArchives(this.conf);
                                    files = DistributedCache.getCacheFiles(this.conf);
                                    if (archives != null) {
                                        for (i = 0; i < archives.length; ++i) {
                                            DistributedCache.releaseCache(archives[i], this.conf);
                                        }
                                    }
                                    if (files != null) {
                                        for (i = 0; i < files.length; ++i) {
                                            DistributedCache.releaseCache(files[i], this.conf);
                                        }
                                    }
                                }
                                catch (IOException ie) {
                                    TaskRunner.LOG.warn((Object)"Error releasing caches : Cache files might not have been cleaned up");
                                }
                                this.tracker.reportTaskFinished(this.t.getTaskId());
                                return;
                            }
                            catch (Throwable throwable) {
                                block70: {
                                    TaskRunner.LOG.warn((Object)(this.t.getTaskId() + " Child Error"), throwable);
                                    baos = new ByteArrayOutputStream();
                                    throwable.printStackTrace(new PrintStream(baos));
                                    try {
                                        this.tracker.reportDiagnosticInfo(this.t.getTaskId(), baos.toString());
                                    }
                                    catch (IOException e) {
                                        TaskRunner.LOG.warn((Object)(this.t.getTaskId() + " Reporting Diagnostics"), (Throwable)e);
                                    }
                                    var35_33 = null;
                                    ** try [egrp 6[TRYBLOCK] [14 : 2154->2243)] { 
lbl218:
                                    // 1 sources

                                    archives = DistributedCache.getCacheArchives(this.conf);
                                    files = DistributedCache.getCacheFiles(this.conf);
                                    if (archives != null) {
                                        for (i = 0; i < archives.length; ++i) {
                                            DistributedCache.releaseCache(archives[i], this.conf);
                                        }
                                    }
                                    if (files != null) {
                                        for (i = 0; i < files.length; ++i) {
                                            DistributedCache.releaseCache(files[i], this.conf);
                                        }
                                    }
                                    break block70;
lbl229:
                                    // 1 sources

                                    catch (IOException ie) {
                                        TaskRunner.LOG.warn((Object)"Error releasing caches : Cache files might not have been cleaned up");
                                    }
                                }
                                this.tracker.reportTaskFinished(this.t.getTaskId());
                                return;
                            }
                        }
                        catch (Throwable var34_76) {
                            block71: {
                                var35_34 = null;
                                ** try [egrp 6[TRYBLOCK] [14 : 2154->2243)] { 
lbl238:
                                // 1 sources

                                archives = DistributedCache.getCacheArchives(this.conf);
                                files = DistributedCache.getCacheFiles(this.conf);
                                if (archives != null) {
                                    for (i = 0; i < archives.length; ++i) {
                                        DistributedCache.releaseCache(archives[i], this.conf);
                                    }
                                }
                                if (files != null) {
                                    for (i = 0; i < files.length; ++i) {
                                        DistributedCache.releaseCache(files[i], this.conf);
                                    }
                                }
                                break block71;
lbl249:
                                // 1 sources

                                catch (IOException ie) {
                                    TaskRunner.LOG.warn((Object)"Error releasing caches : Cache files might not have been cleaned up");
                                }
                            }
                            this.tracker.reportTaskFinished(this.t.getTaskId());
                            throw var34_76;
                        }
                    }
                    ** try [egrp 6[TRYBLOCK] [14 : 2154->2243)] { 
lbl256:
                    // 1 sources

                    archives = DistributedCache.getCacheArchives(this.conf);
                    files = DistributedCache.getCacheFiles(this.conf);
                    if (archives != null) {
                        for (i = 0; i < archives.length; ++i) {
                            DistributedCache.releaseCache(archives[i], this.conf);
                        }
                    }
                    if (files != null) {
                        for (i = 0; i < files.length; ++i) {
                            DistributedCache.releaseCache(files[i], this.conf);
                        }
                    }
                    break block72;
lbl267:
                    // 1 sources

                    catch (IOException ie) {
                        TaskRunner.LOG.warn((Object)"Error releasing caches : Cache files might not have been cleaned up");
                    }
                }
                this.tracker.reportTaskFinished(this.t.getTaskId());
                return;
            }
            var35_31 = null;
            ** try [egrp 6[TRYBLOCK] [14 : 2154->2243)] { 
lbl275:
            // 1 sources

            archives = DistributedCache.getCacheArchives(this.conf);
            files = DistributedCache.getCacheFiles(this.conf);
            if (archives != null) {
                for (i = 0; i < archives.length; ++i) {
                    DistributedCache.releaseCache(archives[i], this.conf);
                }
            }
            if (files != null) {
                for (i = 0; i < files.length; ++i) {
                    DistributedCache.releaseCache(files[i], this.conf);
                }
            }
            break block73;
lbl286:
            // 1 sources

            catch (IOException ie) {
                TaskRunner.LOG.warn((Object)"Error releasing caches : Cache files might not have been cleaned up");
            }
        }
        this.tracker.reportTaskFinished(this.t.getTaskId());
    }

    private static String replaceAll(String text, String toFind, String replacement) {
        if (text == null || toFind == null || replacement == null) {
            throw new IllegalArgumentException("Text " + text + " or toFind " + toFind + " or replacement " + replacement + " are null.");
        }
        int offset = 0;
        int index = text.indexOf(toFind);
        while (index >= 0) {
            offset = index + toFind.length();
            text = text.substring(0, index) + replacement + text.substring(offset);
            index = text.indexOf(toFind, offset);
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runChild(List<String> args, File dir, String taskid) throws IOException {
        try {
            this.shexec = new Shell.ShellCommandExecutor(args.toArray(new String[0]), dir);
            this.shexec.execute();
        }
        catch (IOException ioe) {
            int exit_code = this.shexec.getExitCode();
            if (!this.killed && exit_code != 0) {
                if (exit_code == 65) {
                    this.tracker.getTaskTrackerMetrics().taskFailedPing();
                }
                throw new IOException("Task process exit with nonzero status of " + exit_code + ".");
            }
        }
        finally {
            int exit_code = this.shexec.getExitCode();
            if (!this.killed && exit_code != 0) {
                if (exit_code == 65) {
                    this.tracker.getTaskTrackerMetrics().taskFailedPing();
                }
                throw new IOException("Task process exit with nonzero status of " + exit_code + ".");
            }
        }
    }

    public void kill() {
        Process process;
        if (this.shexec != null && (process = this.shexec.getProcess()) != null) {
            process.destroy();
        }
        this.killed = true;
    }
}

