/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.pipes;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.Partitioner;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.lib.HashPartitioner;
import org.apache.hadoop.mapred.lib.NullOutputFormat;
import org.apache.hadoop.mapred.pipes.PipesMapRunner;
import org.apache.hadoop.mapred.pipes.PipesPartitioner;
import org.apache.hadoop.mapred.pipes.PipesReducer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Submitter {
    public static String getExecutable(JobConf conf) {
        return conf.get("hadoop.pipes.executable");
    }

    public static void setExecutable(JobConf conf, String executable) {
        conf.set("hadoop.pipes.executable", executable);
    }

    public static void setIsJavaRecordReader(JobConf conf, boolean value) {
        conf.setBoolean("hadoop.pipes.java.recordreader", value);
    }

    public static boolean getIsJavaRecordReader(JobConf conf) {
        return conf.getBoolean("hadoop.pipes.java.recordreader", false);
    }

    public static void setIsJavaMapper(JobConf conf, boolean value) {
        conf.setBoolean("hadoop.pipes.java.mapper", value);
    }

    public static boolean getIsJavaMapper(JobConf conf) {
        return conf.getBoolean("hadoop.pipes.java.mapper", false);
    }

    public static void setIsJavaReducer(JobConf conf, boolean value) {
        conf.setBoolean("hadoop.pipes.java.reducer", value);
    }

    public static boolean getIsJavaReducer(JobConf conf) {
        return conf.getBoolean("hadoop.pipes.java.reducer", false);
    }

    public static void setIsJavaRecordWriter(JobConf conf, boolean value) {
        conf.setBoolean("hadoop.pipes.java.recordwriter", value);
    }

    public static boolean getIsJavaRecordWriter(JobConf conf) {
        return conf.getBoolean("hadoop.pipes.java.recordwriter", false);
    }

    private static void setIfUnset(JobConf conf, String key, String value) {
        if (conf.get(key) == null) {
            conf.set(key, value);
        }
    }

    static void setJavaPartitioner(JobConf conf, Class cls) {
        conf.set("hadoop.pipes.partitioner", cls.getName());
    }

    static Class getJavaPartitioner(JobConf conf) {
        return conf.getClass("hadoop.pipes.partitioner", HashPartitioner.class, Partitioner.class);
    }

    public static boolean getKeepCommandFile(JobConf conf) {
        return conf.getBoolean("hadoop.pipes.command-file.keep", false);
    }

    public static void setKeepCommandFile(JobConf conf, boolean keep) {
        conf.setBoolean("hadoop.pipes.command-file.keep", keep);
    }

    public static RunningJob submitJob(JobConf conf) throws IOException {
        URI[] fileCache;
        if (!Submitter.getIsJavaMapper(conf)) {
            conf.setMapRunnerClass(PipesMapRunner.class);
            Submitter.setJavaPartitioner(conf, conf.getPartitionerClass());
            conf.setPartitionerClass(PipesPartitioner.class);
        }
        if (!Submitter.getIsJavaReducer(conf)) {
            conf.setReducerClass(PipesReducer.class);
            if (!Submitter.getIsJavaRecordWriter(conf)) {
                conf.setOutputFormat(NullOutputFormat.class);
            }
        }
        String textClassname = Text.class.getName();
        Submitter.setIfUnset(conf, "mapred.output.key.class", textClassname);
        Submitter.setIfUnset(conf, "mapred.output.value.class", textClassname);
        Submitter.setIfUnset(conf, "mapred.output.key.class", textClassname);
        Submitter.setIfUnset(conf, "mapred.output.value.class", textClassname);
        String exec = Submitter.getExecutable(conf);
        if (exec == null) {
            throw new IllegalArgumentException("No application program defined.");
        }
        if (exec.contains("#")) {
            DistributedCache.createSymlink(conf);
            String defScript = "$HADOOP_HOME/src/c++/pipes/debug/pipes-default-script";
            Submitter.setIfUnset(conf, "mapred.map.task.debug.script", defScript);
            Submitter.setIfUnset(conf, "mapred.reduce.task.debug.script", defScript);
        }
        if ((fileCache = DistributedCache.getCacheFiles(conf)) == null) {
            fileCache = new URI[1];
        } else {
            URI[] tmp = new URI[fileCache.length + 1];
            System.arraycopy(fileCache, 0, tmp, 1, fileCache.length);
            fileCache = tmp;
        }
        try {
            fileCache[0] = new URI(exec);
        }
        catch (URISyntaxException e) {
            IOException ie = new IOException("Problem parsing execable URI " + exec);
            ie.initCause(e);
            throw ie;
        }
        DistributedCache.setCacheFiles(fileCache, conf);
        return JobClient.runJob(conf);
    }

    private static <InterfaceType> Class<? extends InterfaceType> getClass(CommandLine cl, String key, JobConf conf, Class<InterfaceType> cls) throws ClassNotFoundException {
        return conf.getClassByName((String)cl.getValue(key)).asSubclass(cls);
    }

    public static void main(String[] args) throws Exception {
        CommandLineParser cli = new CommandLineParser();
        if (args.length == 0) {
            cli.printUsage();
            return;
        }
        cli.addOption("input", false, "input path to the maps", "path");
        cli.addOption("output", false, "output path from the reduces", "path");
        cli.addOption("conf", false, "job xml configuration file", "path");
        cli.addOption("jar", false, "job jar file", "path");
        cli.addOption("inputformat", false, "java classname of InputFormat", "class");
        cli.addOption("map", false, "java classname of Mapper", "class");
        cli.addOption("partitioner", false, "java classname of Partitioner", "class");
        cli.addOption("reduce", false, "java classname of Reducer", "class");
        cli.addOption("writer", false, "java classname of OutputFormat", "class");
        cli.addOption("program", false, "URI to application executable", "class");
        cli.addOption("reduces", false, "number of reduces", "num");
        cli.addOption("jobconf", false, "\"n1=v1,n2=v2,..\" Optional. Add or override a JobConf property.", "key=val");
        Parser parser = cli.createParser();
        try {
            String jarFile;
            CommandLine results = parser.parse(args);
            JobConf conf = new JobConf();
            if (results.hasOption("-conf")) {
                conf.addResource(new Path((String)results.getValue("-conf")));
            }
            if (results.hasOption("-input")) {
                FileInputFormat.setInputPaths(conf, (String)results.getValue("-input"));
            }
            if (results.hasOption("-output")) {
                FileOutputFormat.setOutputPath(conf, new Path((String)results.getValue("-output")));
            }
            if (results.hasOption("-jar")) {
                conf.setJar((String)results.getValue("-jar"));
            }
            if (results.hasOption("-inputformat")) {
                Submitter.setIsJavaRecordReader(conf, true);
                conf.setInputFormat(Submitter.getClass(results, "-inputformat", conf, InputFormat.class));
            }
            if (results.hasOption("-javareader")) {
                Submitter.setIsJavaRecordReader(conf, true);
            }
            if (results.hasOption("-map")) {
                Submitter.setIsJavaMapper(conf, true);
                conf.setMapperClass(Submitter.getClass(results, "-map", conf, Mapper.class));
            }
            if (results.hasOption("-partitioner")) {
                conf.setPartitionerClass(Submitter.getClass(results, "-partitioner", conf, Partitioner.class));
            }
            if (results.hasOption("-reduce")) {
                Submitter.setIsJavaReducer(conf, true);
                conf.setReducerClass(Submitter.getClass(results, "-reduce", conf, Reducer.class));
            }
            if (results.hasOption("-reduces")) {
                conf.setNumReduceTasks(Integer.parseInt((String)results.getValue("-reduces")));
            }
            if (results.hasOption("-writer")) {
                Submitter.setIsJavaRecordWriter(conf, true);
                conf.setOutputFormat(Submitter.getClass(results, "-writer", conf, OutputFormat.class));
            }
            if (results.hasOption("-program")) {
                Submitter.setExecutable(conf, (String)results.getValue("-program"));
            }
            if (results.hasOption("-jobconf")) {
                String options = (String)results.getValue("-jobconf");
                StringTokenizer tokenizer = new StringTokenizer(options, ",");
                while (tokenizer.hasMoreTokens()) {
                    String keyVal = tokenizer.nextToken().trim();
                    String[] keyValSplit = keyVal.split("=");
                    conf.set(keyValSplit[0], keyValSplit[1]);
                }
            }
            if ((jarFile = conf.getJar()) != null) {
                URLClassLoader loader = new URLClassLoader(new URL[]{FileSystem.getLocal(conf).pathToFile(new Path(jarFile)).toURL()});
                conf.setClassLoader(loader);
            }
            Submitter.submitJob(conf);
        }
        catch (OptionException oe) {
            cli.printUsage();
        }
    }

    static class CommandLineParser {
        private DefaultOptionBuilder option = new DefaultOptionBuilder("-", "-", false);
        private ArgumentBuilder arg = new ArgumentBuilder();
        private GroupBuilder optionList = new GroupBuilder();

        CommandLineParser() {
        }

        void addOption(String longName, boolean required, String description, String paramName) {
            this.arg.withName(paramName).withMinimum(1).withMaximum(1);
            this.optionList.withOption((Option)this.option.withLongName(longName).withArgument(this.arg.create()).withDescription(description).withRequired(required).create());
        }

        void addArgument(String name, boolean required, String description) {
            this.arg.withName(name).withMinimum(1).withMaximum(1);
            this.optionList.withOption((Option)this.arg.create());
        }

        Parser createParser() {
            Parser result = new Parser();
            result.setGroup(this.optionList.create());
            return result;
        }

        void printUsage() {
            System.out.println("bin/hadoop pipes");
            System.out.println("  [-conf <path>]  // Configuration for job");
            System.out.println("  [-jobconf <key=value>, <key=value>, ...]  // add/override configuration for job. (Multiple comma delimited key=value pairs can be passed)");
            System.out.println("  [-input <path>] // Input directory");
            System.out.println("  [-output <path>] // Output directory");
            System.out.println("  [-jar <jar file> // jar filename");
            System.out.println("  [-inputformat <class>] // InputFormat class");
            System.out.println("  [-map <class>] // Java Map class");
            System.out.println("  [-partitioner <class>] // Java Partitioner");
            System.out.println("  [-reduce <class>] // Java Reduce class");
            System.out.println("  [-writer <class>] // Java RecordWriter");
            System.out.println("  [-program <executable>] // executable URI");
            System.out.println("  [-reduces <num>] // number of reduces");
        }
    }
}

