/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import org.apache.hadoop.net.SocketIOWithTimeout;

public class SocketInputStream
extends InputStream
implements ReadableByteChannel {
    private Reader reader;

    public SocketInputStream(ReadableByteChannel channel, long timeout) throws IOException {
        SocketIOWithTimeout.checkChannelValidity(channel);
        this.reader = new Reader(channel, timeout);
    }

    public SocketInputStream(Socket socket, long timeout) throws IOException {
        this(socket.getChannel(), timeout);
    }

    public SocketInputStream(Socket socket) throws IOException {
        this(socket.getChannel(), (long)socket.getSoTimeout());
    }

    public int read() throws IOException {
        byte[] buf = new byte[1];
        if (this.read(buf, 0, 1) > 0) {
            return buf[0];
        }
        throw new IOException("Could not read from stream");
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.read(ByteBuffer.wrap(b, off, len));
    }

    public synchronized void close() throws IOException {
        this.reader.channel.close();
        this.reader.close();
    }

    public ReadableByteChannel getChannel() {
        return this.reader.channel;
    }

    public boolean isOpen() {
        return this.reader.isOpen();
    }

    public int read(ByteBuffer dst) throws IOException {
        return this.reader.doIO(dst, 1);
    }

    private static class Reader
    extends SocketIOWithTimeout {
        ReadableByteChannel channel;

        Reader(ReadableByteChannel channel, long timeout) throws IOException {
            super((SelectableChannel)((Object)channel), timeout);
            this.channel = channel;
        }

        int performIO(ByteBuffer buf) throws IOException {
            return this.channel.read(buf);
        }
    }
}

