/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.record;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.record.Buffer;
import org.apache.hadoop.record.Index;
import org.apache.hadoop.record.RecordInput;
import org.apache.hadoop.record.Utils;

public class BinaryRecordInput
implements RecordInput {
    private DataInput in;
    private static ThreadLocal bIn = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new BinaryRecordInput();
        }
    };

    private BinaryRecordInput() {
    }

    private void setDataInput(DataInput inp) {
        this.in = inp;
    }

    public static BinaryRecordInput get(DataInput inp) {
        BinaryRecordInput bin = (BinaryRecordInput)bIn.get();
        bin.setDataInput(inp);
        return bin;
    }

    public BinaryRecordInput(InputStream strm) {
        this.in = new DataInputStream(strm);
    }

    public BinaryRecordInput(DataInput din) {
        this.in = din;
    }

    public byte readByte(String tag) throws IOException {
        return this.in.readByte();
    }

    public boolean readBool(String tag) throws IOException {
        return this.in.readBoolean();
    }

    public int readInt(String tag) throws IOException {
        return Utils.readVInt(this.in);
    }

    public long readLong(String tag) throws IOException {
        return Utils.readVLong(this.in);
    }

    public float readFloat(String tag) throws IOException {
        return this.in.readFloat();
    }

    public double readDouble(String tag) throws IOException {
        return this.in.readDouble();
    }

    public String readString(String tag) throws IOException {
        return Utils.fromBinaryString(this.in);
    }

    public Buffer readBuffer(String tag) throws IOException {
        int len = Utils.readVInt(this.in);
        byte[] barr = new byte[len];
        this.in.readFully(barr);
        return new Buffer(barr);
    }

    public void startRecord(String tag) throws IOException {
    }

    public void endRecord(String tag) throws IOException {
    }

    public Index startVector(String tag) throws IOException {
        return new BinaryIndex(this.readInt(tag));
    }

    public void endVector(String tag) throws IOException {
    }

    public Index startMap(String tag) throws IOException {
        return new BinaryIndex(this.readInt(tag));
    }

    public void endMap(String tag) throws IOException {
    }

    private static class BinaryIndex
    implements Index {
        private int nelems;

        private BinaryIndex(int nelems) {
            this.nelems = nelems;
        }

        public boolean done() {
            return this.nelems <= 0;
        }

        public void incr() {
            --this.nelems;
        }
    }
}

