/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.security.UnixUserGroupInformation;

public abstract class UserGroupInformation
implements Writable {
    public static final Log LOG = LogFactory.getLog(UserGroupInformation.class);
    private static UserGroupInformation LOGIN_UGI = null;
    private static final ThreadLocal<UserGroupInformation> currentUGI = new ThreadLocal();

    public static UserGroupInformation getCurrentUGI() {
        return currentUGI.get();
    }

    public static void setCurrentUGI(UserGroupInformation ugi) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(Thread.currentThread().getName() + ", ugi=" + ugi));
        }
        currentUGI.set(ugi);
    }

    public abstract String getUserName();

    public abstract String[] getGroupNames();

    public static UserGroupInformation login(Configuration conf) throws LoginException {
        if (LOGIN_UGI == null) {
            LOGIN_UGI = UnixUserGroupInformation.login(conf);
        }
        return LOGIN_UGI;
    }

    public static UserGroupInformation readFrom(Configuration conf) throws IOException {
        try {
            return UnixUserGroupInformation.readFromConf(conf, "hadoop.job.ugi");
        }
        catch (LoginException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }
}

