/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.PrintStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class GenericOptionsParser {
    private static final Log LOG = LogFactory.getLog(GenericOptionsParser.class);
    private CommandLine commandLine;

    public GenericOptionsParser(Configuration conf, String[] args) {
        this(conf, new Options(), args);
    }

    public GenericOptionsParser(Configuration conf, Options options, String[] args) {
        this.parseGeneralOptions(options, conf, args);
    }

    public String[] getRemainingArgs() {
        return this.commandLine.getArgs();
    }

    public CommandLine getCommandLine() {
        return this.commandLine;
    }

    private Options buildGeneralOptions(Options opts) {
        OptionBuilder.withArgName((String)"local|namenode:port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"specify a namenode");
        Option fs = OptionBuilder.create((String)"fs");
        OptionBuilder.withArgName((String)"local|jobtracker:port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"specify a job tracker");
        Option jt = OptionBuilder.create((String)"jt");
        OptionBuilder.withArgName((String)"configuration file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"specify an application configuration file");
        Option oconf = OptionBuilder.create((String)"conf");
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgPattern((String)"=", (int)1);
        OptionBuilder.withDescription((String)"use value for given property");
        Option property = OptionBuilder.create((char)'D');
        opts.addOption(fs);
        opts.addOption(jt);
        opts.addOption(oconf);
        opts.addOption(property);
        return opts;
    }

    private void processGeneralOptions(Configuration conf, CommandLine line) {
        if (line.hasOption("fs")) {
            FileSystem.setDefaultUri(conf, line.getOptionValue("fs"));
        }
        if (line.hasOption("jt")) {
            conf.set("mapred.job.tracker", line.getOptionValue("jt"));
        }
        if (line.hasOption("conf")) {
            conf.addResource(new Path(line.getOptionValue("conf")));
        }
        if (line.hasOption('D')) {
            String[] property = line.getOptionValues('D');
            for (int i = 0; i < property.length - 1; i += 2) {
                if (property[i] == null) continue;
                conf.set(property[i], property[i + 1]);
            }
        }
    }

    private String[] parseGeneralOptions(Options opts, Configuration conf, String[] args) {
        opts = this.buildGeneralOptions(opts);
        GnuParser parser = new GnuParser();
        try {
            this.commandLine = parser.parse(opts, args, true);
            this.processGeneralOptions(conf, this.commandLine);
            return this.commandLine.getArgs();
        }
        catch (ParseException e) {
            LOG.warn((Object)("options parsing failed: " + e.getMessage()));
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("general options are: ", opts);
            return args;
        }
    }

    public static void printGenericCommandUsage(PrintStream out) {
        out.println("Generic options supported are");
        out.println("-conf <configuration file>     specify an application configuration file");
        out.println("-D <property=value>            use value for given property");
        out.println("-fs <local|namenode:port>      specify a namenod");
        out.println("-jt <local|jobtracker:port>    specify a job tracker\n");
        out.println("The general command line syntax is");
        out.println("bin/hadoop command [genericOptions] [commandOptions]\n");
    }
}

