/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSObject;
import org.pdfbox.cos.COSStream;
import org.pdfbox.exceptions.WrappedIOException;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.PDResources;
import org.pdfbox.pdmodel.font.PDFont;
import org.pdfbox.pdmodel.graphics.PDGraphicsState;
import org.pdfbox.util.Matrix;
import org.pdfbox.util.PDFOperator;
import org.pdfbox.util.TextPosition;
import org.pdfbox.util.operator.OperatorProcessor;

public class PDFStreamEngine {
    private static final byte[] SPACE_BYTES = new byte[]{32};
    private PDGraphicsState graphicsState = null;
    private Matrix textMatrix = null;
    private Matrix textLineMatrix = null;
    private Stack graphicsStack = new Stack();
    private Map operators = new HashMap();
    private Map fontToAverageWidths = new HashMap();
    private Stack streamResourcesStack = new Stack();
    private PDPage page;

    public PDFStreamEngine() {
    }

    public PDFStreamEngine(Properties properties) throws IOException {
        try {
            Iterator<Object> keys = properties.keySet().iterator();
            while (keys.hasNext()) {
                String operator = (String)keys.next();
                String operatorClass = properties.getProperty(operator);
                OperatorProcessor op = (OperatorProcessor)Class.forName(operatorClass).newInstance();
                op.setContext(this);
                this.operators.put(operator, op);
            }
        }
        catch (Exception e) {
            throw new WrappedIOException(e);
        }
    }

    public void processStream(PDPage aPage, PDResources resources, COSStream cosStream) throws IOException {
        this.graphicsState = new PDGraphicsState();
        this.textMatrix = null;
        this.textLineMatrix = null;
        this.graphicsStack.clear();
        this.streamResourcesStack.clear();
        this.fontToAverageWidths.clear();
        this.processSubStream(aPage, resources, cosStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processSubStream(PDPage aPage, PDResources resources, COSStream cosStream) throws IOException {
        this.page = aPage;
        if (resources != null) {
            StreamResources sr = new StreamResources();
            sr.fonts = resources.getFonts();
            sr.colorSpaces = resources.getColorSpaces();
            sr.xobjects = resources.getXObjects();
            sr.graphicsStates = resources.getGraphicsStates();
            sr.resources = resources;
            this.streamResourcesStack.push(sr);
        }
        try {
            ArrayList<COSBase> arguments = new ArrayList<COSBase>();
            long startTokens = System.currentTimeMillis();
            List tokens = cosStream.getStreamTokens();
            long stopTokens = System.currentTimeMillis();
            if (tokens != null) {
                Iterator iter = tokens.iterator();
                while (iter.hasNext()) {
                    Object next = iter.next();
                    if (next instanceof COSObject) {
                        arguments.add(((COSObject)next).getObject());
                        continue;
                    }
                    if (next instanceof PDFOperator) {
                        this.processOperator((PDFOperator)next, arguments);
                        arguments = new ArrayList();
                        continue;
                    }
                    arguments.add((COSBase)next);
                }
            }
        }
        finally {
            if (resources != null) {
                this.streamResourcesStack.pop();
            }
        }
    }

    protected void showCharacter(TextPosition text) {
    }

    public void showString(byte[] string) throws IOException {
        float spaceWidth = 0.0f;
        float spacing = 0.0f;
        StringBuffer stringResult = new StringBuffer(string.length);
        float characterDisplacement = 0.0f;
        float spaceDisplacement = 0.0f;
        float fontSize = this.graphicsState.getTextState().getFontSize();
        float horizontalScaling = this.graphicsState.getTextState().getHorizontalScalingPercent() / 100.0f;
        float rise = this.graphicsState.getTextState().getRise();
        float wordSpacing = this.graphicsState.getTextState().getWordSpacing();
        float characterSpacing = this.graphicsState.getTextState().getCharacterSpacing();
        float wordSpacingDisplacement = 0.0f;
        PDFont font = this.graphicsState.getTextState().getFont();
        float glyphSpaceToTextSpaceFactor = 1.0f / font.getFontMatrix().getValue(0, 0);
        Float averageWidth = (Float)this.fontToAverageWidths.get(font);
        if (averageWidth == null) {
            averageWidth = new Float(font.getAverageFontWidth());
            this.fontToAverageWidths.put(font, averageWidth);
        }
        Matrix initialMatrix = new Matrix();
        initialMatrix.setValue(0, 0, 1.0f);
        initialMatrix.setValue(0, 1, 0.0f);
        initialMatrix.setValue(0, 2, 0.0f);
        initialMatrix.setValue(1, 0, 0.0f);
        initialMatrix.setValue(1, 1, 1.0f);
        initialMatrix.setValue(1, 2, 0.0f);
        initialMatrix.setValue(2, 0, 0.0f);
        initialMatrix.setValue(2, 1, rise);
        initialMatrix.setValue(2, 2, 1.0f);
        int codeLength = 1;
        Matrix ctm = this.graphicsState.getCurrentTransformationMatrix();
        spaceDisplacement = font.getFontWidth(SPACE_BYTES, 0, 1) / glyphSpaceToTextSpaceFactor;
        if (spaceDisplacement == 0.0f) {
            spaceDisplacement = averageWidth.floatValue() / glyphSpaceToTextSpaceFactor;
            spaceDisplacement *= 0.8f;
        }
        int pageRotation = this.page.findRotation();
        Matrix trm = initialMatrix.multiply(this.textMatrix).multiply(ctm);
        float x = trm.getValue(2, 0);
        float y = trm.getValue(2, 1);
        if (pageRotation == 0) {
            trm.setValue(2, 1, -y + this.page.findMediaBox().getHeight());
        } else if (pageRotation == 90) {
            trm.setValue(2, 0, y);
            trm.setValue(2, 1, x);
        } else if (pageRotation == 270) {
            trm.setValue(2, 0, -y + this.page.findMediaBox().getHeight());
            trm.setValue(2, 1, x);
        }
        for (int i = 0; i < string.length; i += codeLength) {
            codeLength = 1;
            String c = font.encode(string, i, codeLength);
            if (c == null && i + 1 < string.length) {
                c = font.encode(string, i, ++codeLength);
            }
            stringResult.append(c);
            characterDisplacement += font.getFontWidth(string, i, codeLength) / glyphSpaceToTextSpaceFactor;
            boolean withCS = false;
            if (string[i] == 32 && c.equals(" ")) {
                spacing += wordSpacing + characterSpacing;
                withCS = true;
                continue;
            }
            spacing += characterSpacing;
        }
        float adjustment = 0.0f;
        float ty = 0.0f;
        float tx = ((characterDisplacement - adjustment / glyphSpaceToTextSpaceFactor) * fontSize + spacing) * horizontalScaling;
        float xScale = trm.getXScale();
        float yScale = trm.getYScale();
        float xPos = trm.getXPosition();
        float yPos = trm.getYPosition();
        spaceWidth = spaceDisplacement * xScale * fontSize;
        wordSpacingDisplacement = wordSpacing * xScale * fontSize;
        Matrix td = new Matrix();
        td.setValue(2, 0, tx);
        td.setValue(2, 1, ty);
        float xPosBefore = this.textMatrix.getXPosition();
        float yPosBefore = this.textMatrix.getYPosition();
        this.textMatrix = td.multiply(this.textMatrix);
        float totalStringDisplacement = 0.0f;
        if (pageRotation == 0) {
            totalStringDisplacement = this.textMatrix.getXPosition() - xPosBefore;
        } else if (pageRotation == 90) {
            totalStringDisplacement = this.textMatrix.getYPosition() - yPosBefore;
        } else if (pageRotation == 270) {
            totalStringDisplacement = yPosBefore - this.textMatrix.getYPosition();
        }
        this.showCharacter(new TextPosition(xPos, yPos, xScale, yScale, totalStringDisplacement, spaceWidth, stringResult.toString(), this.graphicsState.getTextState().getFont(), this.graphicsState.getTextState().getFontSize(), wordSpacingDisplacement));
    }

    public void processOperator(String operation, List arguments) throws IOException {
        PDFOperator oper = PDFOperator.getOperator(operation);
        this.processOperator(oper, arguments);
    }

    protected void processOperator(PDFOperator operator, List arguments) throws IOException {
        String operation = operator.getOperation();
        OperatorProcessor processor = (OperatorProcessor)this.operators.get(operation);
        if (processor != null) {
            processor.process(operator, arguments);
        }
    }

    public Map getColorSpaces() {
        return ((StreamResources)this.streamResourcesStack.peek()).colorSpaces;
    }

    public Map getXObjects() {
        return ((StreamResources)this.streamResourcesStack.peek()).xobjects;
    }

    public void setColorSpaces(Map value) {
        ((StreamResources)this.streamResourcesStack.peek()).colorSpaces = value;
    }

    public Map getFonts() {
        return ((StreamResources)this.streamResourcesStack.peek()).fonts;
    }

    public void setFonts(Map value) {
        ((StreamResources)this.streamResourcesStack.peek()).fonts = value;
    }

    public Stack getGraphicsStack() {
        return this.graphicsStack;
    }

    public void setGraphicsStack(Stack value) {
        this.graphicsStack = value;
    }

    public PDGraphicsState getGraphicsState() {
        return this.graphicsState;
    }

    public void setGraphicsState(PDGraphicsState value) {
        this.graphicsState = value;
    }

    public Map getGraphicsStates() {
        return ((StreamResources)this.streamResourcesStack.peek()).graphicsStates;
    }

    public void setGraphicsStates(Map value) {
        ((StreamResources)this.streamResourcesStack.peek()).graphicsStates = value;
    }

    public Matrix getTextLineMatrix() {
        return this.textLineMatrix;
    }

    public void setTextLineMatrix(Matrix value) {
        this.textLineMatrix = value;
    }

    public Matrix getTextMatrix() {
        return this.textMatrix;
    }

    public void setTextMatrix(Matrix value) {
        this.textMatrix = value;
    }

    public PDResources getResources() {
        return ((StreamResources)this.streamResourcesStack.peek()).resources;
    }

    public PDPage getCurrentPage() {
        return this.page;
    }

    private static class StreamResources {
        private Map fonts;
        private Map colorSpaces;
        private Map xobjects;
        private Map graphicsStates;
        private PDResources resources;

        private StreamResources() {
        }
    }
}

