/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.SocketChannel;
import java.util.zip.CRC32;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.BlockCrcInfo;
import org.apache.hadoop.dfs.DFSClient;
import org.apache.hadoop.dfs.DNBlockUpgradeInfo;
import org.apache.hadoop.dfs.DataChecksum;
import org.apache.hadoop.dfs.DatanodeID;
import org.apache.hadoop.dfs.DatanodeInfo;
import org.apache.hadoop.dfs.DatanodeProtocol;
import org.apache.hadoop.dfs.FSDataset;
import org.apache.hadoop.dfs.LocatedBlock;
import org.apache.hadoop.dfs.UpgradeCommand;
import org.apache.hadoop.dfs.UpgradeStatusReport;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.StringUtils;

class BlockCrcUpgradeUtils {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.dfs.BlockCrcUpgradeUtils");
    public static final int LONG_TIMEOUT_MINUTES = 5;
    public static final int LONG_TIMEOUT_MILLISEC = 300000;
    public static final int PRE_BLOCK_CRC_LAYOUT_VERSION = -6;
    static UpgradeCommand noUpgradeOnNamenode = new UpgradeCommand();
    static final int DN_CMD_STATS = 200;
    static final int DN_CMD_CRC_INFO = 201;
    static final int DN_CMD_CRC_INFO_REPLY = 202;
    static final int DN_CMD_VERSION = -6;

    BlockCrcUpgradeUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void readFromRemoteNode(LocatedBlock loc, String crcFile, long offset, long len, byte[] buf, int bufOffset) throws IOException {
        Block blk = loc.getBlock();
        String dnStr = "";
        for (DatanodeInfo dn : loc.getLocations()) {
            dnStr = dnStr + dn.getName() + " ";
            Socket dnSock = null;
            try {
                InetSocketAddress dnAddr = NetUtils.createSocketAddr(dn.getName());
                dnSock = SocketChannel.open().socket();
                dnSock.connect(dnAddr, 60000);
                dnSock.setSoTimeout(60000);
                DFSClient.BlockReader reader = DFSClient.BlockReader.newBlockReader(dnSock, crcFile, blk.getBlockId(), offset, len, (int)Math.min(len, 4096L));
                IOUtils.readFully(reader, buf, bufOffset, (int)len);
                return;
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Could not read " + blk + " from " + dn.getName() + " : " + StringUtils.stringifyException(ioe)));
            }
            finally {
                if (dnSock != null) {
                    dnSock.close();
                }
            }
        }
        throw new IOException("Could not fetch data for " + blk + " from datanodes " + dnStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void readDfsFileData(String filename, long fileOffset, int len, InetSocketAddress namenodeAddr, byte[] buf, int bufOffset) throws IOException {
        URI uri;
        Configuration conf = new Configuration();
        conf.set("fs.hdfs.impl", "org.apache.hadoop.dfs.ChecksumDistributedFileSystem");
        try {
            uri = new URI("hdfs://" + namenodeAddr.getHostName() + ":" + namenodeAddr.getPort());
        }
        catch (URISyntaxException e) {
            throw new IOException("Got URISyntaxException for " + filename);
        }
        FileSystem fs = FileSystem.get(uri, conf);
        FSDataInputStream in = null;
        try {
            in = fs.open(new Path(filename));
            if (fileOffset > 0L) {
                in.seek(fileOffset);
            }
            in.readFully(buf, bufOffset, len);
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(in);
            throw throwable;
        }
        IOUtils.closeStream(in);
    }

    static void readCrcFileData(DNBlockUpgradeInfo blockInfo) throws IOException {
        byte[] header = new byte[8];
        int bytesRead = 0;
        BlockCrcInfo crcInfo = blockInfo.crcInfo;
        for (int i = 0; i < crcInfo.crcBlocks.length && bytesRead < header.length; ++i) {
            LocatedBlock loc = crcInfo.crcBlocks[i];
            long toRead = Math.min(loc.getBlock().getNumBytes(), (long)(header.length - bytesRead));
            BlockCrcUpgradeUtils.readFromRemoteNode(loc, "." + crcInfo.fileName + ".crc", 0L, toRead, header, bytesRead);
            bytesRead = (int)((long)bytesRead + toRead);
        }
        if (bytesRead != header.length || header[0] != 99 || header[1] != 114 || header[2] != 99 || header[3] != 0) {
            throw new IOException("Could not read header from crc file");
        }
        int bytesPerChecksum = (header[4] & 0xFF) << 24 | (header[5] & 0xFF) << 16 | (header[6] & 0xFF) << 8 | header[7] & 0xFF;
        if (bytesPerChecksum < 1 || bytesPerChecksum > 0x6400000) {
            throw new IOException("Insane value for bytesPerChecksum (" + bytesPerChecksum + ")");
        }
        byte[] crcBuf = null;
        try {
            crcBuf = BlockCrcUpgradeUtils.readCrcBuf(blockInfo, bytesPerChecksum);
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Failed to fetch CRC data for " + blockInfo));
            throw ioe;
        }
        BlockCrcUpgradeUtils.writeCrcData(blockInfo, bytesPerChecksum, crcBuf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeCrcData(DNBlockUpgradeInfo blockInfo, int bytesPerChecksum, byte[] crcBuf) throws IOException {
        DataOutputStream out;
        File tmpBlockFile;
        block9: {
            Block block = blockInfo.block;
            FSDataset data = (FSDataset)blockInfo.dataNode.data;
            File blockFile = data.getBlockFile(block);
            File metaFile = FSDataset.getMetaFile(blockFile);
            if (bytesPerChecksum <= 0) {
                if (crcBuf == null) {
                    bytesPerChecksum = blockInfo.dataNode.defaultBytesPerChecksum;
                } else {
                    throw new IOException("Illegal Argument bytesPerChecksum(" + bytesPerChecksum);
                }
            }
            if (metaFile.exists()) {
                throw new IOException("metadata file exists but unexpected for " + blockInfo);
            }
            tmpBlockFile = null;
            File tmpMetaFile = null;
            out = null;
            try {
                tmpBlockFile = data.createTmpFile(null, block);
                tmpMetaFile = FSDataset.getMetaFile(tmpBlockFile);
                out = new DataOutputStream(new FileOutputStream(tmpMetaFile));
                out.writeShort(1);
                DataChecksum checksum = DataChecksum.newDataChecksum(crcBuf == null ? 0 : 1, bytesPerChecksum);
                checksum.writeHeader(out);
                if (crcBuf != null) {
                    out.write(crcBuf);
                }
                out.close();
                out = null;
                if (tmpMetaFile.renameTo(metaFile)) break block9;
                throw new IOException("Could not rename " + tmpMetaFile + " to " + metaFile);
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(out);
                if (tmpBlockFile != null) {
                    tmpBlockFile.delete();
                }
                throw throwable;
            }
        }
        IOUtils.closeStream(out);
        if (tmpBlockFile != null) {
            tmpBlockFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] regenerateCrcBuf(DNBlockUpgradeInfo blockInfo, byte[] oldCrcBuf, int bytesPerChecksum, byte[] bytesBefore, byte[] bytesAfter) throws IOException {
        byte[] byArray;
        DataChecksum verificationChecksum = DataChecksum.newDataChecksum(1, bytesPerChecksum);
        DataChecksum newChecksum = DataChecksum.newDataChecksum(1, bytesPerChecksum);
        BlockCrcInfo crcInfo = blockInfo.crcInfo;
        int checksumSize = newChecksum.getChecksumSize();
        int newCrcSize = (int)(crcInfo.blockLen / (long)bytesPerChecksum * (long)checksumSize);
        if (crcInfo.blockLen % (long)bytesPerChecksum > 0L) {
            newCrcSize += checksumSize;
        }
        byte[] newCrcBuf = new byte[newCrcSize];
        int newCrcOffset = 0;
        int oldCrcOffset = 0;
        Block block = blockInfo.block;
        FSDataset data = (FSDataset)blockInfo.dataNode.data;
        File blockFile = data.getBlockFile(block);
        byte[] blockBuf = new byte[bytesPerChecksum];
        FileInputStream in = null;
        try {
            boolean chunkTainted = false;
            boolean prevChunkTainted = false;
            long bytesRead = 0L;
            if (bytesBefore.length > 0) {
                verificationChecksum.update(bytesBefore, 0, bytesBefore.length);
            }
            int verifyLen = bytesPerChecksum - bytesBefore.length;
            long verifiedOffset = -bytesBefore.length;
            long writtenOffset = 0L;
            in = new FileInputStream(blockFile);
            while (bytesRead <= crcInfo.blockLen) {
                int toRead = (int)Math.min(crcInfo.blockLen - bytesRead, (long)bytesPerChecksum);
                if (toRead > 0) {
                    IOUtils.readFully(in, blockBuf, 0, toRead);
                }
                if (toRead == 0 && bytesAfter.length > 0 || toRead >= verifyLen) {
                    if (toRead > 0) {
                        verificationChecksum.update(blockBuf, 0, verifyLen);
                    }
                    prevChunkTainted = chunkTainted;
                    chunkTainted = !verificationChecksum.compare(oldCrcBuf, oldCrcOffset);
                    oldCrcOffset += checksumSize;
                    verifiedOffset += (long)bytesPerChecksum;
                    verificationChecksum.reset();
                }
                long diff = verifiedOffset - writtenOffset;
                if (toRead == 0 || diff > (long)bytesPerChecksum || bytesRead >= verifiedOffset) {
                    if (diff > (long)bytesPerChecksum && prevChunkTainted || diff < 2L * (long)bytesPerChecksum && chunkTainted) {
                        LOG.warn((Object)("Resetting checksum for " + blockInfo + " at offset " + writtenOffset));
                        newChecksum.reset();
                    }
                    newChecksum.writeValue(newCrcBuf, newCrcOffset, true);
                    newCrcOffset += checksumSize;
                    writtenOffset += Math.min(crcInfo.blockLen - writtenOffset, (long)bytesPerChecksum);
                }
                if (toRead == 0) break;
                if (toRead != verifyLen) {
                    int tmpOff = toRead > verifyLen ? verifyLen : 0;
                    verificationChecksum.update(blockBuf, tmpOff, toRead - tmpOff);
                }
                if ((bytesRead += (long)toRead) == crcInfo.blockLen && bytesAfter.length > 0) {
                    verificationChecksum.update(bytesAfter, 0, bytesAfter.length);
                }
                newChecksum.update(blockBuf, 0, toRead);
            }
            assert (newCrcBuf.length == newCrcOffset) : "something is wrong";
            byArray = newCrcBuf;
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(in);
            throw throwable;
        }
        IOUtils.closeStream(in);
        return byArray;
    }

    static byte[] findMajorityCrcBuf(DNBlockUpgradeInfo blockInfo, long crcStart, int crcSize) throws IOException {
        Block block = blockInfo.block;
        BlockCrcInfo crcInfo = blockInfo.crcInfo;
        int replication = crcInfo.crcReplication;
        class CrcBufInfo {
            byte[] buf;
            long crc32;
            int numMatches = 0;

            CrcBufInfo(byte[] b, long checksum) {
                this.buf = b;
                this.crc32 = checksum;
            }
        }
        CrcBufInfo[] bufInfoArr = new CrcBufInfo[replication];
        int numBufs = 0;
        CRC32 crc32 = new CRC32();
        boolean atleastOneNewReplica = true;
        block2: for (int i = 0; i < replication && atleastOneNewReplica; ++i) {
            int bytesRead = 0;
            byte[] buf = new byte[crcSize];
            long offset = 0L;
            atleastOneNewReplica = false;
            String crcFileName = "." + blockInfo.crcInfo.fileName + ".crc";
            for (LocatedBlock loc : crcInfo.crcBlocks) {
                DatanodeInfo dn;
                long blockStart = crcStart - offset + (long)bytesRead;
                long blockSize = loc.getBlock().getNumBytes();
                offset += blockSize;
                if (blockSize <= blockStart) continue;
                DatanodeInfo[] dnArr = loc.getLocations();
                if (dnArr.length > i) {
                    dn = dnArr[i];
                    atleastOneNewReplica = true;
                } else {
                    if ((bytesRead == 0 || !atleastOneNewReplica) && blockSize - blockStart >= (long)(crcSize - bytesRead)) continue block2;
                    dn = dnArr[dnArr.length - 1];
                }
                try {
                    DatanodeInfo[] tmpArr = new DatanodeInfo[]{dn};
                    long toRead = Math.min((long)(crcSize - bytesRead), blockSize - blockStart);
                    BlockCrcUpgradeUtils.readFromRemoteNode(new LocatedBlock(loc.getBlock(), tmpArr), crcFileName, blockStart, toRead, buf, bytesRead);
                    bytesRead = (int)((long)bytesRead + toRead);
                }
                catch (IOException ioe) {
                    LOG.warn((Object)("Error while fetching crc data from " + dn.getName() + "for " + blockInfo + StringUtils.stringifyException(ioe)));
                    continue block2;
                }
                if (bytesRead < crcSize) continue;
                crc32.reset();
                crc32.update(buf, 0, crcSize);
                long crc = crc32.getValue();
                for (int j = 0; j < numBufs + 1; ++j) {
                    if (j >= numBufs || crc == bufInfoArr[j].crc32) {
                        CrcBufInfo info = j < numBufs ? bufInfoArr[j] : new CrcBufInfo(buf, crc);
                        ++info.numMatches;
                        if (info.numMatches >= replication / 2 + replication % 2) {
                            LOG.info((Object)("At least " + info.numMatches + " of the " + replication + " replicated CRC files agree for " + blockInfo));
                            return buf;
                        }
                        if (j != numBufs) continue block2;
                        bufInfoArr[numBufs++] = info;
                        continue block2;
                    }
                    LOG.warn((Object)("Mismatch in crc for " + blockInfo));
                }
                continue block2;
            }
        }
        int replicasFetched = 0;
        CrcBufInfo selectedBuf = null;
        for (int i = 0; i < numBufs; ++i) {
            CrcBufInfo info = bufInfoArr[i];
            replicasFetched += info.numMatches;
            if (selectedBuf != null && selectedBuf.numMatches >= info.numMatches) continue;
            selectedBuf = info;
        }
        if (selectedBuf == null) {
            throw new IOException("Could not fetch any crc data for " + block);
        }
        LOG.info((Object)(selectedBuf.numMatches + " of the " + replicasFetched + " CRC replicas fetched agree for " + blockInfo));
        return selectedBuf.buf;
    }

    static byte[] readCrcBuf(DNBlockUpgradeInfo blockInfo, int bytesPerChecksum) throws IOException {
        BlockCrcInfo crcInfo = blockInfo.crcInfo;
        int checksumSize = 4;
        byte[] bytesBefore = new byte[(int)(crcInfo.startOffset % (long)bytesPerChecksum)];
        int tmpMod = (int)((crcInfo.blockLen + (long)bytesBefore.length) % (long)bytesPerChecksum);
        if (tmpMod != 0) {
            tmpMod = (int)Math.min((long)(bytesPerChecksum - tmpMod), crcInfo.fileSize - crcInfo.startOffset - crcInfo.blockLen);
        }
        byte[] bytesAfter = new byte[tmpMod];
        if (bytesBefore.length > 0 || bytesAfter.length > 0) {
            if (bytesBefore.length > 0) {
                BlockCrcUpgradeUtils.readDfsFileData(crcInfo.fileName, crcInfo.startOffset - (long)bytesBefore.length, bytesBefore.length, blockInfo.dataNode.getNameNodeAddr(), bytesBefore, 0);
            }
            if (bytesAfter.length > 0) {
                BlockCrcUpgradeUtils.readDfsFileData(crcInfo.fileName, crcInfo.startOffset + crcInfo.blockLen, bytesAfter.length, blockInfo.dataNode.getNameNodeAddr(), bytesAfter, 0);
            }
        }
        long crcStart = 8L + (crcInfo.startOffset - (long)bytesBefore.length) / (long)bytesPerChecksum * (long)checksumSize;
        long tmpLen = crcInfo.blockLen + (long)bytesBefore.length + (long)bytesAfter.length;
        int crcSize = (int)(tmpLen / (long)bytesPerChecksum * (long)checksumSize);
        if (tmpLen % (long)bytesPerChecksum > 0L) {
            crcSize += checksumSize;
        }
        byte[] crcBuf = BlockCrcUpgradeUtils.findMajorityCrcBuf(blockInfo, crcStart, crcSize);
        if (bytesBefore.length > 0 || bytesAfter.length > 0) {
            crcBuf = BlockCrcUpgradeUtils.regenerateCrcBuf(blockInfo, crcBuf, bytesPerChecksum, bytesBefore, bytesAfter);
        }
        return crcBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void generateLocalCrcData(DNBlockUpgradeInfo blockInfo) throws IOException {
        FSDataset data = (FSDataset)blockInfo.dataNode.data;
        Block block = blockInfo.block;
        File blockFile = data.getBlockFile(block);
        long blockLen = blockFile.length();
        if (blockLen != blockFile.length()) {
            LOG.warn((Object)("Mismatch in length for block: local file size is " + blockLen + " but should be " + blockInfo.crcInfo.blockLen + " for " + blockInfo + ". Using local file size for CRC"));
        }
        int bytesPerChecksum = blockInfo.dataNode.defaultBytesPerChecksum;
        DataChecksum checksum = DataChecksum.newDataChecksum(1, bytesPerChecksum);
        int checksumSize = checksum.getChecksumSize();
        int crcBufSize = (int)(blockLen / (long)bytesPerChecksum * (long)checksumSize);
        if (blockLen % (long)bytesPerChecksum != 0L) {
            crcBufSize += checksumSize;
        }
        byte[] crcBuf = new byte[crcBufSize];
        FileInputStream in = null;
        try {
            int toRead;
            in = new FileInputStream(blockFile);
            byte[] dataBuf = new byte[bytesPerChecksum];
            int crcBufPos = 0;
            for (long totalRead = 0L; totalRead < blockLen; totalRead += (long)toRead) {
                toRead = Math.min((int)(blockLen - totalRead), bytesPerChecksum);
                IOUtils.readFully(in, dataBuf, 0, toRead);
                checksum.update(dataBuf, 0, toRead);
                crcBufPos += checksum.writeValue(crcBuf, crcBufPos, true);
                checksum.reset();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(in);
            throw throwable;
        }
        IOUtils.closeStream(in);
        BlockCrcUpgradeUtils.writeCrcData(blockInfo, bytesPerChecksum, crcBuf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] readCrcFromReplica(DNBlockUpgradeInfo blockInfo, DatanodeInfo dnInfo, DataChecksum[] checksumArr) throws IOException {
        String errMsg;
        Socket dnSock;
        block7: {
            byte[] byArray;
            dnSock = null;
            errMsg = "";
            try {
                int headerLen;
                InetSocketAddress dnAddr = NetUtils.createSocketAddr(dnInfo.getName());
                dnSock = new Socket();
                dnSock.connect(dnAddr, 60000);
                dnSock.setSoTimeout(60000);
                DataOutputStream out = new DataOutputStream(dnSock.getOutputStream());
                DataInputStream in = new DataInputStream(dnSock.getInputStream());
                out.writeShort(9);
                out.writeByte(82);
                out.writeLong(blockInfo.block.getBlockId());
                byte reply = in.readByte();
                if (reply != 0) {
                    errMsg = "Got error(" + reply + ") in reply";
                    break block7;
                }
                int len = in.readInt();
                if (len < (headerLen = 7)) {
                    errMsg = "len is too short";
                    break block7;
                }
                if (len <= 0) break block7;
                short version = in.readShort();
                if (version != 1) {
                    errMsg = "Version mismatch";
                    break block7;
                }
                DataChecksum checksum = DataChecksum.newDataChecksum(in);
                if (checksum.getChecksumType() != 1) {
                    errMsg = "Checksum is not CRC32";
                    break block7;
                }
                int crcBufLen = (int)((blockInfo.crcInfo.blockLen + (long)checksum.getBytesPerChecksum() - 1L) / (long)checksum.getBytesPerChecksum() * (long)checksum.getChecksumSize());
                if (len - headerLen != crcBufLen) {
                    errMsg = "CRC data is too short";
                }
                byte[] crcBuf = new byte[crcBufLen];
                in.readFully(crcBuf);
                in.readInt();
                checksumArr[0] = checksum;
                byArray = crcBuf;
            }
            catch (Throwable throwable) {
                IOUtils.closeSocket(dnSock);
                throw throwable;
            }
            IOUtils.closeSocket(dnSock);
            return byArray;
        }
        IOUtils.closeSocket(dnSock);
        throw new IOException("Error while fetching CRC from replica on " + dnInfo.getName() + ": " + errMsg);
    }

    static void readCrcFromReplicas(DNBlockUpgradeInfo blockInfo) throws IOException {
        DatanodeInfo[] dnArr = blockInfo.crcInfo.blockLocationsIncluded ? blockInfo.crcInfo.blockLocations.getLocations() : new DatanodeInfo[]{};
        DataChecksum[] checksumArr = new DataChecksum[1];
        IOException ioe = null;
        String myName = blockInfo.dataNode.dnRegistration.getName();
        for (DatanodeInfo dnInfo : dnArr) {
            if (dnInfo.getName().equals(myName)) {
                LOG.info((Object)("skipping crcInfo fetch from " + dnInfo.getName()));
                continue;
            }
            try {
                byte[] crcBuf = BlockCrcUpgradeUtils.readCrcFromReplica(blockInfo, dnInfo, checksumArr);
                LOG.info((Object)("read crcBuf from " + dnInfo.getName() + " for " + blockInfo));
                BlockCrcUpgradeUtils.writeCrcData(blockInfo, checksumArr[0].getBytesPerChecksum(), crcBuf);
                return;
            }
            catch (IOException e) {
                LOG.warn((Object)("Could not fetch crc data from " + dnInfo.getName() + " : " + e));
                ioe = e;
            }
        }
        if (ioe != null) {
            throw ioe;
        }
        throw new IOException("Could not fetch crc data from any node");
    }

    static void upgradeBlock(DNBlockUpgradeInfo blockInfo) {
        UpgradeCommand ret = null;
        if (blockInfo.offlineUpgrade) {
            blockInfo.crcInfo = BlockCrcUpgradeUtils.getBlockLocations(blockInfo.namenode, blockInfo.block);
        } else {
            ret = BlockCrcUpgradeUtils.sendCommand(blockInfo.namenode, new CrcInfoCommand(blockInfo.block), -1);
        }
        try {
            if (!blockInfo.offlineUpgrade) {
                if (ret == noUpgradeOnNamenode) {
                    throw new IOException("No upgrade is running on Namenode");
                }
                if (ret == null || ((CrcInfoCommandReply)ret).crcInfo == null) {
                    throw new IOException("Could not get crcInfo from Namenode");
                }
                blockInfo.crcInfo = ((CrcInfoCommandReply)ret).crcInfo;
            }
            if (blockInfo.crcInfo == null) {
                throw new IOException("Could not fetch crcInfo for " + blockInfo.block);
            }
            switch (blockInfo.crcInfo.status) {
                case 0: {
                    try {
                        if (blockInfo.offlineUpgrade) {
                            BlockCrcUpgradeUtils.readCrcFromReplicas(blockInfo);
                            break;
                        }
                        BlockCrcUpgradeUtils.readCrcFileData(blockInfo);
                        break;
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("Exception in " + (blockInfo.offlineUpgrade ? "readCrcFromReplicas()" : "readCrcFileData()") + " for " + blockInfo + ". will try to generate local crc."));
                        throw e;
                    }
                }
                case 2: {
                    BlockCrcUpgradeUtils.generateLocalCrcData(blockInfo);
                    break;
                }
                case 3: {
                    LOG.info((Object)("block is already deleted. Will create an empty metadata file for " + blockInfo));
                    BlockCrcUpgradeUtils.writeCrcData(blockInfo, 0, null);
                    break;
                }
                case 1: {
                    BlockCrcUpgradeUtils.writeCrcData(blockInfo, 0, null);
                    break;
                }
                case 4: {
                    LOG.info((Object)("unknown error. will generate local crc data for " + blockInfo));
                    BlockCrcUpgradeUtils.generateLocalCrcData(blockInfo);
                    break;
                }
                default: {
                    LOG.error((Object)("Unknown status from Namenode for " + blockInfo));
                    assert (false) : "Unknown status from Namenode";
                    break;
                }
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Could not fetch crc for " + blockInfo + " will generate local crc data : exception :" + StringUtils.stringifyException(e)));
            try {
                BlockCrcUpgradeUtils.generateLocalCrcData(blockInfo);
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Could not generate local crc data for " + blockInfo + " : exception : " + StringUtils.stringifyException(ioe)));
            }
        }
    }

    static UpgradeCommand sendCommand(DatanodeProtocol namenode, UpgradeCommand cmd, int retries) {
        for (int i = 0; i <= retries || retries < 0; ++i) {
            try {
                UpgradeCommand reply = namenode.processUpgradeCommand(cmd);
                if (reply == null) {
                    return noUpgradeOnNamenode;
                }
                return reply;
            }
            catch (IOException e) {
                LOG.warn((Object)("Exception while sending command " + cmd.getAction() + ": " + e + (retries < 0 || i >= retries ? "... will retry ..." : ": " + StringUtils.stringifyException(e))));
                continue;
            }
        }
        return null;
    }

    static BlockCrcInfo getBlockLocations(DatanodeProtocol namenode, Block block) {
        while (true) {
            try {
                return namenode.blockCrcUpgradeGetBlockLocations(block);
            }
            catch (IOException e) {
                LOG.warn((Object)("Exception while fetching block Locations from namenode: " + e + " ... will retry ..."));
                continue;
            }
            break;
        }
    }

    static void sleep(int seconds, String message) {
        if (message != null) {
            LOG.info((Object)("XXX Sleeping for " + seconds + " seconds. msg: " + message));
        }
        try {
            Thread.sleep((long)seconds * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static class BlockCrcUpgradeStatusReport
    extends UpgradeStatusReport {
        String extraText = "";

        public BlockCrcUpgradeStatusReport() {
        }

        public BlockCrcUpgradeStatusReport(int version, short status, String extraText) {
            super(version, status, false);
            this.extraText = extraText;
        }

        public String getStatusText(boolean details) {
            return super.getStatusText(details) + "\n\n" + this.extraText;
        }

        public void readFields(DataInput in) throws IOException {
            super.readFields(in);
            this.extraText = Text.readString(in);
        }

        public void write(DataOutput out) throws IOException {
            super.write(out);
            Text.writeString(out, this.extraText);
        }
    }

    static class CrcInfoCommandReply
    extends UpgradeCommand {
        BlockCrcInfo crcInfo;

        public CrcInfoCommandReply() {
            super(202, -6, (short)0);
            this.crcInfo = new BlockCrcInfo();
        }

        public CrcInfoCommandReply(BlockCrcInfo info) {
            super(202, -6, (short)0);
            this.crcInfo = info;
        }

        public void readFields(DataInput in) throws IOException {
            super.readFields(in);
            this.crcInfo.readFields(in);
        }

        public void write(DataOutput out) throws IOException {
            super.write(out);
            this.crcInfo.write(out);
        }
    }

    static class CrcInfoCommand
    extends UpgradeCommand {
        Block block;

        public CrcInfoCommand() {
            super(201, -6, (short)0);
            this.block = new Block();
        }

        public CrcInfoCommand(Block blk) {
            super(201, -6, (short)0);
            this.block = blk;
        }

        public void readFields(DataInput in) throws IOException {
            super.readFields(in);
            this.block.readFields(in);
        }

        public void write(DataOutput out) throws IOException {
            super.write(out);
            this.block.write(out);
        }
    }

    static class DatanodeStatsCommand
    extends UpgradeCommand {
        DatanodeID datanodeId;
        int blocksUpgraded;
        int blocksRemaining;
        int errors;

        DatanodeStatsCommand() {
            super(200, -6, (short)0);
            this.datanodeId = new DatanodeID();
        }

        public DatanodeStatsCommand(short status, DatanodeID dn, int blocksUpgraded, int blocksRemaining, int errors) {
            super(200, -6, status);
            this.datanodeId = new DatanodeID(dn);
            this.blocksUpgraded = blocksUpgraded;
            this.blocksRemaining = blocksRemaining;
            this.errors = errors;
        }

        public void readFields(DataInput in) throws IOException {
            super.readFields(in);
            this.datanodeId.readFields(in);
            this.blocksUpgraded = in.readInt();
            this.blocksRemaining = in.readInt();
            this.errors = in.readInt();
        }

        public void write(DataOutput out) throws IOException {
            super.write(out);
            this.datanodeId.write(out);
            out.writeInt(this.blocksUpgraded);
            out.writeInt(this.blocksRemaining);
            out.writeInt(this.errors);
        }
    }
}

