/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import org.apache.hadoop.dfs.INode;
import org.apache.hadoop.dfs.INodeFile;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

class DFSFileInfo
extends FileStatus {
    public DFSFileInfo() {
    }

    public DFSFileInfo(String path, INode node) {
        super(node.isDirectory() ? 0L : node.computeContentSummary().getLength(), node.isDirectory(), node.isDirectory() ? (short)0 : ((INodeFile)node).getReplication(), node.isDirectory() ? 0L : ((INodeFile)node).getPreferredBlockSize(), node.getModificationTime(), node.getFsPermission(), node.getUserName(), node.getGroupName(), new Path(path));
    }

    public String getName() {
        return this.getPath().getName();
    }

    public String getParent() {
        return this.getPath().getParent().toString();
    }

    public long getContentsLen() {
        assert (this.isDir()) : "Must be a directory";
        return this.getLen();
    }

    static {
        WritableFactories.setFactory(DFSFileInfo.class, new WritableFactory(){

            public Writable newInstance() {
                return new DFSFileInfo();
            }
        });
    }
}

