/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Semaphore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.BlockCommand;
import org.apache.hadoop.dfs.BlockListAsLongs;
import org.apache.hadoop.dfs.DataBlockScanner;
import org.apache.hadoop.dfs.DataChecksum;
import org.apache.hadoop.dfs.DataStorage;
import org.apache.hadoop.dfs.DatanodeCommand;
import org.apache.hadoop.dfs.DatanodeInfo;
import org.apache.hadoop.dfs.DatanodeProtocol;
import org.apache.hadoop.dfs.DatanodeRegistration;
import org.apache.hadoop.dfs.DisallowedDatanodeException;
import org.apache.hadoop.dfs.FSConstants;
import org.apache.hadoop.dfs.FSDataset;
import org.apache.hadoop.dfs.FSDatasetInterface;
import org.apache.hadoop.dfs.IncorrectVersionException;
import org.apache.hadoop.dfs.NamespaceInfo;
import org.apache.hadoop.dfs.Storage;
import org.apache.hadoop.dfs.StreamFile;
import org.apache.hadoop.dfs.UnregisteredDatanodeException;
import org.apache.hadoop.dfs.UpgradeCommand;
import org.apache.hadoop.dfs.UpgradeManagerDatanode;
import org.apache.hadoop.dfs.datanode.metrics.DataNodeMetrics;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.mapred.StatusHttpServer;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataNode
implements FSConstants,
Runnable {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.dfs.DataNode");
    DatanodeProtocol namenode = null;
    FSDatasetInterface data = null;
    DatanodeRegistration dnRegistration = null;
    volatile boolean shouldRun = true;
    private LinkedList<Block> receivedBlockList = new LinkedList();
    private LinkedList<String> delHints = new LinkedList();
    static final String EMPTY_DEL_HINT = "";
    int xmitsInProgress = 0;
    Daemon dataXceiveServer = null;
    ThreadGroup threadGroup = null;
    long blockReportInterval;
    long lastBlockReport = Long.MAX_VALUE;
    boolean resetBlockReportTime = true;
    long initialBlockReportDelay = 60000L;
    private boolean waitForFirstBlockReportRequest = false;
    long lastHeartbeat = 0L;
    long heartBeatInterval;
    private DataStorage storage = null;
    private StatusHttpServer infoServer = null;
    private DataNodeMetrics myMetrics;
    private static InetSocketAddress nameNodeAddr;
    private InetSocketAddress selfAddr;
    private static DataNode datanodeObject;
    private Thread dataNodeThread = null;
    String machineName;
    private static String dnThreadName;
    int defaultBytesPerChecksum = 512;
    private int socketTimeout;
    private int socketWriteTimeout = 0;
    private DataBlockScanner blockScanner;
    private Daemon blockScannerThread;
    private static final Random R;
    private static final int MAX_XCEIVER_COUNT = 256;
    private int maxXceiverCount = 256;
    private long estimateBlockSize;
    static final short MAX_BALANCING_THREADS = 5;
    private Semaphore balancingSem = new Semaphore(5);
    long balanceBandwidth;
    private Throttler balancingThrottler;
    Map<Socket, Socket> childSockets = Collections.synchronizedMap(new HashMap());
    UpgradeManagerDatanode upgradeManager = new UpgradeManagerDatanode(this);

    @Deprecated
    public static InetSocketAddress createSocketAddr(String target) throws IOException {
        return NetUtils.createSocketAddr(target);
    }

    static long now() {
        return System.currentTimeMillis();
    }

    DataNode(Configuration conf, AbstractList<File> dataDirs) throws IOException {
        datanodeObject = this;
        try {
            this.startDataNode(conf, dataDirs);
        }
        catch (IOException ie) {
            this.shutdown();
            throw ie;
        }
    }

    void startDataNode(Configuration conf, AbstractList<File> dataDirs) throws IOException {
        if (conf.get("slave.host.name") != null) {
            this.machineName = conf.get("slave.host.name");
        }
        if (this.machineName == null) {
            this.machineName = DNS.getDefaultHost(conf.get("dfs.datanode.dns.interface", "default"), conf.get("dfs.datanode.dns.nameserver", "default"));
        }
        InetSocketAddress nameNodeAddr = NetUtils.createSocketAddr(FileSystem.getDefaultUri(conf).getAuthority());
        this.defaultBytesPerChecksum = Math.max(conf.getInt("io.bytes.per.checksum", 512), 1);
        this.estimateBlockSize = conf.getLong("dfs.block.size", 0x4000000L);
        this.socketTimeout = conf.getInt("dfs.socket.timeout", 60000);
        this.socketWriteTimeout = conf.getInt("dfs.datanode.socket.write.timeout", 480000);
        String address = NetUtils.getServerAddress(conf, "dfs.datanode.bindAddress", "dfs.datanode.port", "dfs.datanode.address");
        InetSocketAddress socAddr = NetUtils.createSocketAddr(address);
        int tmpPort = socAddr.getPort();
        this.storage = new DataStorage();
        this.dnRegistration = new DatanodeRegistration(this.machineName + ":" + tmpPort);
        this.namenode = (DatanodeProtocol)RPC.waitForProxy(DatanodeProtocol.class, 12L, nameNodeAddr, conf);
        NamespaceInfo nsInfo = this.handshake();
        FSConstants.StartupOption startOpt = DataNode.getStartupOption(conf);
        assert (startOpt != null) : "Startup option must be set.";
        boolean simulatedFSDataset = conf.getBoolean("dfs.datanode.simulateddatastorage", false);
        if (simulatedFSDataset) {
            DataNode.setNewStorageID(this.dnRegistration);
            this.dnRegistration.storageInfo.layoutVersion = -13;
            this.dnRegistration.storageInfo.namespaceID = nsInfo.namespaceID;
            conf.set("StorageId", this.dnRegistration.getStorageID());
            try {
                this.data = (FSDatasetInterface)ReflectionUtils.newInstance(Class.forName("org.apache.hadoop.dfs.SimulatedFSDataset"), conf);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(StringUtils.stringifyException(e));
            }
        } else {
            this.storage.recoverTransitionRead(nsInfo, dataDirs, startOpt);
            this.dnRegistration.setStorageInfo(this.storage);
            this.data = new FSDataset(this.storage, conf);
        }
        ServerSocket ss = this.socketWriteTimeout > 0 ? ServerSocketChannel.open().socket() : new ServerSocket();
        Server.bind(ss, socAddr, 0);
        ss.setReceiveBufferSize(131072);
        tmpPort = ss.getLocalPort();
        this.selfAddr = new InetSocketAddress(ss.getInetAddress().getHostAddress(), tmpPort);
        this.dnRegistration.setName(this.machineName + ":" + tmpPort);
        LOG.info((Object)("Opened server at " + tmpPort));
        this.maxXceiverCount = conf.getInt("dfs.datanode.max.xcievers", 256);
        this.threadGroup = new ThreadGroup("dataXceiveServer");
        this.dataXceiveServer = new Daemon(this.threadGroup, new DataXceiveServer(ss));
        this.threadGroup.setDaemon(true);
        this.blockReportInterval = conf.getLong("dfs.blockreport.intervalMsec", 3600000L);
        this.initialBlockReportDelay = conf.getLong("dfs.blockreport.initialDelay", 60L) * 1000L;
        if (this.initialBlockReportDelay >= this.blockReportInterval) {
            this.initialBlockReportDelay = 0L;
            LOG.info((Object)"dfs.blockreport.initialDelay is greater than dfs.blockreport.intervalMsec. Setting initial delay to 0 msec:");
        }
        this.heartBeatInterval = conf.getLong("dfs.heartbeat.interval", 3L) * 1000L;
        DataNode.nameNodeAddr = nameNodeAddr;
        this.balanceBandwidth = conf.getLong("dfs.balance.bandwidthPerSec", 0x100000L);
        LOG.info((Object)("Balancing bandwith is " + this.balanceBandwidth + " bytes/s"));
        this.balancingThrottler = new Throttler(this.balanceBandwidth);
        String reason = null;
        if (conf.getInt("dfs.datanode.scan.period.hours", 0) < 0) {
            reason = "verification is turned off by configuration";
        } else if (!(this.data instanceof FSDataset)) {
            reason = "verifcation is supported only with FSDataset";
        }
        if (reason == null) {
            this.blockScanner = new DataBlockScanner(this, (FSDataset)this.data, conf);
            this.blockScannerThread = new Daemon(this.blockScanner);
        } else {
            LOG.info((Object)("Periodic Block Verification is disabled because " + reason + "."));
        }
        String infoAddr = NetUtils.getServerAddress(conf, "dfs.datanode.info.bindAddress", "dfs.datanode.info.port", "dfs.datanode.http.address");
        InetSocketAddress infoSocAddr = NetUtils.createSocketAddr(infoAddr);
        String infoHost = infoSocAddr.getHostName();
        int tmpInfoPort = infoSocAddr.getPort();
        this.infoServer = new StatusHttpServer("datanode", infoHost, tmpInfoPort, tmpInfoPort == 0);
        InetSocketAddress secInfoSocAddr = NetUtils.createSocketAddr(conf.get("dfs.datanode.https.address", infoHost + ":" + 0));
        Configuration sslConf = new Configuration(conf);
        sslConf.addResource(conf.get("https.keystore.info.rsrc", "sslinfo.xml"));
        String keyloc = sslConf.get("https.keystore.location");
        if (null != keyloc) {
            this.infoServer.addSslListener(secInfoSocAddr, keyloc, sslConf.get("https.keystore.password", EMPTY_DEL_HINT), sslConf.get("https.keystore.keypassword", EMPTY_DEL_HINT));
        }
        this.infoServer.addServlet(null, "/streamFile/*", StreamFile.class);
        this.infoServer.setAttribute("datanode.blockScanner", this.blockScanner);
        this.infoServer.addServlet(null, "/blockScannerReport", DataBlockScanner.Servlet.class);
        this.infoServer.start();
        this.dnRegistration.setInfoPort(this.infoServer.getPort());
        this.myMetrics = new DataNodeMetrics(conf, this.dnRegistration.getStorageID());
    }

    private Socket newSocket() throws IOException {
        return this.socketWriteTimeout > 0 ? SocketChannel.open().socket() : new Socket();
    }

    private NamespaceInfo handshake() throws IOException {
        NamespaceInfo nsInfo = new NamespaceInfo();
        while (this.shouldRun) {
            try {
                nsInfo = this.namenode.versionRequest();
                break;
            }
            catch (SocketTimeoutException e) {
                LOG.info((Object)("Problem connecting to server: " + this.getNameNodeAddr()));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {}
            }
        }
        String errorMsg = null;
        if (!nsInfo.getBuildVersion().equals(Storage.getBuildVersion())) {
            errorMsg = "Incompatible build versions: namenode BV = " + nsInfo.getBuildVersion() + "; datanode BV = " + Storage.getBuildVersion();
            LOG.fatal((Object)errorMsg);
            try {
                this.namenode.errorReport(this.dnRegistration, 0, errorMsg);
            }
            catch (SocketTimeoutException e) {
                LOG.info((Object)("Problem connecting to server: " + this.getNameNodeAddr()));
            }
            throw new IOException(errorMsg);
        }
        assert (-13 == nsInfo.getLayoutVersion()) : "Data-node and name-node layout versions must be the same.";
        return nsInfo;
    }

    public static DataNode getDataNode() {
        return datanodeObject;
    }

    public InetSocketAddress getNameNodeAddr() {
        return nameNodeAddr;
    }

    public InetSocketAddress getSelfAddr() {
        return this.selfAddr;
    }

    DataNodeMetrics getMetrics() {
        return this.myMetrics;
    }

    public String getNamenode() {
        return "<namenode>";
    }

    static void setNewStorageID(DatanodeRegistration dnReg) {
        String ip = "unknownIP";
        try {
            ip = DNS.getDefaultIP("default");
        }
        catch (UnknownHostException ignored) {
            LOG.warn((Object)"Could not find ip address of \"default\" inteface.");
        }
        int rand = 0;
        try {
            rand = SecureRandom.getInstance("SHA1PRNG").nextInt(Integer.MAX_VALUE);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn((Object)"Could not use SecureRandom");
            rand = R.nextInt(Integer.MAX_VALUE);
        }
        dnReg.storageID = "DS-" + rand + "-" + ip + "-" + dnReg.getPort() + "-" + System.currentTimeMillis();
    }

    private void register() throws IOException {
        if (this.dnRegistration.getStorageID().equals(EMPTY_DEL_HINT)) {
            DataNode.setNewStorageID(this.dnRegistration);
        }
        while (this.shouldRun) {
            try {
                this.dnRegistration.name = this.machineName + ":" + this.dnRegistration.getPort();
                this.dnRegistration = this.namenode.register(this.dnRegistration);
                break;
            }
            catch (SocketTimeoutException e) {
                LOG.info((Object)("Problem connecting to server: " + this.getNameNodeAddr()));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        assert (EMPTY_DEL_HINT.equals(this.storage.getStorageID()) && !EMPTY_DEL_HINT.equals(this.dnRegistration.getStorageID()) || this.storage.getStorageID().equals(this.dnRegistration.getStorageID())) : "New storageID can be assigned only if data-node is not formatted";
        if (this.storage.getStorageID().equals(EMPTY_DEL_HINT)) {
            this.storage.setStorageID(this.dnRegistration.getStorageID());
            this.storage.writeAll();
            LOG.info((Object)("New storage id " + this.dnRegistration.getStorageID() + " is assigned to data-node " + this.dnRegistration.getName()));
        }
        if (!this.storage.getStorageID().equals(this.dnRegistration.getStorageID())) {
            throw new IOException("Inconsistent storage IDs. Name-node returned " + this.dnRegistration.getStorageID() + ". Expecting " + this.storage.getStorageID());
        }
        this.waitForFirstBlockReportRequest = true;
    }

    public void shutdown() {
        if (this.infoServer != null) {
            try {
                this.infoServer.stop();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.shouldRun = false;
        if (this.dataXceiveServer != null) {
            ((DataXceiveServer)this.dataXceiveServer.getRunnable()).kill();
            this.dataXceiveServer.interrupt();
            if (this.threadGroup != null) {
                while (true) {
                    this.threadGroup.interrupt();
                    LOG.info((Object)("Waiting for threadgroup to exit, active threads is " + this.threadGroup.activeCount()));
                    if (this.threadGroup.activeCount() == 0) break;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }
        RPC.stopProxy(this.namenode);
        if (this.upgradeManager != null) {
            this.upgradeManager.shutdownUpgrade();
        }
        if (this.blockScannerThread != null) {
            this.blockScanner.shutdown();
            this.blockScannerThread.interrupt();
        }
        if (this.storage != null) {
            try {
                this.storage.unlockAll();
            }
            catch (IOException ie) {
                // empty catch block
            }
        }
        if (this.dataNodeThread != null) {
            this.dataNodeThread.interrupt();
            try {
                this.dataNodeThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.data != null) {
            this.data.shutdown();
        }
        if (this.myMetrics != null) {
            this.myMetrics.shutdown();
        }
    }

    private void checkDiskError(IOException e) throws IOException {
        if (e.getMessage().startsWith("No space left on device")) {
            throw new DiskChecker.DiskOutOfSpaceException("No space left on device");
        }
        this.checkDiskError();
    }

    private void checkDiskError() throws IOException {
        try {
            this.data.checkDataDir();
        }
        catch (DiskChecker.DiskErrorException de) {
            this.handleDiskError(de.getMessage());
        }
    }

    private void handleDiskError(String errMsgr) {
        LOG.warn((Object)("DataNode is shutting down.\n" + errMsgr));
        try {
            this.namenode.errorReport(this.dnRegistration, 1, errMsgr);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.shutdown();
    }

    int getXceiverCount() {
        return this.threadGroup == null ? 0 : this.threadGroup.activeCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerService() throws Exception {
        LOG.info((Object)("using BLOCKREPORT_INTERVAL of " + this.blockReportInterval + "msec" + " Initial delay: " + this.initialBlockReportDelay + "msec"));
        while (this.shouldRun) {
            try {
                LinkedList<String> linkedList;
                long startTime = DataNode.now();
                if (startTime - this.lastHeartbeat > this.heartBeatInterval) {
                    this.lastHeartbeat = startTime;
                    DatanodeCommand cmd = this.namenode.sendHeartbeat(this.dnRegistration, this.data.getCapacity(), this.data.getDfsUsed(), this.data.getRemaining(), this.xmitsInProgress, this.getXceiverCount());
                    this.myMetrics.heartbeats.inc(DataNode.now() - startTime);
                    if (!this.processCommand(cmd)) continue;
                }
                Block[] blockArray = null;
                String[] delHintArray = null;
                LinkedList<Block> linkedList2 = this.receivedBlockList;
                synchronized (linkedList2) {
                    linkedList = this.delHints;
                    synchronized (linkedList) {
                        int numBlocks = this.receivedBlockList.size();
                        if (numBlocks > 0) {
                            if (numBlocks != this.delHints.size()) {
                                LOG.warn((Object)"Panic: receiveBlockList and delHints are not of the same length");
                            }
                            blockArray = this.receivedBlockList.toArray(new Block[numBlocks]);
                            delHintArray = this.delHints.toArray(new String[numBlocks]);
                        }
                    }
                }
                if (blockArray != null) {
                    if (delHintArray == null || delHintArray.length != blockArray.length) {
                        LOG.warn((Object)"Panic: block array & delHintArray are not the same");
                    }
                    this.namenode.blockReceived(this.dnRegistration, blockArray, delHintArray);
                    linkedList2 = this.receivedBlockList;
                    synchronized (linkedList2) {
                        linkedList = this.delHints;
                        synchronized (linkedList) {
                            for (int i = 0; i < blockArray.length; ++i) {
                                this.receivedBlockList.remove(blockArray[i]);
                                this.delHints.remove(delHintArray[i]);
                            }
                        }
                    }
                }
                if (startTime - this.lastBlockReport > this.blockReportInterval) {
                    long brStartTime = DataNode.now();
                    Block[] bReport = this.data.getBlockReport();
                    DatanodeCommand cmd = this.namenode.blockReport(this.dnRegistration, BlockListAsLongs.convertToArrayLongs(bReport));
                    long brTime = DataNode.now() - brStartTime;
                    this.myMetrics.blockReports.inc(brTime);
                    LOG.info((Object)("BlockReport of " + bReport.length + " blocks got processed in " + brTime + " msecs"));
                    if (this.resetBlockReportTime) {
                        this.lastBlockReport = startTime - (long)R.nextInt((int)this.blockReportInterval);
                        this.resetBlockReportTime = false;
                    } else {
                        this.lastBlockReport = startTime;
                    }
                    this.processCommand(cmd);
                }
                long waitTime = this.heartBeatInterval - (System.currentTimeMillis() - this.lastHeartbeat);
                LinkedList<Block> linkedList3 = this.receivedBlockList;
                synchronized (linkedList3) {
                    if (waitTime > 0L && this.receivedBlockList.size() == 0) {
                        try {
                            this.receivedBlockList.wait(waitTime);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (RemoteException re) {
                String reClass = re.getClassName();
                if (UnregisteredDatanodeException.class.getName().equals(reClass) || DisallowedDatanodeException.class.getName().equals(reClass) || IncorrectVersionException.class.getName().equals(reClass)) {
                    LOG.warn((Object)("DataNode is shutting down: " + StringUtils.stringifyException(re)));
                    this.shutdown();
                    return;
                }
                LOG.warn((Object)StringUtils.stringifyException(re));
            }
            catch (IOException e) {
                LOG.warn((Object)StringUtils.stringifyException(e));
            }
        }
    }

    private boolean processCommand(DatanodeCommand cmd) throws IOException {
        if (cmd == null) {
            return true;
        }
        switch (cmd.getAction()) {
            case 1: {
                BlockCommand bcmd = (BlockCommand)cmd;
                this.transferBlocks(bcmd.getBlocks(), bcmd.getTargets());
                break;
            }
            case 2: {
                Block[] toDelete = ((BlockCommand)cmd).getBlocks();
                try {
                    if (this.blockScanner != null) {
                        this.blockScanner.deleteBlocks(toDelete);
                    }
                    this.data.invalidate(toDelete);
                }
                catch (IOException e) {
                    this.checkDiskError();
                    throw e;
                }
                this.myMetrics.blocksRemoved.inc(toDelete.length);
                break;
            }
            case 3: {
                this.shutdown();
                return false;
            }
            case 4: {
                this.register();
                break;
            }
            case 5: {
                this.storage.finalizeUpgrade();
                break;
            }
            case 101: {
                this.processDistributedUpgradeCommand((UpgradeCommand)cmd);
                break;
            }
            case 6: {
                if (!this.waitForFirstBlockReportRequest) break;
                this.waitForFirstBlockReportRequest = false;
                this.scheduleBlockReport(this.initialBlockReportDelay);
                break;
            }
            default: {
                LOG.warn((Object)("Unknown DatanodeCommand action: " + cmd.getAction()));
            }
        }
        return true;
    }

    private void processDistributedUpgradeCommand(UpgradeCommand comm) throws IOException {
        assert (this.upgradeManager != null) : "DataNode.upgradeManager is null.";
        this.upgradeManager.processUpgradeCommand(comm);
    }

    private void startDistributedUpgradeIfNeeded() throws IOException {
        UpgradeManagerDatanode um = DataNode.getDataNode().upgradeManager;
        assert (um != null) : "DataNode.upgradeManager is null.";
        if (!um.getUpgradeState()) {
            return;
        }
        um.setUpgradeState(false, um.getUpgradeVersion());
        um.startUpgrade();
    }

    private void transferBlocks(Block[] blocks, DatanodeInfo[][] xferTargets) throws IOException {
        for (int i = 0; i < blocks.length; ++i) {
            if (!this.data.isValidBlock(blocks[i])) {
                String errStr = "Can't send invalid block " + blocks[i];
                LOG.info((Object)errStr);
                this.namenode.errorReport(this.dnRegistration, 2, errStr);
                break;
            }
            int numTargets = xferTargets[i].length;
            if (numTargets <= 0) continue;
            if (LOG.isInfoEnabled()) {
                StringBuilder xfersBuilder = new StringBuilder();
                for (int j = 0; j < numTargets; ++j) {
                    DatanodeInfo nodeInfo = xferTargets[i][j];
                    xfersBuilder.append(nodeInfo.getName());
                    if (j >= numTargets - 1) continue;
                    xfersBuilder.append(", ");
                }
                String xfersTo = xfersBuilder.toString();
                LOG.info((Object)(this.dnRegistration + " Starting thread to transfer block " + blocks[i] + " to " + xfersTo));
            }
            new Daemon(new DataTransfer(xferTargets[i], blocks[i])).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void receiveResponse(Socket s, int numTargets) throws IOException {
        DataInputStream reply = new DataInputStream(new BufferedInputStream(NetUtils.getInputStream(s), BUFFER_SIZE));
        try {
            for (int i = 0; i < numTargets; ++i) {
                short opStatus = reply.readShort();
                if (opStatus == 0) continue;
                throw new IOException("operation failed at " + s.getInetAddress());
            }
        }
        finally {
            IOUtils.closeStream(reply);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendResponse(Socket s, short opStatus, long timeout) throws IOException {
        DataOutputStream reply = new DataOutputStream(NetUtils.getOutputStream(s, timeout));
        try {
            reply.writeShort(opStatus);
            reply.flush();
        }
        finally {
            IOUtils.closeStream(reply);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyNamenodeReceivedBlock(Block block, String delHint) {
        if (block == null || delHint == null) {
            throw new IllegalArgumentException(block == null ? "Block is null" : "delHint is null");
        }
        LinkedList<Block> linkedList = this.receivedBlockList;
        synchronized (linkedList) {
            LinkedList<String> linkedList2 = this.delHints;
            synchronized (linkedList2) {
                this.receivedBlockList.add(block);
                this.delHints.add(delHint);
                this.receivedBlockList.notifyAll();
            }
        }
    }

    @Override
    public void run() {
        LOG.info((Object)(this.dnRegistration + "In DataNode.run, data = " + this.data));
        if (this.blockScannerThread != null) {
            this.blockScannerThread.start();
        }
        this.dataXceiveServer.start();
        while (this.shouldRun) {
            try {
                this.startDistributedUpgradeIfNeeded();
                this.offerService();
            }
            catch (Exception ex) {
                LOG.error((Object)("Exception: " + StringUtils.stringifyException(ex)));
                if (!this.shouldRun) continue;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        try {
            this.dataXceiveServer.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LOG.info((Object)(this.dnRegistration + ":Finishing DataNode in: " + this.data));
        this.shutdown();
    }

    static void runDatanodeDaemon(DataNode dn) throws IOException {
        if (dn != null) {
            dn.register();
            dn.dataNodeThread = new Thread((Runnable)dn, dnThreadName);
            dn.dataNodeThread.setDaemon(true);
            dn.dataNodeThread.start();
        }
    }

    static DataNode instantiateDataNode(String[] args, Configuration conf) throws IOException {
        if (conf == null) {
            conf = new Configuration();
        }
        if (!DataNode.parseArguments(args, conf)) {
            DataNode.printUsage();
            return null;
        }
        if (conf.get("dfs.network.script") != null) {
            LOG.error((Object)"This configuration for rack identification is not supported anymore. RackID resolution is handled by the NameNode.");
            System.exit(-1);
        }
        String[] dataDirs = conf.getStrings("dfs.data.dir");
        dnThreadName = "DataNode: [" + StringUtils.arrayToString(dataDirs) + "]";
        return DataNode.makeInstance(dataDirs, conf);
    }

    static DataNode createDataNode(String[] args, Configuration conf) throws IOException {
        DataNode dn = DataNode.instantiateDataNode(args, conf);
        DataNode.runDatanodeDaemon(dn);
        return dn;
    }

    void join() {
        if (this.dataNodeThread != null) {
            try {
                this.dataNodeThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static DataNode makeInstance(String[] dataDirs, Configuration conf) throws IOException {
        ArrayList<File> dirs = new ArrayList<File>();
        for (int i = 0; i < dataDirs.length; ++i) {
            File data = new File(dataDirs[i]);
            try {
                DiskChecker.checkDir(data);
                dirs.add(data);
                continue;
            }
            catch (DiskChecker.DiskErrorException e) {
                LOG.warn((Object)("Invalid directory in dfs.data.dir: " + e.getMessage()));
            }
        }
        if (dirs.size() > 0) {
            return new DataNode(conf, dirs);
        }
        LOG.error((Object)"All directories in dfs.data.dir are invalid.");
        return null;
    }

    public String toString() {
        return "DataNode{data=" + this.data + ", localName='" + this.dnRegistration.getName() + "'" + ", storageID='" + this.dnRegistration.getStorageID() + "'" + ", xmitsInProgress=" + this.xmitsInProgress + "}";
    }

    private static void printUsage() {
        System.err.println("Usage: java DataNode");
        System.err.println("           [-rollback]");
    }

    private static boolean parseArguments(String[] args, Configuration conf) {
        int argsLen = args == null ? 0 : args.length;
        FSConstants.StartupOption startOpt = FSConstants.StartupOption.REGULAR;
        for (int i = 0; i < argsLen; ++i) {
            String cmd = args[i];
            if ("-r".equalsIgnoreCase(cmd) || "--rack".equalsIgnoreCase(cmd)) {
                LOG.error((Object)"-r, --rack arguments are not supported anymore. RackID resolution is handled by the NameNode.");
                System.exit(-1);
                continue;
            }
            if ("-rollback".equalsIgnoreCase(cmd)) {
                startOpt = FSConstants.StartupOption.ROLLBACK;
                continue;
            }
            if ("-regular".equalsIgnoreCase(cmd)) {
                startOpt = FSConstants.StartupOption.REGULAR;
                continue;
            }
            return false;
        }
        DataNode.setStartupOption(conf, startOpt);
        return true;
    }

    private static void setStartupOption(Configuration conf, FSConstants.StartupOption opt) {
        conf.set("dfs.datanode.startup", opt.toString());
    }

    static FSConstants.StartupOption getStartupOption(Configuration conf) {
        return FSConstants.StartupOption.valueOf(conf.get("dfs.datanode.startup", FSConstants.StartupOption.REGULAR.toString()));
    }

    public void scheduleBlockReport(long delay) {
        this.lastBlockReport = delay > 0L ? System.currentTimeMillis() - (this.blockReportInterval - (long)R.nextInt((int)delay)) : this.lastHeartbeat - this.blockReportInterval;
        this.resetBlockReportTime = true;
    }

    public FSDatasetInterface getFSDataset() {
        return this.data;
    }

    public static void main(String[] args) {
        try {
            StringUtils.startupShutdownMessage(DataNode.class, args, LOG);
            DataNode datanode = DataNode.createDataNode(args, null);
            if (datanode != null) {
                datanode.join();
            }
        }
        catch (Throwable e) {
            LOG.error((Object)StringUtils.stringifyException(e));
            System.exit(-1);
        }
    }

    static {
        datanodeObject = null;
        R = new Random();
    }

    class DataTransfer
    implements Runnable {
        DatanodeInfo[] targets;
        Block b;

        public DataTransfer(DatanodeInfo[] targets, Block b) throws IOException {
            this.targets = targets;
            this.b = b;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ++DataNode.this.xmitsInProgress;
            Socket sock = null;
            DataOutputStream out = null;
            BlockSender blockSender = null;
            try {
                InetSocketAddress curTarget = NetUtils.createSocketAddr(this.targets[0].getName());
                sock = DataNode.this.newSocket();
                sock.connect(curTarget, DataNode.this.socketTimeout);
                sock.setSoTimeout(this.targets.length * DataNode.this.socketTimeout);
                long writeTimeout = DataNode.this.socketWriteTimeout + 5000 * (this.targets.length - 1);
                out = new DataOutputStream(new BufferedOutputStream(NetUtils.getOutputStream(sock, writeTimeout), FSConstants.SMALL_BUFFER_SIZE));
                blockSender = new BlockSender(this.b, 0L, -1L, false, false, false);
                out.writeShort(9);
                out.writeByte(80);
                out.writeLong(this.b.getBlockId());
                out.writeInt(0);
                out.writeBoolean(false);
                Text.writeString(out, DataNode.EMPTY_DEL_HINT);
                out.writeInt(this.targets.length - 1);
                for (int i = 1; i < this.targets.length; ++i) {
                    this.targets[i].write(out);
                }
                blockSender.sendBlock(out, null);
                LOG.info((Object)(DataNode.this.dnRegistration + ":Transmitted block " + this.b + " to " + curTarget));
            }
            catch (IOException ie) {
                try {
                    LOG.warn((Object)(DataNode.this.dnRegistration + ":Failed to transfer " + this.b + " to " + this.targets[0].getName() + " got " + StringUtils.stringifyException(ie)));
                }
                catch (Throwable throwable) {
                    IOUtils.closeStream(blockSender);
                    IOUtils.closeStream(out);
                    IOUtils.closeSocket(sock);
                    --DataNode.this.xmitsInProgress;
                    throw throwable;
                }
                IOUtils.closeStream(blockSender);
                IOUtils.closeStream(out);
                IOUtils.closeSocket(sock);
                --DataNode.this.xmitsInProgress;
            }
            IOUtils.closeStream(blockSender);
            IOUtils.closeStream(out);
            IOUtils.closeSocket(sock);
            --DataNode.this.xmitsInProgress;
        }
    }

    private class BlockReceiver
    implements Closeable {
        private Block block;
        private boolean finalized;
        private DataInputStream in = null;
        private DataChecksum checksum;
        private DataOutputStream out = null;
        private DataOutputStream checksumOut = null;
        private DFSBufferedOutputStream bufStream = null;
        private int bytesPerChecksum;
        private int checksumSize;
        private byte[] buf;
        private byte[] checksumBuf;
        private long offsetInBlock;
        private final String inAddr;
        private String mirrorAddr;
        private DataOutputStream mirrorOut;
        private Daemon responder = null;
        private Throttler throttler;
        private FSDatasetInterface.BlockWriteStreams streams;
        private boolean isRecovery = false;
        private String clientName;

        BlockReceiver(Block block, DataInputStream in, String inAddr, boolean isRecovery, String clientName) throws IOException {
            try {
                this.block = block;
                this.in = in;
                this.inAddr = inAddr;
                this.isRecovery = isRecovery;
                this.clientName = clientName;
                this.offsetInBlock = 0L;
                this.checksum = DataChecksum.newDataChecksum(in);
                this.bytesPerChecksum = this.checksum.getBytesPerChecksum();
                this.checksumSize = this.checksum.getChecksumSize();
                this.buf = new byte[this.bytesPerChecksum + this.checksumSize];
                this.checksumBuf = new byte[this.checksumSize];
                this.streams = DataNode.this.data.writeToBlock(block, isRecovery);
                this.finalized = DataNode.this.data.isValidBlock(block);
                if (this.streams != null) {
                    this.bufStream = new DFSBufferedOutputStream(this.streams.dataOut, FSConstants.BUFFER_SIZE);
                    this.out = new DataOutputStream(this.bufStream);
                    this.checksumOut = new DataOutputStream(new BufferedOutputStream(this.streams.checksumOut, FSConstants.BUFFER_SIZE));
                }
            }
            catch (IOException ioe) {
                IOUtils.closeStream(this);
                throw ioe;
            }
        }

        public void close() throws IOException {
            IOException ioe = null;
            try {
                if (this.checksumOut != null) {
                    this.checksumOut.close();
                    this.checksumOut = null;
                }
            }
            catch (IOException e) {
                ioe = e;
            }
            try {
                if (this.out != null) {
                    this.out.close();
                    this.out = null;
                }
            }
            catch (IOException e) {
                ioe = e;
            }
            if (ioe != null) {
                DataNode.this.checkDiskError(ioe);
                throw ioe;
            }
        }

        void flush() throws IOException {
            if (this.checksumOut != null) {
                this.checksumOut.flush();
            }
            if (this.out != null) {
                this.out.flush();
            }
        }

        private void handleMirrorOutError(IOException ioe) throws IOException {
            LOG.info((Object)(DataNode.this.dnRegistration + ":Exception writing block " + this.block + " to mirror " + this.mirrorAddr + "\n" + StringUtils.stringifyException(ioe)));
            this.mirrorOut = null;
            if (this.clientName.length() > 0) {
                throw ioe;
            }
        }

        private void receiveChunk(int len, byte[] checksumBuf, int checksumOff) throws IOException {
            if (len <= 0 || len > this.bytesPerChecksum) {
                throw new IOException("Got wrong length during writeBlock(" + this.block + ") from " + this.inAddr + " at offset " + this.offsetInBlock + ": " + len + " expected <= " + this.bytesPerChecksum);
            }
            this.in.readFully(this.buf, 0, len);
            this.checksum.update(this.buf, 0, len);
            if (!this.checksum.compare(checksumBuf, checksumOff)) {
                throw new IOException("Unexpected checksum mismatch while writing " + this.block + " from " + this.inAddr);
            }
            this.checksum.reset();
            this.offsetInBlock += (long)len;
            if (this.mirrorOut != null) {
                try {
                    this.mirrorOut.writeInt(len);
                    this.mirrorOut.write(checksumBuf, checksumOff, this.checksumSize);
                    this.mirrorOut.write(this.buf, 0, len);
                }
                catch (IOException ioe) {
                    this.handleMirrorOutError(ioe);
                }
            }
            try {
                if (!this.finalized) {
                    this.out.write(this.buf, 0, len);
                    this.checksumOut.write(checksumBuf, checksumOff, this.checksumSize);
                    ((DataNode)DataNode.this).myMetrics.bytesWritten.inc(len);
                }
            }
            catch (IOException iex) {
                DataNode.this.checkDiskError(iex);
                throw iex;
            }
            if (this.throttler != null) {
                this.throttler.throttle(len + this.checksumSize + 4);
            }
        }

        private void receivePacket(int packetSize) throws IOException {
            this.offsetInBlock = this.in.readLong();
            long seqno = this.in.readLong();
            boolean lastPacketInBlock = this.in.readBoolean();
            int curPacketSize = 0;
            LOG.debug((Object)("Receiving one packet for block " + this.block + " of size " + packetSize + " seqno " + seqno + " offsetInBlock " + this.offsetInBlock + " lastPacketInBlock " + lastPacketInBlock));
            this.setBlockPosition(this.offsetInBlock);
            int len = this.in.readInt();
            curPacketSize += 4;
            if (this.mirrorOut != null) {
                try {
                    int mirrorPacketSize = packetSize;
                    if (len > this.bytesPerChecksum) {
                        int chunksInPkt = (len + this.bytesPerChecksum - 1) / this.bytesPerChecksum;
                        mirrorPacketSize += (chunksInPkt - 1) * 4;
                    }
                    this.mirrorOut.writeInt(mirrorPacketSize);
                    this.mirrorOut.writeLong(this.offsetInBlock);
                    this.mirrorOut.writeLong(seqno);
                    this.mirrorOut.writeBoolean(lastPacketInBlock);
                }
                catch (IOException e) {
                    this.handleMirrorOutError(e);
                }
            }
            if (len == 0) {
                LOG.info((Object)("Receiving empty packet for block " + this.block));
                if (this.mirrorOut != null) {
                    try {
                        this.mirrorOut.writeInt(len);
                        this.mirrorOut.flush();
                    }
                    catch (IOException e) {
                        this.handleMirrorOutError(e);
                    }
                }
            }
            while (len != 0) {
                int checksumOff = 0;
                if (len > 0) {
                    int checksumLen = (len + this.bytesPerChecksum - 1) / this.bytesPerChecksum * this.checksumSize;
                    if (this.checksumBuf.length < checksumLen) {
                        this.checksumBuf = new byte[checksumLen];
                    }
                    this.in.readFully(this.checksumBuf, 0, checksumLen);
                }
                while (len != 0) {
                    int toRecv;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Receiving one chunk for block " + this.block + " of size " + len));
                    }
                    if ((curPacketSize += (toRecv = Math.min(len, this.bytesPerChecksum)) + this.checksumSize) > packetSize) {
                        throw new IOException("Packet size for block " + this.block + " too long " + curPacketSize + " was expecting " + packetSize);
                    }
                    this.receiveChunk(toRecv, this.checksumBuf, checksumOff);
                    len -= toRecv;
                    checksumOff += this.checksumSize;
                }
                if (curPacketSize == packetSize) {
                    if (this.mirrorOut == null) break;
                    try {
                        this.mirrorOut.flush();
                    }
                    catch (IOException e) {
                        this.handleMirrorOutError(e);
                    }
                    break;
                }
                len = this.in.readInt();
                curPacketSize += 4;
            }
            this.flush();
            if (this.responder != null) {
                ((PacketResponder)this.responder.getRunnable()).enqueue(seqno, lastPacketInBlock);
            }
        }

        public void writeChecksumHeader(DataOutputStream mirrorOut) throws IOException {
            this.checksum.writeHeader(mirrorOut);
        }

        public void receiveBlock(DataOutputStream mirrOut, DataInputStream mirrIn, DataOutputStream replyOut, String mirrAddr, Throttler throttlerArg, int numTargets) throws IOException {
            this.mirrorOut = mirrOut;
            this.mirrorAddr = mirrAddr;
            this.throttler = throttlerArg;
            try {
                if (!this.finalized) {
                    this.checksumOut.writeShort(1);
                    this.checksum.writeHeader(this.checksumOut);
                }
                if (this.clientName.length() > 0) {
                    this.responder = new Daemon(DataNode.this.threadGroup, new PacketResponder(this, this.block, mirrIn, replyOut, numTargets, this.clientName));
                    this.responder.start();
                }
                int len = this.in.readInt();
                while (len != 0) {
                    this.receivePacket(len);
                    len = this.in.readInt();
                }
                if (this.mirrorOut != null) {
                    try {
                        this.mirrorOut.writeInt(0);
                        this.mirrorOut.flush();
                    }
                    catch (IOException e) {
                        this.handleMirrorOutError(e);
                    }
                }
                if (this.responder != null) {
                    ((PacketResponder)this.responder.getRunnable()).close();
                }
                if (this.clientName.length() == 0) {
                    this.close();
                    this.block.setNumBytes(this.offsetInBlock);
                    DataNode.this.data.finalizeBlock(this.block);
                    ((DataNode)DataNode.this).myMetrics.blocksWritten.inc();
                }
            }
            catch (IOException ioe) {
                LOG.info((Object)("Exception in receiveBlock for block " + this.block + " " + ioe));
                IOUtils.closeStream(this);
                if (this.responder != null) {
                    this.responder.interrupt();
                }
                throw ioe;
            }
            finally {
                if (this.responder != null) {
                    try {
                        this.responder.join();
                    }
                    catch (InterruptedException e) {
                        throw new IOException("Interrupted receiveBlock");
                    }
                    this.responder = null;
                }
            }
        }

        private void setBlockPosition(long offsetInBlock) throws IOException {
            if (this.finalized) {
                if (!this.isRecovery) {
                    throw new IOException("Write to offset " + offsetInBlock + " of block " + this.block + " that is already finalized.");
                }
                if (offsetInBlock > DataNode.this.data.getLength(this.block)) {
                    throw new IOException("Write to offset " + offsetInBlock + " of block " + this.block + " that is already finalized and is of size " + DataNode.this.data.getLength(this.block));
                }
                return;
            }
            if (this.bufStream.samePosition(DataNode.this.data, this.streams, this.block, offsetInBlock)) {
                return;
            }
            if (offsetInBlock % (long)this.bytesPerChecksum != 0L) {
                throw new IOException("setBlockPosition trying to set position to " + offsetInBlock + " which is not a multiple of bytesPerChecksum " + this.bytesPerChecksum);
            }
            long offsetInChecksum = (long)this.checksum.getChecksumHeaderSize() + offsetInBlock / (long)this.bytesPerChecksum * (long)this.checksumSize;
            if (this.out != null) {
                this.out.flush();
            }
            if (this.checksumOut != null) {
                this.checksumOut.flush();
            }
            LOG.info((Object)("Changing block file offset of block " + this.block + " from " + DataNode.this.data.getChannelPosition(this.block, this.streams) + " to " + offsetInBlock + " meta file offset to " + offsetInChecksum));
            DataNode.this.data.setChannelPosition(this.block, this.streams, offsetInBlock, offsetInChecksum);
        }
    }

    private static class DFSBufferedOutputStream
    extends BufferedOutputStream {
        OutputStream out;

        DFSBufferedOutputStream(OutputStream out, int capacity) {
            super(out, capacity);
            this.out = out;
        }

        public synchronized void flush() throws IOException {
            super.flush();
        }

        synchronized boolean samePosition(FSDatasetInterface data, FSDatasetInterface.BlockWriteStreams streams, Block block, long offset) throws IOException {
            if (data.getChannelPosition(block, streams) + (long)this.count == offset) {
                return true;
            }
            LOG.debug((Object)("samePosition is false.  current position " + data.getChannelPosition(block, streams) + " buffered size " + this.count + " new offset " + offset));
            return false;
        }
    }

    class PacketResponder
    implements Runnable {
        private LinkedList<Packet> ackQueue = new LinkedList();
        private volatile boolean running = true;
        private Block block;
        DataInputStream mirrorIn;
        DataOutputStream replyOut;
        private int numTargets;
        private String clientName;
        private BlockReceiver receiver;

        public String toString() {
            return "PacketResponder " + this.numTargets + " for Block " + this.block;
        }

        PacketResponder(BlockReceiver receiver, Block b, DataInputStream in, DataOutputStream out, int numTargets, String clientName) {
            this.receiver = receiver;
            this.block = b;
            this.mirrorIn = in;
            this.replyOut = out;
            this.numTargets = numTargets;
            this.clientName = clientName;
        }

        synchronized void enqueue(long seqno, boolean lastPacketInBlock) {
            if (this.running) {
                LOG.debug((Object)("PacketResponder " + this.numTargets + " adding seqno " + seqno + " to ack queue."));
                this.ackQueue.addLast(new Packet(seqno, lastPacketInBlock));
                this.notifyAll();
            }
        }

        synchronized void close() {
            while (this.running && this.ackQueue.size() != 0 && DataNode.this.shouldRun) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    this.running = false;
                }
            }
            LOG.debug((Object)("PacketResponder " + this.numTargets + " for block " + this.block + " Closing down."));
            this.running = false;
            this.notifyAll();
        }

        private synchronized void lastDataNodeRun() {
            long lastHeartbeat = System.currentTimeMillis();
            boolean lastPacket = false;
            while (this.running && DataNode.this.shouldRun && !lastPacket) {
                long now = System.currentTimeMillis();
                try {
                    while (this.running && DataNode.this.shouldRun && this.ackQueue.size() == 0) {
                        long idle = now - lastHeartbeat;
                        long timeout = (long)(DataNode.this.socketTimeout / 2) - idle;
                        if (timeout <= 0L) {
                            timeout = 1000L;
                        }
                        try {
                            this.wait(timeout);
                        }
                        catch (InterruptedException e) {
                            if (!this.running) break;
                            LOG.info((Object)("PacketResponder " + this.numTargets + " for block " + this.block + " Interrupted."));
                            this.running = false;
                            break;
                        }
                        now = System.currentTimeMillis();
                        if (now - lastHeartbeat <= (long)(DataNode.this.socketTimeout / 2)) continue;
                        this.replyOut.writeLong(-1L);
                        this.replyOut.flush();
                        lastHeartbeat = now;
                    }
                    if (!this.running || !DataNode.this.shouldRun) break;
                    Packet pkt = this.ackQueue.removeFirst();
                    long expected = pkt.seqno;
                    this.notifyAll();
                    LOG.debug((Object)("PacketResponder " + this.numTargets + " for block " + this.block + " acking for packet " + expected));
                    if (pkt.lastPacketInBlock) {
                        if (!this.receiver.finalized) {
                            this.receiver.close();
                            this.block.setNumBytes(this.receiver.offsetInBlock);
                            DataNode.this.data.finalizeBlock(this.block);
                            ((DataNode)DataNode.this).myMetrics.blocksWritten.inc();
                            DataNode.this.notifyNamenodeReceivedBlock(this.block, DataNode.EMPTY_DEL_HINT);
                            LOG.info((Object)("Received block " + this.block + " of size " + this.block.getNumBytes() + " from " + this.receiver.inAddr));
                        }
                        lastPacket = true;
                    }
                    this.replyOut.writeLong(expected);
                    this.replyOut.writeShort(0);
                    this.replyOut.flush();
                }
                catch (Exception e) {
                    if (!this.running) continue;
                    LOG.info((Object)("PacketResponder " + this.block + " " + this.numTargets + " Exception " + StringUtils.stringifyException(e)));
                    this.running = false;
                }
            }
            LOG.info((Object)("PacketResponder " + this.numTargets + " for block " + this.block + " terminating"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.numTargets == 0) {
                this.lastDataNodeRun();
                return;
            }
            boolean lastPacketInBlock = false;
            while (this.running && DataNode.this.shouldRun && !lastPacketInBlock) {
                try {
                    long expected;
                    short op;
                    block21: {
                        op = 0;
                        boolean didRead = false;
                        expected = -2L;
                        try {
                            long seqno = this.mirrorIn.readLong();
                            didRead = true;
                            if (seqno == -1L) {
                                this.replyOut.writeLong(-1L);
                                this.replyOut.flush();
                                LOG.debug((Object)("PacketResponder " + this.numTargets + " got -1"));
                                continue;
                            }
                            if (seqno == -2L) {
                                LOG.debug((Object)("PacketResponder " + this.numTargets + " got -2"));
                                break block21;
                            }
                            LOG.debug((Object)("PacketResponder " + this.numTargets + " got seqno = " + seqno));
                            Packet pkt = null;
                            PacketResponder packetResponder = this;
                            synchronized (packetResponder) {
                                while (this.running && DataNode.this.shouldRun && this.ackQueue.size() == 0) {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug((Object)("PacketResponder " + this.numTargets + " seqno = " + seqno + " for block " + this.block + " waiting for local datanode to finish write."));
                                    }
                                    this.wait();
                                }
                                pkt = this.ackQueue.removeFirst();
                                expected = pkt.seqno;
                                this.notifyAll();
                                LOG.debug((Object)("PacketResponder " + this.numTargets + " seqno = " + seqno));
                                if (seqno != expected) {
                                    throw new IOException("PacketResponder " + this.numTargets + " for block " + this.block + " expected seqno:" + expected + " received:" + seqno);
                                }
                                lastPacketInBlock = pkt.lastPacketInBlock;
                            }
                        }
                        catch (Throwable e) {
                            if (!this.running) break block21;
                            LOG.info((Object)("PacketResponder " + this.block + " " + this.numTargets + " Exception " + StringUtils.stringifyException(e)));
                            this.running = false;
                            if (didRead) break block21;
                            op = 1;
                        }
                    }
                    if (lastPacketInBlock && !this.receiver.finalized) {
                        this.receiver.close();
                        this.block.setNumBytes(this.receiver.offsetInBlock);
                        DataNode.this.data.finalizeBlock(this.block);
                        ((DataNode)DataNode.this).myMetrics.blocksWritten.inc();
                        DataNode.this.notifyNamenodeReceivedBlock(this.block, DataNode.EMPTY_DEL_HINT);
                        LOG.info((Object)("Received block " + this.block + " of size " + this.block.getNumBytes() + " from " + this.receiver.inAddr));
                    }
                    this.replyOut.writeLong(expected);
                    this.replyOut.writeShort(0);
                    LOG.debug((Object)("PacketResponder " + this.numTargets + " for block " + this.block + " responded my status " + " for seqno " + expected));
                    for (int i = 0; i < this.numTargets && DataNode.this.shouldRun; ++i) {
                        try {
                            if (op == 0 && (op = this.mirrorIn.readShort()) != 0) {
                                LOG.debug((Object)("PacketResponder for block " + this.block + ": error code received from downstream " + " datanode[" + i + "] " + op));
                            }
                        }
                        catch (Throwable e) {
                            op = 1;
                        }
                        this.replyOut.writeShort(op);
                    }
                    this.replyOut.flush();
                    LOG.debug((Object)("PacketResponder " + this.block + " " + this.numTargets + " responded other status " + " for seqno " + expected));
                    if (expected == -2L) {
                        this.running = false;
                    }
                    if (op != 1 || this.clientName.length() <= 0) continue;
                    this.running = false;
                }
                catch (IOException e) {
                    if (!this.running) continue;
                    LOG.info((Object)("PacketResponder " + this.block + " " + this.numTargets + " Exception " + StringUtils.stringifyException(e)));
                    this.running = false;
                }
                catch (RuntimeException e) {
                    if (!this.running) continue;
                    LOG.info((Object)("PacketResponder " + this.block + " " + this.numTargets + " Exception " + StringUtils.stringifyException(e)));
                    this.running = false;
                }
            }
            LOG.info((Object)("PacketResponder " + this.numTargets + " for block " + this.block + " terminating"));
        }
    }

    private static class Packet {
        long seqno;
        boolean lastPacketInBlock;

        Packet(long seqno, boolean lastPacketInBlock) {
            this.seqno = seqno;
            this.lastPacketInBlock = lastPacketInBlock;
        }
    }

    class BlockSender
    implements Closeable {
        private Block block;
        private InputStream blockIn;
        private DataInputStream checksumIn;
        private DataChecksum checksum;
        private long offset;
        private long endOffset;
        private long blockLength;
        private int bytesPerChecksum;
        private int checksumSize;
        private boolean corruptChecksumOk;
        private boolean chunkOffsetOK;
        private long seqno;
        private boolean blockReadFully;
        private boolean verifyChecksum;
        private Throttler throttler;
        private OutputStream out;
        static final int PKT_HEADER_LEN = 25;

        BlockSender(Block block, long startOffset, long length, boolean corruptChecksumOk, boolean chunkOffsetOK, boolean verifyChecksum) throws IOException {
            try {
                long checksumSkip;
                this.block = block;
                this.chunkOffsetOK = chunkOffsetOK;
                this.corruptChecksumOk = corruptChecksumOk;
                this.verifyChecksum = verifyChecksum;
                this.blockLength = DataNode.this.data.getLength(block);
                if (!corruptChecksumOk || DataNode.this.data.metaFileExists(block)) {
                    this.checksumIn = new DataInputStream(new BufferedInputStream(DataNode.this.data.getMetaDataInputStream(block), FSConstants.BUFFER_SIZE));
                    short version = this.checksumIn.readShort();
                    if (version != 1) {
                        LOG.warn((Object)("Wrong version (" + version + ") for metadata file for " + block + " ignoring ..."));
                    }
                    this.checksum = DataChecksum.newDataChecksum(this.checksumIn);
                } else {
                    LOG.warn((Object)("Could not find metadata file for " + block));
                    this.checksum = DataChecksum.newDataChecksum(0, 16384);
                }
                this.bytesPerChecksum = this.checksum.getBytesPerChecksum();
                if (this.bytesPerChecksum > 0xA00000 && (long)this.bytesPerChecksum > this.blockLength) {
                    this.checksum = DataChecksum.newDataChecksum(this.checksum.getChecksumType(), Math.max((int)this.blockLength, 0xA00000));
                    this.bytesPerChecksum = this.checksum.getBytesPerChecksum();
                }
                this.checksumSize = this.checksum.getChecksumSize();
                if (length < 0L) {
                    length = this.blockLength;
                }
                this.endOffset = this.blockLength;
                if (startOffset < 0L || startOffset > this.endOffset || length + startOffset > this.endOffset) {
                    String msg = " Offset " + startOffset + " and length " + length + " don't match block " + block + " ( blockLen " + this.endOffset + " )";
                    LOG.warn((Object)(DataNode.this.dnRegistration + ":sendBlock() : " + msg));
                    throw new IOException(msg);
                }
                this.offset = startOffset - startOffset % (long)this.bytesPerChecksum;
                if (length >= 0L) {
                    long tmpLen = startOffset + length + (startOffset - this.offset);
                    if (tmpLen % (long)this.bytesPerChecksum != 0L) {
                        tmpLen += (long)this.bytesPerChecksum - tmpLen % (long)this.bytesPerChecksum;
                    }
                    if (tmpLen < this.endOffset) {
                        this.endOffset = tmpLen;
                    }
                }
                if (this.offset > 0L && (checksumSkip = this.offset / (long)this.bytesPerChecksum * (long)this.checksumSize) > 0L) {
                    IOUtils.skipFully(this.checksumIn, checksumSkip);
                }
                this.seqno = 0L;
                this.blockIn = DataNode.this.data.getBlockInputStream(block, this.offset);
            }
            catch (IOException ioe) {
                IOUtils.closeStream(this);
                IOUtils.closeStream(this.blockIn);
                throw ioe;
            }
        }

        public void close() throws IOException {
            IOException ioe = null;
            if (this.checksumIn != null) {
                try {
                    this.checksumIn.close();
                }
                catch (IOException e) {
                    ioe = e;
                }
                this.checksumIn = null;
            }
            if (this.blockIn != null) {
                try {
                    this.blockIn.close();
                }
                catch (IOException e) {
                    ioe = e;
                }
                this.blockIn = null;
            }
            if (ioe != null) {
                throw ioe;
            }
        }

        private int sendChunks(ByteBuffer pkt, int maxChunks) throws IOException {
            int len = Math.min((int)(this.endOffset - this.offset), this.bytesPerChecksum * maxChunks);
            if (len == 0) {
                return 0;
            }
            int numChunks = (len + this.bytesPerChecksum - 1) / this.bytesPerChecksum;
            int packetLen = len + numChunks * this.checksumSize + 4;
            pkt.clear();
            pkt.putInt(packetLen);
            pkt.putLong(this.offset);
            pkt.putLong(this.seqno);
            pkt.put((byte)(this.offset + (long)len >= this.endOffset ? 1 : 0));
            pkt.putInt(len);
            int checksumOff = pkt.position();
            int checksumLen = numChunks * this.checksumSize;
            byte[] buf = pkt.array();
            if (this.checksumSize > 0 && this.checksumIn != null) {
                try {
                    this.checksumIn.readFully(buf, checksumOff, checksumLen);
                }
                catch (IOException e) {
                    LOG.warn((Object)(" Could not read or failed to veirfy checksum for data at offset " + this.offset + " for block " + this.block + " got : " + StringUtils.stringifyException(e)));
                    IOUtils.closeStream(this.checksumIn);
                    this.checksumIn = null;
                    if (this.corruptChecksumOk) {
                        Arrays.fill(buf, checksumOff, checksumLen, (byte)0);
                    }
                    throw e;
                }
            }
            int dataOff = checksumOff + checksumLen;
            IOUtils.readFully(this.blockIn, buf, dataOff, len);
            if (this.verifyChecksum) {
                int dOff = dataOff;
                int cOff = checksumOff;
                int dLeft = len;
                for (int i = 0; i < numChunks; ++i) {
                    this.checksum.reset();
                    int dLen = Math.min(dLeft, this.bytesPerChecksum);
                    this.checksum.update(buf, dOff, dLen);
                    if (!this.checksum.compare(buf, cOff)) {
                        throw new ChecksumException("Checksum failed at " + (this.offset + (long)len - (long)dLeft), len);
                    }
                    dLeft -= dLen;
                    dOff += dLen;
                    cOff += this.checksumSize;
                }
            }
            try {
                this.out.write(buf, 0, dataOff + len);
            }
            catch (IOException e) {
                if (e.getClass().equals(IOException.class)) {
                    SocketException se = new SocketException("Original Exception : " + e);
                    se.initCause(e);
                    se.setStackTrace(e.getStackTrace());
                    throw se;
                }
                throw e;
            }
            if (this.throttler != null) {
                this.throttler.throttle(packetLen);
            }
            return len;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long sendBlock(DataOutputStream out, Throttler throttler) throws IOException {
            if (out == null) {
                throw new IOException("out stream is null");
            }
            this.out = out;
            this.throttler = throttler;
            long initialOffset = this.offset;
            long totalRead = 0L;
            try {
                this.checksum.writeHeader(out);
                if (this.chunkOffsetOK) {
                    out.writeLong(this.offset);
                }
                int maxChunksPerPacket = Math.max(1, (FSConstants.BUFFER_SIZE + this.bytesPerChecksum - 1) / this.bytesPerChecksum);
                ByteBuffer pktBuf = ByteBuffer.allocate(25 + (this.bytesPerChecksum + this.checksumSize) * maxChunksPerPacket);
                while (this.endOffset > this.offset) {
                    long len = this.sendChunks(pktBuf, maxChunksPerPacket);
                    this.offset += len;
                    totalRead += len + (len + (long)this.bytesPerChecksum - 1L) / (long)this.bytesPerChecksum * (long)this.checksumSize;
                    ++this.seqno;
                }
                out.writeInt(0);
                out.flush();
            }
            finally {
                this.close();
            }
            this.blockReadFully = initialOffset == 0L && this.offset >= this.blockLength;
            return totalRead;
        }

        boolean isBlockReadFully() {
            return this.blockReadFully;
        }
    }

    static class Throttler {
        private long period;
        private long periodExtension;
        private long bytesPerPeriod;
        private long curPeriodStart = System.currentTimeMillis();
        private long curReserve;
        private long bytesAlreadyUsed;

        Throttler(long bandwidthPerSec) {
            this(500L, bandwidthPerSec);
        }

        Throttler(long period, long bandwidthPerSec) {
            this.period = period;
            this.curReserve = this.bytesPerPeriod = bandwidthPerSec * period / 1000L;
            this.periodExtension = period * 3L;
        }

        public synchronized long getBandwidth() {
            return this.bytesPerPeriod * 1000L / this.period;
        }

        public synchronized void setBandwidth(long bytesPerSecond) {
            if (bytesPerSecond <= 0L) {
                throw new IllegalArgumentException(DataNode.EMPTY_DEL_HINT + bytesPerSecond);
            }
            this.bytesPerPeriod = bytesPerSecond * this.period / 1000L;
        }

        public synchronized void throttle(long numOfBytes) {
            if (numOfBytes <= 0L) {
                return;
            }
            this.curReserve -= numOfBytes;
            this.bytesAlreadyUsed += numOfBytes;
            while (this.curReserve <= 0L) {
                long curPeriodEnd;
                long now = System.currentTimeMillis();
                if (now < (curPeriodEnd = this.curPeriodStart + this.period)) {
                    try {
                        this.wait(curPeriodEnd - now);
                    }
                    catch (InterruptedException ignored) {}
                    continue;
                }
                if (now < this.curPeriodStart + this.periodExtension) {
                    this.curPeriodStart = curPeriodEnd;
                    this.curReserve += this.bytesPerPeriod;
                    continue;
                }
                this.curPeriodStart = now;
                this.curReserve = this.bytesPerPeriod - this.bytesAlreadyUsed;
            }
            this.bytesAlreadyUsed -= numOfBytes;
        }
    }

    class DataXceiver
    implements Runnable {
        Socket s;
        String remoteAddress;
        String localAddress;

        public DataXceiver(Socket s) {
            this.s = s;
            DataNode.this.childSockets.put(s, s);
            InetSocketAddress isock = (InetSocketAddress)s.getRemoteSocketAddress();
            this.remoteAddress = isock.toString();
            this.localAddress = s.getInetAddress() + ":" + s.getLocalPort();
            LOG.debug((Object)("Number of active connections is: " + DataNode.this.getXceiverCount()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            DataInputStream in = null;
            try {
                in = new DataInputStream(new BufferedInputStream(NetUtils.getInputStream(this.s), FSConstants.BUFFER_SIZE));
                short version = in.readShort();
                if (version != 9) {
                    throw new IOException("Version Mismatch");
                }
                boolean local = this.s.getInetAddress().equals(this.s.getLocalAddress());
                byte op = in.readByte();
                int curXceiverCount = DataNode.this.getXceiverCount();
                if (curXceiverCount > DataNode.this.maxXceiverCount) {
                    throw new IOException("xceiverCount " + curXceiverCount + " exceeds the limit of concurrent xcievers " + DataNode.this.maxXceiverCount);
                }
                long startTime = DataNode.now();
                switch (op) {
                    case 81: {
                        this.readBlock(in);
                        ((DataNode)DataNode.this).myMetrics.readBlockOp.inc(DataNode.now() - startTime);
                        if (local) {
                            ((DataNode)DataNode.this).myMetrics.readsFromLocalClient.inc();
                            return;
                        } else {
                            ((DataNode)DataNode.this).myMetrics.readsFromRemoteClient.inc();
                            return;
                        }
                    }
                    case 80: {
                        this.writeBlock(in);
                        ((DataNode)DataNode.this).myMetrics.writeBlockOp.inc(DataNode.now() - startTime);
                        if (local) {
                            ((DataNode)DataNode.this).myMetrics.writesFromLocalClient.inc();
                            return;
                        } else {
                            ((DataNode)DataNode.this).myMetrics.writesFromRemoteClient.inc();
                            return;
                        }
                    }
                    case 82: {
                        this.readMetadata(in);
                        ((DataNode)DataNode.this).myMetrics.readMetadataOp.inc(DataNode.now() - startTime);
                        return;
                    }
                    case 83: {
                        this.replaceBlock(in);
                        ((DataNode)DataNode.this).myMetrics.replaceBlockOp.inc(DataNode.now() - startTime);
                        return;
                    }
                    case 84: {
                        this.copyBlock(in);
                        ((DataNode)DataNode.this).myMetrics.copyBlockOp.inc(DataNode.now() - startTime);
                        return;
                    }
                    default: {
                        throw new IOException("Unknown opcode " + op + " in data stream");
                    }
                }
            }
            catch (Throwable t) {
                LOG.error((Object)(DataNode.this.dnRegistration + ":DataXceiver: " + StringUtils.stringifyException(t)));
                return;
            }
            finally {
                LOG.debug((Object)(DataNode.this.dnRegistration + ":Number of active connections is: " + DataNode.this.getXceiverCount()));
                IOUtils.closeStream(in);
                IOUtils.closeSocket(this.s);
                DataNode.this.childSockets.remove(this.s);
            }
        }

        /*
         * Loose catch block
         */
        private void readBlock(DataInputStream in) throws IOException {
            block13: {
                long blockId = in.readLong();
                Block block = new Block(blockId, 0L);
                long startOffset = in.readLong();
                long length = in.readLong();
                DataOutputStream out = new DataOutputStream(new BufferedOutputStream(NetUtils.getOutputStream(this.s, DataNode.this.socketWriteTimeout), FSConstants.SMALL_BUFFER_SIZE));
                BlockSender blockSender = null;
                try {
                    try {
                        blockSender = new BlockSender(block, startOffset, length, true, true, false);
                    }
                    catch (IOException e) {
                        out.writeShort(1);
                        throw e;
                    }
                    out.writeShort(0);
                    long read = blockSender.sendBlock(out, null);
                    if (blockSender.isBlockReadFully()) {
                        try {
                            if (in.readShort() == 5 && DataNode.this.blockScanner != null) {
                                DataNode.this.blockScanner.verifiedByClient(block);
                            }
                        }
                        catch (IOException ignored) {
                            // empty catch block
                        }
                    }
                    ((DataNode)DataNode.this).myMetrics.bytesRead.inc((int)read);
                    ((DataNode)DataNode.this).myMetrics.blocksRead.inc();
                    LOG.info((Object)(DataNode.this.dnRegistration + " Served block " + block + " to " + this.s.getInetAddress()));
                    IOUtils.closeStream(out);
                }
                catch (SocketException ignored) {
                    ((DataNode)DataNode.this).myMetrics.blocksRead.inc();
                    break block13;
                }
                catch (IOException ioe) {
                    LOG.warn((Object)(DataNode.this.dnRegistration + ":Got exception while serving " + block + " to " + this.s.getInetAddress() + ":\n" + StringUtils.stringifyException(ioe)));
                    throw ioe;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    IOUtils.closeStream(out);
                    IOUtils.closeStream(blockSender);
                }
                IOUtils.closeStream(blockSender);
            }
        }

        private void writeBlock(DataInputStream in) throws IOException {
            LOG.debug((Object)("writeBlock receive buf size " + this.s.getReceiveBufferSize() + " tcp no delay " + this.s.getTcpNoDelay()));
            Block block = new Block(in.readLong(), DataNode.this.estimateBlockSize);
            LOG.info((Object)("Receiving block " + block + " src: " + this.remoteAddress + " dest: " + this.localAddress));
            int pipelineSize = in.readInt();
            boolean isRecovery = in.readBoolean();
            String client = Text.readString(in);
            int numTargets = in.readInt();
            if (numTargets < 0) {
                throw new IOException("Mislabelled incoming datastream.");
            }
            DatanodeInfo[] targets = new DatanodeInfo[numTargets];
            for (int i = 0; i < targets.length; ++i) {
                DatanodeInfo tmp = new DatanodeInfo();
                tmp.readFields(in);
                targets[i] = tmp;
            }
            DataOutputStream mirrorOut = null;
            DataInputStream mirrorIn = null;
            DataOutputStream replyOut = null;
            Socket mirrorSock = null;
            BlockReceiver blockReceiver = null;
            String mirrorNode = null;
            String firstBadLink = DataNode.EMPTY_DEL_HINT;
            try {
                blockReceiver = new BlockReceiver(block, in, this.s.getInetAddress().toString(), isRecovery, client);
                replyOut = new DataOutputStream(NetUtils.getOutputStream(this.s, DataNode.this.socketWriteTimeout));
                if (targets.length > 0) {
                    InetSocketAddress mirrorTarget = null;
                    mirrorNode = targets[0].getName();
                    mirrorTarget = NetUtils.createSocketAddr(mirrorNode);
                    mirrorSock = DataNode.this.newSocket();
                    try {
                        int timeoutValue = numTargets * DataNode.this.socketTimeout;
                        int writeTimeout = DataNode.this.socketWriteTimeout + 5000 * numTargets;
                        mirrorSock.connect(mirrorTarget, timeoutValue);
                        mirrorSock.setSoTimeout(timeoutValue);
                        mirrorSock.setSendBufferSize(131072);
                        mirrorOut = new DataOutputStream(new BufferedOutputStream(NetUtils.getOutputStream(mirrorSock, writeTimeout), FSConstants.BUFFER_SIZE));
                        mirrorIn = new DataInputStream(NetUtils.getInputStream(mirrorSock));
                        mirrorOut.writeShort(9);
                        mirrorOut.write(80);
                        mirrorOut.writeLong(block.getBlockId());
                        mirrorOut.writeInt(pipelineSize);
                        mirrorOut.writeBoolean(isRecovery);
                        Text.writeString(mirrorOut, client);
                        mirrorOut.writeInt(targets.length - 1);
                        for (int i = 1; i < targets.length; ++i) {
                            targets[i].write(mirrorOut);
                        }
                        blockReceiver.writeChecksumHeader(mirrorOut);
                        mirrorOut.flush();
                        if (client.length() != 0) {
                            firstBadLink = Text.readString(mirrorIn);
                            if (LOG.isDebugEnabled() || firstBadLink.length() > 0) {
                                LOG.info((Object)("Datanode " + targets.length + " got response for connect ack " + " from downstream datanode with firstbadlink as " + firstBadLink));
                            }
                        }
                    }
                    catch (IOException e) {
                        if (client.length() != 0) {
                            Text.writeString(replyOut, mirrorNode);
                            replyOut.flush();
                        }
                        IOUtils.closeStream(mirrorOut);
                        mirrorOut = null;
                        IOUtils.closeStream(mirrorIn);
                        mirrorIn = null;
                        IOUtils.closeSocket(mirrorSock);
                        mirrorSock = null;
                        if (client.length() > 0) {
                            throw e;
                        }
                        LOG.info((Object)(DataNode.this.dnRegistration + ":Exception transfering block " + block + " to mirror " + mirrorNode + ". continuing without the mirror.\n" + StringUtils.stringifyException(e)));
                    }
                }
                if (client.length() != 0) {
                    if (LOG.isDebugEnabled() || firstBadLink.length() > 0) {
                        LOG.info((Object)("Datanode " + targets.length + " forwarding connect ack to upstream firstbadlink is " + firstBadLink));
                    }
                    Text.writeString(replyOut, firstBadLink);
                    replyOut.flush();
                }
                String mirrorAddr = mirrorSock == null ? null : mirrorNode;
                blockReceiver.receiveBlock(mirrorOut, mirrorIn, replyOut, mirrorAddr, null, targets.length);
                if (client.length() == 0) {
                    DataNode.this.notifyNamenodeReceivedBlock(block, DataNode.EMPTY_DEL_HINT);
                    LOG.info((Object)("Received block " + block + " src: " + this.remoteAddress + " dest: " + this.localAddress + " of size " + block.getNumBytes()));
                }
                if (DataNode.this.blockScanner != null) {
                    DataNode.this.blockScanner.addBlock(block);
                }
            }
            catch (IOException ioe) {
                try {
                    LOG.info((Object)("writeBlock " + block + " received exception " + ioe));
                    throw ioe;
                }
                catch (Throwable throwable) {
                    IOUtils.closeStream(mirrorOut);
                    IOUtils.closeStream(mirrorIn);
                    IOUtils.closeStream(replyOut);
                    IOUtils.closeSocket(mirrorSock);
                    IOUtils.closeStream(blockReceiver);
                    throw throwable;
                }
            }
            IOUtils.closeStream(mirrorOut);
            IOUtils.closeStream(mirrorIn);
            IOUtils.closeStream(replyOut);
            IOUtils.closeSocket(mirrorSock);
            IOUtils.closeStream(blockReceiver);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void readMetadata(DataInputStream in) throws IOException {
            Block block = new Block(in.readLong(), 0L);
            FSDatasetInterface.MetaDataInputStream checksumIn = null;
            DataOutputStream out = null;
            try {
                checksumIn = DataNode.this.data.getMetaDataInputStream(block);
                long fileSize = checksumIn.getLength();
                if (fileSize >= 0x80000000L || fileSize <= 0L) {
                    throw new IOException("Unexpected size for checksumFile of block" + block);
                }
                byte[] buf = new byte[(int)fileSize];
                IOUtils.readFully(checksumIn, buf, 0, buf.length);
                out = new DataOutputStream(NetUtils.getOutputStream(this.s, DataNode.this.socketWriteTimeout));
                out.writeByte(0);
                out.writeInt(buf.length);
                out.write(buf);
                out.writeInt(0);
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(out);
                IOUtils.closeStream(checksumIn);
                throw throwable;
            }
            IOUtils.closeStream(out);
            IOUtils.closeStream(checksumIn);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void copyBlock(DataInputStream in) throws IOException {
            long blockId = in.readLong();
            Block block = new Block(blockId, 0L);
            String source = Text.readString(in);
            DatanodeInfo target = new DatanodeInfo();
            target.readFields(in);
            Socket targetSock = null;
            short opStatus = 0;
            BlockSender blockSender = null;
            DataOutputStream targetOut = null;
            try {
                DataNode.this.balancingSem.acquireUninterruptibly();
                blockSender = new BlockSender(block, 0L, -1L, false, false, false);
                InetSocketAddress targetAddr = NetUtils.createSocketAddr(target.getName());
                targetSock = DataNode.this.newSocket();
                targetSock.connect(targetAddr, DataNode.this.socketTimeout);
                targetSock.setSoTimeout(DataNode.this.socketTimeout);
                targetOut = new DataOutputStream(new BufferedOutputStream(NetUtils.getOutputStream(targetSock, DataNode.this.socketWriteTimeout), FSConstants.SMALL_BUFFER_SIZE));
                targetOut.writeShort(9);
                targetOut.writeByte(83);
                targetOut.writeLong(block.getBlockId());
                Text.writeString(targetOut, source);
                long read = blockSender.sendBlock(targetOut, DataNode.this.balancingThrottler);
                ((DataNode)DataNode.this).myMetrics.bytesRead.inc((int)read);
                ((DataNode)DataNode.this).myMetrics.blocksRead.inc();
                DataNode.receiveResponse(targetSock, 1);
                LOG.info((Object)("Copied block " + block + " to " + targetAddr));
            }
            catch (IOException ioe) {
                try {
                    opStatus = 1;
                    LOG.warn((Object)("Got exception while serving " + block + " to " + target.getName() + ": " + StringUtils.stringifyException(ioe)));
                    throw ioe;
                }
                catch (Throwable throwable) {
                    try {
                        DataNode.sendResponse(this.s, opStatus, DataNode.this.socketWriteTimeout);
                    }
                    catch (IOException replyE) {
                        LOG.warn((Object)("Error writing the response back to " + this.s.getRemoteSocketAddress() + "\n" + StringUtils.stringifyException(replyE)));
                    }
                    IOUtils.closeStream(targetOut);
                    IOUtils.closeStream(blockSender);
                    DataNode.this.balancingSem.release();
                    throw throwable;
                }
            }
            try {
                DataNode.sendResponse(this.s, opStatus, DataNode.this.socketWriteTimeout);
            }
            catch (IOException replyE) {
                LOG.warn((Object)("Error writing the response back to " + this.s.getRemoteSocketAddress() + "\n" + StringUtils.stringifyException(replyE)));
            }
            IOUtils.closeStream(targetOut);
            IOUtils.closeStream(blockSender);
            DataNode.this.balancingSem.release();
        }

        private void replaceBlock(DataInputStream in) throws IOException {
            DataNode.this.balancingSem.acquireUninterruptibly();
            Block block = new Block(in.readLong(), DataNode.this.estimateBlockSize);
            String sourceID = Text.readString(in);
            short opStatus = 0;
            BlockReceiver blockReceiver = null;
            try {
                blockReceiver = new BlockReceiver(block, in, this.s.getRemoteSocketAddress().toString(), false, DataNode.EMPTY_DEL_HINT);
                blockReceiver.receiveBlock(null, null, null, null, DataNode.this.balancingThrottler, -1);
                DataNode.this.notifyNamenodeReceivedBlock(block, sourceID);
                LOG.info((Object)("Moved block " + block + " from " + this.s.getRemoteSocketAddress()));
            }
            catch (IOException ioe) {
                opStatus = 1;
                throw ioe;
            }
            finally {
                try {
                    DataNode.sendResponse(this.s, opStatus, DataNode.this.socketWriteTimeout);
                }
                catch (IOException ioe) {
                    LOG.warn((Object)("Error writing reply back to " + this.s.getRemoteSocketAddress()));
                }
                IOUtils.closeStream(blockReceiver);
                DataNode.this.balancingSem.release();
            }
        }
    }

    class DataXceiveServer
    implements Runnable {
        ServerSocket ss;

        public DataXceiveServer(ServerSocket ss) {
            this.ss = ss;
        }

        public void run() {
            while (DataNode.this.shouldRun) {
                try {
                    Socket s = this.ss.accept();
                    s.setTcpNoDelay(true);
                    new Daemon(DataNode.this.threadGroup, new DataXceiver(s)).start();
                }
                catch (IOException ie) {
                    LOG.warn((Object)(DataNode.this.dnRegistration + ":DataXceiveServer: " + StringUtils.stringifyException(ie)));
                }
                catch (Throwable te) {
                    LOG.error((Object)(DataNode.this.dnRegistration + ":DataXceiveServer: Exiting due to:" + StringUtils.stringifyException(te)));
                    DataNode.this.shouldRun = false;
                }
            }
            try {
                this.ss.close();
            }
            catch (IOException ie) {
                LOG.warn((Object)(DataNode.this.dnRegistration + ":DataXceiveServer: " + StringUtils.stringifyException(ie)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void kill() {
            assert (!DataNode.this.shouldRun) : "shoudRun should be set to false before killing";
            try {
                this.ss.close();
            }
            catch (IOException ie) {
                LOG.warn((Object)(DataNode.this.dnRegistration + ":DataXceiveServer.kill(): " + StringUtils.stringifyException(ie)));
            }
            Map<Socket, Socket> map = DataNode.this.childSockets;
            synchronized (map) {
                for (Socket thissock : DataNode.this.childSockets.values()) {
                    try {
                        thissock.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }
}

