/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import org.apache.hadoop.dfs.DataNode;
import org.apache.hadoop.dfs.FSConstants;
import org.apache.hadoop.dfs.InconsistentFSStateException;
import org.apache.hadoop.dfs.IncorrectVersionException;
import org.apache.hadoop.dfs.NamespaceInfo;
import org.apache.hadoop.dfs.Storage;
import org.apache.hadoop.dfs.StorageInfo;
import org.apache.hadoop.dfs.UpgradeManagerDatanode;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.util.Daemon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataStorage
extends Storage {
    static final String BLOCK_SUBDIR_PREFIX = "subdir";
    static final String BLOCK_FILE_PREFIX = "blk_";
    static final String COPY_FILE_PREFIX = "dncp_";
    private String storageID;

    DataStorage() {
        super(FSConstants.NodeType.DATA_NODE);
        this.storageID = "";
    }

    DataStorage(int nsID, long cT, String strgID) {
        super(FSConstants.NodeType.DATA_NODE, nsID, cT);
        this.storageID = strgID;
    }

    DataStorage(StorageInfo storageInfo, String strgID) {
        super(FSConstants.NodeType.DATA_NODE, storageInfo);
        this.storageID = strgID;
    }

    String getStorageID() {
        return this.storageID;
    }

    void setStorageID(String newStorageID) {
        this.storageID = newStorageID;
    }

    void recoverTransitionRead(NamespaceInfo nsInfo, Collection<File> dataDirs, FSConstants.StartupOption startOpt) throws IOException {
        assert (-13 == nsInfo.getLayoutVersion()) : "Data-node and name-node layout versions must be the same.";
        this.storageID = "";
        this.storageDirs = new ArrayList(dataDirs.size());
        ArrayList<Storage.StorageState> dataDirStates = new ArrayList<Storage.StorageState>(dataDirs.size());
        Iterator<File> it = dataDirs.iterator();
        block8: while (it.hasNext()) {
            Storage.StorageState curState;
            File dataDir = it.next();
            Storage.StorageDirectory sd = new Storage.StorageDirectory(this, dataDir);
            try {
                curState = sd.analyzeStorage(startOpt);
                switch (curState) {
                    case NORMAL: {
                        break;
                    }
                    case NON_EXISTENT: {
                        LOG.info((Object)("Storage directory " + dataDir + " does not exist."));
                        it.remove();
                        continue block8;
                    }
                    case CONVERT: {
                        this.convertLayout(sd, nsInfo);
                        break;
                    }
                    case NOT_FORMATTED: {
                        LOG.info((Object)("Storage directory " + dataDir + " is not formatted."));
                        LOG.info((Object)"Formatting ...");
                        this.format(sd, nsInfo);
                        break;
                    }
                    default: {
                        sd.doRecover(curState);
                        break;
                    }
                }
            }
            catch (IOException ioe) {
                sd.unlock();
                throw ioe;
            }
            this.addStorageDir(sd);
            dataDirStates.add(curState);
        }
        if (dataDirs.size() == 0) {
            throw new IOException("All specified directories are not accessible or do not exist.");
        }
        for (int idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            this.doTransition(this.getStorageDir(idx), nsInfo, startOpt);
            assert (this.getLayoutVersion() == nsInfo.getLayoutVersion()) : "Data-node and name-node layout versions must be the same.";
            assert (this.getCTime() == nsInfo.getCTime()) : "Data-node and name-node CTimes must be the same.";
        }
        this.writeAll();
    }

    void format(Storage.StorageDirectory sd, NamespaceInfo nsInfo) throws IOException {
        sd.clearDirectory();
        this.layoutVersion = -13;
        this.namespaceID = nsInfo.getNamespaceID();
        this.cTime = 0L;
        sd.write();
    }

    @Override
    protected void setFields(Properties props, Storage.StorageDirectory sd) throws IOException {
        super.setFields(props, sd);
        props.setProperty("storageID", this.storageID);
    }

    @Override
    protected void getFields(Properties props, Storage.StorageDirectory sd) throws IOException {
        super.getFields(props, sd);
        String ssid = props.getProperty("storageID");
        if (ssid == null || !"".equals(this.storageID) && !"".equals(ssid) && !this.storageID.equals(ssid)) {
            throw new InconsistentFSStateException(sd.root, "has incompatible storage Id.");
        }
        if ("".equals(this.storageID)) {
            this.storageID = ssid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean isConversionNeeded(Storage.StorageDirectory sd) throws IOException {
        File oldF = new File(sd.root, "storage");
        if (!oldF.exists()) {
            return false;
        }
        RandomAccessFile oldFile = new RandomAccessFile(oldF, "rws");
        FileLock oldLock = oldFile.getChannel().tryLock();
        try {
            oldFile.seek(0L);
            int odlVersion = oldFile.readInt();
            if (odlVersion < -3) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            oldLock.release();
            oldFile.close();
        }
        File oldDataDir = new File(sd.root, "data");
        if (!oldDataDir.exists()) {
            throw new InconsistentFSStateException(sd.root, "Old layout block directory " + oldDataDir + " is missing");
        }
        if (!oldDataDir.isDirectory()) {
            throw new InconsistentFSStateException(sd.root, oldDataDir + " is not a directory.");
        }
        if (!oldDataDir.canWrite()) {
            throw new InconsistentFSStateException(sd.root, oldDataDir + " is not writable.");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertLayout(Storage.StorageDirectory sd, NamespaceInfo nsInfo) throws IOException {
        File oldF = new File(sd.root, "storage");
        File oldDataDir = new File(sd.root, "data");
        assert (oldF.exists()) : "Old datanode layout \"storage\" file is missing";
        assert (oldDataDir.exists()) : "Old layout block directory \"data\" is missing";
        LOG.info((Object)("Old layout version file " + oldF + " is found. New layout version is " + -13));
        LOG.info((Object)"Converting ...");
        RandomAccessFile oldFile = new RandomAccessFile(oldF, "rws");
        FileLock oldLock = oldFile.getChannel().tryLock();
        if (oldLock == null) {
            throw new IOException("Cannot lock file: " + oldF);
        }
        String odlStorageID = "";
        try {
            oldFile.seek(0L);
            int odlVersion = oldFile.readInt();
            if (odlVersion < -3) {
                throw new IncorrectVersionException(odlVersion, "file " + oldF, -3);
            }
            odlStorageID = UTF8.readString(oldFile);
            File newDataDir = sd.getCurrentDir();
            File versionF = sd.getVersionFile();
            if (versionF.exists()) {
                throw new IOException("Version file already exists: " + versionF);
            }
            if (newDataDir.exists()) {
                DataStorage.deleteDir(newDataDir);
            }
            DataStorage.rename(oldDataDir, newDataDir);
        }
        finally {
            oldLock.release();
            oldFile.close();
        }
        DataStorage.rename(oldF, new File(sd.getCurrentDir(), "storage"));
        this.layoutVersion = -13;
        this.namespaceID = nsInfo.getNamespaceID();
        this.cTime = 0L;
        this.storageID = odlStorageID;
        sd.write();
        LOG.info((Object)("Conversion of " + oldF + " is complete."));
    }

    private void doTransition(Storage.StorageDirectory sd, NamespaceInfo nsInfo, FSConstants.StartupOption startOpt) throws IOException {
        if (startOpt == FSConstants.StartupOption.ROLLBACK) {
            this.doRollback(sd, nsInfo);
        }
        sd.read();
        assert (this.layoutVersion >= -13) : "Future version is not allowed";
        if (this.getNamespaceID() != nsInfo.getNamespaceID()) {
            throw new IOException("Incompatible namespaceIDs in " + sd.root.getCanonicalPath() + ": namenode namespaceID = " + nsInfo.getNamespaceID() + "; datanode namespaceID = " + this.getNamespaceID());
        }
        if (this.layoutVersion == -13 && this.cTime == nsInfo.getCTime()) {
            return;
        }
        this.verifyDistributedUpgradeProgress(nsInfo);
        if (this.layoutVersion > -13 || this.cTime < nsInfo.getCTime()) {
            this.doUpgrade(sd, nsInfo);
            return;
        }
        throw new IOException("Datanode state: LV = " + this.getLayoutVersion() + " CTime = " + this.getCTime() + " is newer than the namespace state: LV = " + nsInfo.getLayoutVersion() + " CTime = " + nsInfo.getCTime());
    }

    void doUpgrade(Storage.StorageDirectory sd, NamespaceInfo nsInfo) throws IOException {
        LOG.info((Object)("Upgrading storage directory " + sd.root + ".\n   old LV = " + this.getLayoutVersion() + "; old CTime = " + this.getCTime() + ".\n   new LV = " + nsInfo.getLayoutVersion() + "; new CTime = " + nsInfo.getCTime()));
        File curDir = sd.getCurrentDir();
        File prevDir = sd.getPreviousDir();
        assert (curDir.exists()) : "Current directory must exist.";
        if (prevDir.exists()) {
            DataStorage.deleteDir(prevDir);
        }
        File tmpDir = sd.getPreviousTmp();
        assert (!tmpDir.exists()) : "previous.tmp directory must not exist.";
        DataStorage.rename(curDir, tmpDir);
        DataStorage.linkBlocks(tmpDir, curDir);
        this.layoutVersion = -13;
        assert (this.namespaceID == nsInfo.getNamespaceID()) : "Data-node and name-node layout versions must be the same.";
        this.cTime = nsInfo.getCTime();
        sd.write();
        DataStorage.rename(tmpDir, prevDir);
        LOG.info((Object)("Upgrade of " + sd.root + " is complete."));
    }

    void doRollback(Storage.StorageDirectory sd, NamespaceInfo nsInfo) throws IOException {
        DataStorage prevInfo;
        File prevDir = sd.getPreviousDir();
        if (!prevDir.exists()) {
            return;
        }
        DataStorage dataStorage = prevInfo = new DataStorage();
        dataStorage.getClass();
        Storage.StorageDirectory prevSD = new Storage.StorageDirectory(dataStorage, sd.root);
        prevSD.read(prevSD.getPreviousVersionFile());
        if (prevInfo.getLayoutVersion() < -13 || prevInfo.getCTime() > nsInfo.getCTime()) {
            throw new InconsistentFSStateException(prevSD.root, "Cannot rollback to a newer state.\nDatanode previous state: LV = " + prevInfo.getLayoutVersion() + " CTime = " + prevInfo.getCTime() + " is newer than the namespace state: LV = " + nsInfo.getLayoutVersion() + " CTime = " + nsInfo.getCTime());
        }
        LOG.info((Object)("Rolling back storage directory " + sd.root + ".\n   target LV = " + nsInfo.getLayoutVersion() + "; target CTime = " + nsInfo.getCTime()));
        File tmpDir = sd.getRemovedTmp();
        assert (!tmpDir.exists()) : "removed.tmp directory must not exist.";
        File curDir = sd.getCurrentDir();
        assert (curDir.exists()) : "Current directory must exist.";
        DataStorage.rename(curDir, tmpDir);
        DataStorage.rename(prevDir, curDir);
        DataStorage.deleteDir(tmpDir);
        LOG.info((Object)("Rollback of " + sd.root + " is complete."));
    }

    void doFinalize(Storage.StorageDirectory sd) throws IOException {
        File prevDir = sd.getPreviousDir();
        if (!prevDir.exists()) {
            return;
        }
        final String dataDirPath = sd.root.getCanonicalPath();
        LOG.info((Object)("Finalizing upgrade for storage directory " + dataDirPath + ".\n   cur LV = " + this.getLayoutVersion() + "; cur CTime = " + this.getCTime()));
        assert (sd.getCurrentDir().exists()) : "Current directory must exist.";
        final File tmpDir = sd.getFinalizedTmp();
        DataStorage.rename(prevDir, tmpDir);
        new Daemon(new Runnable(){

            public void run() {
                try {
                    Storage.deleteDir(tmpDir);
                }
                catch (IOException ex) {
                    Storage.LOG.error((Object)("Finalize upgrade for " + dataDirPath + " failed."), (Throwable)ex);
                }
                Storage.LOG.info((Object)("Finalize upgrade for " + dataDirPath + " is complete."));
            }

            public String toString() {
                return "Finalize " + dataDirPath;
            }
        }).start();
    }

    void finalizeUpgrade() throws IOException {
        Iterator it = this.storageDirs.iterator();
        while (it.hasNext()) {
            this.doFinalize((Storage.StorageDirectory)it.next());
        }
    }

    static void linkBlocks(File from, File to) throws IOException {
        if (!from.isDirectory()) {
            if (from.getName().startsWith(COPY_FILE_PREFIX)) {
                IOUtils.copyBytes((InputStream)new FileInputStream(from), (OutputStream)new FileOutputStream(to), 16384, true);
            } else {
                FileUtil.HardLink.createHardLink(from, to);
            }
            return;
        }
        if (!to.mkdir()) {
            throw new IOException("Cannot create directory " + to);
        }
        String[] blockNames = from.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(DataStorage.BLOCK_SUBDIR_PREFIX) || name.startsWith(DataStorage.BLOCK_FILE_PREFIX) || name.startsWith(DataStorage.COPY_FILE_PREFIX);
            }
        });
        for (int i = 0; i < blockNames.length; ++i) {
            DataStorage.linkBlocks(new File(from, blockNames[i]), new File(to, blockNames[i]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void corruptPreUpgradeStorage(File rootDir) throws IOException {
        File oldF = new File(rootDir, "storage");
        if (oldF.exists()) {
            return;
        }
        if (!oldF.createNewFile()) {
            throw new IOException("Cannot create file " + oldF);
        }
        RandomAccessFile oldFile = new RandomAccessFile(oldF, "rws");
        try {
            this.writeCorruptedData(oldFile);
        }
        finally {
            oldFile.close();
        }
    }

    private void verifyDistributedUpgradeProgress(NamespaceInfo nsInfo) throws IOException {
        UpgradeManagerDatanode um = DataNode.getDataNode().upgradeManager;
        assert (um != null) : "DataNode.upgradeManager is null.";
        um.setUpgradeState(false, this.getLayoutVersion());
        um.initializeUpgrade(nsInfo);
    }
}

