/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.WritableComparable;

public class DatanodeID
implements WritableComparable {
    protected String name;
    protected String storageID;
    protected int infoPort;

    public DatanodeID() {
        this("", "", -1);
    }

    public DatanodeID(DatanodeID from) {
        this(from.getName(), from.getStorageID(), from.getInfoPort());
    }

    public DatanodeID(String nodeName, String storageID, int infoPort) {
        this.name = nodeName;
        this.storageID = storageID;
        this.infoPort = infoPort;
    }

    public String getName() {
        return this.name;
    }

    public String getStorageID() {
        return this.storageID;
    }

    public int getInfoPort() {
        return this.infoPort;
    }

    void setStorageID(String storageID) {
        this.storageID = storageID;
    }

    public String getHost() {
        int colon = this.name.indexOf(":");
        if (colon < 0) {
            return this.name;
        }
        return this.name.substring(0, colon);
    }

    public int getPort() {
        int colon = this.name.indexOf(":");
        if (colon < 0) {
            return 50010;
        }
        return Integer.parseInt(this.name.substring(colon + 1));
    }

    public boolean equals(Object to) {
        if (this == to) {
            return true;
        }
        if (!(to instanceof DatanodeID)) {
            return false;
        }
        return this.name.equals(((DatanodeID)to).getName()) && this.storageID.equals(((DatanodeID)to).getStorageID());
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.storageID.hashCode();
    }

    public String toString() {
        return this.name;
    }

    void updateRegInfo(DatanodeID nodeReg) {
        this.name = nodeReg.getName();
        this.infoPort = nodeReg.getInfoPort();
    }

    public int compareTo(Object o) {
        return this.name.compareTo(((DatanodeID)o).getName());
    }

    public void write(DataOutput out) throws IOException {
        UTF8.writeString(out, this.name);
        UTF8.writeString(out, this.storageID);
        out.writeShort(this.infoPort);
    }

    public void readFields(DataInput in) throws IOException {
        this.name = UTF8.readString(in);
        this.storageID = UTF8.readString(in);
        this.infoPort = in.readShort() & 0xFFFF;
    }
}

