/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

class GenerationStamp
implements WritableComparable {
    long genstamp;

    public GenerationStamp() {
        this.genstamp = 0L;
    }

    public GenerationStamp(long stamp) {
        this.genstamp = stamp;
    }

    public long getStamp() {
        return this.genstamp;
    }

    public void setStamp(long stamp) {
        this.genstamp = stamp;
    }

    public long nextStamp() {
        ++this.genstamp;
        return this.genstamp;
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.genstamp);
    }

    public void readFields(DataInput in) throws IOException {
        this.genstamp = in.readLong();
        if (this.genstamp < 0L) {
            throw new IOException("Bad Generation Stamp: " + this.genstamp);
        }
    }

    public int compareTo(Object o) {
        GenerationStamp b = (GenerationStamp)o;
        if (this.genstamp < b.genstamp) {
            return -1;
        }
        if (this.genstamp == b.genstamp) {
            return 0;
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (!(o instanceof GenerationStamp)) {
            return false;
        }
        return this.genstamp == ((GenerationStamp)o).genstamp;
    }

    public int hashCode() {
        return 629 + (int)(this.genstamp ^ this.genstamp >>> 32);
    }

    static {
        WritableFactories.setFactory(GenerationStamp.class, new WritableFactory(){

            public Writable newInstance() {
                return new GenerationStamp();
            }
        });
    }
}

