/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dfs.ClientProtocol;
import org.apache.hadoop.dfs.FSConstants;
import org.apache.hadoop.dfs.FSImage;
import org.apache.hadoop.dfs.FSNamesystem;
import org.apache.hadoop.dfs.TransferFsImage;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.mapred.StatusHttpServer;
import org.apache.hadoop.metrics.jvm.JvmMetrics;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.StringUtils;

public class SecondaryNameNode
implements FSConstants,
Runnable {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.dfs.NameNode.Secondary");
    private static final String SRC_FS_IMAGE = "srcimage.tmp";
    private static final String FS_EDITS = "edits.tmp";
    private static final String DEST_FS_IMAGE = "destimage.tmp";
    private ClientProtocol namenode;
    private Configuration conf;
    private InetSocketAddress nameNodeAddr;
    private boolean shouldRun;
    private StatusHttpServer infoServer;
    private int infoPort;
    private String infoBindAddress;
    private File checkpointDir;
    private long checkpointPeriod;
    private long checkpointSize;
    private File srcImage;
    private File destImage;
    private File editFile;

    public SecondaryNameNode(Configuration conf) throws IOException {
        JvmMetrics.init("SecondaryNameNode", conf.get("session.id"));
        this.shouldRun = true;
        this.nameNodeAddr = NetUtils.createSocketAddr(FileSystem.getDefaultUri(conf).getAuthority());
        this.conf = conf;
        this.namenode = (ClientProtocol)RPC.waitForProxy(ClientProtocol.class, 29L, this.nameNodeAddr, conf);
        String infoAddr = NetUtils.getServerAddress(conf, "dfs.secondary.info.bindAddress", "dfs.secondary.info.port", "dfs.secondary.http.address");
        InetSocketAddress infoSocAddr = NetUtils.createSocketAddr(infoAddr);
        this.infoBindAddress = infoSocAddr.getHostName();
        int tmpInfoPort = infoSocAddr.getPort();
        this.infoServer = new StatusHttpServer("dfs", this.infoBindAddress, tmpInfoPort, tmpInfoPort == 0);
        this.infoServer.setAttribute("name.secondary", this);
        this.infoServer.setAttribute("name.conf", conf);
        this.infoServer.addServlet("getimage", "/getimage", GetImageServlet.class);
        this.infoServer.start();
        this.infoPort = this.infoServer.getPort();
        conf.set("dfs.secondary.http.address", this.infoBindAddress + ":" + this.infoPort);
        LOG.info((Object)("Secondary Web-server up at: " + this.infoBindAddress + ":" + this.infoPort));
        String[] dirName = conf.getStrings("fs.checkpoint.dir");
        this.checkpointDir = new File(dirName[0]);
        this.checkpointPeriod = conf.getLong("fs.checkpoint.period", 3600L);
        this.checkpointSize = conf.getLong("fs.checkpoint.size", 0x400000L);
        this.doSetup();
        LOG.warn((Object)("Checkpoint Directory:" + this.checkpointDir));
        LOG.warn((Object)("Checkpoint Period   :" + this.checkpointPeriod + " secs " + "(" + this.checkpointPeriod / 60L + " min)"));
        LOG.warn((Object)("Log Size Trigger    :" + this.checkpointSize + " bytes " + "(" + this.checkpointSize / 1024L + " KB)"));
    }

    public void shutdown() {
        this.shouldRun = false;
        try {
            this.infoServer.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doSetup() throws IOException {
        this.checkpointDir.mkdirs();
        this.srcImage = new File(this.checkpointDir, SRC_FS_IMAGE);
        this.destImage = new File(this.checkpointDir, DEST_FS_IMAGE);
        this.editFile = new File(this.checkpointDir, FS_EDITS);
        this.srcImage.delete();
        this.destImage.delete();
        this.editFile.delete();
    }

    File getNewImage() {
        return this.destImage;
    }

    public void run() {
        long period = 300L;
        long lastCheckpointTime = 0L;
        if (this.checkpointPeriod < period) {
            period = this.checkpointPeriod;
        }
        while (this.shouldRun) {
            try {
                Thread.sleep(1000L * period);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if (!this.shouldRun) break;
            try {
                long now = System.currentTimeMillis();
                long size = this.namenode.getEditLogSize();
                if (size < this.checkpointSize && now < lastCheckpointTime + 1000L * this.checkpointPeriod) continue;
                this.doCheckpoint();
                lastCheckpointTime = now;
            }
            catch (IOException e) {
                LOG.error((Object)"Exception in doCheckpoint:");
                LOG.error((Object)StringUtils.stringifyException(e));
                e.printStackTrace();
            }
            catch (Throwable e) {
                LOG.error((Object)"Throwable Exception in doCheckpoint:");
                LOG.error((Object)StringUtils.stringifyException(e));
                e.printStackTrace();
                Runtime.getRuntime().exit(-1);
            }
        }
    }

    private void getFSImage() throws IOException {
        String fsName = this.getInfoServer();
        String fileid = "getimage=1";
        TransferFsImage.getFileClient(fsName, fileid, this.srcImage);
        LOG.info((Object)("Downloaded file " + this.srcImage + " size " + this.srcImage.length() + " bytes."));
    }

    private void getFSEdits() throws IOException {
        String fsName = this.getInfoServer();
        String fileid = "getedit=1";
        TransferFsImage.getFileClient(fsName, fileid, this.editFile);
        LOG.info((Object)("Downloaded file " + this.editFile + " size " + this.editFile.length() + " bytes."));
    }

    private void putFSImage(long token) throws IOException {
        String fsName = this.getInfoServer();
        String fileid = "putimage=1&port=" + this.infoPort + "&machine=" + InetAddress.getLocalHost().getHostAddress() + "&token=" + token;
        LOG.info((Object)("Posted URL " + fsName + fileid));
        TransferFsImage.getFileClient(fsName, fileid, (File[])null);
    }

    private String getInfoServer() throws IOException {
        URI fsName = FileSystem.getDefaultUri(this.conf);
        if (!"hdfs".equals(fsName.getScheme())) {
            throw new IOException("This is not a DFS");
        }
        return NetUtils.getServerAddress(this.conf, "dfs.info.bindAddress", "dfs.info.port", "dfs.http.address");
    }

    void doCheckpoint() throws IOException {
        this.doSetup();
        long token = this.namenode.rollEditLog();
        if (ErrorSimulator.getErrorSimulation(0)) {
            throw new IOException("Simulating error0 after creating edits.new");
        }
        this.getFSImage();
        this.getFSEdits();
        this.doMerge();
        this.putFSImage(token);
        if (ErrorSimulator.getErrorSimulation(1)) {
            throw new IOException("Simulating error1 after uploading new image to NameNode");
        }
        this.namenode.rollFsImage();
        LOG.warn((Object)("Checkpoint done. Image Size:" + this.srcImage.length() + " Edit Size:" + this.editFile.length() + " New Image Size:" + this.destImage.length()));
    }

    private void doMerge() throws IOException {
        FSNamesystem namesystem = new FSNamesystem(new FSImage(this.checkpointDir), this.conf);
        FSImage fsImage = namesystem.dir.fsImage;
        fsImage.loadFSImage(this.srcImage);
        fsImage.getEditLog().loadFSEdits(this.editFile);
        fsImage.saveFSImage(this.destImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int processArgs(String[] argv) throws Exception {
        int exitCode;
        block18: {
            String cmd;
            if (argv.length < 1) {
                this.printUsage("");
                return -1;
            }
            exitCode = -1;
            int i = 0;
            if ("-geteditsize".equals(cmd = argv[i++])) {
                if (argv.length != 1) {
                    this.printUsage(cmd);
                    return exitCode;
                }
            } else if ("-checkpoint".equals(cmd)) {
                if (argv.length != 1 && argv.length != 2) {
                    this.printUsage(cmd);
                    return exitCode;
                }
                if (argv.length == 2 && !"force".equals(argv[i])) {
                    this.printUsage(cmd);
                    return exitCode;
                }
            }
            exitCode = 0;
            try {
                if ("-checkpoint".equals(cmd)) {
                    long size = this.namenode.getEditLogSize();
                    if (size >= this.checkpointSize || argv.length == 2 && "force".equals(argv[i])) {
                        this.doCheckpoint();
                    } else {
                        System.err.println("EditLog size " + size + " bytes is " + "smaller than configured checkpoint " + "size " + this.checkpointSize + " bytes.");
                        System.err.println("Skipping checkpoint.");
                    }
                    break block18;
                }
                if ("-geteditsize".equals(cmd)) {
                    long size = this.namenode.getEditLogSize();
                    System.out.println("EditLog size is " + size + " bytes");
                    break block18;
                }
                exitCode = -1;
                LOG.error((Object)(cmd.substring(1) + ": Unknown command"));
                this.printUsage("");
            }
            catch (RemoteException e) {
                exitCode = -1;
                try {
                    String[] content = e.getLocalizedMessage().split("\n");
                    LOG.error((Object)(cmd.substring(1) + ": " + content[0]));
                }
                catch (Exception ex) {
                    LOG.error((Object)(cmd.substring(1) + ": " + ex.getLocalizedMessage()));
                }
            }
            catch (IOException e) {
                exitCode = -1;
                LOG.error((Object)(cmd.substring(1) + ": " + e.getLocalizedMessage()));
            }
        }
        return exitCode;
    }

    private void printUsage(String cmd) {
        if ("-geteditsize".equals(cmd)) {
            System.err.println("Usage: java SecondaryNameNode [-geteditsize]");
        } else if ("-checkpoint".equals(cmd)) {
            System.err.println("Usage: java SecondaryNameNode [-checkpoint [force]]");
        } else {
            System.err.println("Usage: java SecondaryNameNode [-checkpoint [force]] [-geteditsize] ");
        }
    }

    public static void main(String[] argv) throws Exception {
        StringUtils.startupShutdownMessage(SecondaryNameNode.class, argv, LOG);
        Configuration tconf = new Configuration();
        if (argv.length >= 1) {
            SecondaryNameNode secondary = new SecondaryNameNode(tconf);
            int ret = secondary.processArgs(argv);
            System.exit(ret);
        }
        Daemon checkpointThread = new Daemon(new SecondaryNameNode(tconf));
        checkpointThread.start();
    }

    public static class GetImageServlet
    extends HttpServlet {
        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            Map pmap = request.getParameterMap();
            try {
                ServletContext context = this.getServletContext();
                SecondaryNameNode nn = (SecondaryNameNode)context.getAttribute("name.secondary");
                TransferFsImage ff = new TransferFsImage(pmap, request, response);
                if (ff.getImage()) {
                    TransferFsImage.getFileServer((OutputStream)response.getOutputStream(), nn.getNewImage());
                }
                LOG.info((Object)("New Image " + nn.getNewImage() + " retrieved by Namenode."));
            }
            catch (Exception ie) {
                String errMsg = "GetImage failed. " + StringUtils.stringifyException(ie);
                response.sendError(410, errMsg);
                throw new IOException(errMsg);
            }
            finally {
                response.getOutputStream().close();
            }
        }
    }

    static class ErrorSimulator {
        private static boolean[] simulation = null;

        ErrorSimulator() {
        }

        static void initializeErrorSimulationEvent(int numberOfEvents) {
            simulation = new boolean[numberOfEvents];
            for (int i = 0; i < numberOfEvents; ++i) {
                ErrorSimulator.simulation[i] = false;
            }
        }

        static boolean getErrorSimulation(int index) {
            if (simulation == null) {
                return false;
            }
            assert (index < simulation.length);
            return simulation[index];
        }

        static void setErrorSimulation(int index) {
            assert (index < simulation.length);
            ErrorSimulator.simulation[index] = true;
        }

        static void clearErrorSimulation(int index) {
            assert (index < simulation.length);
            ErrorSimulator.simulation[index] = false;
        }
    }
}

