/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs.namenode.metrics;

import javax.management.ObjectName;
import org.apache.hadoop.dfs.NameNodeMetrics;
import org.apache.hadoop.dfs.namenode.metrics.NameNodeStatisticsMBean;
import org.apache.hadoop.metrics.util.MBeanUtil;

public class NameNodeStatistics
implements NameNodeStatisticsMBean {
    private NameNodeMetrics myMetrics;
    private ObjectName mbeanName;

    public NameNodeStatistics(NameNodeMetrics nameNodeMetrics) {
        this.myMetrics = nameNodeMetrics;
        this.mbeanName = MBeanUtil.registerMBean("NameNode", "NameNodeStatistics", this);
    }

    public void shutdown() {
        if (this.mbeanName != null) {
            MBeanUtil.unregisterMBean(this.mbeanName);
        }
    }

    public long getBlockReportAverageTime() {
        return this.myMetrics.blockReport.getPreviousIntervalAverageTime();
    }

    public long getBlockReportMaxTime() {
        return this.myMetrics.blockReport.getMaxTime();
    }

    public long getBlockReportMinTime() {
        return this.myMetrics.blockReport.getMinTime();
    }

    public int getBlockReportNum() {
        return this.myMetrics.blockReport.getPreviousIntervalNumOps();
    }

    public long getJournalTransactionAverageTime() {
        return this.myMetrics.transactions.getPreviousIntervalAverageTime();
    }

    public int getJournalTransactionNum() {
        return this.myMetrics.transactions.getPreviousIntervalNumOps();
    }

    public long getJournalTransactionMaxTime() {
        return this.myMetrics.transactions.getMaxTime();
    }

    public long getJournalTransactionMinTime() {
        return this.myMetrics.transactions.getMinTime();
    }

    public long getJournalSyncAverageTime() {
        return this.myMetrics.syncs.getPreviousIntervalAverageTime();
    }

    public long getJournalSyncMaxTime() {
        return this.myMetrics.syncs.getMaxTime();
    }

    public long getJournalSyncMinTime() {
        return this.myMetrics.syncs.getMinTime();
    }

    public int getJournalSyncNum() {
        return this.myMetrics.syncs.getPreviousIntervalNumOps();
    }

    public int getSafemodeTime() {
        return this.myMetrics.safeModeTime.get();
    }

    public int getFSImageLoadTime() {
        return this.myMetrics.fsImageLoadTime.get();
    }

    public void resetAllMinMax() {
        this.myMetrics.resetAllMinMax();
    }

    public int getNumFilesCreated() {
        return this.myMetrics.numFilesCreated.getPreviousIntervalValue();
    }

    public int getNumFilesListed() {
        return this.myMetrics.numFilesListed.getPreviousIntervalValue();
    }

    public int getNumGetBlockLocations() {
        return this.myMetrics.numGetBlockLocations.getPreviousIntervalValue();
    }

    public int getNumFilesRenamed() {
        return this.myMetrics.numFilesRenamed.getPreviousIntervalValue();
    }
}

