/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.fs.FileSystem;

public class FSDataOutputStream
extends DataOutputStream {
    private OutputStream wrappedStream;

    @Deprecated
    public FSDataOutputStream(OutputStream out) throws IOException {
        this(out, null);
    }

    public FSDataOutputStream(OutputStream out, FileSystem.Statistics stats) throws IOException {
        super(new PositionCache(out, stats));
        this.wrappedStream = out;
    }

    public long getPos() throws IOException {
        return ((PositionCache)this.out).getPos();
    }

    public void close() throws IOException {
        this.out.close();
    }

    public OutputStream getWrappedStream() {
        return this.wrappedStream;
    }

    private static class PositionCache
    extends FilterOutputStream {
        private FileSystem.Statistics statistics;
        long position;

        public PositionCache(OutputStream out, FileSystem.Statistics stats) throws IOException {
            super(out);
            this.statistics = stats;
        }

        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.position;
            if (this.statistics != null) {
                this.statistics.incrementBytesWritten(1L);
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.position += (long)len;
            if (this.statistics != null) {
                this.statistics.incrementBytesWritten(len);
            }
        }

        public long getPos() throws IOException {
            return this.position;
        }

        public void close() throws IOException {
            this.out.close();
        }
    }
}

