/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.dfs.DistributedFileSystem;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.MultipleIOException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileSystem
extends Configured
implements Closeable {
    private static final String FS_DEFAULT_NAME_KEY = "fs.default.name";
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.fs.FileSystem");
    private static final Cache CACHE = new Cache();
    private static final Map<Class<? extends FileSystem>, Statistics> statisticsTable = new IdentityHashMap<Class<? extends FileSystem>, Statistics>();
    protected final Statistics statistics = FileSystem.getStatistics(this.getClass());
    private static final ClientFinalizer clientFinalizer = new ClientFinalizer();
    private static final PathFilter DEFAULT_FILTER = new PathFilter(){

        public boolean accept(Path file) {
            return true;
        }
    };

    public static FileSystem parseArgs(String[] argv, int i, Configuration conf) throws IOException {
        int orig = i;
        FileSystem fs = null;
        String cmd = argv[i];
        if ("-dfs".equals(cmd)) {
            int n = ++i;
            ++i;
            InetSocketAddress addr = NetUtils.createSocketAddr(argv[n]);
            fs = new DistributedFileSystem(addr, conf);
        } else if ("-local".equals(cmd)) {
            ++i;
            fs = FileSystem.getLocal(conf);
        } else {
            fs = FileSystem.get(conf);
            LOG.info((Object)("No FS indicated, using default:" + fs.getName()));
        }
        System.arraycopy(argv, i, argv, orig, argv.length - i);
        for (int j = argv.length - i; j < argv.length; ++j) {
            argv[j] = null;
        }
        return fs;
    }

    public static FileSystem get(Configuration conf) throws IOException {
        return FileSystem.get(FileSystem.getDefaultUri(conf), conf);
    }

    public static URI getDefaultUri(Configuration conf) {
        return URI.create(FileSystem.fixName(conf.get(FS_DEFAULT_NAME_KEY, "file:///")));
    }

    public static void setDefaultUri(Configuration conf, URI uri) {
        conf.set(FS_DEFAULT_NAME_KEY, uri.toString());
    }

    public static void setDefaultUri(Configuration conf, String uri) {
        FileSystem.setDefaultUri(conf, URI.create(FileSystem.fixName(uri)));
    }

    public abstract void initialize(URI var1, Configuration var2) throws IOException;

    public abstract URI getUri();

    public String getName() {
        return this.getUri().toString();
    }

    public static FileSystem getNamed(String name, Configuration conf) throws IOException {
        return FileSystem.get(URI.create(FileSystem.fixName(name)), conf);
    }

    private static String fixName(String name) {
        if (name.equals("local")) {
            LOG.warn((Object)"\"local\" is a deprecated filesystem name. Use \"file:///\" instead.");
            name = "file:///";
        } else if (name.indexOf(47) == -1) {
            LOG.warn((Object)("\"" + name + "\" is a deprecated filesystem name." + " Use \"hdfs://" + name + "/\" instead."));
            name = "hdfs://" + name;
        }
        return name;
    }

    public static LocalFileSystem getLocal(Configuration conf) throws IOException {
        return (LocalFileSystem)FileSystem.get(LocalFileSystem.NAME, conf);
    }

    public static FileSystem get(URI uri, Configuration conf) throws IOException {
        URI defaultUri;
        String scheme = uri.getScheme();
        String authority = uri.getAuthority();
        if (scheme == null) {
            return FileSystem.get(conf);
        }
        if (authority == null && scheme.equals((defaultUri = FileSystem.getDefaultUri(conf)).getScheme()) && defaultUri.getAuthority() != null) {
            return FileSystem.get(defaultUri, conf);
        }
        return CACHE.get(uri, conf);
    }

    public static void closeAll() throws IOException {
        CACHE.closeAll();
    }

    public Path makeQualified(Path path) {
        this.checkPath(path);
        return path.makeQualified(this);
    }

    public static FSDataOutputStream create(FileSystem fs, Path file, FsPermission permission) throws IOException {
        FSDataOutputStream out = fs.create(file);
        fs.setPermission(file, permission);
        return out;
    }

    public static boolean mkdirs(FileSystem fs, Path dir, FsPermission permission) throws IOException {
        boolean result = fs.mkdirs(dir);
        fs.setPermission(dir, permission);
        return result;
    }

    protected FileSystem() {
        super(null);
    }

    protected void checkPath(Path path) {
        URI uri = path.toUri();
        if (uri.getScheme() == null) {
            return;
        }
        String thisScheme = this.getUri().getScheme();
        String thatScheme = uri.getScheme();
        String thisAuthority = this.getUri().getAuthority();
        String thatAuthority = uri.getAuthority();
        if (thisScheme.equalsIgnoreCase(thatScheme)) {
            URI defaultUri;
            if (thisAuthority == thatAuthority || thisAuthority != null && thisAuthority.equalsIgnoreCase(thatAuthority)) {
                return;
            }
            if (thatAuthority == null && thisAuthority != null && thisScheme.equalsIgnoreCase((defaultUri = FileSystem.getDefaultUri(this.getConf())).getScheme()) && thisAuthority.equalsIgnoreCase(defaultUri.getAuthority())) {
                return;
            }
            throw new IllegalArgumentException("Wrong FS: " + path + ", expected: " + this.getUri());
        }
    }

    @Deprecated
    public String[][] getFileCacheHints(Path f, long start, long len) throws IOException {
        BlockLocation[] blkLocations = this.getFileBlockLocations(f, start, len);
        if (blkLocations == null || blkLocations.length == 0) {
            return new String[0][];
        }
        int blkCount = blkLocations.length;
        String[][] hints = new String[blkCount][];
        for (int i = 0; i < blkCount; ++i) {
            String[] hosts = blkLocations[i].getHosts();
            hints[i] = new String[hosts.length];
            hints[i] = hosts;
        }
        return hints;
    }

    public BlockLocation[] getFileBlockLocations(Path f, long start, long len) throws IOException {
        if (!this.exists(f)) {
            return null;
        }
        BlockLocation[] result = new BlockLocation[1];
        String[] name = new String[]{"localhost:50010"};
        String[] host = new String[]{"localhost"};
        result[0] = new BlockLocation(name, host, 0L, len);
        return result;
    }

    public abstract FSDataInputStream open(Path var1, int var2) throws IOException;

    public FSDataInputStream open(Path f) throws IOException {
        return this.open(f, this.getConf().getInt("io.file.buffer.size", 4096));
    }

    public FSDataOutputStream create(Path f) throws IOException {
        return this.create(f, true);
    }

    public FSDataOutputStream create(Path f, boolean overwrite) throws IOException {
        return this.create(f, overwrite, this.getConf().getInt("io.file.buffer.size", 4096), this.getDefaultReplication(), this.getDefaultBlockSize());
    }

    public FSDataOutputStream create(Path f, Progressable progress) throws IOException {
        return this.create(f, true, this.getConf().getInt("io.file.buffer.size", 4096), this.getDefaultReplication(), this.getDefaultBlockSize(), progress);
    }

    public FSDataOutputStream create(Path f, short replication) throws IOException {
        return this.create(f, true, this.getConf().getInt("io.file.buffer.size", 4096), replication, this.getDefaultBlockSize());
    }

    public FSDataOutputStream create(Path f, short replication, Progressable progress) throws IOException {
        return this.create(f, true, this.getConf().getInt("io.file.buffer.size", 4096), replication, this.getDefaultBlockSize(), progress);
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize) throws IOException {
        return this.create(f, overwrite, bufferSize, this.getDefaultReplication(), this.getDefaultBlockSize());
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, Progressable progress) throws IOException {
        return this.create(f, overwrite, bufferSize, this.getDefaultReplication(), this.getDefaultBlockSize(), progress);
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize) throws IOException {
        return this.create(f, overwrite, bufferSize, replication, blockSize, null);
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.create(f, FsPermission.getDefault(), overwrite, bufferSize, replication, blockSize, progress);
    }

    public abstract FSDataOutputStream create(Path var1, FsPermission var2, boolean var3, int var4, short var5, long var6, Progressable var8) throws IOException;

    public boolean createNewFile(Path f) throws IOException {
        if (this.exists(f)) {
            return false;
        }
        this.create(f, false, this.getConf().getInt("io.file.buffer.size", 4096)).close();
        return true;
    }

    @Deprecated
    public short getReplication(Path src) throws IOException {
        return this.getFileStatus(src).getReplication();
    }

    public boolean setReplication(Path src, short replication) throws IOException {
        return true;
    }

    public abstract boolean rename(Path var1, Path var2) throws IOException;

    @Deprecated
    public abstract boolean delete(Path var1) throws IOException;

    public abstract boolean delete(Path var1, boolean var2) throws IOException;

    public boolean exists(Path f) throws IOException {
        try {
            return this.getFileStatus(f) != null;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    @Deprecated
    public boolean isDirectory(Path f) throws IOException {
        try {
            return this.getFileStatus(f).isDir();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public boolean isFile(Path f) throws IOException {
        try {
            return !this.getFileStatus(f).isDir();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    @Deprecated
    public long getLength(Path f) throws IOException {
        return this.getFileStatus(f).getLen();
    }

    @Deprecated
    public long getContentLength(Path f) throws IOException {
        return this.getContentSummary(f).getLength();
    }

    public ContentSummary getContentSummary(Path f) throws IOException {
        FileStatus status = this.getFileStatus(f);
        if (!status.isDir()) {
            return new ContentSummary(status.getLen(), 1L, 0L);
        }
        long[] summary = new long[]{0L, 0L, 1L};
        for (FileStatus s : this.listStatus(f)) {
            ContentSummary c = this.getContentSummary(s.getPath());
            summary[0] = summary[0] + c.getLength();
            summary[1] = summary[1] + c.getFileCount();
            summary[2] = summary[2] + c.getDirectoryCount();
        }
        return new ContentSummary(summary[0], summary[1], summary[2]);
    }

    public abstract FileStatus[] listStatus(Path var1) throws IOException;

    private void listStatus(ArrayList<FileStatus> results, Path f, PathFilter filter) throws IOException {
        FileStatus[] listing = this.listStatus(f);
        if (listing != null) {
            for (int i = 0; i < listing.length; ++i) {
                if (!filter.accept(listing[i].getPath())) continue;
                results.add(listing[i]);
            }
        }
    }

    public FileStatus[] listStatus(Path f, PathFilter filter) throws IOException {
        ArrayList<FileStatus> results = new ArrayList<FileStatus>();
        this.listStatus(results, f, filter);
        return results.toArray(new FileStatus[results.size()]);
    }

    public FileStatus[] listStatus(Path[] files) throws IOException {
        return this.listStatus(files, DEFAULT_FILTER);
    }

    public FileStatus[] listStatus(Path[] files, PathFilter filter) throws IOException {
        ArrayList<FileStatus> results = new ArrayList<FileStatus>();
        for (int i = 0; i < files.length; ++i) {
            this.listStatus(results, files[i], filter);
        }
        return results.toArray(new FileStatus[results.size()]);
    }

    public FileStatus[] globStatus(Path pathPattern) throws IOException {
        return this.globStatus(pathPattern, DEFAULT_FILTER);
    }

    public FileStatus[] globStatus(Path pathPattern, PathFilter filter) throws IOException {
        FileStatus[] results;
        Path[] parents = new Path[1];
        int level = 0;
        String filename = pathPattern.toUri().getPath();
        if ("".equals(filename) || "/".equals(filename)) {
            return this.getFileStatus(new Path[]{pathPattern});
        }
        String[] components = filename.split("/");
        if (pathPattern.isAbsolute()) {
            parents[0] = new Path("/");
            level = 1;
        } else {
            parents[0] = new Path(".");
        }
        boolean[] hasGlob = new boolean[]{false};
        Path[] parentPaths = this.globPathsLevel(parents, components, level, filter, hasGlob);
        if (parentPaths == null || parentPaths.length == 0) {
            results = null;
        } else {
            GlobFilter fp = new GlobFilter(components[components.length - 1], filter);
            if (fp.hasPattern()) {
                results = this.listStatus(parentPaths, (PathFilter)fp);
                hasGlob[0] = true;
            } else {
                for (int i = 0; i < parentPaths.length; ++i) {
                    parentPaths[i] = new Path(parentPaths[i], components[components.length - 1]);
                }
                results = this.getFileStatus(parentPaths);
            }
        }
        if (results == null) {
            if (hasGlob[0]) {
                results = new FileStatus[]{};
            }
        } else if (results.length == 0) {
            if (!hasGlob[0]) {
                results = null;
            }
        } else {
            Arrays.sort(results);
        }
        return results;
    }

    private Path[] globPathsLevel(Path[] parents, String[] filePattern, int level, PathFilter filter, boolean[] hasGlob) throws IOException {
        if (level == filePattern.length - 1) {
            return parents;
        }
        if (parents == null || parents.length == 0) {
            return null;
        }
        GlobFilter fp = new GlobFilter(filePattern[level], filter);
        if (fp.hasPattern()) {
            parents = FileUtil.stat2Paths(this.listStatus(parents, (PathFilter)fp));
            hasGlob[0] = true;
        } else {
            for (int i = 0; i < parents.length; ++i) {
                parents[i] = new Path(parents[i], filePattern[level]);
            }
        }
        return this.globPathsLevel(parents, filePattern, level + 1, filter, hasGlob);
    }

    public Path getHomeDirectory() {
        return new Path("/user/" + System.getProperty("user.name")).makeQualified(this);
    }

    public abstract void setWorkingDirectory(Path var1);

    public abstract Path getWorkingDirectory();

    public boolean mkdirs(Path f) throws IOException {
        return this.mkdirs(f, FsPermission.getDefault());
    }

    public abstract boolean mkdirs(Path var1, FsPermission var2) throws IOException;

    public void copyFromLocalFile(Path src, Path dst) throws IOException {
        this.copyFromLocalFile(false, src, dst);
    }

    public void moveFromLocalFile(Path[] srcs, Path dst) throws IOException {
        this.copyFromLocalFile(true, true, srcs, dst);
    }

    public void moveFromLocalFile(Path src, Path dst) throws IOException {
        this.copyFromLocalFile(true, src, dst);
    }

    public void copyFromLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        this.copyFromLocalFile(delSrc, true, src, dst);
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path[] srcs, Path dst) throws IOException {
        Configuration conf = this.getConf();
        FileUtil.copy((FileSystem)FileSystem.getLocal(conf), srcs, this, dst, delSrc, overwrite, conf);
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path src, Path dst) throws IOException {
        Configuration conf = this.getConf();
        FileUtil.copy((FileSystem)FileSystem.getLocal(conf), src, this, dst, delSrc, overwrite, conf);
    }

    public void copyToLocalFile(Path src, Path dst) throws IOException {
        this.copyToLocalFile(false, src, dst);
    }

    public void moveToLocalFile(Path src, Path dst) throws IOException {
        this.copyToLocalFile(true, src, dst);
    }

    public void copyToLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        FileUtil.copy(this, src, FileSystem.getLocal(this.getConf()), dst, delSrc, this.getConf());
    }

    public Path startLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        return tmpLocalFile;
    }

    public void completeLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        this.moveFromLocalFile(tmpLocalFile, fsOutputFile);
    }

    @Override
    public void close() throws IOException {
        CACHE.remove(new Cache.Key(this), this);
    }

    public long getUsed() throws IOException {
        FileStatus[] files;
        long used = 0L;
        for (FileStatus file : files = this.listStatus(new Path("/"))) {
            used += file.getLen();
        }
        return used;
    }

    @Deprecated
    public long getBlockSize(Path f) throws IOException {
        return this.getFileStatus(f).getBlockSize();
    }

    public long getDefaultBlockSize() {
        return this.getConf().getLong("fs.local.block.size", 0x2000000L);
    }

    public short getDefaultReplication() {
        return 1;
    }

    public abstract FileStatus getFileStatus(Path var1) throws IOException;

    private FileStatus[] getFileStatus(Path[] paths) throws IOException {
        if (paths == null) {
            return null;
        }
        ArrayList<FileStatus> results = new ArrayList<FileStatus>(paths.length);
        for (int i = 0; i < paths.length; ++i) {
            try {
                results.add(this.getFileStatus(paths[i]));
                continue;
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
        return results.toArray(new FileStatus[results.size()]);
    }

    public void setPermission(Path p, FsPermission permission) throws IOException {
    }

    public void setOwner(Path p, String username, String groupname) throws IOException {
    }

    private static FileSystem createFileSystem(URI uri, Configuration conf) throws IOException {
        Class<?> clazz = conf.getClass("fs." + uri.getScheme() + ".impl", null);
        if (clazz == null) {
            throw new IOException("No FileSystem for scheme: " + uri.getScheme());
        }
        FileSystem fs = (FileSystem)ReflectionUtils.newInstance(clazz, conf);
        fs.initialize(uri, conf);
        return fs;
    }

    public static synchronized Statistics getStatistics(Class<? extends FileSystem> cls) {
        Statistics result = statisticsTable.get(cls);
        if (result == null) {
            result = new Statistics();
            statisticsTable.put(cls, result);
        }
        return result;
    }

    public static synchronized void printStatistics() throws IOException {
        for (Map.Entry<Class<? extends FileSystem>, Statistics> pair : statisticsTable.entrySet()) {
            System.out.println("  FileSystem " + pair.getKey().getName() + ": " + pair.getValue());
        }
    }

    static /* synthetic */ PathFilter access$200() {
        return DEFAULT_FILTER;
    }

    public static final class Statistics {
        private AtomicLong bytesRead = new AtomicLong();
        private AtomicLong bytesWritten = new AtomicLong();

        public void incrementBytesRead(long newBytes) {
            this.bytesRead.getAndAdd(newBytes);
        }

        public void incrementBytesWritten(long newBytes) {
            this.bytesWritten.getAndAdd(newBytes);
        }

        public long getBytesRead() {
            return this.bytesRead.get();
        }

        public long getBytesWritten() {
            return this.bytesWritten.get();
        }

        public String toString() {
            return this.bytesRead + " bytes read and " + this.bytesWritten + " bytes written";
        }
    }

    private static class Cache {
        private final Map<Key, FileSystem> map = new HashMap<Key, FileSystem>();

        private Cache() {
        }

        synchronized FileSystem get(URI uri, Configuration conf) throws IOException {
            FileSystem fs = this.map.get(new Key(uri, conf));
            if (fs == null) {
                fs = FileSystem.createFileSystem(uri, conf);
                if (this.map.isEmpty() && !clientFinalizer.isAlive()) {
                    Runtime.getRuntime().addShutdownHook(clientFinalizer);
                }
                this.map.put(new Key(fs), fs);
            }
            return fs;
        }

        synchronized void remove(Key key, FileSystem fs) {
            if (this.map.containsKey(key) && fs == this.map.get(key)) {
                this.map.remove(key);
                if (this.map.isEmpty() && !clientFinalizer.isAlive() && !Runtime.getRuntime().removeShutdownHook(clientFinalizer)) {
                    LOG.info((Object)"Could not cancel cleanup thread, though no FileSystems are open");
                }
            }
        }

        synchronized void closeAll() throws IOException {
            ArrayList<IOException> exceptions = new ArrayList<IOException>();
            while (!this.map.isEmpty()) {
                Map.Entry<Key, FileSystem> e = this.map.entrySet().iterator().next();
                Key key = e.getKey();
                FileSystem fs = e.getValue();
                this.remove(key, fs);
                if (fs == null) continue;
                try {
                    fs.close();
                }
                catch (IOException ioe) {
                    exceptions.add(ioe);
                }
            }
            if (!exceptions.isEmpty()) {
                throw MultipleIOException.createIOException(exceptions);
            }
        }

        private static class Key {
            final String scheme;
            final String authority;
            final String username;

            Key(FileSystem fs) throws IOException {
                this(fs.getUri(), fs.getConf());
            }

            Key(URI uri, Configuration conf) throws IOException {
                this.scheme = uri.getScheme();
                this.authority = uri.getAuthority();
                UserGroupInformation ugi = UserGroupInformation.readFrom(conf);
                if (ugi == null) {
                    try {
                        ugi = UserGroupInformation.login(conf);
                    }
                    catch (LoginException e) {
                        LOG.warn((Object)("uri=" + uri), (Throwable)e);
                    }
                }
                this.username = ugi == null ? null : ugi.getUserName();
            }

            public int hashCode() {
                return (this.scheme + this.authority + this.username).hashCode();
            }

            static boolean isEqual(Object a, Object b) {
                return a == b || a != null && a.equals(b);
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj != null && obj instanceof Key) {
                    Key that = (Key)obj;
                    return Key.isEqual(this.scheme, that.scheme) && Key.isEqual(this.authority, that.authority) && Key.isEqual(this.username, that.username);
                }
                return false;
            }

            public String toString() {
                return this.username + "@" + this.scheme + "://" + this.authority;
            }
        }
    }

    private static class GlobFilter
    implements PathFilter {
        private PathFilter userFilter = FileSystem.access$200();
        private Pattern regex;
        private boolean hasPattern = false;
        private static final char PAT_ESCAPE = '\\';
        private static final char PAT_ANY = '.';
        private static final char PAT_SET_CLOSE = ']';

        GlobFilter() {
        }

        GlobFilter(String filePattern) throws IOException {
            this.setRegex(filePattern);
        }

        GlobFilter(String filePattern, PathFilter filter) throws IOException {
            this.userFilter = filter;
            this.setRegex(filePattern);
        }

        private boolean isJavaRegexSpecialChar(char pChar) {
            return pChar == '.' || pChar == '$' || pChar == '(' || pChar == ')' || pChar == '|' || pChar == '+';
        }

        void setRegex(String filePattern) throws IOException {
            StringBuilder fileRegex = new StringBuilder();
            int len = filePattern.length();
            if (len == 0) {
                return;
            }
            int setOpen = 0;
            boolean setRange = false;
            int curlyOpen = 0;
            for (int i = 0; i < len; ++i) {
                int pCh = filePattern.charAt(i);
                if (pCh == 92) {
                    fileRegex.append((char)pCh);
                    if (++i >= len) {
                        this.error("An escaped character does not present", filePattern, i);
                    }
                    pCh = filePattern.charAt(i);
                } else if (this.isJavaRegexSpecialChar((char)pCh)) {
                    fileRegex.append('\\');
                } else if (pCh == 42) {
                    fileRegex.append('.');
                    this.hasPattern = true;
                } else if (pCh == 63) {
                    pCh = 46;
                    this.hasPattern = true;
                } else if (pCh == 123) {
                    fileRegex.append('(');
                    pCh = 40;
                    ++curlyOpen;
                    this.hasPattern = true;
                } else if (pCh == 44 && curlyOpen > 0) {
                    fileRegex.append(")|");
                    pCh = 40;
                } else if (pCh == 125 && curlyOpen > 0) {
                    --curlyOpen;
                    fileRegex.append(")");
                    pCh = 41;
                } else if (pCh == 91 && setOpen == 0) {
                    ++setOpen;
                    this.hasPattern = true;
                } else if (pCh != 94 || setOpen <= 0) {
                    if (pCh == 45 && setOpen > 0) {
                        setRange = true;
                    } else if (pCh == 93 && setRange) {
                        this.error("Incomplete character set range", filePattern, i);
                    } else if (pCh == 93 && setOpen > 0) {
                        if (setOpen < 2) {
                            this.error("Unexpected end of set", filePattern, i);
                        }
                        setOpen = 0;
                    } else if (setOpen > 0) {
                        ++setOpen;
                        setRange = false;
                    }
                }
                fileRegex.append((char)pCh);
            }
            if (setOpen > 0 || setRange || curlyOpen > 0) {
                this.error("Expecting set closure character or end of range, or }", filePattern, len);
            }
            this.regex = Pattern.compile(fileRegex.toString());
        }

        boolean hasPattern() {
            return this.hasPattern;
        }

        public boolean accept(Path path) {
            return this.regex.matcher(path.getName()).matches() && this.userFilter.accept(path);
        }

        private void error(String s, String pattern, int pos) throws IOException {
            throw new IOException("Illegal file pattern: " + s + " for glob " + pattern + " at " + pos);
        }
    }

    private static class ClientFinalizer
    extends Thread {
        private ClientFinalizer() {
        }

        public synchronized void run() {
            try {
                FileSystem.closeAll();
            }
            catch (IOException e) {
                LOG.info((Object)("FileSystem.closeAll() threw an exception:\n" + e));
            }
        }
    }
}

