/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.shell.CommandUtils;

public class Count {
    public static final String NAME = "count";
    public static final String USAGE = "-count <path>";
    public static final String DESCRIPTION = CommandUtils.formatDescription("-count <path>", "Count the number of directories, files and bytes under the paths", "that match the specified file pattern.  The output columns are:", "DIR_COUNT FILE_COUNT CONTENT_SIZE FILE_NAME");

    public static boolean matches(String cmd) {
        return "-count".equals(cmd);
    }

    public static void count(String src, Configuration conf, PrintStream out) throws IOException {
        Path srcPath = new Path(src);
        FileSystem srcFs = srcPath.getFileSystem(conf);
        FileStatus[] statuses = srcFs.globStatus(srcPath);
        if (statuses == null || statuses.length == 0) {
            throw new FileNotFoundException(src + " not found.");
        }
        for (FileStatus s : statuses) {
            Path p = s.getPath();
            String pathstr = p.toString();
            out.println(srcFs.getContentSummary(p) + ("".equals(pathstr) ? "." : pathstr));
        }
    }
}

