/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.ipc.metrics.RpcMetrics;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

public abstract class Server {
    public static final ByteBuffer HEADER = ByteBuffer.wrap("hrpc".getBytes());
    public static final byte CURRENT_VERSION = 1;
    private static final float MAX_CALL_QUEUE_TIME = 0.6f;
    private static final int MAX_QUEUE_SIZE_PER_HANDLER = 100;
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.ipc.Server");
    private static final ThreadLocal<Server> SERVER = new ThreadLocal();
    private static final ThreadLocal<Call> CurCall = new ThreadLocal();
    private String bindAddress;
    private int port;
    private int handlerCount;
    private Class paramClass;
    private int maxIdleTime;
    private int thresholdIdleConnections;
    int maxConnectionsToNuke;
    protected RpcMetrics rpcMetrics;
    private Configuration conf;
    private int timeout;
    private long maxCallStartAge;
    private int maxQueueSize;
    private int socketSendBufferSize;
    private boolean tcpNoDelay;
    private volatile boolean running = true;
    private LinkedList<Call> callQueue = new LinkedList();
    private List<Connection> connectionList = Collections.synchronizedList(new LinkedList());
    private Listener listener = null;
    private Responder responder = null;
    private int numConnections = 0;
    private Handler[] handlers = null;

    public static Server get() {
        return SERVER.get();
    }

    public static InetAddress getRemoteIp() {
        Call call = CurCall.get();
        if (call != null) {
            return call.connection.socket.getInetAddress();
        }
        return null;
    }

    public static String getRemoteAddress() {
        InetAddress addr = Server.getRemoteIp();
        return addr == null ? null : addr.getHostAddress();
    }

    public static void bind(ServerSocket socket, InetSocketAddress address, int backlog) throws IOException {
        try {
            socket.bind(address, backlog);
        }
        catch (BindException e) {
            throw new BindException("Problem binding to " + address);
        }
        catch (SocketException e) {
            if ("Unresolved address".equals(e.getMessage())) {
                throw new UnknownHostException("Invalid hostname for server: " + address.getHostName());
            }
            throw e;
        }
    }

    protected Server(String bindAddress, int port, Class paramClass, int handlerCount, Configuration conf) throws IOException {
        this(bindAddress, port, paramClass, handlerCount, conf, Integer.toString(port));
    }

    protected Server(String bindAddress, int port, Class paramClass, int handlerCount, Configuration conf, String serverName) throws IOException {
        this.bindAddress = bindAddress;
        this.conf = conf;
        this.port = port;
        this.paramClass = paramClass;
        this.handlerCount = handlerCount;
        this.timeout = conf.getInt("ipc.client.timeout", 10000);
        this.socketSendBufferSize = 0;
        this.maxCallStartAge = (long)((float)this.timeout * 0.6f);
        this.maxQueueSize = handlerCount * 100;
        this.maxIdleTime = conf.getInt("ipc.client.maxidletime", 120000);
        this.maxConnectionsToNuke = conf.getInt("ipc.client.kill.max", 10);
        this.thresholdIdleConnections = conf.getInt("ipc.client.idlethreshold", 4000);
        this.listener = new Listener();
        this.port = this.listener.getAddress().getPort();
        this.rpcMetrics = new RpcMetrics(serverName, Integer.toString(this.port), this);
        this.responder = new Responder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection(Connection connection) {
        List<Connection> list = this.connectionList;
        synchronized (list) {
            if (this.connectionList.remove(connection)) {
                --this.numConnections;
            }
        }
        try {
            connection.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setSocketSendBufSize(int size) {
        this.socketSendBufferSize = size;
    }

    public synchronized void start() throws IOException {
        this.responder.start();
        this.listener.start();
        this.handlers = new Handler[this.handlerCount];
        for (int i = 0; i < this.handlerCount; ++i) {
            this.handlers[i] = new Handler(i);
            this.handlers[i].start();
        }
    }

    public synchronized void stop() {
        LOG.info((Object)("Stopping server on " + this.port));
        this.running = false;
        if (this.handlers != null) {
            for (int i = 0; i < this.handlerCount; ++i) {
                if (this.handlers[i] == null) continue;
                this.handlers[i].interrupt();
            }
        }
        this.listener.interrupt();
        this.listener.doStop();
        this.responder.interrupt();
        this.notifyAll();
        if (this.rpcMetrics != null) {
            this.rpcMetrics.shutdown();
        }
    }

    public synchronized void join() throws InterruptedException {
        while (this.running) {
            this.wait();
        }
    }

    public synchronized InetSocketAddress getListenerAddress() {
        return this.listener.getAddress();
    }

    public abstract Writable call(Writable var1, long var2) throws IOException;

    public int getNumOpenConnections() {
        return this.numConnections;
    }

    public int getCallQueueLen() {
        return this.callQueue.size();
    }

    private class Handler
    extends Thread {
        public Handler(int instanceNumber) {
            this.setDaemon(true);
            this.setName("IPC Server handler " + instanceNumber + " on " + Server.this.port);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LOG.info((Object)(this.getName() + ": starting"));
            SERVER.set(Server.this);
            ByteArrayOutputStream buf = new ByteArrayOutputStream(10240);
            while (Server.this.running) {
                try {
                    Call call;
                    LinkedList linkedList = Server.this.callQueue;
                    synchronized (linkedList) {
                        while (Server.this.running && Server.this.callQueue.size() == 0) {
                            Server.this.callQueue.wait(Server.this.timeout);
                        }
                        if (!Server.this.running) {
                            break;
                        }
                        call = (Call)Server.this.callQueue.removeFirst();
                    }
                    if (System.currentTimeMillis() - call.receivedTime > Server.this.maxCallStartAge) {
                        ReflectionUtils.logThreadInfo(LOG, "Discarding call " + call, 30L);
                        int timeInQ = (int)(System.currentTimeMillis() - call.receivedTime);
                        LOG.warn((Object)(this.getName() + ", call " + call + ": discarded for being too old (" + timeInQ + ")"));
                        Server.this.rpcMetrics.rpcDiscardedOps.inc(timeInQ);
                        continue;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(this.getName() + ": has #" + call.id + " from " + call.connection));
                    }
                    String errorClass = null;
                    String error = null;
                    Writable value = null;
                    CurCall.set(call);
                    UserGroupInformation previous = UserGroupInformation.getCurrentUGI();
                    UserGroupInformation.setCurrentUGI(call.connection.ticket);
                    try {
                        value = Server.this.call(call.param, call.receivedTime);
                    }
                    catch (Throwable e) {
                        LOG.info((Object)(this.getName() + ", call " + call + ": error: " + e), e);
                        errorClass = e.getClass().getName();
                        error = StringUtils.stringifyException(e);
                    }
                    UserGroupInformation.setCurrentUGI(previous);
                    CurCall.set(null);
                    buf.reset();
                    DataOutputStream out = new DataOutputStream(buf);
                    out.writeInt(call.id);
                    out.writeBoolean(error != null);
                    if (error == null) {
                        value.write(out);
                    } else {
                        WritableUtils.writeString(out, errorClass);
                        WritableUtils.writeString(out, error);
                    }
                    call.setResponse(ByteBuffer.wrap(buf.toByteArray()));
                    Server.this.responder.doRespond(call);
                }
                catch (InterruptedException e) {
                    if (!Server.this.running) continue;
                    LOG.info((Object)(this.getName() + " caught: " + StringUtils.stringifyException(e)));
                }
                catch (Exception e) {
                    LOG.info((Object)(this.getName() + " caught: " + StringUtils.stringifyException(e)));
                }
            }
            LOG.info((Object)(this.getName() + ": exiting"));
        }
    }

    private class Connection {
        private boolean versionRead = false;
        private boolean headerRead = false;
        private SocketChannel channel;
        private ByteBuffer data;
        private ByteBuffer dataLengthBuffer;
        private LinkedList<Call> responseQueue;
        private long lastContact;
        private int dataLength;
        private Socket socket;
        private String hostAddress;
        private int remotePort;
        private UserGroupInformation ticket = null;

        public Connection(SelectionKey key, SocketChannel channel, long lastContact) {
            this.channel = channel;
            this.lastContact = lastContact;
            this.data = null;
            this.dataLengthBuffer = ByteBuffer.allocate(4);
            this.socket = channel.socket();
            InetAddress addr = this.socket.getInetAddress();
            this.hostAddress = addr == null ? "*Unknown*" : addr.getHostAddress();
            this.remotePort = this.socket.getPort();
            this.responseQueue = new LinkedList();
            if (Server.this.socketSendBufferSize != 0) {
                try {
                    this.socket.setSendBufferSize(Server.this.socketSendBufferSize);
                }
                catch (IOException e) {
                    LOG.warn((Object)("Connection: unable to set socket send buffer size to " + Server.this.socketSendBufferSize));
                }
            }
        }

        public String toString() {
            return this.getHostAddress() + ":" + this.remotePort;
        }

        public String getHostAddress() {
            return this.hostAddress;
        }

        public void setLastContact(long lastContact) {
            this.lastContact = lastContact;
        }

        public long getLastContact() {
            return this.lastContact;
        }

        private boolean timedOut(long currentTime) {
            return currentTime - this.lastContact > (long)Server.this.maxIdleTime;
        }

        public int readAndProcess() throws IOException, InterruptedException {
            int count;
            while (true) {
                count = -1;
                if (this.dataLengthBuffer.remaining() > 0 && ((count = this.channel.read(this.dataLengthBuffer)) < 0 || this.dataLengthBuffer.remaining() > 0)) {
                    return count;
                }
                if (!this.versionRead) {
                    ByteBuffer versionBuffer = ByteBuffer.allocate(1);
                    count = this.channel.read(versionBuffer);
                    if (count <= 0) {
                        return count;
                    }
                    byte version = versionBuffer.get(0);
                    this.dataLengthBuffer.flip();
                    if (!HEADER.equals(this.dataLengthBuffer) || version != 1) {
                        LOG.warn((Object)("Incorrect header or version mismatch from " + this.hostAddress + ":" + this.remotePort + " got version " + version + " expected version " + 1));
                        return -1;
                    }
                    this.dataLengthBuffer.clear();
                    this.versionRead = true;
                    continue;
                }
                if (this.data == null) {
                    this.dataLengthBuffer.flip();
                    this.dataLength = this.dataLengthBuffer.getInt();
                    this.data = ByteBuffer.allocate(this.dataLength);
                }
                count = this.channel.read(this.data);
                if (this.data.remaining() != 0) break;
                this.dataLengthBuffer.clear();
                this.data.flip();
                if (this.headerRead) {
                    this.processData();
                    this.data = null;
                    return count;
                }
                this.processHeader();
                this.headerRead = true;
                this.data = null;
            }
            return count;
        }

        private void processHeader() throws IOException {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(this.data.array()));
            this.ticket = (UserGroupInformation)ObjectWritable.readObject(in, Server.this.conf);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processData() throws IOException, InterruptedException {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(this.data.array()));
            int id = dis.readInt();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(" got #" + id));
            }
            Writable param = (Writable)ReflectionUtils.newInstance(Server.this.paramClass, Server.this.conf);
            param.readFields(dis);
            Call call = new Call(id, param, this);
            LinkedList linkedList = Server.this.callQueue;
            synchronized (linkedList) {
                if (Server.this.callQueue.size() >= Server.this.maxQueueSize) {
                    Call oldCall = (Call)Server.this.callQueue.removeFirst();
                    LOG.warn((Object)("Call queue overflow discarding oldest call " + oldCall));
                }
                Server.this.callQueue.addLast(call);
                Server.this.callQueue.notify();
            }
        }

        private synchronized void close() throws IOException {
            this.data = null;
            this.dataLengthBuffer = null;
            if (!this.channel.isOpen()) {
                return;
            }
            try {
                this.socket.shutdownOutput();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.channel.isOpen()) {
                try {
                    this.channel.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Responder
    extends Thread {
        private Selector writeSelector;
        private int pending;

        Responder() throws IOException {
            this.setName("IPC Server Responder");
            this.setDaemon(true);
            this.writeSelector = Selector.open();
            this.pending = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info((Object)(this.getName() + ": starting"));
            SERVER.set(Server.this);
            long lastPurgeTime = 0L;
            while (Server.this.running) {
                try {
                    this.waitPending();
                    this.writeSelector.select(Server.this.maxCallStartAge);
                    Iterator<SelectionKey> iter = this.writeSelector.selectedKeys().iterator();
                    while (iter.hasNext()) {
                        SelectionKey key = iter.next();
                        iter.remove();
                        try {
                            if (!key.isValid() || !key.isWritable()) continue;
                            this.doAsyncWrite(key);
                        }
                        catch (IOException e) {
                            LOG.info((Object)(this.getName() + ": doAsyncWrite threw exception " + e));
                        }
                    }
                    long now = System.currentTimeMillis();
                    if (now < lastPurgeTime + Server.this.maxCallStartAge) continue;
                    lastPurgeTime = now;
                    LOG.debug((Object)"Checking for old call responses.");
                    Set<SelectionKey> set = this.writeSelector.keys();
                    synchronized (set) {
                        for (SelectionKey key : this.writeSelector.keys()) {
                            try {
                                this.doPurge(key, now);
                            }
                            catch (IOException e) {
                                LOG.warn((Object)("Error in purging old calls " + e));
                            }
                        }
                    }
                }
                catch (OutOfMemoryError e) {
                    LOG.warn((Object)"Out of Memory in server select", (Throwable)e);
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (Exception ie) {}
                }
                catch (Exception e) {
                    LOG.warn((Object)("Exception in Responder " + StringUtils.stringifyException(e)));
                }
            }
            LOG.info((Object)("Stopping " + this.getName()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doAsyncWrite(SelectionKey key) throws IOException {
            Call call = (Call)key.attachment();
            if (call == null) {
                return;
            }
            if (key.channel() != call.connection.channel) {
                throw new IOException("doAsyncWrite: bad channel");
            }
            LinkedList linkedList = call.connection.responseQueue;
            synchronized (linkedList) {
                if (this.processResponse(call.connection.responseQueue, false)) {
                    try {
                        key.interestOps(0);
                    }
                    catch (CancelledKeyException e) {
                        LOG.warn((Object)("Exception while changing ops : " + e));
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doPurge(SelectionKey key, long now) throws IOException {
            LinkedList responseQueue;
            Call call = (Call)key.attachment();
            if (call == null) {
                return;
            }
            if (key.channel() != call.connection.channel) {
                LOG.info((Object)"doPurge: bad channel");
                return;
            }
            boolean close = false;
            LinkedList linkedList = responseQueue = call.connection.responseQueue;
            synchronized (linkedList) {
                ListIterator iter = responseQueue.listIterator(0);
                while (iter.hasNext()) {
                    call = (Call)iter.next();
                    if (now <= call.receivedTime + Server.this.maxCallStartAge) continue;
                    LOG.info((Object)(this.getName() + ", call " + call + ": response discarded for being too old (" + (now - call.receivedTime) + ")"));
                    iter.remove();
                    if (call.response.position() <= 0) continue;
                    close = true;
                    break;
                }
            }
            if (close) {
                Server.this.closeConnection(call.connection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private boolean processResponse(LinkedList<Call> responseQueue, boolean inHandler) throws IOException {
            int numBytes;
            Call call;
            int numElements;
            boolean done;
            boolean error;
            block21: {
                error = true;
                done = false;
                numElements = 0;
                call = null;
                LinkedList<Call> linkedList = responseQueue;
                // MONITORENTER : linkedList
                numElements = responseQueue.size();
                if (numElements != 0) break block21;
                error = false;
                boolean bl = true;
                // MONITOREXIT : linkedList
                if (!error) return bl;
                if (call == null) return bl;
                LOG.warn((Object)(this.getName() + ", call " + call + ": output error"));
                done = true;
                Server.this.closeConnection(call.connection);
                return bl;
            }
            call = responseQueue.removeFirst();
            SocketChannel channel = call.connection.channel;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getName() + ": responding to #" + call.id + " from " + call.connection));
            }
            if ((numBytes = channel.write(call.response)) < 0) {
                boolean bl = true;
                // MONITOREXIT : linkedList
                if (!error) return bl;
                if (call == null) return bl;
                LOG.warn((Object)(this.getName() + ", call " + call + ": output error"));
                done = true;
                Server.this.closeConnection(call.connection);
                return bl;
            }
            try {
                if (!call.response.hasRemaining()) {
                    done = numElements == 1;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(this.getName() + ": responding to #" + call.id + " from " + call.connection + " Wrote " + numBytes + " bytes."));
                    }
                } else {
                    call.connection.responseQueue.addFirst(call);
                    if (inHandler) {
                        this.incPending();
                        try {
                            this.writeSelector.wakeup();
                            channel.register(this.writeSelector, 4, call);
                        }
                        catch (ClosedChannelException e) {
                            done = true;
                        }
                        finally {
                            this.decPending();
                        }
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(this.getName() + ": responding to #" + call.id + " from " + call.connection + " Wrote partial " + numBytes + " bytes."));
                    }
                }
                error = false;
                // MONITOREXIT : linkedList
                return done;
            }
            finally {
                if (error && call != null) {
                    LOG.warn((Object)(this.getName() + ", call " + call + ": output error"));
                    done = true;
                    Server.this.closeConnection(call.connection);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doRespond(Call call) throws IOException {
            LinkedList linkedList = call.connection.responseQueue;
            synchronized (linkedList) {
                call.connection.responseQueue.addLast(call);
                if (call.connection.responseQueue.size() == 1) {
                    this.processResponse(call.connection.responseQueue, true);
                }
            }
        }

        private synchronized void incPending() {
            ++this.pending;
        }

        private synchronized void decPending() {
            --this.pending;
            this.notify();
        }

        private synchronized void waitPending() throws InterruptedException {
            while (this.pending > 0) {
                this.wait();
            }
        }
    }

    private class Listener
    extends Thread {
        private ServerSocketChannel acceptChannel = null;
        private Selector selector = null;
        private InetSocketAddress address;
        private Random rand = new Random();
        private long lastCleanupRunTime = 0L;
        private long cleanupInterval = 10000L;
        private int backlogLength = Server.access$200(Server.this).getInt("ipc.server.listen.queue.size", 128);

        public Listener() throws IOException {
            this.address = new InetSocketAddress(Server.this.bindAddress, Server.this.port);
            this.acceptChannel = ServerSocketChannel.open();
            this.acceptChannel.configureBlocking(false);
            Server.bind(this.acceptChannel.socket(), this.address, this.backlogLength);
            Server.this.port = this.acceptChannel.socket().getLocalPort();
            this.selector = Selector.open();
            this.acceptChannel.register(this.selector, 16);
            this.setName("IPC Server listener on " + Server.this.port);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanupConnections(boolean force) {
            if (force || Server.this.numConnections > Server.this.thresholdIdleConnections) {
                long currentTime = System.currentTimeMillis();
                if (!force && currentTime - this.lastCleanupRunTime < this.cleanupInterval) {
                    return;
                }
                int start = 0;
                int end = Server.this.numConnections - 1;
                if (!force) {
                    start = this.rand.nextInt() % Server.this.numConnections;
                    end = this.rand.nextInt() % Server.this.numConnections;
                    if (end < start) {
                        int temp = start;
                        start = end;
                        end = temp;
                    }
                }
                int i = start;
                int numNuked = 0;
                while (i <= end) {
                    Connection c;
                    List list = Server.this.connectionList;
                    synchronized (list) {
                        try {
                            c = (Connection)Server.this.connectionList.get(i);
                        }
                        catch (Exception e) {
                            return;
                        }
                    }
                    if (c.timedOut(currentTime)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)(this.getName() + ": disconnecting client " + c.getHostAddress()));
                        }
                        Server.this.closeConnection(c);
                        --end;
                        c = null;
                        if (force || ++numNuked != Server.this.maxConnectionsToNuke) continue;
                        break;
                    }
                    ++i;
                }
                this.lastCleanupRunTime = System.currentTimeMillis();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LOG.info((Object)(this.getName() + ": starting"));
            SERVER.set(Server.this);
            while (Server.this.running) {
                SelectionKey key = null;
                try {
                    this.selector.select();
                    Iterator<SelectionKey> iter = this.selector.selectedKeys().iterator();
                    while (iter.hasNext()) {
                        key = iter.next();
                        iter.remove();
                        try {
                            if (key.isValid()) {
                                if (key.isAcceptable()) {
                                    this.doAccept(key);
                                } else if (key.isReadable()) {
                                    this.doRead(key);
                                }
                            }
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        key = null;
                    }
                }
                catch (OutOfMemoryError e) {
                    LOG.warn((Object)"Out of Memory in server select", (Throwable)e);
                    this.closeCurrentConnection(key, e);
                    this.cleanupConnections(true);
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (Exception exception) {}
                }
                catch (Exception e) {
                    this.closeCurrentConnection(key, e);
                }
                this.cleanupConnections(false);
            }
            LOG.info((Object)("Stopping " + this.getName()));
            Listener listener = this;
            synchronized (listener) {
                try {
                    this.acceptChannel.close();
                    this.selector.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.selector = null;
                this.acceptChannel = null;
                while (!Server.this.connectionList.isEmpty()) {
                    Server.this.closeConnection((Connection)Server.this.connectionList.remove(0));
                }
            }
        }

        private void closeCurrentConnection(SelectionKey key, Throwable e) {
            Connection c;
            if (key != null && (c = (Connection)key.attachment()) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.getName() + ": disconnecting client " + c.getHostAddress()));
                }
                Server.this.closeConnection(c);
                Object var3_3 = null;
            }
        }

        InetSocketAddress getAddress() {
            return (InetSocketAddress)this.acceptChannel.socket().getLocalSocketAddress();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doAccept(SelectionKey key) throws IOException, OutOfMemoryError {
            Connection c = null;
            ServerSocketChannel server = (ServerSocketChannel)key.channel();
            SocketChannel channel = server.accept();
            channel.configureBlocking(false);
            channel.socket().setTcpNoDelay(Server.this.tcpNoDelay);
            SelectionKey readKey = channel.register(this.selector, 1);
            c = new Connection(readKey, channel, System.currentTimeMillis());
            readKey.attach(c);
            List list = Server.this.connectionList;
            synchronized (list) {
                Server.this.connectionList.add(Server.this.numConnections, c);
                Server.this.numConnections++;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Server connection from " + c.toString() + "; # active connections: " + Server.this.numConnections + "; # queued calls: " + Server.this.callQueue.size()));
            }
        }

        void doRead(SelectionKey key) {
            int count = 0;
            Connection c = (Connection)key.attachment();
            if (c == null) {
                return;
            }
            c.setLastContact(System.currentTimeMillis());
            try {
                count = c.readAndProcess();
            }
            catch (Exception e) {
                LOG.debug((Object)(this.getName() + ": readAndProcess threw exception " + e + ". Count of bytes read: " + count), (Throwable)e);
                count = -1;
            }
            if (count < 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.getName() + ": disconnecting client " + c.getHostAddress() + ". Number of active connections: " + Server.this.numConnections));
                }
                Server.this.closeConnection(c);
                c = null;
            } else {
                c.setLastContact(System.currentTimeMillis());
            }
        }

        synchronized void doStop() {
            if (this.selector != null) {
                this.selector.wakeup();
                Thread.yield();
            }
            if (this.acceptChannel != null) {
                try {
                    this.acceptChannel.socket().close();
                }
                catch (IOException e) {
                    LOG.info((Object)(this.getName() + ":Exception in closing listener socket. " + e));
                }
            }
        }
    }

    private static class Call {
        private int id;
        private Writable param;
        private Connection connection;
        private long receivedTime;
        private ByteBuffer response;

        public Call(int id, Writable param, Connection connection) {
            this.id = id;
            this.param = param;
            this.connection = connection;
            this.receivedTime = System.currentTimeMillis();
            this.response = null;
        }

        public String toString() {
            return this.param.toString() + " from " + this.connection.toString();
        }

        public void setResponse(ByteBuffer response) {
            this.response = response;
        }
    }
}

