/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.JobTracker;

public class ClusterStatus
implements Writable {
    private int task_trackers;
    private int map_tasks;
    private int reduce_tasks;
    private int max_map_tasks;
    private int max_reduce_tasks;
    private JobTracker.State state;

    ClusterStatus() {
    }

    ClusterStatus(int trackers, int maps, int reduces, int maxMaps, int maxReduces, JobTracker.State state) {
        this.task_trackers = trackers;
        this.map_tasks = maps;
        this.reduce_tasks = reduces;
        this.max_map_tasks = maxMaps;
        this.max_reduce_tasks = maxReduces;
        this.state = state;
    }

    public int getTaskTrackers() {
        return this.task_trackers;
    }

    public int getMapTasks() {
        return this.map_tasks;
    }

    public int getReduceTasks() {
        return this.reduce_tasks;
    }

    public int getMaxMapTasks() {
        return this.max_map_tasks;
    }

    public int getMaxReduceTasks() {
        return this.max_reduce_tasks;
    }

    public JobTracker.State getJobTrackerState() {
        return this.state;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.task_trackers);
        out.writeInt(this.map_tasks);
        out.writeInt(this.reduce_tasks);
        out.writeInt(this.max_map_tasks);
        out.writeInt(this.max_reduce_tasks);
        WritableUtils.writeEnum(out, this.state);
    }

    public void readFields(DataInput in) throws IOException {
        this.task_trackers = in.readInt();
        this.map_tasks = in.readInt();
        this.reduce_tasks = in.readInt();
        this.max_map_tasks = in.readInt();
        this.max_reduce_tasks = in.readInt();
        this.state = WritableUtils.readEnum(in, JobTracker.State.class);
    }
}

