/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.InvalidInputException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileInputFormat<K, V>
implements InputFormat<K, V> {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.mapred.FileInputFormat");
    private static final double SPLIT_SLOP = 1.1;
    private long minSplitSize = 1L;
    private static final PathFilter hiddenFileFilter = new PathFilter(){

        public boolean accept(Path p) {
            String name = p.getName();
            return !name.startsWith("_") && !name.startsWith(".");
        }
    };

    protected void setMinSplitSize(long minSplitSize) {
        this.minSplitSize = minSplitSize;
    }

    protected boolean isSplitable(FileSystem fs, Path filename) {
        return true;
    }

    @Override
    public abstract RecordReader<K, V> getRecordReader(InputSplit var1, JobConf var2, Reporter var3) throws IOException;

    public static void setInputPathFilter(JobConf conf, Class<? extends PathFilter> filter) {
        conf.setClass("mapred.input.pathFilter.class", filter, PathFilter.class);
    }

    public static PathFilter getInputPathFilter(JobConf conf) {
        Class<PathFilter> filterClass = conf.getClass("mapred.input.pathFilter.class", null, PathFilter.class);
        return filterClass != null ? (PathFilter)ReflectionUtils.newInstance(filterClass, conf) : null;
    }

    protected Path[] listPaths(JobConf job) throws IOException {
        Path[] dirs = FileInputFormat.getInputPaths(job);
        if (dirs.length == 0) {
            throw new IOException("No input paths specified in job");
        }
        ArrayList<Path> result = new ArrayList<Path>();
        ArrayList<PathFilter> filters = new ArrayList<PathFilter>();
        filters.add(hiddenFileFilter);
        PathFilter jobFilter = FileInputFormat.getInputPathFilter(job);
        if (jobFilter != null) {
            filters.add(jobFilter);
        }
        MultiPathFilter inputFilter = new MultiPathFilter(filters);
        for (Path p : dirs) {
            FileStatus[] matches;
            FileSystem fs = p.getFileSystem(job);
            for (FileStatus match : matches = fs.listStatus(FileUtil.stat2Paths(fs.globStatus(p, inputFilter)), (PathFilter)inputFilter)) {
                result.add(fs.makeQualified(match.getPath()));
            }
        }
        return result.toArray(new Path[result.size()]);
    }

    @Override
    public void validateInput(JobConf job) throws IOException {
        Path[] inputDirs = FileInputFormat.getInputPaths(job);
        if (inputDirs.length == 0) {
            throw new IOException("No input paths specified in input");
        }
        ArrayList<IOException> result = new ArrayList<IOException>();
        int totalFiles = 0;
        for (Path p : inputDirs) {
            FileSystem fs = p.getFileSystem(job);
            if (fs.exists(p)) {
                Path[] subPaths;
                for (Path subPath : subPaths = FileUtil.stat2Paths(fs.listStatus(p, hiddenFileFilter))) {
                    FileSystem subFS = subPath.getFileSystem(job);
                    if (!subFS.exists(subPath)) {
                        result.add(new IOException("Input path does not exist: " + subPath));
                        continue;
                    }
                    ++totalFiles;
                }
                continue;
            }
            Path[] paths = FileUtil.stat2Paths(fs.globStatus(p, hiddenFileFilter), p);
            if (paths.length == 0) {
                result.add(new IOException("Input Pattern " + p + " matches 0 files"));
                continue;
            }
            for (Path gPath : paths) {
                FileSystem gPathFS = gPath.getFileSystem(job);
                if (gPathFS.exists(gPath)) continue;
                result.add(new FileNotFoundException("Input path doesnt exist : " + gPath));
            }
            totalFiles += paths.length;
        }
        if (!result.isEmpty()) {
            throw new InvalidInputException(result);
        }
        LOG.info((Object)("Total input paths to process : " + totalFiles));
    }

    @Override
    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        Path[] files = this.listPaths(job);
        long totalSize = 0L;
        for (int i = 0; i < files.length; ++i) {
            Path file = files[i];
            FileSystem fs = file.getFileSystem(job);
            if (fs.isDirectory(file) || !fs.exists(file)) {
                throw new IOException("Not a file: " + files[i]);
            }
            totalSize += fs.getLength(files[i]);
        }
        long goalSize = totalSize / (long)(numSplits == 0 ? 1 : numSplits);
        long minSize = Math.max(job.getLong("mapred.min.split.size", 1L), this.minSplitSize);
        ArrayList<FileSplit> splits = new ArrayList<FileSplit>(numSplits);
        for (int i = 0; i < files.length; ++i) {
            Path file = files[i];
            FileSystem fs = file.getFileSystem(job);
            long length = fs.getLength(file);
            BlockLocation[] blkLocations = fs.getFileBlockLocations(file, 0L, length);
            if (length != 0L && this.isSplitable(fs, file)) {
                long blockSize = fs.getBlockSize(file);
                long splitSize = this.computeSplitSize(goalSize, minSize, blockSize);
                long bytesRemaining = length;
                while ((double)bytesRemaining / (double)splitSize > 1.1) {
                    int blkIndex = this.getBlockIndex(blkLocations, length - bytesRemaining);
                    splits.add(new FileSplit(file, length - bytesRemaining, splitSize, blkLocations[blkIndex].getHosts()));
                    bytesRemaining -= splitSize;
                }
                if (bytesRemaining == 0L) continue;
                splits.add(new FileSplit(file, length - bytesRemaining, bytesRemaining, blkLocations[blkLocations.length - 1].getHosts()));
                continue;
            }
            if (length != 0L) {
                splits.add(new FileSplit(file, 0L, length, blkLocations[0].getHosts()));
                continue;
            }
            splits.add(new FileSplit(file, 0L, length, new String[0]));
        }
        LOG.debug((Object)("Total # of splits: " + splits.size()));
        return splits.toArray(new FileSplit[splits.size()]);
    }

    protected long computeSplitSize(long goalSize, long minSize, long blockSize) {
        return Math.max(minSize, Math.min(goalSize, blockSize));
    }

    protected int getBlockIndex(BlockLocation[] blkLocations, long offset) {
        for (int i = 0; i < blkLocations.length; ++i) {
            if (blkLocations[i].getOffset() > offset || offset >= blkLocations[i].getOffset() + blkLocations[i].getLength()) continue;
            return i;
        }
        BlockLocation last = blkLocations[blkLocations.length];
        long fileLength = last.getOffset() + last.getLength() - 1L;
        throw new IllegalArgumentException("Offset " + offset + " is outside of file (0.." + fileLength + ")");
    }

    public static void setInputPaths(JobConf conf, String commaSeparatedPaths) {
        FileInputFormat.setInputPaths(conf, StringUtils.stringToPath(FileInputFormat.getPathStrings(commaSeparatedPaths)));
    }

    public static void addInputPaths(JobConf conf, String commaSeparatedPaths) {
        for (String str : FileInputFormat.getPathStrings(commaSeparatedPaths)) {
            FileInputFormat.addInputPath(conf, new Path(str));
        }
    }

    public static void setInputPaths(JobConf conf, Path ... inputPaths) {
        Path path = new Path(conf.getWorkingDirectory(), inputPaths[0]);
        StringBuffer str = new StringBuffer(StringUtils.escapeString(path.toString()));
        for (int i = 1; i < inputPaths.length; ++i) {
            str.append(",");
            path = new Path(conf.getWorkingDirectory(), inputPaths[i]);
            str.append(StringUtils.escapeString(path.toString()));
        }
        conf.set("mapred.input.dir", str.toString());
    }

    public static void addInputPath(JobConf conf, Path path) {
        path = new Path(conf.getWorkingDirectory(), path);
        String dirStr = StringUtils.escapeString(path.toString());
        String dirs = conf.get("mapred.input.dir");
        conf.set("mapred.input.dir", dirs == null ? dirStr : dirs + "," + dirStr);
    }

    private static String[] getPathStrings(String commaSeparatedPaths) {
        int length = commaSeparatedPaths.length();
        int curlyOpen = 0;
        int pathStart = 0;
        boolean globPattern = false;
        ArrayList<String> pathStrings = new ArrayList<String>();
        block5: for (int i = 0; i < length; ++i) {
            char ch = commaSeparatedPaths.charAt(i);
            switch (ch) {
                case '{': {
                    ++curlyOpen;
                    if (globPattern) continue block5;
                    globPattern = true;
                    continue block5;
                }
                case '}': {
                    if (--curlyOpen != 0 || !globPattern) continue block5;
                    globPattern = false;
                    continue block5;
                }
                case ',': {
                    if (globPattern) continue block5;
                    pathStrings.add(commaSeparatedPaths.substring(pathStart, i));
                    pathStart = i + 1;
                }
            }
        }
        pathStrings.add(commaSeparatedPaths.substring(pathStart, length));
        return pathStrings.toArray(new String[0]);
    }

    public static Path[] getInputPaths(JobConf conf) {
        String dirs = conf.get("mapred.input.dir", "");
        String[] list = StringUtils.split(dirs);
        Path[] result = new Path[list.length];
        for (int i = 0; i < list.length; ++i) {
            result[i] = new Path(StringUtils.unEscapeString(list[i]));
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiPathFilter
    implements PathFilter {
        private List<PathFilter> filters;

        public MultiPathFilter(List<PathFilter> filters) {
            this.filters = filters;
        }

        @Override
        public boolean accept(Path path) {
            for (PathFilter filter : this.filters) {
                if (filter.accept(path)) continue;
                return false;
            }
            return true;
        }
    }
}

