/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.TaskTrackerAction;

class HeartbeatResponse
implements Writable,
Configurable {
    Configuration conf = null;
    short responseId;
    int heartbeatInterval;
    TaskTrackerAction[] actions;

    HeartbeatResponse() {
    }

    HeartbeatResponse(short responseId, TaskTrackerAction[] actions) {
        this.responseId = responseId;
        this.actions = actions;
        this.heartbeatInterval = 5000;
    }

    public void setResponseId(short responseId) {
        this.responseId = responseId;
    }

    public short getResponseId() {
        return this.responseId;
    }

    public void setActions(TaskTrackerAction[] actions) {
        this.actions = actions;
    }

    public TaskTrackerAction[] getActions() {
        return this.actions;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setHeartbeatInterval(int interval) {
        this.heartbeatInterval = interval;
    }

    public int getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public void write(DataOutput out) throws IOException {
        out.writeShort(this.responseId);
        out.writeInt(this.heartbeatInterval);
        if (this.actions == null) {
            WritableUtils.writeVInt(out, 0);
        } else {
            WritableUtils.writeVInt(out, this.actions.length);
            for (TaskTrackerAction action : this.actions) {
                WritableUtils.writeEnum(out, action.getActionId());
                action.write(out);
            }
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.responseId = in.readShort();
        this.heartbeatInterval = in.readInt();
        int length = WritableUtils.readVInt(in);
        if (length > 0) {
            this.actions = new TaskTrackerAction[length];
            for (int i = 0; i < length; ++i) {
                TaskTrackerAction.ActionType actionType = WritableUtils.readEnum(in, TaskTrackerAction.ActionType.class);
                this.actions[i] = TaskTrackerAction.createAction(actionType);
                this.actions[i].readFields(in);
            }
        } else {
            this.actions = null;
        }
    }
}

