/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.util.RunJar;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class JobShell
extends Configured
implements Tool {
    private FileSystem localFs;
    protected static final Log LOG = LogFactory.getLog((String)JobShell.class.getName());
    private CommandLineParser parser = new GnuParser();
    private Options opts = new Options();

    public JobShell() {
        this(null);
    }

    public JobShell(Configuration conf) {
        super(conf);
        this.setUpOptions();
    }

    private Option createOption(String name, String desc, String argName, int max) {
        OptionBuilder.withArgName((String)argName);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)desc);
        return OptionBuilder.create((String)name);
    }

    private void setUpOptions() {
        Option libjar = this.createOption("libjars", "comma seperated jar files to include in the classpath.", "paths", 1);
        Option file = this.createOption("files", "comma seperated files to be copied to the map reduce cluster.", "paths", 1);
        Option archives = this.createOption("archives", "comma seperated archives to be unarchives on the compute machines.", "paths", 1);
        this.opts.addOption(libjar);
        this.opts.addOption(file);
        this.opts.addOption(archives);
    }

    protected void init() throws IOException {
        this.getConf().setQuietMode(true);
    }

    private String validateFiles(String files) throws IOException {
        if (files == null) {
            return null;
        }
        String[] fileArr = files.split(",");
        String[] finalArr = new String[fileArr.length];
        for (int i = 0; i < fileArr.length; ++i) {
            String finalPath;
            String tmp = fileArr[i];
            Path path = new Path(tmp);
            URI pathURI = path.toUri();
            if (pathURI.getScheme() == null) {
                if (!this.localFs.exists(path)) {
                    throw new FileNotFoundException("File " + tmp + " does not exist.");
                }
                finalPath = path.makeQualified(this.localFs).toString();
            } else {
                FileSystem fs = path.getFileSystem(this.getConf());
                if (!fs.exists(path)) {
                    throw new FileNotFoundException("File " + tmp + " does not exist.");
                }
                finalPath = path.makeQualified(fs).toString();
                try {
                    fs.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            finalArr[i] = finalPath;
        }
        return StringUtils.arrayToString(finalArr);
    }

    public int run(String[] argv) throws Exception {
        int exitCode = -1;
        Configuration conf = this.getConf();
        this.localFs = FileSystem.getLocal(conf);
        CommandLine cmdLine = null;
        try {
            try {
                cmdLine = this.parser.parse(this.opts, argv, true);
            }
            catch (Exception ie) {
                LOG.error((Object)ie.getMessage());
                this.printUsage();
            }
            if (cmdLine != null) {
                String allFiles = cmdLine.getOptionValue("files");
                String alllibJars = cmdLine.getOptionValue("libjars");
                String allArchives = cmdLine.getOptionValue("archives");
                if (allFiles != null) {
                    String allFilesVal = this.validateFiles(allFiles);
                    conf.set("tmpfiles", allFilesVal);
                }
                if (alllibJars != null) {
                    String alllibJarsVal = this.validateFiles(alllibJars);
                    conf.set("tmpjars", alllibJarsVal);
                }
                if (allArchives != null) {
                    String allArchivesVal = this.validateFiles(allArchives);
                    conf.set("tmparchives", allArchivesVal);
                }
                JobClient.setCommandLineConfig(conf);
                try {
                    String[] args = cmdLine.getArgs();
                    if (args.length == 0) {
                        this.printUsage();
                        return -1;
                    }
                    RunJar.main(cmdLine.getArgs());
                    exitCode = 0;
                }
                catch (Throwable th) {
                    System.err.println(StringUtils.stringifyException(th));
                }
            }
        }
        catch (RuntimeException re) {
            exitCode = -1;
            System.err.println(re.getLocalizedMessage());
        }
        return exitCode;
    }

    private void printUsage() {
        System.out.println("Usage: $HADOOP_HOME/bin/hadoop \\");
        System.out.println("       [--config dir] jar \\");
        System.out.println("       [-libjars <comma seperated list of jars>] \\");
        System.out.println("       [-archives <comma seperated list of archives>] \\");
        System.out.println("       [-files <comma seperated list of files>] \\");
        System.out.println("       jarFile [mainClass] args");
    }

    public static void main(String[] argv) throws Exception {
        JobShell jshell = new JobShell();
        int res = ToolRunner.run(jshell, argv);
        System.exit(res);
    }
}

