/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AccessControlException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.CompletedJobStatusStore;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.DisallowedTaskTrackerException;
import org.apache.hadoop.mapred.HeartbeatResponse;
import org.apache.hadoop.mapred.InterTrackerProtocol;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobEndNotifier;
import org.apache.hadoop.mapred.JobHistory;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.JobSubmissionProtocol;
import org.apache.hadoop.mapred.KillJobAction;
import org.apache.hadoop.mapred.KillTaskAction;
import org.apache.hadoop.mapred.LaunchTaskAction;
import org.apache.hadoop.mapred.MRConstants;
import org.apache.hadoop.mapred.ReinitTrackerAction;
import org.apache.hadoop.mapred.StatusHttpServer;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskInProgress;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTrackerAction;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.metrics.jvm.JvmMetrics;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.net.ScriptBasedMapping;
import org.apache.hadoop.util.HostsFileReader;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobTracker
implements MRConstants,
InterTrackerProtocol,
JobSubmissionProtocol {
    static long TASKTRACKER_EXPIRY_INTERVAL = 600000L;
    static long RETIRE_JOB_INTERVAL;
    static long RETIRE_JOB_CHECK_INTERVAL;
    static float TASK_ALLOC_EPSILON;
    static float PAD_FRACTION;
    static final int MIN_CLUSTER_SIZE_FOR_PADDING = 3;
    State state = State.INITIALIZING;
    private static final int SYSTEM_DIR_CLEANUP_RETRY_PERIOD = 10000;
    private DNSToSwitchMapping dnsToSwitchMapping;
    private NetworkTopology clusterMap = new NetworkTopology();
    private ResolutionThread resThread = new ResolutionThread();
    private int numTaskCacheLevels;
    private Set<Node> nodesAtMaxLevel = new HashSet<Node>();
    static final FsPermission SYSTEM_DIR_PERMISSION;
    final int MAX_COMPLETE_USER_JOBS_IN_MEMORY;
    private static NumberFormat idFormat;
    private int nextJobId = 1;
    public static final Log LOG;
    private JobTrackerMetrics myMetrics = null;
    int port;
    String localMachine;
    private String trackerIdentifier;
    long startTime;
    int totalSubmissions = 0;
    private int totalMapTaskCapacity;
    private int totalReduceTaskCapacity;
    private HostsFileReader hostsReader;
    Map<String, JobInProgress> jobs = new TreeMap<String, JobInProgress>();
    List<JobInProgress> jobsByPriority = new ArrayList<JobInProgress>();
    TreeMap<String, ArrayList<JobInProgress>> userToJobsMap = new TreeMap();
    Map<String, TaskInProgress> taskidToTIPMap = new TreeMap<String, TaskInProgress>();
    TreeMap<String, String> taskidToTrackerMap = new TreeMap();
    TreeMap<String, Set<String>> trackerToTaskMap = new TreeMap();
    TreeMap<String, Set<String>> trackerToMarkedTasksMap = new TreeMap();
    Map<String, HeartbeatResponse> trackerToHeartbeatResponseMap = new TreeMap<String, HeartbeatResponse>();
    Map<String, Node> hostnameToNodeMap = Collections.synchronizedMap(new TreeMap());
    int numResolved;
    int totalMaps = 0;
    int totalReduces = 0;
    private TreeMap<String, TaskTrackerStatus> taskTrackers = new TreeMap();
    List<JobInProgress> jobInitQueue = new ArrayList<JobInProgress>();
    ExpireTrackers expireTrackers = new ExpireTrackers();
    Thread expireTrackersThread = null;
    RetireJobs retireJobs = new RetireJobs();
    Thread retireJobsThread = null;
    JobInitThread initJobs = new JobInitThread();
    Thread initJobsThread = null;
    ExpireLaunchingTasks expireLaunchingTasks = new ExpireLaunchingTasks();
    Thread expireLaunchingTaskThread = new Thread((Runnable)this.expireLaunchingTasks, "expireLaunchingTasks");
    CompletedJobStatusStore completedJobStatusStore = null;
    Thread completedJobsStoreThread = null;
    TreeSet<TaskTrackerStatus> trackerExpiryQueue = new TreeSet<TaskTrackerStatus>(new Comparator<TaskTrackerStatus>(){

        @Override
        public int compare(TaskTrackerStatus p1, TaskTrackerStatus p2) {
            if (p1.getLastSeen() < p2.getLastSeen()) {
                return -1;
            }
            if (p1.getLastSeen() > p2.getLastSeen()) {
                return 1;
            }
            return p1.getTrackerName().compareTo(p2.getTrackerName());
        }
    });
    StatusHttpServer infoServer;
    int infoPort;
    Server interTrackerServer;
    static final String SUBDIR = "jobTracker";
    FileSystem fs = null;
    Path systemDir = null;
    private JobConf conf;
    private Thread taskCommitThread;

    public static JobTracker startTracker(JobConf conf) throws IOException, InterruptedException {
        JobTracker result = null;
        while (true) {
            try {
                result = new JobTracker(conf);
            }
            catch (RPC.VersionMismatch e) {
                throw e;
            }
            catch (BindException e) {
                throw e;
            }
            catch (UnknownHostException e) {
                throw e;
            }
            catch (IOException e) {
                LOG.warn((Object)("Error starting tracker: " + StringUtils.stringifyException(e)));
                Thread.sleep(1000L);
                continue;
            }
            break;
        }
        if (result != null) {
            JobEndNotifier.startNotifier();
        }
        return result;
    }

    public void stopTracker() throws IOException {
        JobEndNotifier.stopNotifier();
        this.close();
    }

    @Override
    public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
        if (protocol.equals(InterTrackerProtocol.class.getName())) {
            return 10L;
        }
        if (protocol.equals(JobSubmissionProtocol.class.getName())) {
            return 7L;
        }
        throw new IOException("Unknown protocol to job tracker: " + protocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JobTracker(JobConf conf) throws IOException, InterruptedException {
        int tmpInfoPort;
        TASKTRACKER_EXPIRY_INTERVAL = conf.getLong("mapred.tasktracker.expiry.interval", 600000L);
        RETIRE_JOB_INTERVAL = conf.getLong("mapred.jobtracker.retirejob.interval", 86400000L);
        RETIRE_JOB_CHECK_INTERVAL = conf.getLong("mapred.jobtracker.retirejob.check", 60000L);
        TASK_ALLOC_EPSILON = conf.getFloat("mapred.jobtracker.taskalloc.loadbalance.epsilon", 0.2f);
        PAD_FRACTION = conf.getFloat("mapred.jobtracker.taskalloc.capacitypad", 0.01f);
        this.MAX_COMPLETE_USER_JOBS_IN_MEMORY = conf.getInt("mapred.jobtracker.completeuserjobs.maximum", 100);
        this.conf = conf;
        JobConf jobConf = new JobConf(conf);
        this.hostsReader = new HostsFileReader(conf.get("mapred.hosts", ""), conf.get("mapred.hosts.exclude", ""));
        InetSocketAddress addr = JobTracker.getAddress(conf);
        this.localMachine = addr.getHostName();
        this.port = addr.getPort();
        int handlerCount = conf.getInt("mapred.job.tracker.handler.count", 10);
        this.interTrackerServer = RPC.getServer(this, addr.getHostName(), addr.getPort(), handlerCount, false, conf);
        this.interTrackerServer.start();
        if (LOG.isDebugEnabled()) {
            Properties p = System.getProperties();
            for (String string : p.keySet()) {
                String val = p.getProperty(string);
                LOG.debug((Object)("Property '" + string + "' is " + val));
            }
        }
        String infoAddr = NetUtils.getServerAddress(conf, "mapred.job.tracker.info.bindAddress", "mapred.job.tracker.info.port", "mapred.job.tracker.http.address");
        InetSocketAddress infoSocAddr = NetUtils.createSocketAddr(infoAddr);
        String string = infoSocAddr.getHostName();
        this.infoServer = new StatusHttpServer("job", string, tmpInfoPort, (tmpInfoPort = infoSocAddr.getPort()) == 0);
        this.infoServer.setAttribute("job.tracker", this);
        boolean historyInitialized = JobHistory.init(conf, this.localMachine);
        String historyLogDir = null;
        FileSystem historyFS = null;
        if (historyInitialized) {
            historyLogDir = conf.get("hadoop.job.history.location");
            this.infoServer.setAttribute("historyLogDir", historyLogDir);
            historyFS = new Path(historyLogDir).getFileSystem(conf);
            this.infoServer.setAttribute("fileSys", historyFS);
        }
        this.infoServer.start();
        this.startTime = System.currentTimeMillis();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmm");
        this.trackerIdentifier = dateFormat.format(new Date());
        this.myMetrics = new JobTrackerMetrics(this, jobConf);
        this.port = this.interTrackerServer.getListenerAddress().getPort();
        this.conf.set("mapred.job.tracker", this.localMachine + ":" + this.port);
        LOG.info((Object)("JobTracker up at: " + this.port));
        this.infoPort = this.infoServer.getPort();
        this.conf.set("mapred.job.tracker.http.address", string + ":" + this.infoPort);
        LOG.info((Object)("JobTracker webserver: " + this.infoServer.getPort()));
        this.systemDir = jobConf.getSystemDir();
        while (true) {
            try {
                if (this.fs == null) {
                    this.fs = FileSystem.get(conf);
                }
                this.fs.delete(this.systemDir, true);
                if (FileSystem.mkdirs(this.fs, this.systemDir, new FsPermission(SYSTEM_DIR_PERMISSION))) break;
                LOG.error((Object)("Mkdirs failed to create " + this.systemDir));
            }
            catch (IOException ie) {
                if (ie instanceof RemoteException && AccessControlException.class.getName().equals(((RemoteException)ie).getClassName())) {
                    throw ie;
                }
                LOG.info((Object)("problem cleaning system directory: " + this.systemDir), (Throwable)ie);
            }
            Thread.sleep(10000L);
        }
        jobConf.deleteLocalFiles(SUBDIR);
        if (!historyInitialized) {
            JobHistory.init(conf, this.localMachine);
            historyLogDir = conf.get("hadoop.job.history.location");
            this.infoServer.setAttribute("historyLogDir", historyLogDir);
            historyFS = new Path(historyLogDir).getFileSystem(conf);
            this.infoServer.setAttribute("fileSys", historyFS);
        }
        this.dnsToSwitchMapping = (DNSToSwitchMapping)ReflectionUtils.newInstance(conf.getClass("topology.node.switch.mapping.impl", ScriptBasedMapping.class, DNSToSwitchMapping.class), conf);
        this.numTaskCacheLevels = conf.getInt("mapred.task.cache.levels", 2);
        JobTracker jobTracker = this;
        synchronized (jobTracker) {
            this.state = State.RUNNING;
        }
        this.completedJobStatusStore = new CompletedJobStatusStore(conf);
        LOG.info((Object)"Starting RUNNING");
    }

    public static InetSocketAddress getAddress(Configuration conf) {
        String jobTrackerStr = conf.get("mapred.job.tracker", "localhost:8012");
        return NetUtils.createSocketAddr(jobTrackerStr);
    }

    public void offerService() throws InterruptedException {
        this.expireTrackersThread = new Thread((Runnable)this.expireTrackers, "expireTrackers");
        this.expireTrackersThread.start();
        this.resThread.start();
        this.retireJobsThread = new Thread((Runnable)this.retireJobs, "retireJobs");
        this.retireJobsThread.start();
        this.initJobsThread = new Thread((Runnable)this.initJobs, "initJobs");
        this.initJobsThread.start();
        this.expireLaunchingTaskThread.start();
        this.taskCommitThread = new TaskCommitQueue();
        this.taskCommitThread.start();
        if (this.completedJobStatusStore.isActive()) {
            this.completedJobsStoreThread = new Thread((Runnable)this.completedJobStatusStore, "completedjobsStore-housekeeper");
            this.completedJobsStoreThread.start();
        }
        this.interTrackerServer.join();
        LOG.info((Object)"Stopped interTrackerServer");
    }

    void close() throws IOException {
        if (this.infoServer != null) {
            LOG.info((Object)"Stopping infoServer");
            try {
                this.infoServer.stop();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        if (this.interTrackerServer != null) {
            LOG.info((Object)"Stopping interTrackerServer");
            this.interTrackerServer.stop();
        }
        if (this.expireTrackersThread != null && this.expireTrackersThread.isAlive()) {
            LOG.info((Object)"Stopping expireTrackers");
            this.expireTrackersThread.interrupt();
            try {
                this.expireTrackersThread.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        if (this.retireJobsThread != null && this.retireJobsThread.isAlive()) {
            LOG.info((Object)"Stopping retirer");
            this.retireJobsThread.interrupt();
            try {
                this.retireJobsThread.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        if (this.initJobsThread != null && this.initJobsThread.isAlive()) {
            LOG.info((Object)"Stopping initer");
            this.initJobsThread.interrupt();
            try {
                this.initJobsThread.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        if (this.expireLaunchingTaskThread != null && this.expireLaunchingTaskThread.isAlive()) {
            LOG.info((Object)"Stopping expireLaunchingTasks");
            this.expireLaunchingTaskThread.interrupt();
            try {
                this.expireLaunchingTaskThread.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        if (this.taskCommitThread != null) {
            LOG.info((Object)"Stopping TaskCommit thread");
            this.taskCommitThread.interrupt();
            try {
                this.taskCommitThread.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        if (this.resThread != null) {
            LOG.info((Object)"Stopping DNSToSwitchMapping Resolution thread");
            this.resThread.interrupt();
            try {
                this.resThread.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        if (this.completedJobsStoreThread != null && this.completedJobsStoreThread.isAlive()) {
            LOG.info((Object)"Stopping completedJobsStore thread");
            this.completedJobsStoreThread.interrupt();
            try {
                this.completedJobsStoreThread.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        LOG.info((Object)"stopped all jobtracker services");
    }

    void createTaskEntry(String taskid, String taskTracker, TaskInProgress tip) {
        LOG.info((Object)("Adding task '" + taskid + "' to tip " + tip.getTIPId() + ", for tracker '" + taskTracker + "'"));
        this.taskidToTrackerMap.put(taskid, taskTracker);
        Set<String> taskset = this.trackerToTaskMap.get(taskTracker);
        if (taskset == null) {
            taskset = new TreeSet<String>();
            this.trackerToTaskMap.put(taskTracker, taskset);
        }
        taskset.add(taskid);
        this.taskidToTIPMap.put(taskid, tip);
    }

    void removeTaskEntry(String taskid) {
        Set<String> trackerSet;
        String tracker = this.taskidToTrackerMap.remove(taskid);
        if (tracker != null && (trackerSet = this.trackerToTaskMap.get(tracker)) != null) {
            trackerSet.remove(taskid);
        }
        this.taskidToTIPMap.remove(taskid);
        LOG.debug((Object)("Removing task '" + taskid + "'"));
    }

    void markCompletedTaskAttempt(String taskTracker, String taskid) {
        Set<String> taskset = this.trackerToMarkedTasksMap.get(taskTracker);
        if (taskset == null) {
            taskset = new TreeSet<String>();
            this.trackerToMarkedTasksMap.put(taskTracker, taskset);
        }
        taskset.add(taskid);
        LOG.debug((Object)("Marked '" + taskid + "' from '" + taskTracker + "'"));
    }

    void markCompletedJob(JobInProgress job) {
        for (TaskInProgress tip : job.getMapTasks()) {
            for (TaskStatus taskStatus : tip.getTaskStatuses()) {
                if (taskStatus.getRunState() == TaskStatus.State.RUNNING || taskStatus.getRunState() == TaskStatus.State.COMMIT_PENDING) continue;
                this.markCompletedTaskAttempt(taskStatus.getTaskTracker(), taskStatus.getTaskId());
            }
        }
        for (TaskInProgress tip : job.getReduceTasks()) {
            for (TaskStatus taskStatus : tip.getTaskStatuses()) {
                if (taskStatus.getRunState() == TaskStatus.State.RUNNING || taskStatus.getRunState() == TaskStatus.State.COMMIT_PENDING) continue;
                this.markCompletedTaskAttempt(taskStatus.getTaskTracker(), taskStatus.getTaskId());
            }
        }
    }

    private void removeMarkedTasks(String taskTracker) {
        Set<String> markedTaskSet = this.trackerToMarkedTasksMap.get(taskTracker);
        if (markedTaskSet != null) {
            for (String taskid : markedTaskSet) {
                this.removeTaskEntry(taskid);
                LOG.info((Object)("Removed completed task '" + taskid + "' from '" + taskTracker + "'"));
            }
            this.trackerToMarkedTasksMap.remove(taskTracker);
        }
    }

    private synchronized void removeJobTasks(JobInProgress job) {
        for (TaskInProgress tip : job.getMapTasks()) {
            for (TaskStatus taskStatus : tip.getTaskStatuses()) {
                this.removeTaskEntry(taskStatus.getTaskId());
            }
        }
        for (TaskInProgress tip : job.getReduceTasks()) {
            for (TaskStatus taskStatus : tip.getTaskStatuses()) {
                this.removeTaskEntry(taskStatus.getTaskId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void finalizeJob(JobInProgress job) {
        this.markCompletedJob(job);
        this.completedJobStatusStore.store(job);
        JobEndNotifier.registerNotification(job.getJobConf(), job.getStatus());
        Map<String, JobInProgress> map = this.jobs;
        synchronized (map) {
            List<JobInProgress> list = this.jobsByPriority;
            synchronized (list) {
                List<JobInProgress> list2 = this.jobInitQueue;
                synchronized (list2) {
                    TreeMap<String, ArrayList<JobInProgress>> treeMap = this.userToJobsMap;
                    synchronized (treeMap) {
                        ArrayList<JobInProgress> userJobs;
                        String jobUser = job.getProfile().getUser();
                        if (!this.userToJobsMap.containsKey(jobUser)) {
                            this.userToJobsMap.put(jobUser, new ArrayList());
                        }
                        ArrayList<JobInProgress> arrayList = userJobs = this.userToJobsMap.get(jobUser);
                        synchronized (arrayList) {
                            int rjobRunState;
                            JobInProgress rjob;
                            userJobs.add(job);
                            while (userJobs.size() > this.MAX_COMPLETE_USER_JOBS_IN_MEMORY && (rjob = userJobs.get(0)) != job && ((rjobRunState = rjob.getStatus().getRunState()) == 2 || rjobRunState == 3)) {
                                this.removeJobTasks(rjob);
                                userJobs.remove(0);
                                this.jobs.remove(rjob.getProfile().getJobId());
                                this.jobInitQueue.remove(rjob);
                                this.jobsByPriority.remove(rjob);
                                LOG.info((Object)("Retired job with id: '" + rjob.getProfile().getJobId() + "' of user: '" + jobUser + "'"));
                            }
                        }
                        if (userJobs.isEmpty()) {
                            this.userToJobsMap.remove(jobUser);
                        }
                    }
                }
            }
        }
    }

    public int getTotalSubmissions() {
        return this.totalSubmissions;
    }

    public String getJobTrackerMachine() {
        return this.localMachine;
    }

    public String getTrackerIdentifier() {
        return this.trackerIdentifier;
    }

    public int getTrackerPort() {
        return this.port;
    }

    public int getInfoPort() {
        return this.infoPort;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Vector<JobInProgress> runningJobs() {
        Vector<JobInProgress> v = new Vector<JobInProgress>();
        for (JobInProgress jip : this.jobs.values()) {
            JobStatus status = jip.getStatus();
            if (status.getRunState() != 1) continue;
            v.add(jip);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<JobInProgress> getRunningJobs() {
        Map<String, JobInProgress> map = this.jobs;
        synchronized (map) {
            return this.runningJobs();
        }
    }

    public Vector<JobInProgress> failedJobs() {
        Vector<JobInProgress> v = new Vector<JobInProgress>();
        for (JobInProgress jip : this.jobs.values()) {
            JobStatus status = jip.getStatus();
            if (status.getRunState() != 3) continue;
            v.add(jip);
        }
        return v;
    }

    public Vector<JobInProgress> completedJobs() {
        Vector<JobInProgress> v = new Vector<JobInProgress>();
        for (JobInProgress jip : this.jobs.values()) {
            JobStatus status = jip.getStatus();
            if (status.getRunState() != 2) continue;
            v.add(jip);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection taskTrackers() {
        TreeMap<String, TaskTrackerStatus> treeMap = this.taskTrackers;
        synchronized (treeMap) {
            return this.taskTrackers.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskTrackerStatus getTaskTracker(String trackerID) {
        TreeMap<String, TaskTrackerStatus> treeMap = this.taskTrackers;
        synchronized (treeMap) {
            return this.taskTrackers.get(trackerID);
        }
    }

    public Node resolveAndAddToTopology(String name) {
        ArrayList<String> tmpList = new ArrayList<String>(1);
        tmpList.add(name);
        List<String> rNameList = this.dnsToSwitchMapping.resolve(tmpList);
        String rName = rNameList.get(0);
        String networkLoc = NodeBase.normalize(rName);
        return this.addHostToNodeMapping(name, networkLoc);
    }

    private Node addHostToNodeMapping(String host, String networkLoc) {
        Node node = this.clusterMap.getNode(networkLoc + "/" + host);
        if (node == null) {
            node = new NodeBase(host, networkLoc);
            this.clusterMap.add(node);
            if (node.getLevel() < this.getNumTaskCacheLevels()) {
                LOG.fatal((Object)("Got a host whose level is: " + node.getLevel() + "." + " Should get at least a level of value: " + this.getNumTaskCacheLevels()));
                try {
                    this.stopTracker();
                }
                catch (IOException ie) {
                    LOG.warn((Object)("Exception encountered during shutdown: " + StringUtils.stringifyException(ie)));
                    System.exit(-1);
                }
            }
            this.hostnameToNodeMap.put(host, node);
            this.nodesAtMaxLevel.add(JobTracker.getParentNode(node, this.getNumTaskCacheLevels() - 1));
        }
        return node;
    }

    public Collection<Node> getNodesAtMaxLevel() {
        return this.nodesAtMaxLevel;
    }

    public static Node getParentNode(Node node, int level) {
        for (int i = 0; i < level; ++i) {
            node = node.getParent();
        }
        return node;
    }

    public Node getNode(String name) {
        return this.hostnameToNodeMap.get(name);
    }

    public int getNumTaskCacheLevels() {
        return this.numTaskCacheLevels;
    }

    public int getNumResolvedTaskTrackers() {
        return this.numResolved;
    }

    @Override
    public synchronized HeartbeatResponse heartbeat(TaskTrackerStatus status, boolean initialContact, boolean acceptNewTasks, short responseId) throws IOException {
        List<TaskTrackerAction> killTasksList;
        Task task;
        LOG.debug((Object)("Got heartbeat from: " + status.getTrackerName() + " (initialContact: " + initialContact + " acceptNewTasks: " + acceptNewTasks + ")" + " with responseId: " + responseId));
        if (!this.acceptTaskTracker(status)) {
            throw new DisallowedTaskTrackerException(status);
        }
        String trackerName = status.getTrackerName();
        HeartbeatResponse prevHeartbeatResponse = this.trackerToHeartbeatResponseMap.get(trackerName);
        if (!initialContact) {
            if (prevHeartbeatResponse == null) {
                LOG.warn((Object)("Serious problem, cannot find record of 'previous' heartbeat for '" + trackerName + "'; reinitializing the tasktracker"));
                return new HeartbeatResponse(responseId, new TaskTrackerAction[]{new ReinitTrackerAction()});
            }
            if (prevHeartbeatResponse.getResponseId() != responseId) {
                LOG.info((Object)("Ignoring 'duplicate' heartbeat from '" + trackerName + "'; resending the previous 'lost' response"));
                return prevHeartbeatResponse;
            }
        }
        short newResponseId = (short)(responseId + 1);
        if (!this.processHeartbeat(status, initialContact)) {
            if (prevHeartbeatResponse != null) {
                this.trackerToHeartbeatResponseMap.remove(trackerName);
            }
            return new HeartbeatResponse(newResponseId, new TaskTrackerAction[]{new ReinitTrackerAction()});
        }
        HeartbeatResponse response = new HeartbeatResponse(newResponseId, null);
        ArrayList<TaskTrackerAction> actions = new ArrayList<TaskTrackerAction>();
        if (acceptNewTasks && (task = this.getNewTaskForTaskTracker(trackerName)) != null) {
            LOG.debug((Object)(trackerName + " -> LaunchTask: " + task.getTaskId()));
            actions.add(new LaunchTaskAction(task));
        }
        if ((killTasksList = this.getTasksToKill(trackerName)) != null) {
            actions.addAll(killTasksList);
        }
        int nextInterval = this.getNextHeartbeatInterval();
        response.setHeartbeatInterval(nextInterval);
        response.setActions(actions.toArray(new TaskTrackerAction[actions.size()]));
        this.trackerToHeartbeatResponseMap.put(trackerName, response);
        this.removeMarkedTasks(trackerName);
        return response;
    }

    private int getNextHeartbeatInterval() {
        int clusterSize = this.getClusterStatus().getTaskTrackers();
        int heartbeatInterval = Math.max(1000 * (clusterSize / 50 + 1), 5000);
        return heartbeatInterval;
    }

    private boolean inHostsList(TaskTrackerStatus status) {
        Set<String> hostsList = this.hostsReader.getHosts();
        return hostsList.isEmpty() || hostsList.contains(status.getHost());
    }

    private boolean inExcludedHostsList(TaskTrackerStatus status) {
        Set<String> excludeList = this.hostsReader.getExcludedHosts();
        return excludeList.contains(status.getHost());
    }

    private boolean acceptTaskTracker(TaskTrackerStatus status) {
        return this.inHostsList(status) && !this.inExcludedHostsList(status);
    }

    private boolean updateTaskTrackerStatus(String trackerName, TaskTrackerStatus status) {
        TaskTrackerStatus oldStatus = this.taskTrackers.get(trackerName);
        if (oldStatus != null) {
            this.totalMaps -= oldStatus.countMapTasks();
            this.totalReduces -= oldStatus.countReduceTasks();
            this.totalMapTaskCapacity -= oldStatus.getMaxMapTasks();
            this.totalReduceTaskCapacity -= oldStatus.getMaxReduceTasks();
            if (status == null) {
                this.taskTrackers.remove(trackerName);
            }
        }
        if (status != null) {
            this.totalMaps += status.countMapTasks();
            this.totalReduces += status.countReduceTasks();
            this.totalMapTaskCapacity += status.getMaxMapTasks();
            this.totalReduceTaskCapacity += status.getMaxReduceTasks();
            this.taskTrackers.put(trackerName, status);
        }
        return oldStatus != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean processHeartbeat(TaskTrackerStatus trackerStatus, boolean initialContact) {
        String trackerName = trackerStatus.getTrackerName();
        trackerStatus.setLastSeen(System.currentTimeMillis());
        TreeMap<String, TaskTrackerStatus> treeMap = this.taskTrackers;
        synchronized (treeMap) {
            TreeSet<TaskTrackerStatus> treeSet = this.trackerExpiryQueue;
            synchronized (treeSet) {
                boolean seenBefore = this.updateTaskTrackerStatus(trackerName, trackerStatus);
                if (initialContact) {
                    if (seenBefore) {
                        this.lostTaskTracker(trackerName);
                    }
                } else if (!seenBefore) {
                    LOG.warn((Object)("Status from unknown Tracker : " + trackerName));
                    this.updateTaskTrackerStatus(trackerName, null);
                    return false;
                }
                if (initialContact) {
                    this.trackerExpiryQueue.add(trackerStatus);
                    this.resThread.addToResolutionQueue(trackerStatus);
                }
            }
        }
        this.updateTaskStatuses(trackerStatus);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Task getNewTaskForTaskTracker(String taskTracker) throws IOException {
        TaskTrackerStatus tts;
        int numTaskTrackers;
        int remainingReduceLoad = 0;
        int remainingMapLoad = 0;
        Object object = this.taskTrackers;
        synchronized (object) {
            numTaskTrackers = this.taskTrackers.size();
            tts = this.taskTrackers.get(taskTracker);
        }
        if (tts == null) {
            LOG.warn((Object)("Unknown task tracker polling; ignoring: " + taskTracker));
            return null;
        }
        object = this.jobsByPriority;
        synchronized (object) {
            for (JobInProgress job : this.jobsByPriority) {
                if (job.getStatus().getRunState() != 1) continue;
                int totalMapTasks = job.desiredMaps();
                int totalReduceTasks = job.desiredReduces();
                remainingMapLoad += totalMapTasks - job.finishedMaps();
                remainingReduceLoad += totalReduceTasks - job.finishedReduces();
            }
        }
        int maxCurrentMapTasks = tts.getMaxMapTasks();
        int maxCurrentReduceTasks = tts.getMaxReduceTasks();
        int maxMapLoad = 0;
        int maxReduceLoad = 0;
        if (numTaskTrackers > 0) {
            maxMapLoad = Math.min(maxCurrentMapTasks, (int)Math.ceil((double)remainingMapLoad / (double)numTaskTrackers));
            maxReduceLoad = Math.min(maxCurrentReduceTasks, (int)Math.ceil((double)remainingReduceLoad / (double)numTaskTrackers));
        }
        int numMaps = tts.countMapTasks();
        int numReduces = tts.countReduceTasks();
        List<JobInProgress> list = this.jobsByPriority;
        synchronized (list) {
            int padding;
            Task t;
            if (numMaps < maxMapLoad) {
                int totalNeededMaps = 0;
                for (JobInProgress job : this.jobsByPriority) {
                    if (job.getStatus().getRunState() != 1) continue;
                    t = job.obtainNewMapTask(tts, numTaskTrackers);
                    if (t != null) {
                        this.expireLaunchingTasks.addNewTask(t.getTaskId());
                        this.myMetrics.launchMap();
                        return t;
                    }
                    totalNeededMaps += job.desiredMaps();
                    padding = 0;
                    if (numTaskTrackers > 3) {
                        padding = Math.min(maxCurrentMapTasks, (int)((float)totalNeededMaps * PAD_FRACTION));
                    }
                    if (this.totalMaps + padding < this.totalMapTaskCapacity) continue;
                    break;
                }
            }
            if (numReduces < maxReduceLoad) {
                int totalNeededReduces = 0;
                for (JobInProgress job : this.jobsByPriority) {
                    if (job.getStatus().getRunState() != 1 || job.numReduceTasks == 0) continue;
                    t = job.obtainNewReduceTask(tts, numTaskTrackers);
                    if (t != null) {
                        this.expireLaunchingTasks.addNewTask(t.getTaskId());
                        this.myMetrics.launchReduce();
                        return t;
                    }
                    totalNeededReduces += job.desiredReduces();
                    padding = 0;
                    if (numTaskTrackers > 3) {
                        padding = Math.min(maxCurrentReduceTasks, (int)((float)totalNeededReduces * PAD_FRACTION));
                    }
                    if (this.totalReduces + padding < this.totalReduceTaskCapacity) continue;
                    break;
                }
            }
        }
        return null;
    }

    private synchronized List<TaskTrackerAction> getTasksToKill(String taskTracker) {
        Set<String> taskIds = this.trackerToTaskMap.get(taskTracker);
        if (taskIds != null) {
            ArrayList<TaskTrackerAction> killList = new ArrayList<TaskTrackerAction>();
            TreeSet<String> killJobIds = new TreeSet<String>();
            for (String killTaskId : taskIds) {
                TaskInProgress tip = this.taskidToTIPMap.get(killTaskId);
                if (!tip.shouldClose(killTaskId)) continue;
                if (tip.getJob().getStatus().getRunState() == 1) {
                    killList.add(new KillTaskAction(killTaskId));
                    LOG.debug((Object)(taskTracker + " -> KillTaskAction: " + killTaskId));
                    continue;
                }
                String killJobId = tip.getJob().getStatus().getJobId();
                killJobIds.add(killJobId);
            }
            for (String killJobId : killJobIds) {
                killList.add(new KillJobAction(killJobId));
                LOG.debug((Object)(taskTracker + " -> KillJobAction: " + killJobId));
            }
            return killList;
        }
        return null;
    }

    @Override
    public synchronized String getFilesystemName() throws IOException {
        if (this.fs == null) {
            throw new IllegalStateException("FileSystem object not available yet");
        }
        return this.fs.getUri().toString();
    }

    @Override
    public void reportTaskTrackerError(String taskTracker, String errorClass, String errorMessage) throws IOException {
        LOG.warn((Object)("Report from " + taskTracker + ": " + errorMessage));
    }

    static String getJobUniqueString(String jobid) {
        return jobid.substring(4);
    }

    private synchronized void ensureRunning() throws IllegalStateException {
        if (this.state != State.RUNNING) {
            throw new IllegalStateException("Job tracker still initializing");
        }
    }

    @Override
    public synchronized String getNewJobId() throws IOException {
        this.ensureRunning();
        return "job_" + this.getTrackerIdentifier() + "_" + idFormat.format(this.nextJobId++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized JobStatus submitJob(String jobId) throws IOException {
        this.ensureRunning();
        if (this.jobs.containsKey(jobId)) {
            return this.jobs.get(jobId).getStatus();
        }
        ++this.totalSubmissions;
        JobInProgress job = new JobInProgress(jobId, this, this.conf);
        Map<String, JobInProgress> map = this.jobs;
        synchronized (map) {
            List<JobInProgress> list = this.jobsByPriority;
            synchronized (list) {
                List<JobInProgress> list2 = this.jobInitQueue;
                synchronized (list2) {
                    this.jobs.put(job.getProfile().getJobId(), job);
                    this.jobsByPriority.add(job);
                    this.jobInitQueue.add(job);
                    this.resortPriority();
                    this.jobInitQueue.notifyAll();
                }
            }
        }
        this.myMetrics.submitJob();
        return job.getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void resortPriority() {
        Comparator<JobInProgress> comp = new Comparator<JobInProgress>(){

            @Override
            public int compare(JobInProgress o1, JobInProgress o2) {
                int res = o1.getPriority().compareTo(o2.getPriority());
                if (res == 0) {
                    res = o1.getStartTime() < o2.getStartTime() ? -1 : (o1.getStartTime() == o2.getStartTime() ? 0 : 1);
                }
                return res;
            }
        };
        List<JobInProgress> list = this.jobsByPriority;
        synchronized (list) {
            Collections.sort(this.jobsByPriority, comp);
        }
        list = this.jobInitQueue;
        synchronized (list) {
            Collections.sort(this.jobInitQueue, comp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ClusterStatus getClusterStatus() {
        TreeMap<String, TaskTrackerStatus> treeMap = this.taskTrackers;
        synchronized (treeMap) {
            return new ClusterStatus(this.taskTrackers.size(), this.totalMaps, this.totalReduces, this.totalMapTaskCapacity, this.totalReduceTaskCapacity, this.state);
        }
    }

    @Override
    public synchronized void killJob(String jobid) {
        JobInProgress job = this.jobs.get(jobid);
        job.kill();
    }

    @Override
    public synchronized JobProfile getJobProfile(String jobid) {
        JobInProgress job = this.jobs.get(jobid);
        if (job != null) {
            return job.getProfile();
        }
        return this.completedJobStatusStore.readJobProfile(jobid);
    }

    @Override
    public synchronized JobStatus getJobStatus(String jobid) {
        JobInProgress job = this.jobs.get(jobid);
        if (job != null) {
            return job.getStatus();
        }
        return this.completedJobStatusStore.readJobStatus(jobid);
    }

    @Override
    public synchronized Counters getJobCounters(String jobid) {
        JobInProgress job = this.jobs.get(jobid);
        if (job != null) {
            return job.getCounters();
        }
        return this.completedJobStatusStore.readCounters(jobid);
    }

    @Override
    public synchronized TaskReport[] getMapTaskReports(String jobid) {
        JobInProgress job = this.jobs.get(jobid);
        if (job == null) {
            return new TaskReport[0];
        }
        Vector<TaskReport> reports = new Vector<TaskReport>();
        Vector<TaskInProgress> completeMapTasks = job.reportTasksInProgress(true, true);
        for (TaskInProgress tip : completeMapTasks) {
            reports.add(tip.generateSingleReport());
        }
        Vector<TaskInProgress> incompleteMapTasks = job.reportTasksInProgress(true, false);
        for (TaskInProgress tip : incompleteMapTasks) {
            reports.add(tip.generateSingleReport());
        }
        return reports.toArray(new TaskReport[reports.size()]);
    }

    @Override
    public synchronized TaskReport[] getReduceTaskReports(String jobid) {
        JobInProgress job = this.jobs.get(jobid);
        if (job == null) {
            return new TaskReport[0];
        }
        Vector<TaskReport> reports = new Vector<TaskReport>();
        Vector<TaskInProgress> completeReduceTasks = job.reportTasksInProgress(false, true);
        for (TaskInProgress tip : completeReduceTasks) {
            reports.add(tip.generateSingleReport());
        }
        Vector<TaskInProgress> incompleteReduceTasks = job.reportTasksInProgress(false, false);
        for (TaskInProgress tip : incompleteReduceTasks) {
            reports.add(tip.generateSingleReport());
        }
        return reports.toArray(new TaskReport[reports.size()]);
    }

    @Override
    public synchronized TaskCompletionEvent[] getTaskCompletionEvents(String jobid, int fromEventId, int maxEvents) throws IOException {
        JobInProgress job = this.jobs.get(jobid);
        TaskCompletionEvent[] events = null != job ? job.getTaskCompletionEvents(fromEventId, maxEvents) : this.completedJobStatusStore.readJobTaskCompletionEvents(jobid, fromEventId, maxEvents);
        return events;
    }

    @Override
    public synchronized String[] getTaskDiagnostics(String jobId, String tipId, String taskId) throws IOException {
        JobInProgress job = this.jobs.get(jobId);
        if (job == null) {
            throw new IllegalArgumentException("Job " + jobId + " not found.");
        }
        TaskInProgress tip = job.getTaskInProgress(tipId);
        if (tip == null) {
            throw new IllegalArgumentException("TIP " + tipId + " not found.");
        }
        List<String> taskDiagnosticInfo = tip.getDiagnosticInfo(taskId);
        return taskDiagnosticInfo == null ? null : taskDiagnosticInfo.toArray(new String[0]);
    }

    TaskStatus[] getTaskStatuses(String jobid, String tipid) {
        TaskInProgress tip = this.getTip(jobid, tipid);
        return tip == null ? new TaskStatus[]{} : tip.getTaskStatuses();
    }

    TaskStatus getTaskStatus(String jobid, String tipid, String taskid) {
        TaskInProgress tip = this.getTip(jobid, tipid);
        return tip == null ? null : tip.getTaskStatus(taskid);
    }

    Counters getTipCounters(String jobid, String tipid) {
        TaskInProgress tip = this.getTip(jobid, tipid);
        return tip == null ? null : tip.getCounters();
    }

    private TaskInProgress getTip(String jobid, String tipid) {
        JobInProgress job = this.jobs.get(jobid);
        return job == null ? null : job.getTaskInProgress(tipid);
    }

    @Override
    public synchronized boolean killTask(String taskid, boolean shouldFail) throws IOException {
        TaskInProgress tip = this.taskidToTIPMap.get(taskid);
        if (tip != null) {
            return tip.killTask(taskid, shouldFail);
        }
        LOG.info((Object)("Kill task attempt failed since task " + taskid + " was not found"));
        return false;
    }

    public synchronized String getAssignedTracker(String taskId) {
        return this.taskidToTrackerMap.get(taskId);
    }

    @Override
    public JobStatus[] jobsToComplete() {
        Vector<JobStatus> v = new Vector<JobStatus>();
        for (JobInProgress jip : this.jobs.values()) {
            JobStatus status = jip.getStatus();
            if (status.getRunState() != 1 && status.getRunState() != 4) continue;
            status.setStartTime(jip.getStartTime());
            status.setUsername(jip.getProfile().getUser());
            v.add(status);
        }
        return v.toArray(new JobStatus[v.size()]);
    }

    @Override
    public JobStatus[] getAllJobs() {
        Vector<JobStatus> v = new Vector<JobStatus>();
        for (JobInProgress jip : this.jobs.values()) {
            JobStatus status = jip.getStatus();
            status.setStartTime(jip.getStartTime());
            status.setUsername(jip.getProfile().getUser());
            v.add(status);
        }
        return v.toArray(new JobStatus[v.size()]);
    }

    public JobInProgress getJob(String jobid) {
        return this.jobs.get(jobid);
    }

    synchronized void setJobPriority(String jobId, JobPriority priority) {
        JobInProgress job = this.jobs.get(jobId);
        if (job != null) {
            job.setPriority(priority);
            this.resortPriority();
        } else {
            LOG.warn((Object)("Trying to change the priority of an unknown job: " + jobId));
        }
    }

    void updateTaskStatuses(TaskTrackerStatus status) {
        String trackerName = status.getTrackerName();
        for (TaskStatus report : status.getTaskReports()) {
            List<String> failedFetchMaps;
            report.setTaskTracker(trackerName);
            String taskId = report.getTaskId();
            TaskInProgress tip = this.taskidToTIPMap.get(taskId);
            if (tip == null) {
                LOG.info((Object)("Serious problem.  While updating status, cannot find taskid " + report.getTaskId()));
            } else {
                this.expireLaunchingTasks.removeTask(taskId);
                tip.getJob().updateTaskStatus(tip, report, this.myMetrics);
            }
            if ((failedFetchMaps = report.getFetchFailedMaps()) == null) continue;
            for (String mapTaskId : failedFetchMaps) {
                TaskInProgress failedFetchMap = this.taskidToTIPMap.get(mapTaskId);
                if (failedFetchMap == null) continue;
                String failedFetchTrackerName = this.getAssignedTracker(mapTaskId);
                if (failedFetchTrackerName == null) {
                    failedFetchTrackerName = "Lost task tracker";
                }
                failedFetchMap.getJob().fetchFailureNotification(failedFetchMap, mapTaskId, failedFetchTrackerName, this.myMetrics);
            }
        }
    }

    void lostTaskTracker(String trackerName) {
        LOG.info((Object)("Lost tracker '" + trackerName + "'"));
        Set<String> lostTasks = this.trackerToTaskMap.get(trackerName);
        this.trackerToTaskMap.remove(trackerName);
        if (lostTasks != null) {
            HashSet<JobInProgress> jobsWithFailures = new HashSet<JobInProgress>();
            for (String taskId : lostTasks) {
                TaskInProgress tip = this.taskidToTIPMap.get(taskId);
                if (tip.isMapTask() || !tip.isComplete()) {
                    JobInProgress job = tip.getJob();
                    if (job.getStatus().getRunState() != 1) continue;
                    job.failedTask(tip, taskId, "Lost task tracker: " + trackerName, tip.isMapTask() ? TaskStatus.Phase.MAP : TaskStatus.Phase.REDUCE, TaskStatus.State.KILLED, trackerName, this.myMetrics);
                    jobsWithFailures.add(job);
                    continue;
                }
                if (tip.isMapTask() || !tip.isComplete()) continue;
                this.markCompletedTaskAttempt(trackerName, taskId);
            }
            for (JobInProgress job : jobsWithFailures) {
                job.addTrackerTaskFailure(trackerName);
            }
            this.removeMarkedTasks(trackerName);
        }
    }

    void addToCommitQueue(JobInProgress.JobWithTaskContext j) {
        ((TaskCommitQueue)this.taskCommitThread).addToQueue(j);
    }

    public static String getLocalJobFilePath(String jobId) {
        return JobHistory.JobInfo.getLocalJobFilePath(jobId);
    }

    public static void main(String[] argv) throws IOException, InterruptedException {
        StringUtils.startupShutdownMessage(JobTracker.class, argv, LOG);
        if (argv.length != 0) {
            System.out.println("usage: JobTracker");
            System.exit(-1);
        }
        try {
            JobTracker tracker = JobTracker.startTracker(new JobConf());
            tracker.offerService();
        }
        catch (Throwable e) {
            LOG.fatal((Object)StringUtils.stringifyException(e));
            System.exit(-1);
        }
    }

    static {
        SYSTEM_DIR_PERMISSION = FsPermission.createImmutable((short)475);
        idFormat = NumberFormat.getInstance();
        idFormat.setMinimumIntegerDigits(4);
        idFormat.setGroupingUsed(false);
        LOG = LogFactory.getLog((String)"org.apache.hadoop.mapred.JobTracker");
    }

    private class TaskCommitQueue
    extends Thread {
        private LinkedBlockingQueue<JobInProgress.JobWithTaskContext> queue = new LinkedBlockingQueue();

        public TaskCommitQueue() {
            this.setName("Task Commit Thread");
            this.setDaemon(true);
        }

        public void addToQueue(JobInProgress.JobWithTaskContext j) {
            while (true) {
                try {
                    this.queue.put(j);
                    return;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int batchCommitSize = JobTracker.this.conf.getInt("jobtracker.task.commit.batch.size", 5000);
            while (!this.isInterrupted()) {
                try {
                    Object object;
                    ArrayList<JobInProgress.JobWithTaskContext> jobList = new ArrayList<JobInProgress.JobWithTaskContext>(batchCommitSize);
                    jobList.add(this.queue.take());
                    this.queue.drainTo(jobList, batchCommitSize);
                    JobInProgress[] jobs = new JobInProgress[jobList.size()];
                    TaskInProgress[] tips = new TaskInProgress[jobList.size()];
                    String[] taskids = new String[jobList.size()];
                    JobTrackerMetrics[] metrics = new JobTrackerMetrics[jobList.size()];
                    Iterator iter = jobList.iterator();
                    int count = 0;
                    while (iter.hasNext()) {
                        JobInProgress.JobWithTaskContext j = (JobInProgress.JobWithTaskContext)iter.next();
                        jobs[count] = j.getJob();
                        tips[count] = j.getTIP();
                        taskids[count] = j.getTaskId();
                        metrics[count] = j.getJobTrackerMetrics();
                        ++count;
                    }
                    Task[] tasks = new Task[jobList.size()];
                    TaskStatus[] status = new TaskStatus[jobList.size()];
                    boolean[] isTipComplete = new boolean[jobList.size()];
                    TaskStatus.State[] states = new TaskStatus.State[jobList.size()];
                    JobTracker jobTracker = JobTracker.this;
                    synchronized (jobTracker) {
                        for (int i = 0; i < jobList.size(); ++i) {
                            JobInProgress jobInProgress = jobs[i];
                            synchronized (jobInProgress) {
                                object = tips[i];
                                synchronized (object) {
                                    status[i] = tips[i].getTaskStatus(taskids[i]);
                                    tasks[i] = tips[i].getTaskObject(taskids[i]);
                                    states[i] = status[i].getRunState();
                                    isTipComplete[i] = tips[i].isComplete();
                                }
                            }
                        }
                    }
                    HashSet<String> seenTIPs = new HashSet<String>();
                    for (int index = 0; index < jobList.size(); ++index) {
                        try {
                            if (states[index] != TaskStatus.State.COMMIT_PENDING || isTipComplete[index]) continue;
                            if (!seenTIPs.contains(tips[index].getTIPId())) {
                                tasks[index].saveTaskOutput();
                                seenTIPs.add(tips[index].getTIPId());
                                continue;
                            }
                            isTipComplete[index] = true;
                            continue;
                        }
                        catch (IOException ioe) {
                            states[index] = TaskStatus.State.FAILED;
                            object = JobTracker.this;
                            synchronized (object) {
                                String reason = "Failed to rename output with the exception: " + StringUtils.stringifyException(ioe);
                                TaskStatus.Phase phase = tips[index].isMapTask() ? TaskStatus.Phase.MAP : TaskStatus.Phase.REDUCE;
                                jobs[index].failedTask(tips[index], status[index].getTaskId(), reason, phase, TaskStatus.State.FAILED, status[index].getTaskTracker(), null);
                            }
                            LOG.info((Object)("Failed to rename the output of " + status[index].getTaskId() + " with " + StringUtils.stringifyException(ioe)));
                        }
                    }
                    JobTracker jobTracker2 = JobTracker.this;
                    synchronized (jobTracker2) {
                        for (int i = 0; i < jobList.size(); ++i) {
                            TaskStatus newStatus = null;
                            if (states[i] != TaskStatus.State.COMMIT_PENDING) continue;
                            JobInProgress jobInProgress = jobs[i];
                            synchronized (jobInProgress) {
                                TaskInProgress taskInProgress = tips[i];
                                synchronized (taskInProgress) {
                                    status[i] = tips[i].getTaskStatus(taskids[i]);
                                    if (!isTipComplete[i]) {
                                        states[i] = status[i].getRunState() != TaskStatus.State.COMMIT_PENDING ? TaskStatus.State.KILLED : TaskStatus.State.SUCCEEDED;
                                    } else {
                                        tips[i].addDiagnosticInfo(tasks[i].getTaskId(), "Already completed  TIP");
                                        states[i] = TaskStatus.State.KILLED;
                                    }
                                    newStatus = (TaskStatus)status[i].clone();
                                    newStatus.setRunState(states[i]);
                                    newStatus.setProgress(states[i] == TaskStatus.State.SUCCEEDED ? 1.0f : 0.0f);
                                }
                                if (newStatus != null) {
                                    jobs[i].updateTaskStatus(tips[i], newStatus, metrics[i]);
                                }
                                continue;
                            }
                        }
                    }
                }
                catch (InterruptedException ie) {
                    break;
                }
                catch (Throwable t) {
                    LOG.error((Object)(this.getName() + " got an exception: " + StringUtils.stringifyException(t)));
                }
            }
            LOG.warn((Object)(this.getName() + " exiting..."));
        }
    }

    private class ResolutionThread
    extends Thread {
        private LinkedBlockingQueue<TaskTrackerStatus> queue = new LinkedBlockingQueue();

        public ResolutionThread() {
            this.setName("DNSToSwitchMapping reolution Thread");
            this.setDaemon(true);
        }

        public void addToResolutionQueue(TaskTrackerStatus t) {
            while (!this.queue.add(t)) {
                LOG.warn((Object)"Couldn't add to the Resolution queue now. Will try again");
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void run() {
            while (!this.isInterrupted()) {
                try {
                    ArrayList<TaskTrackerStatus> statuses = new ArrayList<TaskTrackerStatus>(this.queue.size());
                    statuses.add(this.queue.take());
                    this.queue.drainTo(statuses);
                    ArrayList<String> dnHosts = new ArrayList<String>(statuses.size());
                    for (TaskTrackerStatus t : statuses) {
                        dnHosts.add(t.getHost());
                    }
                    List<String> rName = JobTracker.this.dnsToSwitchMapping.resolve(dnHosts);
                    if (rName == null) {
                        LOG.error((Object)"The resolve call returned null! Using /default-rack for some hosts");
                        rName = new ArrayList<String>(dnHosts.size());
                        for (int i = 0; i < dnHosts.size(); ++i) {
                            rName.add("/default-rack");
                        }
                    }
                    int i = 0;
                    for (String m : rName) {
                        String host = ((TaskTrackerStatus)statuses.get(i++)).getHost();
                        String networkLoc = NodeBase.normalize(m);
                        JobTracker.this.addHostToNodeMapping(host, networkLoc);
                        ++JobTracker.this.numResolved;
                    }
                }
                catch (InterruptedException ie) {
                    LOG.warn((Object)(this.getName() + " exiting, got interrupted: " + StringUtils.stringifyException(ie)));
                    return;
                }
                catch (Throwable t) {
                    LOG.error((Object)(this.getName() + " got an exception: " + StringUtils.stringifyException(t)));
                }
            }
            LOG.warn((Object)(this.getName() + " exiting..."));
        }
    }

    static class JobTrackerMetrics
    implements Updater {
        private MetricsRecord metricsRecord = null;
        private int numMapTasksLaunched = 0;
        private int numMapTasksCompleted = 0;
        private int numReduceTasksLaunched = 0;
        private int numReduceTasksCompleted = 0;
        private int numJobsSubmitted = 0;
        private int numJobsCompleted = 0;
        private JobTracker tracker;

        JobTrackerMetrics(JobTracker tracker, JobConf conf) {
            String sessionId = conf.getSessionId();
            JvmMetrics.init("JobTracker", sessionId);
            MetricsContext context = MetricsUtil.getContext("mapred");
            this.metricsRecord = MetricsUtil.createRecord(context, "jobtracker");
            this.metricsRecord.setTag("sessionId", sessionId);
            this.tracker = tracker;
            context.registerUpdater(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doUpdates(MetricsContext unused) {
            JobTrackerMetrics jobTrackerMetrics = this;
            synchronized (jobTrackerMetrics) {
                this.metricsRecord.incrMetric("maps_launched", this.numMapTasksLaunched);
                this.metricsRecord.incrMetric("maps_completed", this.numMapTasksCompleted);
                this.metricsRecord.incrMetric("reduces_launched", this.numReduceTasksLaunched);
                this.metricsRecord.incrMetric("reduces_completed", this.numReduceTasksCompleted);
                this.metricsRecord.incrMetric("jobs_submitted", this.numJobsSubmitted);
                this.metricsRecord.incrMetric("jobs_completed", this.numJobsCompleted);
                this.numMapTasksLaunched = 0;
                this.numMapTasksCompleted = 0;
                this.numReduceTasksLaunched = 0;
                this.numReduceTasksCompleted = 0;
                this.numJobsSubmitted = 0;
                this.numJobsCompleted = 0;
            }
            this.metricsRecord.update();
            if (this.tracker != null) {
                for (JobInProgress jip : this.tracker.getRunningJobs()) {
                    jip.updateMetrics();
                }
            }
        }

        synchronized void launchMap() {
            ++this.numMapTasksLaunched;
        }

        synchronized void completeMap() {
            ++this.numMapTasksCompleted;
        }

        synchronized void launchReduce() {
            ++this.numReduceTasksLaunched;
        }

        synchronized void completeReduce() {
            ++this.numReduceTasksCompleted;
        }

        synchronized void submitJob() {
            ++this.numJobsSubmitted;
        }

        synchronized void completeJob() {
            ++this.numJobsCompleted;
        }
    }

    class JobInitThread
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                JobInProgress job = null;
                try {
                    List<JobInProgress> list = JobTracker.this.jobInitQueue;
                    synchronized (list) {
                        while (JobTracker.this.jobInitQueue.isEmpty()) {
                            JobTracker.this.jobInitQueue.wait();
                        }
                        job = JobTracker.this.jobInitQueue.remove(0);
                    }
                    job.initTasks();
                    continue;
                }
                catch (InterruptedException t) {
                }
                catch (Throwable t) {
                    LOG.error((Object)("Job initialization failed:\n" + StringUtils.stringifyException(t)));
                    if (job == null) continue;
                    job.kill();
                    continue;
                }
                break;
            }
        }
    }

    class RetireJobs
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    Object object;
                    ArrayList<JobInProgress> retiredJobs;
                    do {
                        Thread.sleep(RETIRE_JOB_CHECK_INTERVAL);
                        retiredJobs = new ArrayList<JobInProgress>();
                        long retireBefore = System.currentTimeMillis() - RETIRE_JOB_INTERVAL;
                        object = JobTracker.this.jobsByPriority;
                        synchronized (object) {
                            for (JobInProgress job : JobTracker.this.jobsByPriority) {
                                if (job.getStatus().getRunState() == 1 || job.getStatus().getRunState() == 4 || job.getFinishTime() >= retireBefore) continue;
                                retiredJobs.add(job);
                            }
                        }
                    } while (retiredJobs.isEmpty());
                    object = JobTracker.this;
                    synchronized (object) {
                        Map<String, JobInProgress> map = JobTracker.this.jobs;
                        synchronized (map) {
                            List<JobInProgress> list = JobTracker.this.jobsByPriority;
                            synchronized (list) {
                                List<JobInProgress> list2 = JobTracker.this.jobInitQueue;
                                synchronized (list2) {
                                    for (JobInProgress job : retiredJobs) {
                                        JobTracker.this.removeJobTasks(job);
                                        JobTracker.this.jobs.remove(job.getProfile().getJobId());
                                        JobTracker.this.jobInitQueue.remove(job);
                                        JobTracker.this.jobsByPriority.remove(job);
                                        String jobUser = job.getProfile().getUser();
                                        TreeMap<String, ArrayList<JobInProgress>> treeMap = JobTracker.this.userToJobsMap;
                                        synchronized (treeMap) {
                                            ArrayList<JobInProgress> userJobs;
                                            ArrayList<JobInProgress> arrayList = userJobs = JobTracker.this.userToJobsMap.get(jobUser);
                                            synchronized (arrayList) {
                                                userJobs.remove(job);
                                            }
                                            if (userJobs.isEmpty()) {
                                                JobTracker.this.userToJobsMap.remove(jobUser);
                                            }
                                        }
                                        LOG.info((Object)("Retired job with id: '" + job.getProfile().getJobId() + "' of user '" + jobUser + "'"));
                                    }
                                }
                            }
                        }
                    }
                }
                catch (InterruptedException t) {
                }
                catch (Throwable t) {
                    LOG.error((Object)("Error in retiring job:\n" + StringUtils.stringifyException(t)));
                    continue;
                }
                break;
            }
        }
    }

    class ExpireTrackers
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(TASKTRACKER_EXPIRY_INTERVAL / 3L);
                        JobTracker jobTracker = JobTracker.this;
                        synchronized (jobTracker) {
                            TreeMap treeMap = JobTracker.this.taskTrackers;
                            synchronized (treeMap) {
                                TreeSet<TaskTrackerStatus> treeSet = JobTracker.this.trackerExpiryQueue;
                                synchronized (treeSet) {
                                    long now = System.currentTimeMillis();
                                    TaskTrackerStatus leastRecent = null;
                                    while (JobTracker.this.trackerExpiryQueue.size() > 0 && (leastRecent = JobTracker.this.trackerExpiryQueue.first()) != null && now - leastRecent.getLastSeen() > TASKTRACKER_EXPIRY_INTERVAL) {
                                        JobTracker.this.trackerExpiryQueue.remove(leastRecent);
                                        String trackerName = leastRecent.getTrackerName();
                                        TaskTrackerStatus newProfile = (TaskTrackerStatus)JobTracker.this.taskTrackers.get(leastRecent.getTrackerName());
                                        if (newProfile == null) continue;
                                        if (now - newProfile.getLastSeen() > TASKTRACKER_EXPIRY_INTERVAL) {
                                            JobTracker.this.updateTaskTrackerStatus(trackerName, null);
                                            JobTracker.this.lostTaskTracker(leastRecent.getTrackerName());
                                            continue;
                                        }
                                        JobTracker.this.trackerExpiryQueue.add(newProfile);
                                    }
                                }
                            }
                        }
                    }
                }
                catch (InterruptedException iex) {
                    return;
                }
                catch (Exception t) {
                    LOG.error((Object)("Tracker Expiry Thread got exception: " + StringUtils.stringifyException(t)));
                    continue;
                }
                break;
            }
        }
    }

    private class ExpireLaunchingTasks
    implements Runnable {
        private Map<String, Long> launchingTasks = new LinkedHashMap<String, Long>();

        private ExpireLaunchingTasks() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(TASKTRACKER_EXPIRY_INTERVAL / 3L);
                        long now = System.currentTimeMillis();
                        LOG.debug((Object)"Starting launching task sweep");
                        JobTracker jobTracker = JobTracker.this;
                        synchronized (jobTracker) {
                            Map<String, Long> map = this.launchingTasks;
                            synchronized (map) {
                                Iterator<Map.Entry<String, Long>> itr = this.launchingTasks.entrySet().iterator();
                                while (itr.hasNext()) {
                                    Map.Entry<String, Long> pair = itr.next();
                                    String taskId = pair.getKey();
                                    long age = now - pair.getValue();
                                    LOG.info((Object)(taskId + " is " + age + " ms debug."));
                                    if (age <= TASKTRACKER_EXPIRY_INTERVAL) break;
                                    LOG.info((Object)("Launching task " + taskId + " timed out."));
                                    TaskInProgress tip = null;
                                    tip = JobTracker.this.taskidToTIPMap.get(taskId);
                                    if (tip != null) {
                                        JobInProgress job = tip.getJob();
                                        String trackerName = JobTracker.this.getAssignedTracker(taskId);
                                        TaskTrackerStatus trackerStatus = JobTracker.this.getTaskTracker(trackerName);
                                        if (trackerStatus != null) {
                                            job.failedTask(tip, taskId, "Error launching task", tip.isMapTask() ? TaskStatus.Phase.MAP : TaskStatus.Phase.STARTING, TaskStatus.State.FAILED, trackerName, JobTracker.this.myMetrics);
                                        }
                                    }
                                    itr.remove();
                                }
                            }
                        }
                    }
                }
                catch (InterruptedException ie) {
                    return;
                }
                catch (Exception e) {
                    LOG.error((Object)("Expire Launching Task Thread got exception: " + StringUtils.stringifyException(e)));
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addNewTask(String taskName) {
            Map<String, Long> map = this.launchingTasks;
            synchronized (map) {
                this.launchingTasks.put(taskName, System.currentTimeMillis());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeTask(String taskName) {
            Map<String, Long> map = this.launchingTasks;
            synchronized (map) {
                this.launchingTasks.remove(taskName);
            }
        }
    }

    public static class IllegalStateException
    extends IOException {
        public IllegalStateException(String msg) {
            super(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        INITIALIZING,
        RUNNING;

    }
}

