/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TaskTracker;

class MapOutputFile {
    private JobConf conf;
    private String jobDir;
    private LocalDirAllocator lDirAlloc = new LocalDirAllocator("mapred.local.dir");

    MapOutputFile() {
    }

    MapOutputFile(String jobId) {
        this.jobDir = TaskTracker.getJobCacheSubdir() + "/" + jobId;
    }

    public Path getOutputFile(String mapTaskId) throws IOException {
        return this.lDirAlloc.getLocalPathToRead(this.jobDir + "/" + mapTaskId + "/" + "output" + "/file.out", this.conf);
    }

    public Path getOutputFileForWrite(String mapTaskId, long size) throws IOException {
        return this.lDirAlloc.getLocalPathForWrite(this.jobDir + "/" + mapTaskId + "/" + "output" + "/file.out", size, this.conf);
    }

    public Path getOutputIndexFile(String mapTaskId) throws IOException {
        return this.lDirAlloc.getLocalPathToRead(this.jobDir + "/" + mapTaskId + "/" + "output" + "/file.out.index", this.conf);
    }

    public Path getOutputIndexFileForWrite(String mapTaskId, long size) throws IOException {
        return this.lDirAlloc.getLocalPathForWrite(this.jobDir + "/" + mapTaskId + "/" + "output" + "/file.out.index", size, this.conf);
    }

    public Path getSpillFile(String mapTaskId, int spillNumber) throws IOException {
        return this.lDirAlloc.getLocalPathToRead(this.jobDir + "/" + mapTaskId + "/" + "output" + "/spill" + spillNumber + ".out", this.conf);
    }

    public Path getSpillFileForWrite(String mapTaskId, int spillNumber, long size) throws IOException {
        return this.lDirAlloc.getLocalPathForWrite(this.jobDir + "/" + mapTaskId + "/" + "output" + "/spill" + spillNumber + ".out", size, this.conf);
    }

    public Path getSpillIndexFile(String mapTaskId, int spillNumber) throws IOException {
        return this.lDirAlloc.getLocalPathToRead(this.jobDir + "/" + mapTaskId + "/" + "output" + "/spill" + spillNumber + ".out.index", this.conf);
    }

    public Path getSpillIndexFileForWrite(String mapTaskId, int spillNumber, long size) throws IOException {
        return this.lDirAlloc.getLocalPathForWrite(this.jobDir + "/" + mapTaskId + "/" + "output" + "/spill" + spillNumber + ".out.index", size, this.conf);
    }

    public Path getInputFile(int mapId, String reduceTaskId) throws IOException {
        return this.lDirAlloc.getLocalPathToRead(this.jobDir + "/" + reduceTaskId + "/" + "output" + "/map_" + mapId + ".out", this.conf);
    }

    public Path getInputFileForWrite(int mapId, String reduceTaskId, long size) throws IOException {
        return this.lDirAlloc.getLocalPathForWrite(this.jobDir + "/" + reduceTaskId + "/" + "output" + "/map_" + mapId + ".out", size, this.conf);
    }

    public void removeAll(String taskId) throws IOException {
        this.conf.deleteLocalFiles(this.jobDir + "/" + taskId + "/" + "output");
    }

    public void setConf(Configuration conf) {
        this.conf = conf instanceof JobConf ? (JobConf)conf : new JobConf(conf);
    }

    public void setJobId(String jobId) {
        this.jobDir = TaskTracker.getJobCacheSubdir() + "/" + jobId;
    }
}

