/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.MapTask;
import org.apache.hadoop.mapred.ReduceTask;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.hadoop.mapred.TaskStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TaskInProgress {
    static final int MAX_TASK_EXECS = 1;
    int maxTaskAttempts = 4;
    static final double SPECULATIVE_GAP = 0.2;
    static final long SPECULATIVE_LAG = 60000L;
    static final String MAP_IDENTIFIER = "_m_";
    static final String REDUCE_IDENTIFIER = "_r_";
    private static NumberFormat idFormat = NumberFormat.getInstance();
    public static final Log LOG;
    private String jobFile = null;
    private JobClient.RawSplit rawSplit;
    private int numMaps;
    private int partition;
    private JobTracker jobtracker;
    private String id;
    private JobInProgress job;
    private int successEventNumber = -1;
    private int numTaskFailures = 0;
    private int numKilledTasks = 0;
    private double progress = 0.0;
    private String state = "";
    private long startTime = 0L;
    private long execStartTime = 0L;
    private long execFinishTime = 0L;
    private int completes = 0;
    private boolean failed = false;
    private boolean killed = false;
    String taskIdPrefix;
    int nextTaskId = 0;
    private String successfulTaskId;
    private TreeMap<String, String> activeTasks = new TreeMap();
    private JobConf conf;
    private Map<String, List<String>> taskDiagnosticData = new TreeMap<String, List<String>>();
    private TreeMap<String, TaskStatus> taskStatuses = new TreeMap();
    private Map<String, Task> tasks = new TreeMap<String, Task>();
    private TreeSet<String> machinesWhereFailed = new TreeSet();
    private TreeSet<String> tasksReportedClosed = new TreeSet();
    private TreeMap<String, Boolean> tasksToKill = new TreeMap();
    private Counters counters = new Counters();

    public TaskInProgress(String jobid, String jobFile, JobClient.RawSplit rawSplit, JobTracker jobtracker, JobConf conf, JobInProgress job, int partition) {
        this.jobFile = jobFile;
        this.rawSplit = rawSplit;
        this.jobtracker = jobtracker;
        this.job = job;
        this.conf = conf;
        this.partition = partition;
        this.setMaxTaskAttempts();
        this.init(JobTracker.getJobUniqueString(jobid));
    }

    public TaskInProgress(String jobid, String jobFile, int numMaps, int partition, JobTracker jobtracker, JobConf conf, JobInProgress job) {
        this.jobFile = jobFile;
        this.numMaps = numMaps;
        this.partition = partition;
        this.jobtracker = jobtracker;
        this.job = job;
        this.conf = conf;
        this.setMaxTaskAttempts();
        this.init(JobTracker.getJobUniqueString(jobid));
    }

    private void setMaxTaskAttempts() {
        this.maxTaskAttempts = this.isMapTask() ? this.conf.getMaxMapAttempts() : this.conf.getMaxReduceAttempts();
    }

    public static boolean isMapId(String tipId) {
        return tipId.contains(MAP_IDENTIFIER);
    }

    private String makeUniqueString(String uniqueBase) {
        StringBuilder result = new StringBuilder();
        result.append(uniqueBase);
        if (this.isMapTask()) {
            result.append(MAP_IDENTIFIER);
        } else {
            result.append(REDUCE_IDENTIFIER);
        }
        result.append(idFormat.format(this.partition));
        return result.toString();
    }

    public int idWithinJob() {
        return this.partition;
    }

    public boolean isOnlyCommitPending() {
        for (TaskStatus t : this.taskStatuses.values()) {
            if (t.getRunState() != TaskStatus.State.COMMIT_PENDING) continue;
            return true;
        }
        return false;
    }

    void init(String jobUniqueString) {
        this.startTime = System.currentTimeMillis();
        this.taskIdPrefix = this.makeUniqueString(jobUniqueString);
        this.id = "tip_" + this.taskIdPrefix;
    }

    public JobInProgress getJob() {
        return this.job;
    }

    public String getTIPId() {
        return this.id;
    }

    public boolean isMapTask() {
        return this.rawSplit != null;
    }

    public Task getTaskObject(String taskId) {
        return this.tasks.get(taskId);
    }

    public boolean isRunning() {
        return !this.activeTasks.isEmpty();
    }

    private String getSuccessfulTaskid() {
        return this.successfulTaskId;
    }

    private void setSuccessfulTaskid(String successfulTaskId) {
        this.successfulTaskId = successfulTaskId;
    }

    private void resetSuccessfulTaskid() {
        this.successfulTaskId = "";
    }

    public synchronized boolean isComplete() {
        return this.completes > 0;
    }

    public boolean isComplete(String taskid) {
        return this.completes > 0 && this.getSuccessfulTaskid().equals(taskid);
    }

    public boolean isFailed() {
        return this.failed;
    }

    public int numTaskFailures() {
        return this.numTaskFailures;
    }

    public int numKilledTasks() {
        return this.numKilledTasks;
    }

    public double getProgress() {
        return this.progress;
    }

    public Counters getCounters() {
        return this.counters;
    }

    public boolean shouldClose(String taskid) {
        boolean close = false;
        TaskStatus ts = this.taskStatuses.get(taskid);
        if (ts != null && !this.tasksReportedClosed.contains(taskid) && this.job.getStatus().getRunState() != 1) {
            this.tasksReportedClosed.add(taskid);
            close = true;
        } else if (!(!this.isComplete() || this.isMapTask() && this.isComplete(taskid) || this.tasksReportedClosed.contains(taskid))) {
            this.tasksReportedClosed.add(taskid);
            close = true;
        } else {
            close = this.tasksToKill.keySet().contains(taskid);
        }
        return close;
    }

    synchronized TaskReport generateSingleReport() {
        ArrayList<String> diagnostics = new ArrayList<String>();
        for (List<String> l : this.taskDiagnosticData.values()) {
            diagnostics.addAll(l);
        }
        TaskReport report = new TaskReport(this.getTIPId(), (float)this.progress, this.state, diagnostics.toArray(new String[diagnostics.size()]), this.execStartTime, this.execFinishTime, this.counters);
        return report;
    }

    synchronized List<String> getDiagnosticInfo(String taskId) {
        return this.taskDiagnosticData.get(taskId);
    }

    public void addDiagnosticInfo(String taskId, String diagInfo) {
        List<String> diagHistory = this.taskDiagnosticData.get(taskId);
        if (diagHistory == null) {
            diagHistory = new ArrayList<String>();
            this.taskDiagnosticData.put(taskId, diagHistory);
        }
        diagHistory.add(diagInfo);
    }

    synchronized boolean updateStatus(TaskStatus status) {
        String taskid = status.getTaskId();
        String diagInfo = status.getDiagnosticInfo();
        TaskStatus oldStatus = this.taskStatuses.get(taskid);
        boolean changed = true;
        if (diagInfo != null && diagInfo.length() > 0) {
            LOG.info((Object)("Error from " + taskid + ": " + diagInfo));
            this.addDiagnosticInfo(taskid, diagInfo);
        }
        if (oldStatus != null) {
            TaskStatus.State oldState = oldStatus.getRunState();
            TaskStatus.State newState = status.getRunState();
            if (newState != TaskStatus.State.RUNNING && oldState == newState) {
                LOG.warn((Object)("Recieved duplicate status update of '" + (Object)((Object)newState) + "' for '" + taskid + "' of TIP '" + this.getTIPId() + "'"));
                return false;
            }
            if (newState == TaskStatus.State.RUNNING && (oldState == TaskStatus.State.FAILED || oldState == TaskStatus.State.KILLED || oldState == TaskStatus.State.SUCCEEDED || oldState == TaskStatus.State.COMMIT_PENDING)) {
                return false;
            }
            changed = oldState != newState;
        }
        this.taskStatuses.put(taskid, status);
        this.recomputeProgress();
        return changed;
    }

    public void incompleteSubTask(String taskid, String trackerName, JobStatus jobStatus) {
        TaskStatus status = this.taskStatuses.get(taskid);
        TaskStatus.State taskState = TaskStatus.State.FAILED;
        if (status != null) {
            Boolean shouldFail = this.tasksToKill.remove(taskid);
            if (shouldFail != null) {
                taskState = shouldFail != false ? TaskStatus.State.FAILED : TaskStatus.State.KILLED;
                status.setRunState(taskState);
                this.addDiagnosticInfo(taskid, "Task has been " + (Object)((Object)taskState) + " by the user");
            }
            if ((taskState = status.getRunState()) != TaskStatus.State.FAILED && taskState != TaskStatus.State.KILLED) {
                LOG.info((Object)("Task '" + taskid + "' running on '" + trackerName + "' in state: '" + (Object)((Object)taskState) + "' being failed!"));
                status.setRunState(TaskStatus.State.FAILED);
                taskState = TaskStatus.State.FAILED;
            }
            if (0L == status.getFinishTime()) {
                status.setFinishTime(System.currentTimeMillis());
            }
        }
        this.activeTasks.remove(taskid);
        if (this.isMapTask() && this.isComplete(taskid) && jobStatus.getRunState() != 2) {
            --this.completes;
            this.resetSuccessfulTaskid();
        }
        if (taskState == TaskStatus.State.FAILED) {
            ++this.numTaskFailures;
            this.machinesWhereFailed.add(trackerName);
        } else {
            ++this.numKilledTasks;
        }
        if (this.numTaskFailures >= this.maxTaskAttempts) {
            LOG.info((Object)("TaskInProgress " + this.getTIPId() + " has failed " + this.numTaskFailures + " times."));
            this.kill();
        }
    }

    private void completedTask(String taskId, TaskStatus.State finalTaskState) {
        TaskStatus status = this.taskStatuses.get(taskId);
        status.setRunState(finalTaskState);
        this.activeTasks.remove(taskId);
    }

    void alreadyCompletedTask(String taskid) {
        this.completedTask(taskid, TaskStatus.State.KILLED);
        this.addDiagnosticInfo(taskid, "Already completed TIP");
        LOG.info((Object)("Already complete TIP " + this.getTIPId() + " has completed task " + taskid));
    }

    public void completed(String taskid) {
        this.completedTask(taskid, TaskStatus.State.SUCCEEDED);
        this.setSuccessfulTaskid(taskid);
        ++this.completes;
        this.recomputeProgress();
    }

    public String[] getSplitLocations() {
        return this.rawSplit.getLocations();
    }

    public TaskStatus[] getTaskStatuses() {
        return this.taskStatuses.values().toArray(new TaskStatus[this.taskStatuses.size()]);
    }

    public TaskStatus getTaskStatus(String taskid) {
        return this.taskStatuses.get(taskid);
    }

    public void kill() {
        if (this.isComplete() || this.failed) {
            return;
        }
        this.failed = true;
        this.killed = true;
        this.recomputeProgress();
    }

    public boolean wasKilled() {
        return this.killed;
    }

    boolean killTask(String taskId, boolean shouldFail) {
        TaskStatus st = this.taskStatuses.get(taskId);
        if (st != null && (st.getRunState() == TaskStatus.State.RUNNING || st.getRunState() == TaskStatus.State.COMMIT_PENDING) && this.tasksToKill.put(taskId, shouldFail) == null) {
            String logStr = "Request received to " + (shouldFail ? "fail" : "kill") + " task '" + taskId + "' by user";
            this.addDiagnosticInfo(taskId, logStr);
            LOG.info((Object)logStr);
            return true;
        }
        return false;
    }

    void recomputeProgress() {
        if (this.isComplete()) {
            this.progress = 1.0;
            this.execFinishTime = System.currentTimeMillis();
        } else if (this.failed) {
            this.progress = 0.0;
            this.execFinishTime = System.currentTimeMillis();
        } else {
            double bestProgress = 0.0;
            String bestState = "";
            Counters bestCounters = new Counters();
            for (String taskid : this.taskStatuses.keySet()) {
                TaskStatus status = this.taskStatuses.get(taskid);
                if (status.getRunState() == TaskStatus.State.SUCCEEDED) {
                    bestProgress = 1.0;
                    bestState = status.getStateString();
                    bestCounters = status.getCounters();
                    break;
                }
                if (status.getRunState() == TaskStatus.State.COMMIT_PENDING) {
                    bestProgress = this.progress;
                    bestState = this.state;
                    bestCounters = this.counters;
                    continue;
                }
                if (status.getRunState() != TaskStatus.State.RUNNING || !((double)status.getProgress() >= bestProgress)) continue;
                bestProgress = status.getProgress();
                bestState = status.getStateString();
                bestCounters = status.getCounters();
            }
            this.progress = bestProgress;
            this.state = bestState;
            this.counters = bestCounters;
        }
    }

    boolean isRunnable() {
        return !this.failed && this.completes == 0;
    }

    boolean hasSpeculativeTask(long currentTime, double averageProgress) {
        return this.activeTasks.size() <= 1 && averageProgress - this.progress >= 0.2 && currentTime - this.startTime >= 60000L && this.completes == 0 && !this.isOnlyCommitPending();
    }

    public Task getTaskToRun(String taskTracker) throws IOException {
        Task t = null;
        if (0L == this.execStartTime) {
            this.execStartTime = System.currentTimeMillis();
        }
        String taskid = null;
        if (this.nextTaskId < 1 + this.maxTaskAttempts + this.numKilledTasks) {
            taskid = "task_" + this.taskIdPrefix + "_" + this.nextTaskId;
            ++this.nextTaskId;
        } else {
            LOG.warn((Object)("Exceeded limit of " + (1 + this.maxTaskAttempts) + " (plus " + this.numKilledTasks + " killed)" + " attempts for the tip '" + this.getTIPId() + "'"));
            return null;
        }
        String jobId = this.job.getProfile().getJobId();
        t = this.isMapTask() ? new MapTask(jobId, this.jobFile, this.id, taskid, this.partition, this.rawSplit.getClassName(), this.rawSplit.getBytes()) : new ReduceTask(jobId, this.jobFile, this.id, taskid, this.partition, this.numMaps);
        t.setConf(this.conf);
        this.tasks.put(taskid, t);
        this.activeTasks.put(taskid, taskTracker);
        this.jobtracker.createTaskEntry(taskid, taskTracker, this);
        return t;
    }

    public boolean hasFailedOnMachine(String tracker) {
        return this.machinesWhereFailed.contains(tracker);
    }

    public boolean hasRunOnMachine(String tracker) {
        return this.activeTasks.values().contains(tracker) || this.hasFailedOnMachine(tracker);
    }

    public int getNumberOfFailedMachines() {
        return this.machinesWhereFailed.size();
    }

    public int getIdWithinJob() {
        return this.partition;
    }

    public void setSuccessEventNumber(int eventNumber) {
        this.successEventNumber = eventNumber;
    }

    public int getSuccessEventNumber() {
        return this.successEventNumber;
    }

    public static String getTipId(String taskId) {
        return taskId.substring(0, taskId.lastIndexOf(95)).replace("task", "tip");
    }

    static {
        idFormat.setMinimumIntegerDigits(6);
        idFormat.setGroupingUsed(false);
        LOG = LogFactory.getLog((String)"org.apache.hadoop.mapred.TaskInProgress");
    }
}

