/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSError;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.mapred.DisallowedTaskTrackerException;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.HeartbeatResponse;
import org.apache.hadoop.mapred.InterTrackerProtocol;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.KillJobAction;
import org.apache.hadoop.mapred.KillTaskAction;
import org.apache.hadoop.mapred.LaunchTaskAction;
import org.apache.hadoop.mapred.MRConstants;
import org.apache.hadoop.mapred.ReduceTask;
import org.apache.hadoop.mapred.StatusHttpServer;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapred.TaskLogServlet;
import org.apache.hadoop.mapred.TaskRunner;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTrackerAction;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapred.pipes.Submitter;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsException;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.metrics.jvm.JvmMetrics;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.RunJar;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.log4j.LogManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskTracker
implements MRConstants,
TaskUmbilicalProtocol,
Runnable {
    static final long WAIT_FOR_DONE = 3000L;
    private int httpPort;
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.mapred.TaskTracker");
    private boolean running = true;
    private LocalDirAllocator localDirAllocator;
    String taskTrackerName;
    String localHostname;
    InetSocketAddress jobTrackAddr;
    InetSocketAddress taskReportAddress;
    Server taskReportServer = null;
    InterTrackerProtocol jobClient;
    short heartbeatResponseId = (short)-1;
    TaskTrackerStatus status = null;
    StatusHttpServer server = null;
    boolean shuttingDown = false;
    Map<String, TaskInProgress> tasks = new HashMap<String, TaskInProgress>();
    Map<String, TaskInProgress> runningTasks = null;
    Map<String, RunningJob> runningJobs = null;
    volatile int mapTotal = 0;
    volatile int reduceTotal = 0;
    boolean justStarted = true;
    Map<String, DF> localDirsDf = new HashMap<String, DF>();
    long minSpaceStart = 0L;
    boolean acceptNewTasks = true;
    long minSpaceKill = 0L;
    static Random r = new Random();
    private static final String SUBDIR = "taskTracker";
    private static final String CACHEDIR = "archive";
    private static final String JOBCACHE = "jobcache";
    private JobConf originalConf;
    private JobConf fConf;
    private int maxCurrentMapTasks;
    private int maxCurrentReduceTasks;
    private int failures;
    private int[] finishedCount = new int[1];
    private MapEventsFetcherThread mapEventsFetcher;
    int workerThreads;
    private static final int MIN_POLL_INTERVAL = 5000;
    private volatile int heartbeatInterval = 5000;
    private int probe_sample_size = 50;
    private ShuffleServerMetrics shuffleServerMetrics;
    private TaskTrackerMetrics myMetrics = null;
    private BlockingQueue<TaskTrackerAction> tasksToCleanup = new LinkedBlockingQueue<TaskTrackerAction>();
    private Thread taskCleanupThread = new Thread(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        TaskTrackerAction action;
                        if ((action = (TaskTrackerAction)TaskTracker.this.tasksToCleanup.take()) instanceof KillJobAction) {
                            TaskTracker.this.purgeJob((KillJobAction)action);
                            continue;
                        }
                        if (action instanceof KillTaskAction) {
                            TaskInProgress tip;
                            KillTaskAction killAction = (KillTaskAction)action;
                            TaskTracker taskTracker = TaskTracker.this;
                            synchronized (taskTracker) {
                                tip = TaskTracker.this.tasks.get(killAction.getTaskId());
                            }
                            LOG.info((Object)("Received KillTaskAction for task: " + killAction.getTaskId()));
                            TaskTracker.this.purgeTask(tip, false);
                            continue;
                        }
                        LOG.error((Object)("Non-delete action given to cleanup thread: " + action));
                    }
                }
                catch (Throwable except) {
                    LOG.warn((Object)StringUtils.stringifyException(except));
                    continue;
                }
                break;
            }
        }
    }, "taskCleanup");
    private Object waitingOn;
    private LocalDirAllocator lDirAlloc;
    private long previousUpdate;

    public TaskTrackerMetrics getTaskTrackerMetrics() {
        return this.myMetrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunningJob addTaskToJob(String jobId, Path localJobFile, TaskInProgress tip) {
        Map<String, RunningJob> map = this.runningJobs;
        synchronized (map) {
            RunningJob rJob = null;
            if (!this.runningJobs.containsKey(jobId)) {
                rJob = new RunningJob(jobId, localJobFile);
                rJob.localized = false;
                rJob.tasks = new HashSet<TaskInProgress>();
                rJob.jobFile = localJobFile;
                this.runningJobs.put(jobId, rJob);
            } else {
                rJob = this.runningJobs.get(jobId);
            }
            RunningJob runningJob = rJob;
            synchronized (runningJob) {
                rJob.tasks.add(tip);
            }
            this.runningJobs.notify();
            return rJob;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTaskFromJob(String jobId, TaskInProgress tip) {
        Map<String, RunningJob> map = this.runningJobs;
        synchronized (map) {
            RunningJob rjob = this.runningJobs.get(jobId);
            if (rjob == null) {
                LOG.warn((Object)("Unknown job " + jobId + " being deleted."));
            } else {
                RunningJob runningJob = rjob;
                synchronized (runningJob) {
                    rjob.tasks.remove(tip);
                }
            }
        }
    }

    static String getCacheSubdir() {
        return "taskTracker/archive";
    }

    static String getJobCacheSubdir() {
        return "taskTracker/jobcache";
    }

    @Override
    public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
        if (protocol.equals(TaskUmbilicalProtocol.class.getName())) {
            return 7L;
        }
        throw new IOException("Unknown protocol for task tracker: " + protocol);
    }

    synchronized void initialize() throws IOException {
        this.fConf = new JobConf(this.originalConf);
        if (this.fConf.get("slave.host.name") != null) {
            this.localHostname = this.fConf.get("slave.host.name");
        }
        if (this.localHostname == null) {
            this.localHostname = DNS.getDefaultHost(this.fConf.get("mapred.tasktracker.dns.interface", "default"), this.fConf.get("mapred.tasktracker.dns.nameserver", "default"));
        }
        TaskTracker.checkLocalDirs(this.fConf.getLocalDirs());
        this.fConf.deleteLocalFiles(SUBDIR);
        this.tasks.clear();
        this.runningTasks = new TreeMap<String, TaskInProgress>();
        this.runningJobs = new TreeMap<String, RunningJob>();
        this.mapTotal = 0;
        this.reduceTotal = 0;
        this.acceptNewTasks = true;
        this.status = null;
        this.minSpaceStart = this.fConf.getLong("mapred.local.dir.minspacestart", 0L);
        this.minSpaceKill = this.fConf.getLong("mapred.local.dir.minspacekill", 0L);
        int numCopiers = this.fConf.getInt("mapred.reduce.parallel.copies", 5);
        this.probe_sample_size = Math.max(numCopiers * 5, 50);
        this.myMetrics = new TaskTrackerMetrics();
        String address = NetUtils.getServerAddress(this.fConf, "mapred.task.tracker.report.bindAddress", "mapred.task.tracker.report.port", "mapred.task.tracker.report.address");
        InetSocketAddress socAddr = NetUtils.createSocketAddr(address);
        String bindAddress = socAddr.getHostName();
        int tmpPort = socAddr.getPort();
        int max = this.maxCurrentMapTasks > this.maxCurrentReduceTasks ? this.maxCurrentMapTasks : this.maxCurrentReduceTasks;
        this.taskReportServer = RPC.getServer(this, bindAddress, tmpPort, max, false, this.fConf);
        this.taskReportServer.start();
        this.taskReportAddress = this.taskReportServer.getListenerAddress();
        this.fConf.set("mapred.task.tracker.report.address", this.taskReportAddress.getHostName() + ":" + this.taskReportAddress.getPort());
        LOG.info((Object)("TaskTracker up at: " + this.taskReportAddress));
        this.taskTrackerName = "tracker_" + this.localHostname + ":" + this.taskReportAddress;
        LOG.info((Object)("Starting tracker " + this.taskTrackerName));
        DistributedCache.purgeCache(this.fConf);
        this.cleanupStorage();
        this.justStarted = true;
        this.jobClient = (InterTrackerProtocol)RPC.waitForProxy(InterTrackerProtocol.class, 10L, this.jobTrackAddr, this.fConf);
        this.running = true;
        this.mapEventsFetcher = new MapEventsFetcherThread();
        this.mapEventsFetcher.setDaemon(true);
        this.mapEventsFetcher.setName("Map-events fetcher for all reduce tasks on " + this.taskTrackerName);
        this.mapEventsFetcher.start();
    }

    public void cleanupStorage() throws IOException {
        this.fConf.deleteLocalFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void localizeJob(TaskInProgress tip) throws IOException {
        RunningJob rjob;
        Path localJarFile = null;
        Task t = tip.getTask();
        String jobId = t.getJobId();
        String jobFile = t.getJobFile();
        FileSystem fileSystem = FileSystem.get(this.fConf);
        FileStatus[] status = fileSystem.listStatus(new Path(jobFile).getParent());
        long jarFileSize = -1L;
        long jobFileSize = -1L;
        for (FileStatus stat : status) {
            jobFileSize = stat.getPath().toString().contains("job.xml") ? stat.getLen() : -1L;
            jarFileSize = stat.getPath().toString().contains("job.jar") ? stat.getLen() : -1L;
        }
        Path localJobFile = this.lDirAlloc.getLocalPathForWrite(TaskTracker.getJobCacheSubdir() + "/" + jobId + "/" + "job.xml", jobFileSize, this.fConf);
        RunningJob runningJob = rjob = this.addTaskToJob(jobId, localJobFile, tip);
        synchronized (runningJob) {
            if (!rjob.localized) {
                Path jobDir;
                LocalFileSystem localFs = FileSystem.getLocal(this.fConf);
                if (localFs.exists(jobDir = localJobFile.getParent())) {
                    ((FileSystem)localFs).delete(jobDir, true);
                    boolean b = ((FileSystem)localFs).mkdirs(jobDir);
                    if (!b) {
                        throw new IOException("Not able to create job directory " + jobDir.toString());
                    }
                }
                FileSystem fs = FileSystem.getNamed(this.jobClient.getFilesystemName(), this.fConf);
                fs.copyToLocalFile(new Path(jobFile), localJobFile);
                JobConf localJobConf = new JobConf(localJobFile);
                Path workDir = this.lDirAlloc.getLocalPathForWrite(TaskTracker.getJobCacheSubdir() + "/" + jobId + "/" + "work", this.fConf);
                if (!((FileSystem)localFs).mkdirs(workDir)) {
                    throw new IOException("Mkdirs failed to create " + workDir.toString());
                }
                System.setProperty("job.local.dir", workDir.toString());
                localJobConf.set("job.local.dir", workDir.toString());
                String jarFile = localJobConf.getJar();
                if (jarFile != null) {
                    localJarFile = new Path(this.lDirAlloc.getLocalPathForWrite(TaskTracker.getJobCacheSubdir() + "/" + jobId + "/" + "jars", 5L * jarFileSize, this.fConf), "job.jar");
                    if (!((FileSystem)localFs).mkdirs(localJarFile.getParent())) {
                        throw new IOException("Mkdirs failed to create jars directory ");
                    }
                    fs.copyToLocalFile(new Path(jarFile), localJarFile);
                    localJobConf.setJar(localJarFile.toString());
                    FSDataOutputStream out = localFs.create(localJobFile);
                    try {
                        localJobConf.write(out);
                    }
                    finally {
                        ((OutputStream)out).close();
                    }
                    RunJar.unJar(new File(localJarFile.toString()), new File(localJarFile.getParent().toString()));
                }
                rjob.keepJobFiles = localJobConf.getKeepTaskFilesPattern() != null || localJobConf.getKeepFailedTaskFiles();
                rjob.localized = true;
            }
        }
        this.launchTaskForJob(tip, new JobConf(rjob.jobFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launchTaskForJob(TaskInProgress tip, JobConf jobConf) throws IOException {
        TaskInProgress taskInProgress = tip;
        synchronized (taskInProgress) {
            try {
                tip.setJobConf(jobConf);
                tip.launchTask();
            }
            catch (Throwable ie) {
                tip.taskStatus.setRunState(TaskStatus.State.FAILED);
                try {
                    tip.cleanup();
                }
                catch (Throwable ie2) {
                    // empty catch block
                }
                String error = StringUtils.stringifyException(ie);
                tip.reportDiagnosticInfo(error);
                LOG.info((Object)error);
            }
        }
    }

    public synchronized void shutdown() throws IOException {
        this.shuttingDown = true;
        this.close();
        if (this.server != null) {
            try {
                LOG.info((Object)"Shutting down StatusHttpServer");
                this.server.stop();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    public synchronized void close() throws IOException {
        TreeMap<String, TaskInProgress> tasksToClose = new TreeMap<String, TaskInProgress>();
        tasksToClose.putAll(this.tasks);
        for (TaskInProgress tip : tasksToClose.values()) {
            tip.jobHasFinished(false);
        }
        new Thread("RPC shutdown"){

            public void run() {
                if (TaskTracker.this.taskReportServer != null) {
                    TaskTracker.this.taskReportServer.stop();
                    TaskTracker.this.taskReportServer = null;
                }
            }
        }.start();
        this.running = false;
        this.cleanupStorage();
        this.mapEventsFetcher.interrupt();
        RPC.stopProxy(this.jobClient);
    }

    public TaskTracker(JobConf conf) throws IOException {
        this.taskCleanupThread.setDaemon(true);
        this.taskCleanupThread.start();
        this.waitingOn = new Object();
        this.lDirAlloc = new LocalDirAllocator("mapred.local.dir");
        this.previousUpdate = 0L;
        this.originalConf = conf;
        this.maxCurrentMapTasks = conf.getInt("mapred.tasktracker.map.tasks.maximum", 2);
        this.maxCurrentReduceTasks = conf.getInt("mapred.tasktracker.reduce.tasks.maximum", 2);
        this.jobTrackAddr = JobTracker.getAddress(conf);
        String infoAddr = NetUtils.getServerAddress(conf, "tasktracker.http.bindAddress", "tasktracker.http.port", "mapred.task.tracker.http.address");
        InetSocketAddress infoSocAddr = NetUtils.createSocketAddr(infoAddr);
        String httpBindAddress = infoSocAddr.getHostName();
        int httpPort = infoSocAddr.getPort();
        this.server = new StatusHttpServer("task", httpBindAddress, httpPort, httpPort == 0);
        this.workerThreads = conf.getInt("tasktracker.http.threads", 40);
        this.shuffleServerMetrics = new ShuffleServerMetrics(conf);
        this.server.setThreads(1, this.workerThreads);
        LocalFileSystem local = FileSystem.getLocal(conf);
        this.localDirAllocator = new LocalDirAllocator("mapred.local.dir");
        this.server.setAttribute("task.tracker", this);
        this.server.setAttribute("local.file.system", local);
        this.server.setAttribute("conf", conf);
        this.server.setAttribute("log", LOG);
        this.server.setAttribute("localDirAllocator", this.localDirAllocator);
        this.server.setAttribute("shuffleServerMetrics", this.shuffleServerMetrics);
        this.server.addServlet("mapOutput", "/mapOutput", MapOutputServlet.class);
        this.server.addServlet("taskLog", "/tasklog", TaskLogServlet.class);
        this.server.start();
        this.httpPort = this.server.getPort();
        this.initialize();
    }

    public InterTrackerProtocol getJobClient() {
        return this.jobClient;
    }

    public synchronized InetSocketAddress getTaskTrackerReportAddress() {
        return this.taskReportAddress;
    }

    private List<TaskCompletionEvent> queryJobTracker(IntWritable fromEventId, String jobId, InterTrackerProtocol jobClient) throws IOException {
        TaskCompletionEvent[] t = jobClient.getTaskCompletionEvents(jobId, fromEventId.get(), this.probe_sample_size);
        ArrayList<TaskCompletionEvent> recentMapEvents = new ArrayList<TaskCompletionEvent>();
        for (int i = 0; i < t.length; ++i) {
            if (!t[i].isMap) continue;
            recentMapEvents.add(t[i]);
        }
        fromEventId.set(fromEventId.get() + t.length);
        return recentMapEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    State offerService() throws Exception {
        long lastHeartbeat = 0L;
        while (this.running) {
            String msg;
            if (this.shuttingDown) return State.NORMAL;
            try {
                long now = System.currentTimeMillis();
                long waitTime = (long)this.heartbeatInterval - (now - lastHeartbeat);
                if (waitTime > 0L) {
                    int[] nArray = this.finishedCount;
                    // MONITORENTER : this.finishedCount
                    if (this.finishedCount[0] == 0) {
                        this.finishedCount.wait(waitTime);
                    }
                    this.finishedCount[0] = 0;
                    // MONITOREXIT : nArray
                }
                HeartbeatResponse heartbeatResponse = this.transmitHeartBeat();
                TaskTrackerAction[] actions = heartbeatResponse.getActions();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Got heartbeatResponse from JobTracker with responseId: " + heartbeatResponse.getResponseId() + " and " + (actions != null ? actions.length : 0) + " actions"));
                }
                if (this.reinitTaskTracker(actions)) {
                    return State.STALE;
                }
                lastHeartbeat = now;
                this.heartbeatInterval = heartbeatResponse.getHeartbeatInterval();
                this.justStarted = false;
                if (actions != null) {
                    for (TaskTrackerAction action : actions) {
                        if (action instanceof LaunchTaskAction) {
                            this.startNewTask((LaunchTaskAction)action);
                            continue;
                        }
                        this.tasksToCleanup.put(action);
                    }
                }
                this.markUnresponsiveTasks();
                this.killOverflowingTasks();
                if (this.acceptNewTasks || !this.isIdle()) continue;
                this.acceptNewTasks = true;
            }
            catch (InterruptedException ie) {
                LOG.info((Object)"Interrupted. Closing down.");
                return State.INTERRUPTED;
            }
            catch (DiskChecker.DiskErrorException de) {
                msg = "Exiting task tracker for disk error:\n" + StringUtils.stringifyException(de);
                LOG.error((Object)msg);
                TaskTracker taskTracker = this;
                // MONITORENTER : taskTracker
                this.jobClient.reportTaskTrackerError(this.taskTrackerName, "DiskErrorException", msg);
                // MONITOREXIT : taskTracker
                return State.STALE;
            }
            catch (RemoteException re) {
                String reClass = re.getClassName();
                if (!DisallowedTaskTrackerException.class.getName().equals(reClass)) continue;
                LOG.info((Object)"Tasktracker disallowed by JobTracker.");
                return State.DENIED;
            }
            catch (Exception except) {
                msg = "Caught exception: " + StringUtils.stringifyException(except);
                LOG.error((Object)msg);
            }
        }
        return State.NORMAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HeartbeatResponse transmitHeartBeat() throws IOException {
        long localMinSpaceStart;
        boolean askForNewTask;
        boolean sendCounters;
        long now = System.currentTimeMillis();
        if (now > this.previousUpdate + 60000L) {
            sendCounters = true;
            this.previousUpdate = now;
        } else {
            sendCounters = false;
        }
        if (this.status == null) {
            TaskTracker taskTracker = this;
            synchronized (taskTracker) {
                this.status = new TaskTrackerStatus(this.taskTrackerName, this.localHostname, this.httpPort, this.cloneAndResetRunningTaskStatuses(sendCounters), this.failures, this.maxCurrentMapTasks, this.maxCurrentReduceTasks);
            }
        } else {
            LOG.info((Object)("Resending 'status' to '" + this.jobTrackAddr.getHostName() + "' with reponseId '" + this.heartbeatResponseId));
        }
        TaskTracker taskTracker = this;
        synchronized (taskTracker) {
            askForNewTask = (this.mapTotal < this.maxCurrentMapTasks || this.reduceTotal < this.maxCurrentReduceTasks) && this.acceptNewTasks;
            localMinSpaceStart = this.minSpaceStart;
        }
        if (askForNewTask) {
            TaskTracker.checkLocalDirs(this.fConf.getLocalDirs());
            askForNewTask = this.enoughFreeSpace(localMinSpaceStart);
        }
        HeartbeatResponse heartbeatResponse = this.jobClient.heartbeat(this.status, this.justStarted, askForNewTask, this.heartbeatResponseId);
        this.heartbeatResponseId = heartbeatResponse.getResponseId();
        TaskTracker taskTracker2 = this;
        synchronized (taskTracker2) {
            for (TaskStatus taskStatus : this.status.getTaskReports()) {
                if (taskStatus.getRunState() == TaskStatus.State.RUNNING) continue;
                if (taskStatus.getIsMap()) {
                    --this.mapTotal;
                } else {
                    --this.reduceTotal;
                }
                try {
                    this.myMetrics.completeTask();
                }
                catch (MetricsException me) {
                    LOG.warn((Object)("Caught: " + StringUtils.stringifyException(me)));
                }
                this.runningTasks.remove(taskStatus.getTaskId());
            }
            for (TaskInProgress tip : this.runningTasks.values()) {
                tip.getStatus().clearStatus();
            }
        }
        this.status = null;
        return heartbeatResponse;
    }

    private boolean reinitTaskTracker(TaskTrackerAction[] actions) {
        if (actions != null) {
            for (TaskTrackerAction action : actions) {
                if (action.getActionId() != TaskTrackerAction.ActionType.REINIT_TRACKER) continue;
                LOG.info((Object)"Recieved RenitTrackerAction from JobTracker");
                return true;
            }
        }
        return false;
    }

    private synchronized void markUnresponsiveTasks() throws IOException {
        long now = System.currentTimeMillis();
        for (TaskInProgress tip : this.runningTasks.values()) {
            long timeSinceLastReport;
            long jobTaskTimeout;
            if (tip.getRunState() != TaskStatus.State.RUNNING || (jobTaskTimeout = tip.getTaskTimeout()) == 0L || (timeSinceLastReport = now - tip.getLastProgressReport()) <= jobTaskTimeout || tip.wasKilled) continue;
            String msg = "Task " + tip.getTask().getTaskId() + " failed to report status for " + timeSinceLastReport / 1000L + " seconds. Killing!";
            LOG.info((Object)(tip.getTask().getTaskId() + ": " + msg));
            ReflectionUtils.logThreadInfo(LOG, "lost task", 30L);
            tip.reportDiagnosticInfo(msg);
            this.myMetrics.timedoutTask();
            this.purgeTask(tip, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void purgeJob(KillJobAction action) throws IOException {
        String jobId = action.getJobId();
        LOG.info((Object)("Received 'KillJobAction' for job: " + jobId));
        RunningJob rjob = null;
        Map<String, RunningJob> map = this.runningJobs;
        synchronized (map) {
            rjob = this.runningJobs.get(jobId);
        }
        if (rjob == null) {
            LOG.warn((Object)("Unknown job " + jobId + " being deleted."));
        } else {
            map = rjob;
            synchronized (map) {
                for (TaskInProgress tip : rjob.tasks) {
                    tip.jobHasFinished(false);
                }
                if (!rjob.keepJobFiles) {
                    this.fConf.deleteLocalFiles("taskTracker/jobcache/" + rjob.getJobId());
                }
                rjob.tasks.clear();
            }
        }
        map = this.runningJobs;
        synchronized (map) {
            this.runningJobs.remove(jobId);
        }
    }

    private void purgeTask(TaskInProgress tip, boolean wasFailure) throws IOException {
        if (tip != null) {
            LOG.info((Object)("About to purge task: " + tip.getTask().getTaskId()));
            this.removeTaskFromJob(tip.getTask().getJobId(), tip);
            tip.jobHasFinished(wasFailure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killOverflowingTasks() throws IOException {
        long localMinSpaceKill;
        TaskTracker taskTracker = this;
        synchronized (taskTracker) {
            localMinSpaceKill = this.minSpaceKill;
        }
        if (!this.enoughFreeSpace(localMinSpaceKill)) {
            this.acceptNewTasks = false;
            taskTracker = this;
            synchronized (taskTracker) {
                TaskInProgress killMe = this.findTaskToKill();
                if (killMe != null) {
                    String msg = "Tasktracker running out of space. Killing task.";
                    LOG.info((Object)(killMe.getTask().getTaskId() + ": " + msg));
                    killMe.reportDiagnosticInfo(msg);
                    this.purgeTask(killMe, false);
                }
            }
        }
    }

    private TaskInProgress findTaskToKill() {
        TaskInProgress killMe = null;
        for (TaskInProgress tip : this.runningTasks.values()) {
            if (tip.getRunState() != TaskStatus.State.RUNNING || tip.wasKilled) continue;
            if (killMe == null) {
                killMe = tip;
                continue;
            }
            if (!tip.getTask().isMapTask()) {
                if (!killMe.getTask().isMapTask() && !(tip.getTask().getProgress().get() < killMe.getTask().getProgress().get())) continue;
                killMe = tip;
                continue;
            }
            if (!killMe.getTask().isMapTask() || !(tip.getTask().getProgress().get() < killMe.getTask().getProgress().get())) continue;
            killMe = tip;
        }
        return killMe;
    }

    private boolean enoughFreeSpace(long minSpace) throws IOException {
        if (minSpace == 0L) {
            return true;
        }
        String[] localDirs = this.fConf.getLocalDirs();
        for (int i = 0; i < localDirs.length; ++i) {
            DF df = null;
            if (this.localDirsDf.containsKey(localDirs[i])) {
                df = this.localDirsDf.get(localDirs[i]);
            } else {
                df = new DF(new File(localDirs[i]), this.fConf);
                this.localDirsDf.put(localDirs[i], df);
            }
            if (df.getAvailable() <= minSpace) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startNewTask(LaunchTaskAction action) {
        block9: {
            Task t = action.getTask();
            LOG.info((Object)("LaunchTaskAction: " + t.getTaskId()));
            TaskInProgress tip = new TaskInProgress(t, this.fConf);
            TaskTracker taskTracker = this;
            synchronized (taskTracker) {
                this.tasks.put(t.getTaskId(), tip);
                this.runningTasks.put(t.getTaskId(), tip);
                boolean isMap = t.isMapTask();
                if (isMap) {
                    ++this.mapTotal;
                } else {
                    ++this.reduceTotal;
                }
            }
            try {
                this.localizeJob(tip);
            }
            catch (Throwable e) {
                String msg = "Error initializing " + tip.getTask().getTaskId() + ":\n" + StringUtils.stringifyException(e);
                LOG.warn((Object)msg);
                tip.reportDiagnosticInfo(msg);
                try {
                    tip.kill(true);
                }
                catch (IOException ie2) {
                    LOG.info((Object)("Error cleaning up " + tip.getTask().getTaskId() + ":\n" + StringUtils.stringifyException(ie2)));
                }
                if (!(e instanceof Error)) break block9;
                throw (Error)e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            boolean denied = false;
            while (true) {
                if (!this.running || this.shuttingDown || denied) {
                    if (!denied) return;
                    this.shutdown();
                    return;
                }
                boolean staleState = false;
                try {
                    while (this.running && !staleState && !this.shuttingDown && !denied) {
                        try {
                            State osState = this.offerService();
                            if (osState == State.STALE) {
                                staleState = true;
                                continue;
                            }
                            if (osState != State.DENIED) continue;
                            denied = true;
                        }
                        catch (Exception ex) {
                            if (this.shuttingDown) continue;
                            LOG.info((Object)("Lost connection to JobTracker [" + this.jobTrackAddr + "].  Retrying..."), (Throwable)ex);
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException ie) {}
                        }
                    }
                }
                finally {
                    this.close();
                }
                if (this.shuttingDown) {
                    return;
                }
                LOG.warn((Object)"Reinitializing local state");
                this.initialize();
            }
        }
        catch (IOException iex) {
            LOG.error((Object)("Got fatal exception while reinitializing TaskTracker: " + StringUtils.stringifyException(iex)));
            return;
        }
    }

    @Override
    public synchronized Task getTask(String taskid) throws IOException {
        TaskInProgress tip = this.tasks.get(taskid);
        if (tip != null) {
            return tip.getTask();
        }
        return null;
    }

    @Override
    public synchronized boolean statusUpdate(String taskid, TaskStatus taskStatus) throws IOException {
        TaskInProgress tip = this.tasks.get(taskid);
        if (tip != null) {
            tip.reportProgress(taskStatus);
            return true;
        }
        LOG.warn((Object)("Progress from unknown child task: " + taskid));
        return false;
    }

    @Override
    public synchronized void reportDiagnosticInfo(String taskid, String info) throws IOException {
        TaskInProgress tip = this.tasks.get(taskid);
        if (tip != null) {
            tip.reportDiagnosticInfo(info);
        } else {
            LOG.warn((Object)("Error from unknown child task: " + taskid + ". Ignored."));
        }
    }

    @Override
    public synchronized boolean ping(String taskid) throws IOException {
        return this.tasks.get(taskid) != null;
    }

    @Override
    public synchronized void done(String taskid, boolean shouldPromote) throws IOException {
        TaskInProgress tip = this.tasks.get(taskid);
        if (tip != null) {
            tip.reportDone(shouldPromote);
        } else {
            LOG.warn((Object)("Unknown child task done: " + taskid + ". Ignored."));
        }
    }

    @Override
    public synchronized void shuffleError(String taskId, String message) throws IOException {
        LOG.fatal((Object)("Task: " + taskId + " - Killed due to Shuffle Failure: " + message));
        TaskInProgress tip = this.runningTasks.get(taskId);
        tip.reportDiagnosticInfo("Shuffle Error: " + message);
        this.purgeTask(tip, true);
    }

    @Override
    public synchronized void fsError(String taskId, String message) throws IOException {
        LOG.fatal((Object)("Task: " + taskId + " - Killed due to FSError: " + message));
        TaskInProgress tip = this.runningTasks.get(taskId);
        tip.reportDiagnosticInfo("FSError: " + message);
        this.purgeTask(tip, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskCompletionEvent[] getMapCompletionEvents(String jobId, int fromEventId, int maxLocs) throws IOException {
        TaskCompletionEvent[] mapEvents = TaskCompletionEvent.EMPTY_ARRAY;
        Map<String, RunningJob> map = this.runningJobs;
        synchronized (map) {
            RunningJob rjob = this.runningJobs.get(jobId);
            if (rjob != null) {
                RunningJob runningJob = rjob;
                synchronized (runningJob) {
                    FetchStatus f = rjob.getFetchStatus();
                    if (f != null) {
                        mapEvents = f.getMapEvents(fromEventId, maxLocs);
                    }
                }
            }
        }
        return mapEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportTaskFinished(String taskid) {
        TaskInProgress tip;
        Object object = this;
        synchronized (object) {
            tip = this.tasks.get(taskid);
        }
        if (tip != null) {
            tip.taskFinished();
            object = this.finishedCount;
            synchronized (this.finishedCount) {
                this.finishedCount[0] = this.finishedCount[0] + 1;
                this.finishedCount.notify();
                // ** MonitorExit[var3_2] (shouldn't be in output)
            }
        } else {
            LOG.warn((Object)("Unknown child task finshed: " + taskid + ". Ignored."));
        }
    }

    public synchronized void mapOutputLost(String taskid, String errorMsg) throws IOException {
        TaskInProgress tip = this.tasks.get(taskid);
        if (tip != null) {
            tip.mapOutputLost(errorMsg);
        } else {
            LOG.warn((Object)("Unknown child with bad map output: " + taskid + ". Ignored."));
        }
    }

    String getName() {
        return this.taskTrackerName;
    }

    private synchronized List<TaskStatus> cloneAndResetRunningTaskStatuses(boolean sendCounters) {
        ArrayList<TaskStatus> result = new ArrayList<TaskStatus>(this.runningTasks.size());
        for (TaskInProgress tip : this.runningTasks.values()) {
            TaskStatus status = tip.getStatus();
            status.setIncludeCounters(sendCounters);
            if (status.getRunState() != TaskStatus.State.RUNNING) {
                status.setIncludeCounters(true);
            }
            result.add((TaskStatus)status.clone());
            status.clearStatus();
        }
        return result;
    }

    synchronized List<TaskStatus> getRunningTaskStatuses() {
        ArrayList<TaskStatus> result = new ArrayList<TaskStatus>(this.runningTasks.size());
        for (TaskInProgress tip : this.runningTasks.values()) {
            result.add(tip.getStatus());
        }
        return result;
    }

    synchronized List<TaskStatus> getNonRunningTasks() {
        ArrayList<TaskStatus> result = new ArrayList<TaskStatus>(this.tasks.size());
        for (Map.Entry<String, TaskInProgress> task : this.tasks.entrySet()) {
            if (this.runningTasks.containsKey(task.getKey())) continue;
            result.add(task.getValue().getStatus());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized List<TaskStatus> getTasksFromRunningJobs() {
        ArrayList<TaskStatus> result = new ArrayList<TaskStatus>(this.tasks.size());
        for (Map.Entry<String, RunningJob> item : this.runningJobs.entrySet()) {
            RunningJob rjob;
            RunningJob runningJob = rjob = item.getValue();
            synchronized (runningJob) {
                for (TaskInProgress tip : rjob.tasks) {
                    result.add(tip.getStatus());
                }
            }
        }
        return result;
    }

    JobConf getJobConf() {
        return this.fConf;
    }

    private static void checkLocalDirs(String[] localDirs) throws DiskChecker.DiskErrorException {
        boolean writable = false;
        if (localDirs != null) {
            for (int i = 0; i < localDirs.length; ++i) {
                try {
                    DiskChecker.checkDir(new File(localDirs[i]));
                    writable = true;
                    continue;
                }
                catch (DiskChecker.DiskErrorException e) {
                    LOG.warn((Object)("Task Tracker local " + e.getMessage()));
                }
            }
        }
        if (!writable) {
            throw new DiskChecker.DiskErrorException("all local directories are not writable");
        }
    }

    public synchronized boolean isIdle() {
        return this.tasks.isEmpty() && this.tasksToCleanup.isEmpty();
    }

    public static void main(String[] argv) throws Exception {
        StringUtils.startupShutdownMessage(TaskTracker.class, argv, LOG);
        if (argv.length != 0) {
            System.out.println("usage: TaskTracker");
            System.exit(-1);
        }
        try {
            JobConf conf = new JobConf();
            ReflectionUtils.setContentionTracing(conf.getBoolean("tasktracker.contention.tracking", false));
            new TaskTracker(conf).run();
        }
        catch (Throwable e) {
            LOG.error((Object)("Can not start task tracker because " + StringUtils.stringifyException(e)));
            System.exit(-1);
        }
    }

    public static class MapOutputServlet
    extends HttpServlet {
        private static final int MAX_BYTES_TO_READ = 65536;

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            String mapId = request.getParameter("map");
            String reduceId = request.getParameter("reduce");
            String jobId = request.getParameter("job");
            if (jobId == null) {
                throw new IOException("job parameter is required");
            }
            if (mapId == null || reduceId == null) {
                throw new IOException("map and reduce parameters are required");
            }
            ServletContext context = this.getServletContext();
            int reduce = Integer.parseInt(reduceId);
            byte[] buffer = new byte[65536];
            boolean isInputException = true;
            ServletOutputStream outStream = null;
            FilterInputStream indexIn = null;
            FilterInputStream mapOutputIn = null;
            ShuffleServerMetrics shuffleMetrics = (ShuffleServerMetrics)context.getAttribute("shuffleServerMetrics");
            try {
                shuffleMetrics.serverHandlerBusy();
                outStream = response.getOutputStream();
                JobConf conf = (JobConf)context.getAttribute("conf");
                LocalDirAllocator lDirAlloc = (LocalDirAllocator)context.getAttribute("localDirAllocator");
                FileSystem fileSys = (FileSystem)context.getAttribute("local.file.system");
                Path indexFileName = lDirAlloc.getLocalPathToRead(TaskTracker.getJobCacheSubdir() + "/" + jobId + "/" + mapId + "/output" + "/file.out.index", conf);
                Path mapOutputFileName = lDirAlloc.getLocalPathToRead(TaskTracker.getJobCacheSubdir() + "/" + jobId + "/" + mapId + "/output" + "/file.out", conf);
                indexIn = fileSys.open(indexFileName);
                ((FSDataInputStream)indexIn).seek(reduce * 16);
                long startOffset = ((DataInputStream)indexIn).readLong();
                long partLength = ((DataInputStream)indexIn).readLong();
                indexIn.close();
                indexIn = null;
                response.setHeader("Map-Output-Length", Long.toString(partLength));
                response.setBufferSize(65536);
                mapOutputIn = fileSys.open(mapOutputFileName);
                ((FSDataInputStream)mapOutputIn).seek(startOffset);
                long totalRead = 0L;
                int len = ((DataInputStream)mapOutputIn).read(buffer, 0, partLength < 65536L ? (int)partLength : 65536);
                while (len > 0) {
                    try {
                        shuffleMetrics.outputBytes(len);
                        outStream.write(buffer, 0, len);
                        outStream.flush();
                    }
                    catch (IOException ie) {
                        isInputException = false;
                        throw ie;
                    }
                    if ((totalRead += (long)len) == partLength) {
                        break;
                    }
                    len = ((DataInputStream)mapOutputIn).read(buffer, 0, partLength - totalRead < 65536L ? (int)(partLength - totalRead) : 65536);
                }
            }
            catch (IOException ie) {
                TaskTracker tracker = (TaskTracker)context.getAttribute("task.tracker");
                Log log = (Log)context.getAttribute("log");
                String errorMsg = "getMapOutput(" + mapId + "," + reduceId + ") failed :\n" + StringUtils.stringifyException(ie);
                log.warn((Object)errorMsg);
                if (isInputException) {
                    tracker.mapOutputLost(mapId, errorMsg);
                }
                response.sendError(410, errorMsg);
                shuffleMetrics.failedOutput();
                throw ie;
            }
            finally {
                if (indexIn != null) {
                    indexIn.close();
                }
                if (mapOutputIn != null) {
                    mapOutputIn.close();
                }
                shuffleMetrics.serverHandlerFree();
            }
            outStream.close();
            shuffleMetrics.successOutput();
        }
    }

    public static class Child {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String[] args) throws Throwable {
            LOG.debug((Object)"Child starting");
            JobConf defaultConf = new JobConf();
            String host = args[0];
            int port = Integer.parseInt(args[1]);
            InetSocketAddress address = new InetSocketAddress(host, port);
            String taskid = args[2];
            defaultConf.setInt("ipc.client.connection.maxidletime", 3600000);
            TaskUmbilicalProtocol umbilical = (TaskUmbilicalProtocol)RPC.getProxy(TaskUmbilicalProtocol.class, 7L, address, defaultConf);
            Task task = umbilical.getTask(taskid);
            JobConf job = new JobConf(task.getJobFile());
            TaskLog.cleanup(job.getInt("mapred.userlog.retain.hours", 24));
            task.setConf(job);
            defaultConf.addResource(new Path(task.getJobFile()));
            JvmMetrics.init(task.getPhase().toString(), job.getSessionId());
            try {
                FileSystem.get(job).setWorkingDirectory(job.getWorkingDirectory());
                task.run(job, umbilical);
            }
            catch (FSError e) {
                LOG.fatal((Object)"FSError from child", (Throwable)e);
                umbilical.fsError(taskid, e.getMessage());
            }
            catch (Throwable throwable) {
                LOG.warn((Object)"Error running child", throwable);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                throwable.printStackTrace(new PrintStream(baos));
                umbilical.reportDiagnosticInfo(taskid, baos.toString());
            }
            finally {
                RPC.stopProxy(umbilical);
                MetricsContext metricsContext = MetricsUtil.getContext("mapred");
                metricsContext.close();
                LogManager.shutdown();
            }
        }
    }

    static class RunningJob {
        private String jobid;
        private Path jobFile;
        Set<TaskInProgress> tasks;
        boolean localized;
        boolean keepJobFiles;
        FetchStatus f;

        RunningJob(String jobid, Path jobFile) {
            this.jobid = jobid;
            this.localized = false;
            this.tasks = new HashSet<TaskInProgress>();
            this.jobFile = jobFile;
            this.keepJobFiles = false;
        }

        Path getJobFile() {
            return this.jobFile;
        }

        String getJobId() {
            return this.jobid;
        }

        void setFetchStatus(FetchStatus f) {
            this.f = f;
        }

        FetchStatus getFetchStatus() {
            return this.f;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TaskInProgress {
        Task task;
        long lastProgressReport;
        StringBuffer diagnosticInfo = new StringBuffer();
        private TaskRunner runner;
        volatile boolean done = false;
        boolean wasKilled = false;
        private JobConf defaultJobConf;
        private JobConf localJobConf;
        private boolean keepFailedTaskFiles;
        private boolean alwaysKeepTaskFiles;
        private TaskStatus taskStatus;
        private long taskTimeout;
        private String debugCommand;
        private boolean shouldPromoteOutput = false;

        public TaskInProgress(Task task, JobConf conf) {
            this.task = task;
            this.lastProgressReport = System.currentTimeMillis();
            this.defaultJobConf = conf;
            this.localJobConf = null;
            this.taskStatus = TaskStatus.createTaskStatus(task.isMapTask(), task.getTaskId(), 0.0f, TaskStatus.State.UNASSIGNED, this.diagnosticInfo.toString(), "initializing", TaskTracker.this.getName(), task.isMapTask() ? TaskStatus.Phase.MAP : TaskStatus.Phase.SHUFFLE, task.getCounters());
            this.taskTimeout = 600000L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void localizeTask(Task task) throws IOException {
            Path cwd;
            Path localTaskDir = TaskTracker.this.lDirAlloc.getLocalPathForWrite(TaskTracker.getJobCacheSubdir() + "/" + task.getJobId() + "/" + task.getTaskId(), this.defaultJobConf);
            LocalFileSystem localFs = FileSystem.getLocal(TaskTracker.this.fConf);
            if (!((FileSystem)localFs).mkdirs(localTaskDir)) {
                throw new IOException("Mkdirs failed to create " + localTaskDir.toString());
            }
            String workDir = TaskTracker.this.lDirAlloc.getLocalPathToRead(TaskTracker.getJobCacheSubdir() + "/" + task.getJobId() + "/" + "work", this.defaultJobConf).toString();
            String link = localTaskDir.getParent().toString() + "/" + "work";
            File flink = new File(link);
            if (!flink.exists()) {
                FileUtil.symLink(workDir, link);
            }
            if (!((FileSystem)localFs).mkdirs(cwd = TaskTracker.this.lDirAlloc.getLocalPathForWrite(TaskTracker.getJobCacheSubdir() + "/" + task.getJobId() + "/" + task.getTaskId() + "/" + "work", this.defaultJobConf))) {
                throw new IOException("Mkdirs failed to create " + cwd.toString());
            }
            Path localTaskFile = new Path(localTaskDir, "job.xml");
            task.setJobFile(localTaskFile.toString());
            this.localJobConf.set("mapred.local.dir", TaskTracker.this.fConf.get("mapred.local.dir"));
            this.localJobConf.set("mapred.task.id", task.getTaskId());
            this.keepFailedTaskFiles = this.localJobConf.getKeepFailedTaskFiles();
            Path outputPath = FileOutputFormat.getOutputPath(this.localJobConf);
            if (outputPath != null) {
                Path jobTmpDir = new Path(outputPath, "_temporary");
                FileSystem fs = jobTmpDir.getFileSystem(this.localJobConf);
                if (fs.exists(jobTmpDir)) {
                    Path taskTmpDir = new Path(jobTmpDir, "_" + task.getTaskId());
                    if (!fs.mkdirs(taskTmpDir)) {
                        throw new IOException("Mkdirs failed to create " + taskTmpDir.toString());
                    }
                } else {
                    throw new IOException("The directory " + jobTmpDir.toString() + " doesnt exist ");
                }
            }
            task.localizeConfiguration(this.localJobConf);
            List<String[]> staticResolutions = NetUtils.getAllStaticResolutions();
            if (staticResolutions != null && staticResolutions.size() > 0) {
                StringBuffer str = new StringBuffer();
                for (int i = 0; i < staticResolutions.size(); ++i) {
                    String[] hostToResolved = staticResolutions.get(i);
                    str.append(hostToResolved[0] + "=" + hostToResolved[1]);
                    if (i == staticResolutions.size() - 1) continue;
                    str.append(',');
                }
                this.localJobConf.set("hadoop.net.static.resolutions", str.toString());
            }
            FSDataOutputStream out = localFs.create(localTaskFile);
            try {
                this.localJobConf.write(out);
            }
            finally {
                ((OutputStream)out).close();
            }
            task.setConf(this.localJobConf);
            String keepPattern = this.localJobConf.getKeepTaskFilesPattern();
            this.alwaysKeepTaskFiles = keepPattern != null ? Pattern.matches(keepPattern, task.getTaskId()) : false;
            this.debugCommand = task.isMapTask() ? this.localJobConf.getMapDebugScript() : this.localJobConf.getReduceDebugScript();
        }

        public Task getTask() {
            return this.task;
        }

        public synchronized void setJobConf(JobConf lconf) {
            this.localJobConf = lconf;
            this.keepFailedTaskFiles = this.localJobConf.getKeepFailedTaskFiles();
            this.taskTimeout = this.localJobConf.getLong("mapred.task.timeout", 600000L);
        }

        public synchronized JobConf getJobConf() {
            return this.localJobConf;
        }

        public synchronized TaskStatus getStatus() {
            this.taskStatus.setDiagnosticInfo(this.diagnosticInfo.toString());
            if (this.diagnosticInfo.length() > 0) {
                this.diagnosticInfo = new StringBuffer();
            }
            return this.taskStatus;
        }

        public synchronized void launchTask() throws IOException {
            this.localizeTask(this.task);
            this.taskStatus.setRunState(TaskStatus.State.RUNNING);
            this.runner = this.task.createRunner(TaskTracker.this);
            this.runner.start();
            this.taskStatus.setStartTime(System.currentTimeMillis());
        }

        public synchronized void reportProgress(TaskStatus taskStatus) {
            LOG.info((Object)(this.task.getTaskId() + " " + taskStatus.getProgress() + "% " + taskStatus.getStateString()));
            if (this.done || this.taskStatus.getRunState() != TaskStatus.State.RUNNING) {
                LOG.info((Object)(this.task.getTaskId() + " Ignoring status-update since " + (this.done ? "task is 'done'" : "runState: " + (Object)((Object)this.taskStatus.getRunState()))));
                return;
            }
            this.taskStatus.statusUpdate(taskStatus);
            this.lastProgressReport = System.currentTimeMillis();
        }

        public long getLastProgressReport() {
            return this.lastProgressReport;
        }

        public TaskStatus.State getRunState() {
            return this.taskStatus.getRunState();
        }

        public long getTaskTimeout() {
            return this.taskTimeout;
        }

        public synchronized void reportDiagnosticInfo(String info) {
            this.diagnosticInfo.append(info);
        }

        public synchronized void reportDone(boolean shouldPromote) {
            TaskStatus.State state = null;
            this.shouldPromoteOutput = shouldPromote;
            state = shouldPromote ? TaskStatus.State.COMMIT_PENDING : TaskStatus.State.SUCCEEDED;
            this.taskStatus.setRunState(state);
            this.taskStatus.setProgress(1.0f);
            this.taskStatus.setFinishTime(System.currentTimeMillis());
            this.done = true;
            LOG.info((Object)("Task " + this.task.getTaskId() + " is done."));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void taskFinished() {
            long start = System.currentTimeMillis();
            while (!this.done && System.currentTimeMillis() - start < 3000L) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {}
            }
            boolean needCleanup = false;
            TaskInProgress taskInProgress = this;
            synchronized (taskInProgress) {
                if (this.done) {
                    if (this.shouldPromoteOutput) {
                        this.taskStatus.setRunState(TaskStatus.State.COMMIT_PENDING);
                    } else {
                        this.taskStatus.setRunState(TaskStatus.State.SUCCEEDED);
                    }
                } else {
                    if (!this.wasKilled) {
                        TaskTracker.this.failures += 1;
                        this.taskStatus.setRunState(TaskStatus.State.FAILED);
                        if (this.debugCommand != null) {
                            String taskStdout = "";
                            String taskStderr = "";
                            String taskSyslog = "";
                            String jobConf = this.task.getJobFile();
                            try {
                                taskStdout = FileUtil.makeShellPath(TaskLog.getTaskLogFile(this.task.getTaskId(), TaskLog.LogName.STDOUT));
                                taskStderr = FileUtil.makeShellPath(TaskLog.getTaskLogFile(this.task.getTaskId(), TaskLog.LogName.STDERR));
                                taskSyslog = FileUtil.makeShellPath(TaskLog.getTaskLogFile(this.task.getTaskId(), TaskLog.LogName.SYSLOG));
                            }
                            catch (IOException e) {
                                LOG.warn((Object)"Exception finding task's stdout/err/syslog files");
                            }
                            File workDir = null;
                            try {
                                workDir = new File(TaskTracker.this.lDirAlloc.getLocalPathToRead(TaskTracker.getJobCacheSubdir() + "/" + this.task.getJobId() + "/" + this.task.getTaskId() + "/" + "work", this.localJobConf).toString());
                            }
                            catch (IOException e) {
                                LOG.warn((Object)("Working Directory of the task " + this.task.getTaskId() + "doesnt exist. Throws expetion " + StringUtils.stringifyException(e)));
                            }
                            File stdout = TaskLog.getTaskLogFile(this.task.getTaskId(), TaskLog.LogName.DEBUGOUT);
                            String program = "";
                            String executable = Submitter.getExecutable(this.localJobConf);
                            if (executable != null) {
                                try {
                                    program = new URI(executable).getFragment();
                                }
                                catch (URISyntaxException ur) {
                                    LOG.warn((Object)"Problem in the URI fragment for pipes executable");
                                }
                            }
                            String[] debug = this.debugCommand.split(" ");
                            Vector<String> vargs = new Vector<String>();
                            for (String component : debug) {
                                vargs.add(component);
                            }
                            vargs.add(taskStdout);
                            vargs.add(taskStderr);
                            vargs.add(taskSyslog);
                            vargs.add(jobConf);
                            vargs.add(program);
                            try {
                                List<String> wrappedCommand = TaskLog.captureDebugOut(vargs, stdout);
                                try {
                                    this.runScript(wrappedCommand, workDir);
                                }
                                catch (IOException ioe) {
                                    LOG.warn((Object)("runScript failed with: " + StringUtils.stringifyException(ioe)));
                                }
                            }
                            catch (IOException e) {
                                LOG.warn((Object)"Error in preparing wrapped debug command");
                            }
                            try {
                                int num = this.localJobConf.getInt("mapred.debug.out.lines", -1);
                                this.addDiagnostics(FileUtil.makeShellPath(stdout), num, "DEBUG OUT");
                            }
                            catch (IOException ioe) {
                                LOG.warn((Object)"Exception in add diagnostics!");
                            }
                        }
                    } else {
                        this.taskStatus.setRunState(TaskStatus.State.KILLED);
                    }
                    this.taskStatus.setProgress(0.0f);
                }
                this.taskStatus.setFinishTime(System.currentTimeMillis());
                needCleanup = this.taskStatus.getRunState() == TaskStatus.State.FAILED || this.taskStatus.getRunState() == TaskStatus.State.KILLED;
            }
            if (needCleanup) {
                try {
                    TaskTracker.this.removeTaskFromJob(this.task.getJobId(), this);
                    this.cleanup();
                }
                catch (IOException ie) {
                    // empty catch block
                }
            }
        }

        public void runScript(List<String> args, File dir) throws IOException {
            Shell.ShellCommandExecutor shexec = new Shell.ShellCommandExecutor(args.toArray(new String[0]), dir);
            shexec.execute();
            int exitCode = shexec.getExitCode();
            if (exitCode != 0) {
                throw new IOException("Task debug script exit with nonzero status of " + exitCode + ".");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDiagnostics(String file, int num, String tag) {
            RandomAccessFile rafile = null;
            try {
                int n;
                rafile = new RandomAccessFile(file, "r");
                int no_lines = 0;
                String line = null;
                StringBuffer tail = new StringBuffer();
                tail.append("\n-------------------- " + tag + "---------------------\n");
                String[] lines = null;
                if (num > 0) {
                    lines = new String[num];
                }
                while ((line = rafile.readLine()) != null) {
                    ++no_lines;
                    if (num > 0) {
                        if (no_lines <= num) {
                            lines[no_lines - 1] = line;
                            continue;
                        }
                        for (int i = 0; i < num - 1; ++i) {
                            lines[i] = lines[i + 1];
                        }
                        lines[num - 1] = line;
                        continue;
                    }
                    if (num != -1) continue;
                    tail.append(line);
                    tail.append("\n");
                }
                int n2 = n = no_lines > num ? num : no_lines;
                if (num > 0) {
                    for (int i = 0; i < n; ++i) {
                        tail.append(lines[i]);
                        tail.append("\n");
                    }
                }
                if (n != 0) {
                    this.reportDiagnosticInfo(tail.toString());
                }
            }
            catch (FileNotFoundException fnfe) {
                LOG.warn((Object)("File " + file + " not found"));
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Error reading file " + file));
            }
            finally {
                try {
                    if (rafile != null) {
                        rafile.close();
                    }
                }
                catch (IOException ioe) {
                    LOG.warn((Object)("Error closing file " + file));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void jobHasFinished(boolean wasFailure) throws IOException {
            TaskInProgress taskInProgress = this;
            synchronized (taskInProgress) {
                if (this.getRunState() == TaskStatus.State.RUNNING) {
                    this.kill(wasFailure);
                }
            }
            this.cleanup();
        }

        public synchronized void kill(boolean wasFailure) throws IOException {
            if (this.taskStatus.getRunState() == TaskStatus.State.RUNNING) {
                this.wasKilled = true;
                if (wasFailure) {
                    TaskTracker.this.failures += 1;
                }
                this.runner.kill();
                this.taskStatus.setRunState(wasFailure ? TaskStatus.State.FAILED : TaskStatus.State.KILLED);
            } else if (this.taskStatus.getRunState() == TaskStatus.State.UNASSIGNED) {
                if (wasFailure) {
                    TaskTracker.this.failures += 1;
                    this.taskStatus.setRunState(TaskStatus.State.FAILED);
                } else {
                    this.taskStatus.setRunState(TaskStatus.State.KILLED);
                }
            }
        }

        private synchronized void mapOutputLost(String failure) throws IOException {
            if (this.taskStatus.getRunState() == TaskStatus.State.COMMIT_PENDING || this.taskStatus.getRunState() == TaskStatus.State.SUCCEEDED) {
                LOG.info((Object)("Reporting output lost:" + this.task.getTaskId()));
                this.taskStatus.setRunState(TaskStatus.State.FAILED);
                this.taskStatus.setProgress(0.0f);
                this.reportDiagnosticInfo("Map output lost, rescheduling: " + failure);
                TaskTracker.this.runningTasks.put(this.task.getTaskId(), this);
                ++TaskTracker.this.mapTotal;
            } else {
                LOG.warn((Object)("Output already reported lost:" + this.task.getTaskId()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cleanup() throws IOException {
            String taskId = this.task.getTaskId();
            LOG.debug((Object)("Cleaning up " + taskId));
            Object object = TaskTracker.this;
            synchronized (object) {
                TaskTracker.this.tasks.remove(taskId);
                TaskInProgress taskInProgress = this;
                synchronized (taskInProgress) {
                    if (this.alwaysKeepTaskFiles || this.taskStatus.getRunState() == TaskStatus.State.FAILED && this.keepFailedTaskFiles) {
                        return;
                    }
                }
            }
            object = this;
            synchronized (object) {
                try {
                    if (this.runner != null) {
                        this.runner.close();
                    }
                    this.defaultJobConf.deleteLocalFiles("taskTracker/jobcache/" + this.task.getJobId() + "/" + taskId);
                }
                catch (Throwable ie) {
                    LOG.info((Object)("Error cleaning up task runner: " + StringUtils.stringifyException(ie)));
                }
            }
        }

        public boolean equals(Object obj) {
            return obj instanceof TaskInProgress && this.task.getTaskId().equals(((TaskInProgress)obj).getTask().getTaskId());
        }

        public int hashCode() {
            return this.task.getTaskId().hashCode();
        }
    }

    private class FetchStatus {
        private IntWritable fromEventId = new IntWritable(0);
        private List<TaskCompletionEvent> allMapEvents;
        private String jobId;

        public FetchStatus(String jobId, int numMaps) {
            this.jobId = jobId;
            this.allMapEvents = new ArrayList<TaskCompletionEvent>(numMaps);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TaskCompletionEvent[] getMapEvents(int fromId, int max) {
            TaskCompletionEvent[] mapEvents = TaskCompletionEvent.EMPTY_ARRAY;
            boolean notifyFetcher = false;
            Object object = this.allMapEvents;
            synchronized (object) {
                if (this.allMapEvents.size() > fromId) {
                    int actualMax = Math.min(max, this.allMapEvents.size() - fromId);
                    List<TaskCompletionEvent> eventSublist = this.allMapEvents.subList(fromId, actualMax + fromId);
                    mapEvents = eventSublist.toArray(mapEvents);
                } else {
                    notifyFetcher = true;
                }
            }
            if (notifyFetcher) {
                object = TaskTracker.this.waitingOn;
                synchronized (object) {
                    TaskTracker.this.waitingOn.notify();
                }
            }
            return mapEvents;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fetchMapCompletionEvents() throws IOException {
            List recentMapEvents = TaskTracker.this.queryJobTracker(this.fromEventId, this.jobId, TaskTracker.this.jobClient);
            List<TaskCompletionEvent> list = this.allMapEvents;
            synchronized (list) {
                this.allMapEvents.addAll(recentMapEvents);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapEventsFetcherThread
    extends Thread {
        private MapEventsFetcherThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<FetchStatus> reducesInShuffle() {
            ArrayList<FetchStatus> fList = new ArrayList<FetchStatus>();
            for (Map.Entry<String, RunningJob> item : TaskTracker.this.runningJobs.entrySet()) {
                RunningJob rjob = item.getValue();
                String jobId = item.getKey();
                RunningJob runningJob = rjob;
                synchronized (runningJob) {
                    FetchStatus f = rjob.getFetchStatus();
                    for (TaskInProgress tip : rjob.tasks) {
                        Task task = tip.getTask();
                        if (task.isMapTask() || ((ReduceTask)task).getPhase() != TaskStatus.Phase.SHUFFLE) continue;
                        if (rjob.getFetchStatus() == null) {
                            f = new FetchStatus(jobId, ((ReduceTask)task).getNumMaps());
                            rjob.setFetchStatus(f);
                        }
                        f = rjob.getFetchStatus();
                        fList.add(f);
                        break;
                    }
                }
            }
            return fList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info((Object)("Starting thread: " + this.getName()));
            while (true) {
                try {
                    block15: while (true) {
                        List<FetchStatus> fList = null;
                        Map<String, RunningJob> map = TaskTracker.this.runningJobs;
                        synchronized (map) {
                            while ((fList = this.reducesInShuffle()).size() == 0) {
                                try {
                                    TaskTracker.this.runningJobs.wait();
                                }
                                catch (InterruptedException e) {
                                    LOG.info((Object)("Shutting down: " + this.getName()));
                                    return;
                                }
                            }
                        }
                        Iterator<FetchStatus> i$ = fList.iterator();
                        while (true) {
                            if (!i$.hasNext()) continue block15;
                            FetchStatus f = i$.next();
                            try {
                                f.fetchMapCompletionEvents();
                                int waitTime = TaskTracker.this.heartbeatInterval;
                                int minWait = 5000;
                                Object object = TaskTracker.this.waitingOn;
                                synchronized (object) {
                                    try {
                                        while (true) {
                                            long startWait = System.currentTimeMillis();
                                            TaskTracker.this.waitingOn.wait(waitTime);
                                            long endWait = System.currentTimeMillis();
                                            int diff = (int)(endWait - startWait);
                                            if (diff < minWait) {
                                                waitTime = minWait -= diff;
                                                continue;
                                            }
                                            break;
                                        }
                                    }
                                    catch (InterruptedException ie) {
                                        LOG.info((Object)("Shutting down: " + this.getName()));
                                        return;
                                    }
                                }
                            }
                            catch (Exception e) {
                                LOG.warn((Object)("Ignoring exception that fetch for map completion events threw for " + f.jobId + " threw: " + StringUtils.stringifyException(e)));
                                continue;
                            }
                            break;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    LOG.info((Object)("Ignoring exception " + e.getMessage()));
                    continue;
                }
                break;
            }
        }
    }

    public class TaskTrackerMetrics
    implements Updater {
        private MetricsRecord metricsRecord = null;
        private int numCompletedTasks = 0;
        private int timedoutTasks = 0;
        private int tasksFailedPing = 0;

        TaskTrackerMetrics() {
            JobConf conf = TaskTracker.this.getJobConf();
            String sessionId = conf.getSessionId();
            JvmMetrics.init("TaskTracker", sessionId);
            MetricsContext context = MetricsUtil.getContext("mapred");
            this.metricsRecord = MetricsUtil.createRecord(context, "tasktracker");
            this.metricsRecord.setTag("sessionId", sessionId);
            context.registerUpdater(this);
        }

        synchronized void completeTask() {
            ++this.numCompletedTasks;
        }

        synchronized void timedoutTask() {
            ++this.timedoutTasks;
        }

        synchronized void taskFailedPing() {
            ++this.tasksFailedPing;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doUpdates(MetricsContext unused) {
            TaskTrackerMetrics taskTrackerMetrics = this;
            synchronized (taskTrackerMetrics) {
                if (this.metricsRecord != null) {
                    this.metricsRecord.setMetric("maps_running", TaskTracker.this.mapTotal);
                    this.metricsRecord.setMetric("reduces_running", TaskTracker.this.reduceTotal);
                    this.metricsRecord.setMetric("mapTaskSlots", (short)TaskTracker.this.maxCurrentMapTasks);
                    this.metricsRecord.setMetric("reduceTaskSlots", (short)TaskTracker.this.maxCurrentReduceTasks);
                    this.metricsRecord.incrMetric("tasks_completed", this.numCompletedTasks);
                    this.metricsRecord.incrMetric("tasks_failed_timeout", this.timedoutTasks);
                    this.metricsRecord.incrMetric("tasks_failed_ping", this.tasksFailedPing);
                }
                this.numCompletedTasks = 0;
                this.timedoutTasks = 0;
                this.tasksFailedPing = 0;
            }
            this.metricsRecord.update();
        }
    }

    private class ShuffleServerMetrics
    implements Updater {
        private MetricsRecord shuffleMetricsRecord = null;
        private int serverHandlerBusy = 0;
        private long outputBytes = 0L;
        private int failedOutputs = 0;
        private int successOutputs = 0;

        ShuffleServerMetrics(JobConf conf) {
            MetricsContext context = MetricsUtil.getContext("mapred");
            this.shuffleMetricsRecord = MetricsUtil.createRecord(context, "shuffleOutput");
            this.shuffleMetricsRecord.setTag("sessionId", conf.getSessionId());
            context.registerUpdater(this);
        }

        synchronized void serverHandlerBusy() {
            ++this.serverHandlerBusy;
        }

        synchronized void serverHandlerFree() {
            --this.serverHandlerBusy;
        }

        synchronized void outputBytes(long bytes) {
            this.outputBytes += bytes;
        }

        synchronized void failedOutput() {
            ++this.failedOutputs;
        }

        synchronized void successOutput() {
            ++this.successOutputs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doUpdates(MetricsContext unused) {
            ShuffleServerMetrics shuffleServerMetrics = this;
            synchronized (shuffleServerMetrics) {
                if (TaskTracker.this.workerThreads != 0) {
                    this.shuffleMetricsRecord.setMetric("shuffle_handler_busy_percent", 100.0f * ((float)this.serverHandlerBusy / (float)TaskTracker.this.workerThreads));
                } else {
                    this.shuffleMetricsRecord.setMetric("shuffle_handler_busy_percent", 0);
                }
                this.shuffleMetricsRecord.incrMetric("shuffle_output_bytes", this.outputBytes);
                this.shuffleMetricsRecord.incrMetric("shuffle_failed_outputs", this.failedOutputs);
                this.shuffleMetricsRecord.incrMetric("shuffle_success_outputs", this.successOutputs);
                this.outputBytes = 0L;
                this.failedOutputs = 0;
                this.successOutputs = 0;
            }
            this.shuffleMetricsRecord.update();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        NORMAL,
        STALE,
        INTERRUPTED,
        DENIED;

    }
}

