/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.index.IndexType;
import org.h2.message.Message;
import org.h2.schema.Schema;
import org.h2.table.IndexColumn;
import org.h2.table.Table;

public class CreateIndex
extends SchemaCommand {
    private String tableName;
    private String indexName;
    private IndexColumn[] indexColumns;
    private boolean primaryKey;
    private boolean unique;
    private boolean hash;
    private boolean ifNotExists;
    private String comment;

    public CreateIndex(Session session, Schema schema) {
        super(session, schema);
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public void setIndexColumns(IndexColumn[] columns) {
        this.indexColumns = columns;
    }

    public boolean getPrimaryKey() {
        return this.primaryKey;
    }

    public IndexColumn[] getIndexColumns() {
        return this.indexColumns;
    }

    public int update() throws SQLException {
        IndexType indexType;
        this.session.commit(true);
        Database db = this.session.getDatabase();
        boolean persistent = db.isPersistent();
        Table table = this.getSchema().getTableOrView(this.session, this.tableName);
        this.session.getUser().checkRight(table, 15);
        table.lock(this.session, true, true);
        if (!table.isPersistent()) {
            persistent = false;
        }
        int id = this.getObjectId(true, false);
        if (this.indexName == null) {
            this.indexName = this.getSchema().getUniqueIndexName(table, "INDEX_");
        }
        if (this.getSchema().findIndex(this.indexName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw Message.getSQLException(42111, this.indexName);
        }
        if (this.primaryKey) {
            if (table.findPrimaryKey() != null) {
                throw Message.getSQLException(90017);
            }
            indexType = IndexType.createPrimaryKey(persistent, this.hash);
        } else {
            indexType = this.unique ? IndexType.createUnique(persistent, this.hash) : IndexType.createNonUnique(persistent);
        }
        IndexColumn.mapColumns(this.indexColumns, table);
        table.addIndex(this.session, this.indexName, id, this.indexColumns, indexType, this.headPos, this.comment);
        return 0;
    }

    public void setPrimaryKey(boolean b) {
        this.primaryKey = b;
    }

    public void setUnique(boolean b) {
        this.unique = b;
    }

    public void setHash(boolean b) {
        this.hash = b;
    }

    public boolean getHash() {
        return this.hash;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }
}

