/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.SQLException;
import org.h2.server.ftp.FtpServer;
import org.h2.store.fs.FileSystem;
import org.h2.util.IOUtils;

public class FtpData
extends Thread {
    private FtpServer server;
    private InetAddress address;
    private ServerSocket serverSocket;
    private volatile Socket socket;
    private boolean active;
    private int port;

    public FtpData(FtpServer server, InetAddress address, ServerSocket serverSocket) throws IOException {
        this.server = server;
        this.address = address;
        this.serverSocket = serverSocket;
    }

    public FtpData(FtpServer server, InetAddress address, int port) throws IOException {
        this.server = server;
        this.address = address;
        this.port = port;
        this.active = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            FtpData ftpData = this;
            synchronized (ftpData) {
                Socket s = this.serverSocket.accept();
                if (s.getInetAddress().equals(this.address)) {
                    this.server.log("Data connected:" + s.getInetAddress() + " expected:" + this.address);
                    this.socket = s;
                    this.notifyAll();
                } else {
                    this.server.log("Data REJECTED:" + s.getInetAddress() + " expected:" + this.address);
                    this.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void connect() throws IOException {
        if (this.active) {
            this.socket = new Socket(this.address, this.port);
        } else {
            this.waitUntilConnected();
        }
    }

    private void waitUntilConnected() {
        while (this.serverSocket != null && this.socket == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.server.log("connected");
    }

    public void close() {
        this.serverSocket = null;
        this.socket = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void receive(FileSystem fs, String fileName) throws IOException, SQLException {
        this.connect();
        try {
            InputStream in = this.socket.getInputStream();
            OutputStream out = fs.openFileOutputStream(fileName, false);
            IOUtils.copy(in, out);
            out.close();
        }
        finally {
            this.socket.close();
        }
        this.server.log("closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void send(FileSystem fs, String fileName, long skip) throws IOException {
        this.connect();
        try {
            OutputStream out = this.socket.getOutputStream();
            InputStream in = fs.openFileInputStream(fileName);
            IOUtils.skipFully(in, skip);
            IOUtils.copy(in, out);
            in.close();
        }
        finally {
            this.socket.close();
        }
        this.server.log("closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void send(byte[] data) throws IOException {
        this.connect();
        try {
            OutputStream out = this.socket.getOutputStream();
            out.write(data);
        }
        finally {
            this.socket.close();
        }
        this.server.log("closed");
    }
}

